/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.IAccessPermissionsSupport;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.PACKAGE;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefFallbackParser;
import de.intarsys.pdf.st.XRefStreamParser;
import de.intarsys.pdf.st.XRefTrailerParser;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.randomaccess.BufferedRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STDocument
implements INotificationSupport,
IAttributeSupport,
ILocatorSupport {
    public static final String ATTR_LOCATOR = "locator";
    public static final String ATTR_XREF_SECTION = "xRefSection";
    public static final String ATTR_SYSTEM_SECURITY_HANDLER = "systemSecurityHandler";
    private static int COUNTER = 0;
    public static final STDocType DOCTYPE_FDF = new STDocType("FDF", "1.2");
    public static final STDocType DOCTYPE_PDF = new STDocType("PDF", "1.4");
    private static Logger Log = PACKAGE.Log;
    private static final MessageBundle Msg = PACKAGE.Messages;
    public static final String OPTION_WRITEMODEHINT = "writeModeHint";
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private Object accessLock = new Object();
    private final AttributeMap attributes = new AttributeMap();
    private final Set<COSIndirectObject> changes = new HashSet<COSIndirectObject>();
    private boolean closed = false;
    private boolean dirty = false;
    private COSDocument doc;
    private STDocType docType;
    private COSIndirectObject[] objects = new COSIndirectObject[100];
    private ILocator locator;
    private COSObjectKey nextKey;
    private COSDocumentParser parser;
    private IRandomAccess randomAccess;
    private ISystemSecurityHandler readSecurityHandler;
    private EnumWriteMode writeModeHint = (EnumWriteMode)EnumWriteMode.META.getDefault();
    private ISystemSecurityHandler writeSecurityHandler;
    private STXRefSection xRefSection;

    public static STDocument createFromLocator(ILocator iLocator) throws IOException, COSLoadException {
        return STDocument.createFromLocator(iLocator, null);
    }

    public static STDocument createFromLocator(ILocator iLocator, Map map) throws IOException, COSLoadException {
        if (!iLocator.exists()) {
            throw new FileNotFoundException("'" + iLocator.getFullName() + "' not found");
        }
        STDocument sTDocument = new STDocument(iLocator);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                sTDocument.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        sTDocument.initializeFromLocator();
        return sTDocument;
    }

    protected static String createName(String string) {
        return Msg.getString("STDocument.documentName.new", (Object)string, (Object)new Integer(++COUNTER));
    }

    public static STDocument createNew() {
        return STDocument.createNew(DOCTYPE_PDF);
    }

    public static STDocument createNew(STDocType sTDocType) {
        STDocument sTDocument = new STDocument();
        sTDocument.initializeFromScratch(sTDocType);
        return sTDocument;
    }

    protected STDocument() {
    }

    protected STDocument(ILocator iLocator) {
        this.setLocator(iLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedReference(COSIndirectObject cOSIndirectObject) {
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            this.setDirty(true);
            this.changes.add(cOSIndirectObject);
        }
    }

    public void addNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        this.dispatcher.addNotificationListener(eventType, iNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectReference(COSIndirectObject cOSIndirectObject) {
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            int n = cOSIndirectObject.getObjectNumber();
            this.ensureLength(n);
            this.objects[n] = cOSIndirectObject;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkConsistency() throws COSLoadError {
        COSDictionary cOSDictionary;
        if (this.getDocType() == null) {
            throw new COSLoadError("unknown document type");
        }
        if (this.getDocType().isPDF()) {
            if (this.getXRefSection() == null) {
                throw new COSLoadError("x ref section missing");
            }
            if (this.getXRefSection().cosGetDict() == null) {
                throw new COSLoadError("trailer missing");
            }
        }
        if ((cOSDictionary = this.getTrailer().getRoot().cosGetDict()) == null || !COSCatalog.CN_Type_Catalog.equals(cOSDictionary.get(PDObject.DK_Type))) {
            throw new COSLoadError("catalog invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.getRandomAccess() != null) {
                this.getRandomAccess().close();
                this.setClosed(true);
                this.setRandomAccess(null);
            }
        }
    }

    public STDocument copyDeep() {
        STDocument sTDocument = STDocument.createNew();
        COSDictionary cOSDictionary = (COSDictionary)this.cosGetTrailer().copyDeep();
        cOSDictionary.remove(COSTrailer.DK_Prev);
        cOSDictionary.remove(COSTrailer.DK_Size);
        cOSDictionary.remove(STXRefSection.DK_XRefStm);
        ((STTrailerXRefSection)sTDocument.getXRefSection()).cosSetDict(cOSDictionary);
        sTDocument.readSecurityHandler = this.readSecurityHandler;
        sTDocument.writeSecurityHandler = this.writeSecurityHandler;
        String string = Msg.getString("STDocument.documentName.copyOf", (Object)this.getName());
        sTDocument.locator = new TransientLocator(string, this.getDocType().getTypeName());
        return sTDocument;
    }

    public COSDictionary cosGetTrailer() {
        return this.getXRefSection().cosGetDict();
    }

    public STXRefSection createNewXRefSection() {
        if (this.getXRefSection().getOffset() != -1L) {
            return this.getXRefSection().createSuccessor();
        }
        return this.getXRefSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COSObjectKey createObjectKey() {
        COSObjectKey cOSObjectKey = this.nextKey;
        synchronized (cOSObjectKey) {
            this.nextKey = this.nextKey.createNextKey();
            return this.nextKey;
        }
    }

    protected IRandomAccess createRandomAccess(ILocator iLocator) throws IOException {
        if (iLocator == null) {
            return null;
        }
        IRandomAccess iRandomAccess = iLocator.getRandomAccess();
        if (iRandomAccess.isReadOnly()) {
            iLocator.setReadOnly();
        }
        BufferedRandomAccess bufferedRandomAccess = new BufferedRandomAccess(iRandomAccess, 4096);
        return bufferedRandomAccess;
    }

    protected void ensureLength(int n) {
        if (n >= this.objects.length) {
            int n2 = this.objects.length + 100;
            if (n >= n2) {
                n2 = n + 100;
            }
            COSIndirectObject[] cOSIndirectObjectArray = new COSIndirectObject[n2];
            System.arraycopy(this.objects, 0, cOSIndirectObjectArray, 0, this.objects.length);
            this.objects = cOSIndirectObjectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void garbageCollect() {
        Object object = this.changes;
        synchronized (object) {
            this.changes.clear();
        }
        object = new COSObjectWalkerDeep(){

            @Override
            public Object visitFromIndirectObject(COSIndirectObject cOSIndirectObject) throws COSVisitorException {
                if (this.getVisited().contains(cOSIndirectObject)) {
                    return null;
                }
                super.visitFromIndirectObject(cOSIndirectObject);
                COSObject cOSObject = cOSIndirectObject.dereference();
                cOSIndirectObject.setDirty(true);
                return null;
            }
        };
        try {
            this.cosGetTrailer().accept((ICOSObjectVisitor)object);
        }
        catch (COSVisitorException cOSVisitorException) {
            // empty catch block
        }
        STTrailerXRefSection sTTrailerXRefSection = new STTrailerXRefSection(this);
        COSDictionary cOSDictionary = sTTrailerXRefSection.cosGetDict();
        cOSDictionary.addAll(this.cosGetTrailer());
        cOSDictionary.remove(COSTrailer.DK_Prev);
        cOSDictionary.remove(COSTrailer.DK_Size);
        cOSDictionary.remove(STXRefSection.DK_XRefStm);
        this.setXRefSection(sTTrailerXRefSection);
        Object object2 = this.objects;
        synchronized (this.objects) {
            Arrays.fill(this.objects, null);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            object2 = this.nextKey;
            synchronized (object2) {
                this.nextKey = new COSObjectKey(0, 0);
            }
            for (COSIndirectObject cOSIndirectObject : ((COSObjectWalkerDeep)object).getVisited()) {
                cOSIndirectObject.setKey(null);
                this.addObjectReference(cOSIndirectObject);
            }
            return;
        }
    }

    public Object getAccessLock() {
        return this.accessLock;
    }

    public IAccessPermissions getAccessPermissions() {
        ISecurityHandler iSecurityHandler;
        if (this.getReadSecurityHandler() != null && (iSecurityHandler = this.getReadSecurityHandler().getSecurityHandler()) instanceof IAccessPermissionsSupport) {
            return ((IAccessPermissionsSupport)((Object)iSecurityHandler)).getAccessPermissions();
        }
        return AccessPermissionsFull.get();
    }

    public final synchronized Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<COSIndirectObject> getChanges() {
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            return this.changes;
        }
    }

    public COSDocument getDoc() {
        return this.doc;
    }

    public STDocType getDocType() {
        return this.docType;
    }

    public int getIncrementalCount() {
        return this.getXRefSection().getIncrementalCount();
    }

    public COSDictionary getLinearizedDict() {
        Object object;
        int n = 0;
        Iterator iterator = this.getXRefSection().entryIterator();
        while (iterator.hasNext()) {
            object = (STXRefEntry)iterator.next();
            if (((STXRefEntry)object).getObjectNumber() == 0) continue;
            n = ((STXRefEntry)object).getObjectNumber();
            break;
        }
        try {
            COSObject cOSObject;
            object = this.load(n);
            if (object != null && ((COSObject)object).asDictionary() != null && !(cOSObject = ((COSObject)object).asDictionary().get(COSName.constant("Linearized"))).isNull()) {
                return ((COSObject)object).asDictionary();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.getLocator().getLocalName();
    }

    public COSIndirectObject getObjectReference(COSObjectKey cOSObjectKey) {
        return this.getObjectReference(cOSObjectKey.getObjectNumber(), cOSObjectKey.getGenerationNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COSIndirectObject getObjectReference(int n, int n2) {
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            COSIndirectObject cOSIndirectObject = null;
            if (n < this.objects.length) {
                cOSIndirectObject = this.objects[n];
            }
            if (cOSIndirectObject == null) {
                cOSIndirectObject = COSIndirectObject.create(this, n, n2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cOSIndirectObject;
        }
    }

    public COSDocumentParser getParser() {
        return this.parser;
    }

    public IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    public ISystemSecurityHandler getReadSecurityHandler() {
        return this.readSecurityHandler;
    }

    public COSTrailer getTrailer() {
        return (COSTrailer)COSTrailer.META.createFromCos(this.cosGetTrailer());
    }

    public String getVersion() {
        return this.getDocType().toString();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.writeModeHint;
    }

    public ISystemSecurityHandler getWriteSecurityHandler() {
        return this.writeSecurityHandler;
    }

    public STXRefSection getXRefSection() {
        return this.xRefSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementalGarbageCollect() {
        HashSet<COSIndirectObject> hashSet;
        Object object = this.changes;
        synchronized (object) {
            hashSet = new HashSet<COSIndirectObject>(this.changes);
        }
        object = new COSObjectWalkerDeep(true, false){

            @Override
            public Object visitFromIndirectObject(COSIndirectObject cOSIndirectObject) throws COSVisitorException {
                hashSet.remove(cOSIndirectObject);
                return super.visitFromIndirectObject(cOSIndirectObject);
            }
        };
        try {
            this.cosGetTrailer().accept((ICOSObjectVisitor)object);
        }
        catch (COSVisitorException cOSVisitorException) {
            // empty catch block
        }
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            this.changes.removeAll(hashSet);
        }
    }

    protected void initEncryption() throws IOException {
        this.readSecurityHandler = null;
        this.writeSecurityHandler = null;
        try {
            this.readSecurityHandler = SystemSecurityHandler.createFromSt(this);
            if (this.readSecurityHandler != null) {
                this.readSecurityHandler.authenticate();
            }
        }
        catch (COSSecurityException cOSSecurityException) {
            IOException iOException = new IOException(cOSSecurityException.getMessage());
            iOException.initCause(cOSSecurityException);
            throw iOException;
        }
        this.writeSecurityHandler = this.readSecurityHandler;
    }

    protected void initializeFromLocator() throws IOException, COSLoadException {
        this.parser = new COSDocumentParser(this);
        this.streamLoad();
    }

    protected void initializeFromScratch(STDocType sTDocType) {
        this.setDocType(sTDocType);
        String string = STDocument.createName(this.getDocType().getTypeName());
        this.locator = new TransientLocator(string, sTDocType.getTypeName());
        this.parser = new COSDocumentParser(this);
        this.setXRefSection(new STTrailerXRefSection(this));
        this.nextKey = new COSObjectKey(0, 0);
        this.cosGetTrailer().put(COSTrailer.DK_Root, COSCatalog.META.createNew().cosGetDict());
        this.setDirty(true);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEncrypted() {
        return this.getReadSecurityHandler() != null;
    }

    public boolean isLinearized() {
        return this.getLinearizedDict() != null;
    }

    public boolean isNew() {
        return this.getXRefSection().getOffset() == -1L && this.getXRefSection().getPrevious() == null;
    }

    public boolean isReadOnly() {
        return this.getRandomAccess() == null || this.getRandomAccess().isReadOnly();
    }

    public boolean isStreamed() {
        if (this.getXRefSection() != null) {
            return this.getXRefSection().isStreamed();
        }
        return false;
    }

    public COSObject load(COSIndirectObject cOSIndirectObject) throws IOException, COSLoadException {
        int n = cOSIndirectObject.getKey().getObjectNumber();
        return this.load(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSObject load(int n) throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return COSNull.NULL;
            }
            return this.getXRefSection().load(n, this.getReadSecurityHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            int n = 0;
            while (n < this.getXRefSection().getSize()) {
                this.getXRefSection().load(n, this.getReadSecurityHandler());
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadedSize() {
        int n = 0;
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            COSIndirectObject[] cOSIndirectObjectArray2 = this.objects;
            int n2 = this.objects.length;
            int n3 = 0;
            while (n3 < n2) {
                COSIndirectObject cOSIndirectObject = cOSIndirectObjectArray2[n3];
                if (!cOSIndirectObject.isSwapped()) {
                    ++n;
                }
                ++n3;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    public Iterator objects() {
        return new Iterator(){
            int i = 1;
            int size;
            {
                this.size = STDocument.this.getXRefSection().getSize();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("");
                }
                return STDocument.this.getObjectReference(this.i++, 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.randomAccess != null && !this.isClosed()) {
                throw new IllegalStateException("can't open an open document");
            }
            this.setRandomAccess(this.createRandomAccess(this.getLocator()));
        }
    }

    public final synchronized Object removeAttribute(Object object) {
        Object object2 = this.attributes.remove(object);
        this.triggerChanged(object, object2, null);
        return object2;
    }

    public void removeNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        this.dispatcher.removeNotificationListener(eventType, iNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFromLocator() throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            int n = this.getParser().searchLastStartXRef(this.getRandomAccess());
            AbstractXRefParser abstractXRefParser = this.getParser().isTokenXRefAt(this.getRandomAccess(), n) ? new XRefTrailerParser(this, this.getParser()) : new XRefStreamParser(this, this.getParser());
            this.getRandomAccess().seek((long)n);
            abstractXRefParser.parse(this.getRandomAccess());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceLocator(ILocator iLocator) throws IOException {
        ILocator iLocator2 = this.getLocator();
        if (iLocator.equals(iLocator2)) {
            return;
        }
        Object object = this.getAccessLock();
        synchronized (object) {
            IRandomAccess iRandomAccess = this.getRandomAccess();
            try {
                this.setLocator(iLocator);
                this.setRandomAccess(null);
                this.open();
                IRandomAccess iRandomAccess2 = this.getRandomAccess();
                if (iRandomAccess2.isReadOnly()) {
                    throw new FileNotFoundException();
                }
                if (iRandomAccess != null) {
                    iRandomAccess2.setLength(iRandomAccess.getLength());
                    InputStream inputStream = iRandomAccess.asInputStream();
                    OutputStream outputStream = iRandomAccess2.asOutputStream();
                    iRandomAccess.seek(0L);
                    StreamTools.copyStream((InputStream)inputStream, (boolean)false, (OutputStream)outputStream, (boolean)false);
                } else {
                    iRandomAccess2.setLength(0L);
                }
                StreamTools.close((IRandomAccess)iRandomAccess);
            }
            catch (Exception exception) {
                StreamTools.close((IRandomAccess)this.getRandomAccess());
                this.setLocator(iLocator2);
                this.setRandomAccess(iRandomAccess);
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw ExceptionTools.createIOException((String)("unexpected exception saving '" + iLocator.getFullName() + "'"), (Throwable)exception);
            }
        }
        this.triggerChanged(ATTR_LOCATOR, iLocator2, iLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void restore(ILocator iLocator) throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        // MONITORENTER : object
        ILocator iLocator2 = this.getLocator();
        if (iLocator.equals(iLocator2)) {
            // MONITOREXIT : object
            return;
        }
        IRandomAccess iRandomAccess = this.getRandomAccess();
        StreamTools.close((IRandomAccess)iRandomAccess);
        this.setRandomAccess(null);
        this.setLocator(iLocator);
        COSIndirectObject[] cOSIndirectObjectArray = this.changes;
        // MONITORENTER : this.changes
        this.changes.clear();
        // MONITOREXIT : cOSIndirectObjectArray
        cOSIndirectObjectArray = this.objects;
        // MONITORENTER : this.objects
        Arrays.fill(this.objects, null);
        // MONITOREXIT : cOSIndirectObjectArray
        this.closed = false;
        this.dirty = false;
        this.streamLoad();
        // MONITOREXIT : object
        this.getDoc().triggerChangedAll();
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator iLocator) throws IOException {
        this.save(iLocator, null);
    }

    public void save(ILocator iLocator, Map hashMap) throws IOException {
        Object object;
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (iLocator != null && iLocator != this.getLocator()) {
            this.replaceLocator(iLocator);
        }
        boolean bl = true;
        EnumWriteMode enumWriteMode = this.doc.getWriteModeHint();
        this.doc.setWriteModeHint(EnumWriteMode.UNDEFINED);
        if (enumWriteMode.isUndefined() && (object = hashMap.get(OPTION_WRITEMODEHINT)) instanceof EnumWriteMode) {
            enumWriteMode = (EnumWriteMode)((Object)object);
        }
        if (enumWriteMode.isFull()) {
            bl = false;
        }
        if ((object = this.getRandomAccess()) == null) {
            throw new IOException("nowhere to write to");
        }
        if (object.isReadOnly()) {
            throw new FileNotFoundException("destination is read only");
        }
        COSWriter cOSWriter = new COSWriter((IRandomAccess)object, this.getWriteSecurityHandler());
        cOSWriter.setIncremental(bl);
        cOSWriter.writeDocument(this);
        this.readSecurityHandler = this.writeSecurityHandler;
    }

    public final synchronized Object setAttribute(Object object, Object object2) {
        Object object3 = this.attributes.put(object, object2);
        this.triggerChanged(object, object3, object2);
        return object3;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (!bl) {
            Set<COSIndirectObject> set = this.changes;
            synchronized (set) {
                this.changes.clear();
            }
        }
    }

    public void setDoc(COSDocument cOSDocument) {
        this.doc = cOSDocument;
        this.getXRefSection().setCOSDoc(this.getDoc());
    }

    protected void setDocType(STDocType sTDocType) {
        this.docType = sTDocType;
    }

    protected void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }

    public void setName(String string) {
        if (this.getLocator() instanceof TransientLocator) {
            ((TransientLocator)this.getLocator()).setLocalName(string);
        }
    }

    protected void setRandomAccess(IRandomAccess iRandomAccess) {
        this.randomAccess = iRandomAccess;
    }

    public void setSystemSecurityHandler(ISystemSecurityHandler iSystemSecurityHandler) throws COSSecurityException {
        ISystemSecurityHandler iSystemSecurityHandler2 = this.writeSecurityHandler;
        if (this.writeSecurityHandler != null) {
            this.writeSecurityHandler.detach(this);
        }
        this.writeSecurityHandler = iSystemSecurityHandler;
        if (this.writeSecurityHandler != null) {
            this.writeSecurityHandler.attach(this);
        }
        this.triggerChanged(ATTR_SYSTEM_SECURITY_HANDLER, iSystemSecurityHandler2, this.writeSecurityHandler);
    }

    public void setWriteModeHint(EnumWriteMode enumWriteMode) {
        if (enumWriteMode == null) {
            throw new IllegalArgumentException("write mode can't be null");
        }
        this.writeModeHint = enumWriteMode;
    }

    public void setXRefSection(STXRefSection sTXRefSection) {
        STXRefSection sTXRefSection2 = this.xRefSection;
        this.xRefSection = sTXRefSection;
        if (this.getDoc() != null) {
            this.xRefSection.setCOSDoc(this.getDoc());
        }
        this.triggerChanged(ATTR_XREF_SECTION, sTXRefSection2, this.xRefSection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void streamLoad() throws IOException, COSLoadException {
        try {
            STXRefSection sTXRefSection;
            int n;
            this.open();
            this.setDocType(this.getParser().parseHeader(this.getRandomAccess()));
            try {
                n = this.getParser().searchLastStartXRef(this.getRandomAccess());
                AbstractXRefParser abstractXRefParser = this.getParser().isTokenXRefAt(this.getRandomAccess(), n) ? new XRefTrailerParser(this, this.getParser()) : new XRefStreamParser(this, this.getParser());
                this.getRandomAccess().seek((long)n);
                sTXRefSection = abstractXRefParser.parse(this.getRandomAccess());
                this.setXRefSection(sTXRefSection);
                this.checkConsistency();
            }
            catch (Exception exception) {
                Log.log(Level.FINEST, "error parsing " + this.getLocator().getFullName(), exception);
                COSIndirectObject[] cOSIndirectObjectArray = this.objects;
                // MONITORENTER : this.objects
                Arrays.fill(this.objects, null);
                // MONITOREXIT : cOSIndirectObjectArray
                sTXRefSection = new XRefFallbackParser(this, this.getParser()).parse(this.getRandomAccess());
                this.setXRefSection(sTXRefSection);
                this.checkConsistency();
            }
            n = sTXRefSection.getSize();
            this.nextKey = new COSObjectKey(n - 1, 0);
            this.ensureLength(n);
            this.initEncryption();
            return;
        }
        catch (IOException iOException) {
            try {
                this.close();
                throw iOException;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (COSLoadException cOSLoadException) {
            try {
                this.close();
                throw cOSLoadException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw cOSLoadException;
        }
    }

    protected void triggerChanged(Object object, Object object2, Object object3) {
        AttributeChangedEvent attributeChangedEvent = new AttributeChangedEvent((Object)this, object, object2, object3);
        this.triggerEvent((Event)attributeChangedEvent);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    public void updateModificationDate() {
        COSDictionary cOSDictionary = this.cosGetTrailer().get(COSTrailer.DK_Info).asDictionary();
        if (cOSDictionary == null) {
            return;
        }
        cOSDictionary.put(COSInfoDict.DK_ModDate, new CDSDate().cosGetObject());
    }
}

