/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionChangeSupport<T> {
    private final Object source;
    private final List<CollectionListener<T>> collectionListeners;

    public CollectionChangeSupport(Object object) {
        this.source = object;
        this.collectionListeners = new ArrayList<CollectionListener<T>>(5);
    }

    public void addCollectionListener(CollectionListener<T> collectionListener) {
        this.collectionListeners.add(collectionListener);
    }

    public void removeCollectionListener(CollectionListener<T> collectionListener) {
        this.collectionListeners.remove(collectionListener);
    }

    public void fireCollectionChanged(T t, CollectionEvent.Type type) {
        this.fireCollectionChanged(t, -1, type);
    }

    public void fireCollectionChanged(T t, int n, CollectionEvent.Type type) {
        if (!this.collectionListeners.isEmpty()) {
            CollectionListener[] collectionListenerArray;
            CollectionEvent<T> collectionEvent = new CollectionEvent<T>(this.source, t, n, type);
            for (CollectionListener collectionListener : collectionListenerArray = this.collectionListeners.toArray(new CollectionListener[this.collectionListeners.size()])) {
                collectionListener.collectionChanged(collectionEvent);
            }
        }
    }
}

