/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ProportionalLayout;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.viewcontroller.BackgroundImageWizardController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class BackgroundImageWizardStepsPanel
extends JPanel
implements View {
    private static final int LARGE_IMAGE_PIXEL_COUNT_THRESHOLD = 10000000;
    private static final int LARGE_IMAGE_MAX_PIXEL_COUNT = 8000000;
    private final BackgroundImageWizardController controller;
    private final Executor imageLoader;
    private CardLayout cardLayout;
    private JLabel imageChoiceOrChangeLabel;
    private JButton imageChoiceOrChangeButton;
    private JLabel imageChoiceErrorLabel;
    private ScaledImageComponent imageChoicePreviewComponent;
    private JLabel scaleLabel;
    private JLabel scaleDistanceLabel;
    private JSpinner scaleDistanceSpinner;
    private ScaledImageComponent scalePreviewComponent;
    private JLabel originLabel;
    private JLabel xOriginLabel;
    private JSpinner xOriginSpinner;
    private JLabel yOriginLabel;
    private JSpinner yOriginSpinner;
    private ScaledImageComponent originPreviewComponent;
    private static BufferedImage waitImage;

    public BackgroundImageWizardStepsPanel(BackgroundImage backgroundImage, UserPreferences userPreferences, final BackgroundImageWizardController backgroundImageWizardController) {
        this.controller = backgroundImageWizardController;
        this.imageLoader = Executors.newSingleThreadExecutor();
        this.createComponents(userPreferences, backgroundImageWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
        this.updateController(backgroundImage, userPreferences);
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BackgroundImageWizardStepsPanel.this.updateStep(backgroundImageWizardController);
            }
        });
    }

    private void createComponents(final UserPreferences userPreferences, final BackgroundImageWizardController backgroundImageWizardController) {
        String string = userPreferences.getLengthUnit().getName();
        this.imageChoiceOrChangeLabel = new JLabel();
        this.imageChoiceOrChangeButton = new JButton();
        this.imageChoiceOrChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BackgroundImageWizardStepsPanel.this.showImageChoiceDialog(userPreferences, backgroundImageWizardController.getContentManager());
                if (string != null) {
                    BackgroundImageWizardStepsPanel.this.updateController(string, userPreferences, backgroundImageWizardController.getContentManager());
                }
            }
        });
        this.imageChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceErrorLabel.text", new Object[0]));
        this.imageChoiceErrorLabel.setVisible(false);
        this.imageChoicePreviewComponent = new ScaledImageComponent();
        this.imageChoicePreviewComponent.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = true;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final String string = ((File)list.get(0)).getAbsolutePath();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            BackgroundImageWizardStepsPanel.this.updateController(string, userPreferences, backgroundImageWizardController.getContentManager());
                        }
                    });
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceError", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.imageChoicePreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.scaleLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "scaleLabel.text", new Object[0]));
        this.scaleDistanceLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "scaleDistanceLabel.text", string));
        float f = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, userPreferences.getLengthUnit().getMinimumLength(), f);
        this.scaleDistanceSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        this.scaleDistanceSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                backgroundImageWizardController.setScaleDistance(((NullableSpinner.NullableSpinnerLengthModel)BackgroundImageWizardStepsPanel.this.scaleDistanceSpinner.getModel()).getLength());
            }
        });
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.SCALE_DISTANCE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(backgroundImageWizardController.getScaleDistance() == null);
                nullableSpinnerLengthModel.setLength(backgroundImageWizardController.getScaleDistance());
            }
        });
        this.scalePreviewComponent = new ScaleImagePreviewComponent(backgroundImageWizardController);
        this.originLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "originLabel.text", new Object[0]));
        this.xOriginLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "xOriginLabel.text", string));
        this.yOriginLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "yOriginLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, backgroundImageWizardController.getXOrigin(), -f, f);
        this.xOriginSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, backgroundImageWizardController.getYOrigin(), -f, f);
        this.yOriginSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                backgroundImageWizardController.setOrigin(nullableSpinnerLengthModel2.getLength().floatValue(), nullableSpinnerLengthModel3.getLength().floatValue());
            }
        };
        nullableSpinnerLengthModel2.addChangeListener(changeListener);
        nullableSpinnerLengthModel3.addChangeListener(changeListener);
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.X_ORIGIN, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(backgroundImageWizardController.getXOrigin()));
            }
        });
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.Y_ORIGIN, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength(Float.valueOf(backgroundImageWizardController.getYOrigin()));
            }
        });
        this.originPreviewComponent = new OriginImagePreviewComponent(backgroundImageWizardController);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.scaleDistanceLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "scaleDistanceLabel.mnemonic", new Object[0])).getKeyCode());
            this.scaleDistanceLabel.setLabelFor(this.scaleDistanceSpinner);
            this.xOriginLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "xOriginLabel.mnemonic", new Object[0])).getKeyCode());
            this.xOriginLabel.setLabelFor(this.xOriginSpinner);
            this.yOriginLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "yOriginLabel.mnemonic", new Object[0])).getKeyCode());
            this.yOriginLabel.setLabelFor(this.yOriginSpinner);
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.imageChoiceOrChangeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.imageChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.imageChoiceErrorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new ProportionalLayout());
        jPanel2.add((Component)jPanel, (Object)ProportionalLayout.Constraints.TOP);
        jPanel2.add((Component)this.imageChoicePreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.scaleLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.scaleDistanceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.scaleDistanceSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.createScalableImageComponent(this.scalePreviewComponent, userPreferences), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.originLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel4.add((Component)this.xOriginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel4.add((Component)this.xOriginSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 10), -10, 0));
        jPanel4.add((Component)this.yOriginLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel4.add((Component)this.yOriginSpinner, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), -10, 0));
        jPanel4.add((Component)this.createScalableImageComponent(this.originPreviewComponent, userPreferences), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, BackgroundImageWizardController.Step.CHOICE.name());
        this.add((Component)jPanel3, BackgroundImageWizardController.Step.SCALE.name());
        this.add((Component)jPanel4, BackgroundImageWizardController.Step.ORIGIN.name());
    }

    private JComponent createScalableImageComponent(final ScaledImageComponent scaledImageComponent, UserPreferences userPreferences) {
        final JButton jButton = new JButton();
        final JButton jButton2 = new JButton();
        jButton.setAction(new ResourceAction(userPreferences, BackgroundImageWizardStepsPanel.class, "ZOOM_IN", true){

            public void actionPerformed(ActionEvent actionEvent) {
                final Rectangle rectangle = ((JViewport)scaledImageComponent.getParent()).getViewRect();
                scaledImageComponent.setScaleMultiplier(2.0f * scaledImageComponent.getScaleMultiplier());
                jButton2.setEnabled(scaledImageComponent.getScaleMultiplier() > 1.0f);
                jButton.setEnabled(scaledImageComponent.getScaleMultiplier() < 32.0f);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((JViewport)scaledImageComponent.getParent()).setViewPosition(new Point((int)(rectangle.getCenterX() * 2.0 - (double)(rectangle.width / 2)), (int)(rectangle.getCenterY() * 2.0 - (double)(rectangle.height / 2))));
                    }
                });
            }
        });
        jButton.setPreferredSize(new Dimension(30, 30));
        jButton2.setAction(new ResourceAction(userPreferences, BackgroundImageWizardStepsPanel.class, "ZOOM_OUT", false){

            public void actionPerformed(ActionEvent actionEvent) {
                final Rectangle rectangle = ((JViewport)scaledImageComponent.getParent()).getViewRect();
                scaledImageComponent.setScaleMultiplier(0.5f * scaledImageComponent.getScaleMultiplier());
                jButton2.setEnabled(scaledImageComponent.getScaleMultiplier() > 1.0f);
                jButton.setEnabled(scaledImageComponent.getScaleMultiplier() < 128.0f);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((JViewport)scaledImageComponent.getParent()).setViewPosition(new Point(Math.max(0, (int)(rectangle.getCenterX() / 2.0 - (double)(rectangle.width / 2))), Math.max(0, (int)(rectangle.getCenterY() / 2.0 - (double)(rectangle.height / 2)))));
                    }
                });
            }
        });
        jButton2.setPreferredSize(new Dimension(30, 30));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = SwingTools.createScrollPane(scaledImageComponent);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateStep(BackgroundImageWizardController backgroundImageWizardController) {
        BackgroundImageWizardController.Step step = backgroundImageWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case CHOICE: {
                this.imageChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case SCALE: {
                ((JSpinner.DefaultEditor)this.scaleDistanceSpinner.getEditor()).getTextField().requestFocusInWindow();
                break;
            }
            case ORIGIN: {
                ((JSpinner.DefaultEditor)this.xOriginSpinner.getEditor()).getTextField().requestFocusInWindow();
            }
        }
    }

    private void updateController(final BackgroundImage backgroundImage, final UserPreferences userPreferences) {
        if (backgroundImage == null) {
            this.setImageChoiceTexts(userPreferences);
            this.updatePreviewComponentsImage(null);
        } else {
            this.setImageChangeTexts(userPreferences);
            this.imageLoader.execute(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = BackgroundImageWizardStepsPanel.this.readImage(backgroundImage.getImage(), userPreferences);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    final BufferedImage bufferedImage2 = bufferedImage;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (bufferedImage2 != null) {
                                BackgroundImageWizardStepsPanel.this.controller.setImage(backgroundImage.getImage());
                                BackgroundImageWizardStepsPanel.this.controller.setScaleDistance(Float.valueOf(backgroundImage.getScaleDistance()));
                                BackgroundImageWizardStepsPanel.this.controller.setScaleDistancePoints(backgroundImage.getScaleDistanceXStart(), backgroundImage.getScaleDistanceYStart(), backgroundImage.getScaleDistanceXEnd(), backgroundImage.getScaleDistanceYEnd());
                                BackgroundImageWizardStepsPanel.this.controller.setOrigin(backgroundImage.getXOrigin(), backgroundImage.getYOrigin());
                            } else {
                                BackgroundImageWizardStepsPanel.this.controller.setImage(null);
                                BackgroundImageWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                                BackgroundImageWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateController(final String string, final UserPreferences userPreferences, final ContentManager contentManager) {
        this.imageLoader.execute(new Runnable(){

            public void run() {
                Dimension dimension;
                Content content = null;
                try {
                    content = TemporaryURLContent.copyToTemporaryURLContent(contentManager.getContent(string));
                }
                catch (RecorderException recorderException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (content == null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceError", string));
                        }
                    });
                    return;
                }
                BufferedImage bufferedImage = null;
                try {
                    dimension = SwingTools.getImageSizeInPixels(content);
                    if ((long)dimension.width * (long)dimension.height > 10000000L && (content = BackgroundImageWizardStepsPanel.this.readAndReduceImage(content, dimension, userPreferences)) == null) {
                        return;
                    }
                    bufferedImage = BackgroundImageWizardStepsPanel.this.readImage(content, userPreferences);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                dimension = bufferedImage;
                TemporaryURLContent temporaryURLContent = content;
                EventQueue.invokeLater(new Runnable((BufferedImage)((Object)dimension), temporaryURLContent){
                    final /* synthetic */ BufferedImage val$readImage;
                    final /* synthetic */ Content val$readContent;
                    {
                        this.val$readImage = bufferedImage;
                        this.val$readContent = content;
                    }

                    public void run() {
                        if (this.val$readImage != null) {
                            BackgroundImageWizardStepsPanel.this.controller.setImage(this.val$readContent);
                            BackgroundImageWizardStepsPanel.this.setImageChangeTexts(userPreferences);
                            BackgroundImageWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(false);
                            BackgroundImageWizardStepsPanel.this.controller.setScaleDistance(null);
                            float f = (float)this.val$readImage.getWidth() * 0.1f;
                            float f2 = (float)this.val$readImage.getHeight() / 2.0f;
                            float f3 = (float)this.val$readImage.getWidth() * 0.9f;
                            BackgroundImageWizardStepsPanel.this.controller.setScaleDistancePoints(f, f2, f3, f2);
                            BackgroundImageWizardStepsPanel.this.controller.setOrigin(0.0f, 0.0f);
                        } else if (BackgroundImageWizardStepsPanel.this.isShowing()) {
                            BackgroundImageWizardStepsPanel.this.controller.setImage(null);
                            BackgroundImageWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private Content readAndReduceImage(Content content, final Dimension dimension, final UserPreferences userPreferences) throws IOException {
        try {
            float f = (float)Math.sqrt(8000000.0f / (float)((long)dimension.width * (long)dimension.height));
            final int n = Math.round((float)dimension.width * f);
            final int n2 = Math.round((float)dimension.height * f);
            final AtomicInteger atomicInteger = new AtomicInteger(2);
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    String string = userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "reduceImageSize.title", new Object[0]);
                    String string2 = userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "reduceImageSize.message", dimension.width, dimension.height, n, n2);
                    String string3 = userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "reduceImageSize.reduceSize", new Object[0]);
                    String string4 = userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "reduceImageSize.keepUnchanged", new Object[0]);
                    String string5 = userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "reduceImageSize.cancel", new Object[0]);
                    atomicInteger.set(JOptionPane.showOptionDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), string2, string, 1, 3, null, new Object[]{string3, string4, string5}, string4));
                }
            });
            if (atomicInteger.get() == 2) {
                return null;
            }
            if (atomicInteger.get() == 0) {
                this.updatePreviewComponentsWithWaitImage(userPreferences);
                InputStream inputStream = content.openStream();
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
                if (bufferedImage != null) {
                    BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                    Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.drawImage(bufferedImage, AffineTransform.getScaleInstance(f, f), null);
                    graphics2D.dispose();
                    File file = OperatingSystem.createTemporaryFile("background", ".tmp");
                    ImageIO.write((RenderedImage)bufferedImage2, bufferedImage.getTransparency() == 1 ? "JPEG" : "PNG", file);
                    return new TemporaryURLContent(file.toURI().toURL());
                }
            }
            return content;
        }
        catch (InterruptedException interruptedException) {
            return content;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return content;
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private BufferedImage readImage(Content content, UserPreferences userPreferences) throws IOException {
        try {
            this.updatePreviewComponentsWithWaitImage(userPreferences);
            InputStream inputStream = content.openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (bufferedImage != null) {
                this.updatePreviewComponentsImage(bufferedImage);
                return bufferedImage;
            }
            throw new IOException();
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private void updatePreviewComponentsWithWaitImage(UserPreferences userPreferences) throws IOException {
        if (waitImage == null) {
            waitImage = ImageIO.read(BackgroundImageWizardStepsPanel.class.getResource(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "waitIcon", new Object[0])));
        }
        this.updatePreviewComponentsImage(waitImage);
    }

    private void updatePreviewComponentsImage(BufferedImage bufferedImage) {
        this.imageChoicePreviewComponent.setImage(bufferedImage);
        this.scalePreviewComponent.setImage(bufferedImage);
        this.originPreviewComponent.setImage(bufferedImage);
    }

    private void setImageChangeTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChangeLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "imageChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setImageChoiceTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "imageChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showImageChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceDialog.title", new Object[0]), ContentManager.ContentType.IMAGE);
    }

    private static Color getSelectionColor() {
        Color color = OperatingSystem.isMacOSXLeopardOrSuperior() ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("textHighlight");
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        if (fArray[1] < 0.4f) {
            color = new Color(40, 89, 208);
        }
        return color;
    }

    private static class OriginImagePreviewComponent
    extends ScaledImageComponent {
        private final BackgroundImageWizardController controller;

        public OriginImagePreviewComponent(BackgroundImageWizardController backgroundImageWizardController) {
            super(null, true);
            this.controller = backgroundImageWizardController;
            this.addChangeListeners(backgroundImageWizardController);
            this.addMouseListener(backgroundImageWizardController);
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        }

        private void addChangeListeners(BackgroundImageWizardController backgroundImageWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    OriginImagePreviewComponent.this.repaint();
                }
            };
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.X_ORIGIN, propertyChangeListener);
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.Y_ORIGIN, propertyChangeListener);
        }

        public void addMouseListener(final BackgroundImageWizardController backgroundImageWizardController) {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger() && OriginImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        this.updateOrigin(mouseEvent.getPoint());
                    }
                }

                private void updateOrigin(Point point) {
                    Point point2 = OriginImagePreviewComponent.this.getImageTranslation();
                    float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                    float f = OriginImagePreviewComponent.this.getImageScale() / BackgroundImage.getScale(backgroundImageWizardController.getScaleDistance().floatValue(), fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                    float f2 = (float)Math.round((point.getX() - (double)point2.x) / (double)f * 10.0) / 10.0f;
                    float f3 = (float)Math.round((point.getY() - (double)point2.y) / (double)f * 10.0) / 10.0f;
                    backgroundImageWizardController.setOrigin(f2, f3);
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.updateOrigin(OriginImagePreviewComponent.this.getPointConstrainedInImage(mouseEvent.getX(), mouseEvent.getY()));
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (OriginImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        OriginImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(1));
                    } else {
                        OriginImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        protected void paintComponent(Graphics graphics) {
            if (this.getImage() != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Point point = this.getImageTranslation();
                graphics2D.setColor(UIManager.getColor("window"));
                graphics2D.fillRect(point.x, point.y, (int)((float)this.getImage().getWidth() * this.getImageScale()), (int)((float)this.getImage().getHeight() * this.getImageScale()));
                this.paintImage(graphics, AlphaComposite.getInstance(3, 0.5f));
                graphics2D.setPaint(BackgroundImageWizardStepsPanel.getSelectionColor());
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.translate(point.x, point.y);
                float[][] fArray = this.controller.getScaleDistancePoints();
                float f = this.getImageScale() / BackgroundImage.getScale(this.controller.getScaleDistance().floatValue(), fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                graphics2D.scale(f, f);
                graphics2D.translate(this.controller.getXOrigin(), this.controller.getYOrigin());
                float f2 = 4.0f / f;
                graphics2D.fill(new Ellipse2D.Float(-f2, -f2, f2 * 2.0f, f2 * 2.0f));
                graphics2D.setStroke(new BasicStroke(1.0f / f, 0, 2));
                graphics2D.draw(new Line2D.Double(8.0f / f, 0.0, -8.0f / f, 0.0));
                graphics2D.draw(new Line2D.Double(0.0, 8.0f / f, 0.0, -8.0f / f));
                graphics2D.setTransform(affineTransform);
                graphics2D.setStroke(stroke);
            }
        }
    }

    private static class ScaleImagePreviewComponent
    extends ScaledImageComponent {
        private final BackgroundImageWizardController controller;

        public ScaleImagePreviewComponent(BackgroundImageWizardController backgroundImageWizardController) {
            super(null, true);
            this.controller = backgroundImageWizardController;
            this.addChangeListeners(backgroundImageWizardController);
            this.addMouseListeners(backgroundImageWizardController);
            this.setBorder(null);
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke("shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("alt shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("control shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("meta shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("alt released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("control released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("meta released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            this.setInputMap(2, inputMap);
        }

        private void addChangeListeners(BackgroundImageWizardController backgroundImageWizardController) {
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.SCALE_DISTANCE_POINTS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScaleImagePreviewComponent.this.repaint();
                }
            });
        }

        public void addMouseListeners(final BackgroundImageWizardController backgroundImageWizardController) {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
                private int deltaXMousePressed;
                private int deltaYMousePressed;
                private boolean distanceStartPoint;
                private boolean distanceEndPoint;
                private Point lastMouseLocation;

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger()) {
                        this.mouseMoved(mouseEvent);
                        if (this.distanceStartPoint || this.distanceEndPoint) {
                            float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                            Point point = ScaleImagePreviewComponent.this.getImageTranslation();
                            float f = ScaleImagePreviewComponent.this.getImageScale();
                            this.deltaXMousePressed = mouseEvent.getX() - point.x;
                            this.deltaYMousePressed = mouseEvent.getY() - point.y;
                            if (this.distanceStartPoint) {
                                this.deltaXMousePressed = (int)((float)this.deltaXMousePressed - fArray[0][0] * f);
                                this.deltaYMousePressed = (int)((float)this.deltaYMousePressed - fArray[0][1] * f);
                            } else {
                                this.deltaXMousePressed = (int)((float)this.deltaXMousePressed - fArray[1][0] * f);
                                this.deltaYMousePressed = (int)((float)this.deltaYMousePressed - fArray[1][1] * f);
                            }
                            ActionMap actionMap = ScaleImagePreviewComponent.this.getActionMap();
                            actionMap.put((Object)ActionType.ACTIVATE_ALIGNMENT, new AbstractAction(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    this.mouseDragged(null, true);
                                }
                            });
                            actionMap.put((Object)ActionType.DEACTIVATE_ALIGNMENT, new AbstractAction(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    this.mouseDragged(null, false);
                                }
                            });
                            ScaleImagePreviewComponent.this.setActionMap(actionMap);
                        }
                    }
                    this.lastMouseLocation = mouseEvent.getPoint();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    ActionMap actionMap = ScaleImagePreviewComponent.this.getActionMap();
                    actionMap.remove((Object)ActionType.ACTIVATE_ALIGNMENT);
                    actionMap.remove((Object)ActionType.DEACTIVATE_ALIGNMENT);
                    ScaleImagePreviewComponent.this.setActionMap(actionMap);
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseDragged(mouseEvent.getPoint(), mouseEvent.isShiftDown());
                    this.lastMouseLocation = mouseEvent.getPoint();
                }

                public void mouseDragged(Point point, boolean bl) {
                    if (this.distanceStartPoint || this.distanceEndPoint) {
                        float[] fArray;
                        float[] fArray2;
                        if (point == null) {
                            point = this.lastMouseLocation;
                        }
                        Point point2 = ScaleImagePreviewComponent.this.getPointConstrainedInImage(point.x - this.deltaXMousePressed, point.y - this.deltaYMousePressed);
                        Point point3 = ScaleImagePreviewComponent.this.getImageTranslation();
                        float[][] fArray3 = backgroundImageWizardController.getScaleDistancePoints();
                        if (this.distanceStartPoint) {
                            fArray2 = fArray3[0];
                            fArray = fArray3[1];
                        } else {
                            fArray2 = fArray3[1];
                            fArray = fArray3[0];
                        }
                        float f = ScaleImagePreviewComponent.this.getImageScale();
                        float f2 = (float)((point2.getX() - (double)point3.x) / (double)f);
                        float f3 = (float)((point2.getY() - (double)point3.y) / (double)f);
                        if (Point2D.distanceSq(fArray[0] * f, fArray[1] * f, f2 * f, f3 * f) >= 4.0) {
                            if (bl) {
                                double d = Math.abs(Math.atan2(fArray[1] - f3, f2 - fArray[0]));
                                if (d > 0.7853981633974483 && d <= 2.356194490192345) {
                                    f2 = fArray[0];
                                } else {
                                    f3 = fArray[1];
                                }
                            }
                            fArray2[0] = f2;
                            fArray2[1] = f3;
                            backgroundImageWizardController.setScaleDistancePoints(fArray3[0][0], fArray3[0][1], fArray3[1][0], fArray3[1][1]);
                            ScaleImagePreviewComponent.this.repaint();
                        }
                    }
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.distanceEndPoint = false;
                    this.distanceStartPoint = false;
                    if (ScaleImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                        Point point = ScaleImagePreviewComponent.this.getImageTranslation();
                        float f = ScaleImagePreviewComponent.this.getImageScale();
                        if (Math.abs(fArray[0][0] * f - (float)mouseEvent.getX() + (float)point.x) <= 3.0f && Math.abs(fArray[0][1] * f - (float)mouseEvent.getY() + (float)point.y) <= 3.0f) {
                            this.distanceStartPoint = true;
                        } else if (Math.abs(fArray[1][0] * f - (float)mouseEvent.getX() + (float)point.x) <= 3.0f && Math.abs(fArray[1][1] * f - (float)mouseEvent.getY() + (float)point.y) <= 3.0f) {
                            this.distanceEndPoint = true;
                        }
                    }
                    if (this.distanceStartPoint || this.distanceEndPoint) {
                        ScaleImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(1));
                    } else {
                        ScaleImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        protected void paintComponent(Graphics graphics) {
            if (this.getImage() != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Point point = this.getImageTranslation();
                float f = this.getImageScale();
                graphics2D.setColor(UIManager.getColor("window"));
                graphics2D.fillRect(point.x, point.y, (int)((float)this.getImage().getWidth() * f), (int)((float)this.getImage().getHeight() * f));
                this.paintImage(graphics2D, AlphaComposite.getInstance(3, 0.5f));
                graphics2D.setPaint(BackgroundImageWizardStepsPanel.getSelectionColor());
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.translate(point.x, point.y);
                graphics2D.scale(f, f);
                graphics2D.setStroke(new BasicStroke(5.0f / f, 0, 2));
                float[][] fArray = this.controller.getScaleDistancePoints();
                graphics2D.draw(new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]));
                graphics2D.setStroke(new BasicStroke(1.0f / f, 0, 2));
                double d = Math.atan2(fArray[1][1] - fArray[0][1], fArray[1][0] - fArray[0][0]);
                AffineTransform affineTransform2 = graphics2D.getTransform();
                graphics2D.translate(fArray[0][0], fArray[0][1]);
                graphics2D.rotate(d);
                Line2D.Double double_ = new Line2D.Double(0.0, 5.0f / f, 0.0, -5.0f / f);
                graphics2D.draw(double_);
                graphics2D.setTransform(affineTransform2);
                graphics2D.translate(fArray[1][0], fArray[1][1]);
                graphics2D.rotate(d);
                graphics2D.draw(double_);
                graphics2D.setTransform(affineTransform);
                graphics2D.setStroke(stroke);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ActionType {
            ACTIVATE_ALIGNMENT,
            DEACTIVATE_ALIGNMENT;

        }
    }
}

