/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogItem;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureCatalogTree;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class CatalogItemToolTip
extends JToolTip {
    private static final int ICON_SIZE = 128;
    private final DisplayedInformation displayedInformation;
    private final UserPreferences preferences;
    private final JLabel itemIconLabel;
    private CatalogItem catalogItem;

    public CatalogItemToolTip(boolean bl, UserPreferences userPreferences) {
        this(bl ? DisplayedInformation.ICON_NAME_AUTHOR : DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY, userPreferences);
    }

    public CatalogItemToolTip(DisplayedInformation displayedInformation, UserPreferences userPreferences) {
        this.displayedInformation = displayedInformation;
        this.preferences = userPreferences;
        this.itemIconLabel = new JLabel();
        this.itemIconLabel.setPreferredSize(new Dimension(128, 128));
        this.itemIconLabel.setMinimumSize(this.itemIconLabel.getPreferredSize());
        this.itemIconLabel.setHorizontalAlignment(0);
        this.itemIconLabel.setVerticalAlignment(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.itemIconLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalogItem(CatalogItem catalogItem) {
        if (catalogItem != this.catalogItem) {
            String string;
            String string2 = null;
            if (this.preferences != null && (string = catalogItem.getCreator()) != null) {
                string2 = this.preferences.getLocalizedString(FurnitureCatalogTree.class, "tooltipCreator", string);
            }
            boolean bl = false;
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = "<html><center>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</center>";
                } else {
                    string = "";
                }
            } else if (this.isTipTextComplete()) {
                bl = true;
                string = "<html><table>";
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = string + "<tr><td align='center'>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</td></tr>";
                }
            } else if (this.displayedInformation != DisplayedInformation.ICON) {
                string = catalogItem.getName();
                if (string2 != null) {
                    string = string + " " + string2;
                }
            } else {
                string = null;
            }
            this.itemIconLabel.setIcon(null);
            if (catalogItem.getIcon() instanceof URLContent) {
                InputStream inputStream = null;
                try {
                    inputStream = catalogItem.getIcon().openStream();
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage != null) {
                        int n = Math.round(128.0f * Math.min(1.0f, (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()));
                        int n2 = Math.round((float)n * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
                        if (bl) {
                            string = string + "<tr><td width='128' height='128' align='center' valign='middle'><img width='" + n + "' height='" + n2 + "' src='" + ((URLContent)catalogItem.getIcon()).getURL() + "'></td></tr>";
                        } else {
                            this.itemIconLabel.setIcon(new ImageIcon(bufferedImage.getHeight() != n2 ? bufferedImage.getScaledInstance(n, n2, 4) : bufferedImage));
                        }
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (bl) {
                string = string + "</table>";
            }
            this.setTipText(string);
            this.catalogItem = catalogItem;
        }
    }

    public boolean isTipTextComplete() {
        return !OperatingSystem.isJavaVersionGreaterOrEqual("1.6") && OperatingSystem.isMacOSX();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.itemIconLabel.getIcon() != null) {
            dimension.width = Math.max(dimension.width, 134);
            dimension.height += 134;
        }
        return dimension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayedInformation {
        ICON,
        ICON_NAME_AUTHOR,
        ICON_NAME_AUTHOR_CATEGORY;

    }
}

