/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.config.Config;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.FormattedFont;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class FontHandler {
    private final DiagramHandler handler;
    private Double fontSize;
    private Double diagramDefaultSize = null;
    private String diagramDefaultFontFamily = null;
    private FontRenderContext fontrenderContext = new FontRenderContext(null, true, true);

    public FontHandler(DiagramHandler handler) {
        this.handler = handler;
    }

    public void setFontSize(Double fontsize) {
        this.fontSize = fontsize;
    }

    public void setDiagramDefaultFontFamily(String fontfamily) {
        if (Constants.fontFamilyList.contains(fontfamily)) {
            this.diagramDefaultFontFamily = fontfamily;
        }
    }

    public void resetDiagramDefaultFontFamily() {
        this.diagramDefaultFontFamily = null;
    }

    private String getDiagramDefaultFontFamily() {
        String returnFontFamily = this.diagramDefaultFontFamily != null ? this.diagramDefaultFontFamily : Config.getInstance().getDefaultFontFamily();
        return returnFontFamily;
    }

    public void setDiagramDefaultFontSize(Double diagramDefaultSize) {
        this.diagramDefaultSize = diagramDefaultSize;
    }

    public void resetFontSize() {
        this.fontSize = null;
    }

    public void resetDiagramDefaultFontSize() {
        this.diagramDefaultSize = null;
    }

    public double getFontSize() {
        return this.getFontSize(true);
    }

    public double getFontSize(boolean applyZoom) {
        Double returnFontSize = this.fontSize != null ? this.fontSize : (this.diagramDefaultSize != null ? this.diagramDefaultSize : Double.valueOf(Config.getInstance().getDefaultFontsize().intValue()));
        if (applyZoom) {
            return returnFontSize * (double)this.handler.getGridSize() / 10.0;
        }
        return returnFontSize;
    }

    public Font getFont() {
        return this.getFont(true);
    }

    public Font getFont(boolean applyZoom) {
        return new Font(this.getDiagramDefaultFontFamily(), 0, (int)this.getFontSize(applyZoom));
    }

    public double getDistanceBetweenTexts() {
        return this.getDistanceBetweenTexts(true);
    }

    public double getDistanceBetweenTexts(boolean applyZoom) {
        return this.getFontSize(applyZoom) / 4.0;
    }

    public DimensionDouble getTextSize(String stringWithFormatLabels) {
        return this.getTextSize(stringWithFormatLabels, true);
    }

    public DimensionDouble getTextSize(String stringWithFormatLabels, boolean applyZoom) {
        if (stringWithFormatLabels.isEmpty()) {
            return new DimensionDouble(0.0, 0.0);
        }
        return FontHandler.getTextSizeStatic(new FormattedFont(stringWithFormatLabels, this.getFontSize(applyZoom), this.getFont(applyZoom), this.fontrenderContext));
    }

    public double getTextWidth(String s) {
        return this.getTextWidth(s, true);
    }

    public double getTextWidth(String s, boolean applyZoom) {
        if (s == null) {
            return 0.0;
        }
        return this.getTextSize(s, applyZoom).getWidth();
    }

    public void writeText(Graphics2D g2, String s, double x, double y, AlignHorizontal align) {
        this.writeText(g2, s, x, y, align, true);
    }

    public void writeText(Graphics2D g2, String s, double x, double y, AlignHorizontal align, boolean applyZoom) {
        String[] stringArray = s.split("\n", -1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.write(g2, line, x, y, align, applyZoom);
            y += (double)g2.getFontMetrics().getHeight();
            ++n2;
        }
    }

    private void write(Graphics2D g2, String stringWithFormatLabels, double x, double y, AlignHorizontal align, boolean applyZoom) {
        if (stringWithFormatLabels == null || stringWithFormatLabels.isEmpty()) {
            return;
        }
        double fontSize = this.getFontSize(applyZoom);
        FormattedFont formattedFont = new FormattedFont(stringWithFormatLabels, fontSize, this.getFont(applyZoom), g2.getFontRenderContext());
        this.fontrenderContext = g2.getFontRenderContext();
        if (align == AlignHorizontal.CENTER) {
            x = (int)(x - formattedFont.getWidth() / 2.0);
        } else if (align == AlignHorizontal.RIGHT) {
            x = (int)(x - formattedFont.getWidth());
        }
        g2.drawString(formattedFont.getAttributedCharacterIterator(), (float)x, (float)y);
    }

    public static DimensionDouble getTextSizeStatic(FormattedFont formattedFont) {
        formattedFont.replaceFirstAndLastSpaceWithDot();
        TextLayout tl = new TextLayout(formattedFont.getAttributedCharacterIterator(), formattedFont.getFontRenderContext());
        return new DimensionDouble(tl.getBounds().getWidth(), tl.getBounds().getHeight());
    }
}

