/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw;

import com.baselet.control.StringStyle;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Lines;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawFunction;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.diagram.draw.helper.StyleException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class DrawHandler {
    protected static final double HALF_PX = 0.5;
    protected Style style = new Style();
    private final Style overlay = new Style();
    private final ArrayList<DrawFunction> drawablesBackground = new ArrayList();
    private final ArrayList<DrawFunction> drawablesForeground = new ArrayList();
    private Layer layer = Layer.Background;
    private boolean enableDrawing = true;

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setEnableDrawing(boolean bl) {
        this.enableDrawing = bl;
    }

    protected Style getOverlay() {
        return this.overlay;
    }

    protected void addDrawable(DrawFunction drawFunction) {
        if (this.enableDrawing) {
            if (this.layer == Layer.Foreground) {
                this.drawablesForeground.add(drawFunction);
            } else {
                this.drawablesBackground.add(drawFunction);
            }
        }
    }

    public void drawAll(boolean bl) {
        if (bl) {
            this.overlay.setForegroundColor(ColorOwn.SELECTION_FG);
        } else {
            this.overlay.setForegroundColor(null);
        }
        this.drawAll();
    }

    public void clearCache() {
        this.drawablesBackground.clear();
        this.drawablesForeground.clear();
    }

    public final double textHeightMaxWithSpace() {
        return this.textHeightMax() + this.getDistanceBetweenTextLines();
    }

    public final double textHeightMax() {
        return this.textDimension("Hy").getHeight();
    }

    public final double textHeight(String string) {
        return this.textDimension(string).getHeight();
    }

    public final double textWidth(String string) {
        return this.textDimension(string).getWidth();
    }

    public final void setForegroundColor(String string) {
        if (string.equals("fg")) {
            this.setForegroundColor(ColorOwn.DEFAULT_FOREGROUND);
        } else {
            this.setForegroundColor(ColorOwn.forString(string, ColorOwn.Transparency.FOREGROUND));
        }
    }

    public final void setForegroundColor(ColorOwn colorOwn) {
        if (colorOwn == null) {
            this.style.setForegroundColor(ColorOwn.DEFAULT_FOREGROUND);
        } else {
            this.style.setForegroundColor(colorOwn);
        }
    }

    public final void setBackgroundColor(String string) {
        if (string.equals("bg")) {
            this.setBackgroundColor(ColorOwn.DEFAULT_BACKGROUND);
        } else {
            this.setBackgroundColor(ColorOwn.forString(string, ColorOwn.Transparency.BACKGROUND));
        }
    }

    public final void setBackgroundColor(ColorOwn colorOwn) {
        if (colorOwn == null) {
            this.style.setBackgroundColor(ColorOwn.DEFAULT_BACKGROUND);
        } else {
            this.style.setBackgroundColor(colorOwn);
        }
    }

    public ColorOwn getForegroundColor() {
        return this.style.getForegroundColor();
    }

    public ColorOwn getBackgroundColor() {
        return this.style.getBackgroundColor();
    }

    public double getLineWidth() {
        return this.style.getLineWidth();
    }

    public void resetColorSettings() {
        this.setForegroundColor("fg");
        this.setBackgroundColor("bg");
    }

    public final void setFontSize(double d) {
        this.assertDoubleRange(d);
        this.style.setFontSize(d);
    }

    public double getFontSize() {
        return this.style.getFontSize();
    }

    public final void setLineType(LineType lineType) {
        this.style.setLineType(lineType);
    }

    public LineType getLineType() {
        return this.style.getLineType();
    }

    public final void setLineWidth(double d) {
        this.assertDoubleRange(d);
        this.style.setLineWidth(d);
    }

    private void assertDoubleRange(double d) {
        if (d <= 0.0 || d > 100.0) {
            throw new StyleException("value must be >0 and <=100");
        }
    }

    public void resetStyle() {
        this.resetColorSettings();
        this.style.setFontSize(this.getDefaultFontSize());
        this.style.setLineType(LineType.SOLID);
        this.style.setLineWidth(1.0);
    }

    public Style getStyleClone() {
        return this.style.cloneFromMe();
    }

    public void setStyle(Style style) {
        this.style = style.cloneFromMe();
    }

    public void drawAll() {
        for (DrawFunction drawFunction : this.drawablesBackground) {
            drawFunction.run();
        }
        for (DrawFunction drawFunction : this.drawablesForeground) {
            drawFunction.run();
        }
    }

    public double getDistanceBorderToText() {
        return 5.0;
    }

    public double getDistanceBetweenTextLines() {
        return 3.0;
    }

    protected DimensionDouble textDimension(String string) {
        return this.textDimensionHelper(StringStyle.replaceNotEscaped(string));
    }

    protected abstract DimensionDouble textDimensionHelper(String var1);

    protected abstract double getDefaultFontSize();

    public void drawRectangle(Rectangle rectangle) {
        this.drawRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void drawLine(Line line) {
        this.drawLine(line.getStart().getX(), line.getStart().getY(), line.getEnd().getX(), line.getEnd().getY());
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.drawLines(new PointDouble(d, d2), new PointDouble(d3, d4));
    }

    public void drawLines(Collection<PointDouble> collection) {
        this.drawLines(collection.toArray(new PointDouble[collection.size()]));
    }

    public void drawLines(Line ... lineArray) {
        this.drawLines(Lines.toPoints(lineArray));
    }

    public void print(String string, double d, double d2, AlignHorizontal alignHorizontal) {
        this.print(string, new PointDouble(d, d2), alignHorizontal);
    }

    protected String escape(String string) {
        return StringStyle.replaceNotEscaped(string);
    }

    public void print(String string, PointDouble pointDouble, AlignHorizontal alignHorizontal) {
        this.printHelper(StringStyle.replaceNotEscaped(string), pointDouble, alignHorizontal);
    }

    public abstract void drawArc(double var1, double var3, double var5, double var7, double var9, double var11, boolean var13);

    public abstract void drawCircle(double var1, double var3, double var5);

    public abstract void drawEllipse(double var1, double var3, double var5, double var7);

    public abstract void drawLines(PointDouble ... var1);

    public abstract void drawRectangle(double var1, double var3, double var5, double var7);

    public abstract void drawRectangleRound(double var1, double var3, double var5, double var7, double var9);

    public abstract void printHelper(String var1, PointDouble var2, AlignHorizontal var3);

    public static enum Layer {
        Foreground,
        Background;

    }
}

