/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.relation.helper.ResizableObject;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;

public class RelationDrawer {
    private static final double ARROW_LENGTH = 13.0;
    private static final double DIAGONAL_CROSS_LENGTH = 9.0;
    private static final double BOX_SIZE = 20.0;

    public static Rectangle drawBoxArrow(DrawHandler drawHandler, Line line, boolean bl, String string, ResizableObject resizableObject) {
        double d = drawHandler.getFontSize();
        drawHandler.setFontSize(12.0);
        double d2 = 20.0;
        double d3 = drawHandler.getDistanceBorderToText();
        double d4 = Math.max(20.0, drawHandler.textWidth(string) + d3 * 2.0);
        PointDoubleIndexed pointDoubleIndexed = (PointDoubleIndexed)line.getPoint(bl);
        Rectangle rectangle = new Rectangle(pointDoubleIndexed.getX() - d4 / 2.0, pointDoubleIndexed.getY() - d2 / 2.0, d4, d2);
        drawHandler.drawRectangle(rectangle);
        int n = 4;
        ColorOwn colorOwn = drawHandler.getBackgroundColor();
        drawHandler.setBackgroundColor(drawHandler.getForegroundColor());
        if (string.equals("^")) {
            PointDouble pointDouble = new PointDouble(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() - (double)n);
            drawHandler.drawLines(pointDouble, new PointDouble(pointDoubleIndexed.getX() + (double)n, pointDoubleIndexed.getY() + (double)n), new PointDouble(pointDoubleIndexed.getX() - (double)n, pointDoubleIndexed.getY() + (double)n), pointDouble);
        } else if (string.equals("<")) {
            PointDouble pointDouble = new PointDouble(pointDoubleIndexed.getX() - (double)n, pointDoubleIndexed.getY());
            drawHandler.drawLines(pointDouble, new PointDouble(pointDoubleIndexed.getX() + (double)n, pointDoubleIndexed.getY() - (double)n), new PointDouble(pointDoubleIndexed.getX() + (double)n, pointDoubleIndexed.getY() + (double)n), pointDouble);
        } else if (string.equals(">")) {
            PointDouble pointDouble = new PointDouble(pointDoubleIndexed.getX() + (double)n, pointDoubleIndexed.getY());
            drawHandler.drawLines(pointDouble, new PointDouble(pointDoubleIndexed.getX() - (double)n, pointDoubleIndexed.getY() - (double)n), new PointDouble(pointDoubleIndexed.getX() - (double)n, pointDoubleIndexed.getY() + (double)n), pointDouble);
        } else if (string.equals("v")) {
            PointDouble pointDouble = new PointDouble(pointDoubleIndexed.getX() - (double)n, pointDoubleIndexed.getY() - (double)n);
            drawHandler.drawLines(pointDouble, new PointDouble(pointDoubleIndexed.getX() + (double)n, pointDoubleIndexed.getY() - (double)n), new PointDouble(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() + (double)n), pointDouble);
        } else if (string.equals("=")) {
            int n2 = 2;
            int n3 = 6;
            drawHandler.drawLines(new PointDouble(pointDoubleIndexed.getX() - (double)n3, pointDoubleIndexed.getY() - (double)n2), new PointDouble(pointDoubleIndexed.getX() + (double)n3, pointDoubleIndexed.getY() - (double)n2), new PointDouble(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() - (double)n3));
            drawHandler.drawLines(new PointDouble(pointDoubleIndexed.getX() + (double)n3, pointDoubleIndexed.getY() + (double)n2), new PointDouble(pointDoubleIndexed.getX() - (double)n3, pointDoubleIndexed.getY() + (double)n2), new PointDouble(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() + (double)n3));
        } else {
            drawHandler.print(string, new PointDouble(pointDoubleIndexed.getX() - d4 / 2.0 + d3, pointDoubleIndexed.getY() + drawHandler.textHeightMax() / 2.0), AlignHorizontal.LEFT);
            resizableObject.setPointMinSize(pointDoubleIndexed.getIndex(), new Rectangle(-d4 / 2.0, -d2 / 2.0, d4, d2));
        }
        drawHandler.setFontSize(d);
        drawHandler.setBackgroundColor(colorOwn);
        return rectangle;
    }

    public static void drawArrowToLine(DrawHandler drawHandler, Line line, boolean bl, ArrowEndType arrowEndType, boolean bl2, boolean bl3) {
        RelationDrawer.drawArrowToLine(line.getPoint(bl), drawHandler, line, bl, arrowEndType, bl2, bl3);
    }

    public static void drawArrowToLine(PointDouble pointDouble, DrawHandler drawHandler, Line line, boolean bl, ArrowEndType arrowEndType, boolean bl2, boolean bl3) {
        if (bl3) {
            pointDouble = line.getPointOnLineWithDistanceFrom(bl, 13.0);
            bl = !bl;
        }
        int n = bl ? 150 : 30;
        PointDouble pointDouble2 = RelationDrawer.calcPointArrow(pointDouble, line.getAngleOfSlope() - (double)n);
        PointDouble pointDouble3 = RelationDrawer.calcPointArrow(pointDouble, line.getAngleOfSlope() + (double)n);
        ArrayList<PointDouble> arrayList = new ArrayList<PointDouble>(Arrays.asList(pointDouble2, pointDouble, pointDouble3));
        if (arrowEndType == ArrowEndType.CLOSED) {
            arrayList.add(pointDouble2);
        } else if (arrowEndType == ArrowEndType.DIAMOND) {
            double d = GeometricFunctions.getDistanceBetweenLineAndPoint(pointDouble2, pointDouble3, pointDouble) * 2.0;
            PointDouble pointDouble4 = bl ? line.getPointOnLineWithDistanceFrom(true, d) : line.getPointOnLineWithDistanceFrom(false, d);
            arrayList.add(pointDouble4);
            arrayList.add(pointDouble2);
        }
        if (bl2) {
            ColorOwn colorOwn = drawHandler.getBackgroundColor();
            drawHandler.setBackgroundColor(drawHandler.getForegroundColor());
            drawHandler.drawLines(arrayList);
            drawHandler.setBackgroundColor(colorOwn);
        } else {
            drawHandler.drawLines(arrayList);
        }
    }

    private static PointDouble calcPointArrow(PointDouble pointDouble, double d) {
        return RelationDrawer.calcPoint(pointDouble, d, 13.0);
    }

    private static PointDouble calcPointCross(PointDouble pointDouble, double d) {
        return RelationDrawer.calcPoint(pointDouble, d, 9.0);
    }

    private static PointDouble calcPoint(PointDouble pointDouble, double d, double d2) {
        double d3 = pointDouble.x + d2 * Math.cos(Math.toRadians(d));
        double d4 = pointDouble.y + d2 * Math.sin(Math.toRadians(d));
        return new PointDouble(d3, d4);
    }

    public static void drawCircle(DrawHandler drawHandler, Line line, boolean bl, ResizableObject resizableObject, Direction direction, boolean bl2) {
        PointDoubleIndexed pointDoubleIndexed = (PointDoubleIndexed)line.getPoint(bl);
        if (direction == null) {
            drawHandler.drawCircle(pointDoubleIndexed.getX(), pointDoubleIndexed.getY(), 10.0);
        } else if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            ColorOwn colorOwn = drawHandler.getBackgroundColor();
            drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
            double d = 30.0;
            Direction direction2 = line.getDirectionOfLine(bl);
            if (direction2 == Direction.RIGHT) {
                drawHandler.drawArc(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() - d / 2.0, d, d, 90.0, 180.0, true);
                resizableObject.setPointMinSize(pointDoubleIndexed.getIndex(), new Rectangle(-d / 4.0, -d / 2.0, d * 0.75, d));
            } else if (direction2 == Direction.DOWN) {
                drawHandler.drawArc(pointDoubleIndexed.getX() - d / 2.0, pointDoubleIndexed.getY(), d, d, 0.0, 180.0, true);
                resizableObject.setPointMinSize(pointDoubleIndexed.getIndex(), new Rectangle(-d / 2.0, -d / 4.0, d, d * 0.75));
            } else if (direction2 == Direction.LEFT) {
                drawHandler.drawArc(pointDoubleIndexed.getX() - d, pointDoubleIndexed.getY() - d / 2.0, d, d, -90.0, 180.0, true);
                resizableObject.setPointMinSize(pointDoubleIndexed.getIndex(), new Rectangle(-d / 2.0, -d / 2.0, d * 0.75, d));
            } else {
                drawHandler.drawArc(pointDoubleIndexed.getX() - d / 2.0, pointDoubleIndexed.getY() - d, d, d, -180.0, 180.0, true);
                resizableObject.setPointMinSize(pointDoubleIndexed.getIndex(), new Rectangle(-d / 2.0, -d / 2.0, d, d * 0.75));
            }
            drawHandler.setBackgroundColor(colorOwn);
        }
        if (bl2) {
            double d = 5.0;
            drawHandler.drawLine(pointDoubleIndexed.getX() - d, pointDoubleIndexed.getY(), pointDoubleIndexed.getX() + d, pointDoubleIndexed.getY());
            drawHandler.drawLine(pointDoubleIndexed.getX(), pointDoubleIndexed.getY() - d, pointDoubleIndexed.getX(), pointDoubleIndexed.getY() + d);
        }
    }

    public static void drawDiagonalCross(DrawHandler drawHandler, Line line, boolean bl, ResizableObject resizableObject, Direction direction, boolean bl2) {
        PointDouble pointDouble = line.getPointOnLineWithDistanceFrom(bl, 13.0);
        drawHandler.drawLines(RelationDrawer.calcPointCross(pointDouble, line.getAngleOfSlope() + 45.0), RelationDrawer.calcPointCross(pointDouble, line.getAngleOfSlope() - 135.0));
        drawHandler.drawLines(RelationDrawer.calcPointCross(pointDouble, line.getAngleOfSlope() - 45.0), RelationDrawer.calcPointCross(pointDouble, line.getAngleOfSlope() + 135.0));
    }

    public static enum ArrowEndType {
        NORMAL,
        CLOSED,
        DIAMOND;

    }
}

