/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.util.reflection.Whitebox;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.zaproxy.zap.utils.I18N;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Constant.class})
public class CommandLineUnitTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final Vector<CommandLineArgument[]> NO_EXTENSIONS_CUSTOM_ARGUMENTS = new Vector();
    private static final Map<String, CommandLineListener> NO_SUPPORTED_FILE_EXTENSIONS = Collections.emptyMap();
    @Mock
    private Constant constant;
    @Mock
    private I18N i18n;
    private CommandLine cmdLine;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mockConstantClass();
    }

    private void mockConstantClass() {
        this.constant = (Constant)PowerMockito.mock(Constant.class);
        this.i18n = (I18N)PowerMockito.mock(I18N.class);
        Whitebox.setInternalState((Object)this.constant, (String)"messages", (Object)this.i18n);
        BDDMockito.given((Object)this.i18n.getString(org.mockito.Matchers.anyString())).willReturn((Object)"");
        BDDMockito.given((Object)this.i18n.getString(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyObject())).willReturn((Object)"");
    }

    @Test
    public void emptyCommandLine() throws Exception {
        this.cmdLine = new CommandLine(new String[0]);
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertTrue((boolean)this.cmdLine.isGUI());
        Assert.assertFalse((boolean)this.cmdLine.isDaemon());
        Assert.assertFalse((boolean)this.cmdLine.isReportVersion());
    }

    @Test
    public void daemonFlag() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-daemon"});
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertFalse((boolean)this.cmdLine.isGUI());
        Assert.assertTrue((boolean)this.cmdLine.isDaemon());
        Assert.assertFalse((boolean)this.cmdLine.isReportVersion());
    }

    @Test
    public void shouldReportNonDaemonNorGuiIfSetCommandLineArgument() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-cmd"});
        Assert.assertThat((Object)this.cmdLine.isDaemon(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        Assert.assertThat((Object)this.cmdLine.isGUI(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test(expected=Exception.class)
    public void shouldFailIfSessionArgumentDoesNotHaveValue() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-session"});
    }

    @Test
    public void shouldAcceptSessionArgument() throws Exception {
        String string = "/Dummy/Session/Path";
        this.cmdLine = new CommandLine(new String[]{"-session", string});
        Assert.assertThat((Object)this.cmdLine.getArgument("-session"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test(expected=Exception.class)
    public void shouldFailIfNewSessionArgumentDoesNotHaveValue() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-newsession"});
    }

    @Test
    public void shouldAcceptNewSessionArgument() throws Exception {
        String string = "/Dummy/Session/Path";
        this.cmdLine = new CommandLine(new String[]{"-newsession", string});
        Assert.assertThat((Object)this.cmdLine.getArgument("-newsession"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test(expected=Exception.class)
    public void shouldFailIfPortArgumentDoesNotHaveValue() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-port"});
    }

    @Test(expected=Exception.class)
    public void shouldFailToParseInvalidPortArgument() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-port", "InvalidPort"});
    }

    @Test
    public void shouldParseValidPortArgument() throws Exception {
        int n = 8080;
        this.cmdLine = new CommandLine(new String[]{"-port", Integer.toString(n)});
        Assert.assertThat((Object)this.cmdLine.getPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)n)));
        Assert.assertThat((Object)this.cmdLine.getArgument("-port"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"8080")));
    }

    @Test(expected=Exception.class)
    public void shouldFailIfHostArgumentDoesNotHaveValue() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-host"});
    }

    @Test
    public void shouldParseHostArgument() throws Exception {
        String string = "127.0.0.1";
        this.cmdLine = new CommandLine(new String[]{"-host", string});
        Assert.assertThat((Object)this.cmdLine.getHost(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldGetNullFromNonGivenArgument() throws Exception {
        this.cmdLine = new CommandLine(new String[0]);
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertThat((Object)this.cmdLine.getArgument("-NonGivenArgument"), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldGetNullValueFromNonBuiltInArgument() throws Exception {
        String string = "-arg";
        Vector<CommandLineArgument[]> vector = new Vector<CommandLineArgument[]>();
        vector.add(new CommandLineArgument[]{new CommandLineArgument(string, 1)});
        this.cmdLine = new CommandLine(new String[]{string, "value"});
        this.cmdLine.parse(vector, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertThat((Object)this.cmdLine.getArgument(string), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test(expected=Exception.class)
    public void shouldFailIfGivenUnsupportedArgument() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-unsupported"});
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
    }

    @Test
    public void claWithoutArgs() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-a", "-b"});
        Vector<CommandLineArgument[]> vector = new Vector<CommandLineArgument[]>();
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-a", 0, null, null, null)});
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-b", 0, null, null, null)});
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-c", 0, null, null, null)});
        this.cmdLine.parse(vector, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertTrue((boolean)vector.get(0)[0].isEnabled());
        Assert.assertTrue((boolean)vector.get(1)[0].isEnabled());
        Assert.assertFalse((boolean)vector.get(2)[0].isEnabled());
    }

    @Test
    public void claWithMissingArgs() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-a", "aaa", "-b", "bbb"});
        Vector<CommandLineArgument[]> vector = new Vector<CommandLineArgument[]>();
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-a", 1, null, null, null)});
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-b", 2, null, null, null)});
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-c", 3, null, null, null)});
        try {
            this.cmdLine.parse(vector, NO_SUPPORTED_FILE_EXTENSIONS);
            Assert.fail((String)"Expected an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void claWithPattern() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"-script", "aaa", "bbb", "ccc"});
        Vector<CommandLineArgument[]> vector = new Vector<CommandLineArgument[]>();
        vector.add(new CommandLineArgument[]{new CommandLineArgument("-script", -1, ".*", null, null)});
        this.cmdLine.parse(vector, NO_SUPPORTED_FILE_EXTENSIONS);
        Assert.assertTrue((boolean)vector.get(0)[0].isEnabled());
        Assert.assertThat((Object)vector.get(0)[0].getArguments().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
    }

    @Test(expected=Exception.class)
    public void shouldFailTheParseIfArgumentIsNotSupportedArgumentNorFile() throws Exception {
        String string = "NotAFile" + new Random().nextInt();
        this.cmdLine = new CommandLine(new String[]{string});
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
    }

    @Test(expected=Exception.class)
    public void shouldFailTheParseIfArgumentIsNotSupportedArgumentNorSupportedFileWithExtension() throws Exception {
        this.cmdLine = new CommandLine(new String[]{"notsupported.test"});
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, NO_SUPPORTED_FILE_EXTENSIONS);
    }

    @Test(expected=Exception.class)
    public void shouldNotAcceptFileArgumentIfRejectedBySupportedFileExtension() throws Exception {
        String string = "test";
        File file = this.folder.newFile("aaa." + string);
        HashMap<String, CommandLineListener> hashMap = new HashMap<String, CommandLineListener>();
        hashMap.put(string, new RejectAllFilesCommandLineListener());
        this.cmdLine = new CommandLine(new String[]{file.toString()});
        this.cmdLine.parse(NO_EXTENSIONS_CUSTOM_ARGUMENTS, hashMap);
    }

    private static class RejectAllFilesCommandLineListener
    implements CommandLineListener {
        private RejectAllFilesCommandLineListener() {
        }

        @Override
        public boolean handleFile(File file) {
            return false;
        }

        @Override
        public List<String> getHandledExtensions() {
            return null;
        }

        @Override
        public void execute(CommandLineArgument[] commandLineArgumentArray) {
        }
    }

    private static class AcceptAllFilesCommandLineListener
    implements CommandLineListener {
        private AcceptAllFilesCommandLineListener() {
        }

        @Override
        public boolean handleFile(File file) {
            return true;
        }

        @Override
        public List<String> getHandledExtensions() {
            return null;
        }

        @Override
        public void execute(CommandLineArgument[] commandLineArgumentArray) {
        }
    }
}

