/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.DisplayUtils;

public class MainFooterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JToolBar footerToolbarLeft = null;
    private JToolBar footerToolbarRight = null;
    private JLabel alertHigh = null;
    private JLabel alertMedium = null;
    private JLabel alertLow = null;
    private JLabel alertInfo = null;

    public MainFooterPanel() {
        this.initialise();
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 20));
        this.setMaximumSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 20));
        this.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.fill = 2;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.anchor = 13;
        JLabel jLabel = new JLabel();
        this.add((Component)this.getToolbarLeft(), gridBagConstraints);
        this.add((Component)jLabel, gridBagConstraints3);
        this.add((Component)this.getToolbarRight(), gridBagConstraints2);
        this.footerToolbarLeft.add(new JLabel(Constant.messages.getString("footer.alerts.label")));
        this.footerToolbarLeft.add(this.getAlertHigh());
        this.footerToolbarLeft.add(this.getAlertMedium());
        this.footerToolbarLeft.add(this.getAlertLow());
        this.footerToolbarLeft.add(this.getAlertInfo());
        this.footerToolbarRight.add(new JLabel(Constant.messages.getString("footer.scans.label")));
    }

    private JToolBar getToolbarLeft() {
        if (this.footerToolbarLeft == null) {
            this.footerToolbarLeft = new JToolBar();
            this.footerToolbarLeft.setEnabled(true);
            this.footerToolbarLeft.setFloatable(false);
            this.footerToolbarLeft.setRollover(true);
            this.footerToolbarLeft.setName("Footer Toolbar Left");
            this.footerToolbarLeft.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.footerToolbarLeft;
    }

    private JToolBar getToolbarRight() {
        if (this.footerToolbarRight == null) {
            this.footerToolbarRight = new JToolBar();
            this.footerToolbarRight.setEnabled(true);
            this.footerToolbarRight.setFloatable(false);
            this.footerToolbarRight.setRollover(true);
            this.footerToolbarRight.setName("Footer Toolbar Right");
            this.footerToolbarRight.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.footerToolbarRight;
    }

    public void addAlertFlag(JButton jButton) {
        this.getToolbarLeft().add(jButton);
    }

    public void addSeparator() {
        this.getToolbarLeft().addSeparator();
    }

    private JLabel getAlertHigh() {
        if (this.alertHigh == null) {
            this.alertHigh = this.createAlertLabel(Constant.messages.getString("footer.alerts.high.tooltip"), Constant.HIGH_FLAG_IMAGE_URL);
        }
        return this.alertHigh;
    }

    public void setAlertHigh(int n) {
        this.getAlertHigh().setText(Integer.toString(n));
    }

    private JLabel getAlertMedium() {
        if (this.alertMedium == null) {
            this.alertMedium = this.createAlertLabel(Constant.messages.getString("footer.alerts.medium.tooltip"), Constant.MED_FLAG_IMAGE_URL);
        }
        return this.alertMedium;
    }

    public void setAlertMedium(int n) {
        this.getAlertMedium().setText(Integer.toString(n));
    }

    private JLabel getAlertLow() {
        if (this.alertLow == null) {
            this.alertLow = this.createAlertLabel(Constant.messages.getString("footer.alerts.low.tooltip"), Constant.LOW_FLAG_IMAGE_URL);
        }
        return this.alertLow;
    }

    public void setAlertLow(int n) {
        this.getAlertLow().setText(Integer.toString(n));
    }

    private JLabel getAlertInfo() {
        if (this.alertInfo == null) {
            this.alertInfo = this.createAlertLabel(Constant.messages.getString("footer.alerts.info.tooltip"), Constant.INFO_FLAG_IMAGE_URL);
        }
        return this.alertInfo;
    }

    public void setAlertInfo(int n) {
        this.getAlertInfo().setText(Integer.toString(n));
    }

    private JLabel createAlertLabel(String string, URL uRL) throws NullPointerException {
        JLabel jLabel = new JLabel("0", DisplayUtils.getScaledIcon(new ImageIcon(uRL)), 10);
        jLabel.setToolTipText(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    public void addFooterToolbarRightLabel(JLabel jLabel) {
        DisplayUtils.scaleIcon(jLabel);
        this.footerToolbarRight.add(jLabel);
        this.validate();
    }

    public void removeFooterToolbarRightLabel(JLabel jLabel) {
        this.footerToolbarRight.remove(jLabel);
        this.validate();
    }

    public void addFooterSeparator() {
        this.footerToolbarRight.addSeparator();
    }
}

