/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseFactory;
import org.zaproxy.clientapi.core.ClientApiException;

public class ApiResponseList
extends ApiResponse {
    private List<ApiResponse> list = null;

    public ApiResponseList(String string) {
        super(string);
        this.list = new ArrayList<ApiResponse>();
    }

    public ApiResponseList(Node node) throws ClientApiException {
        this(node.getNodeName());
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.addItem(ApiResponseFactory.getResponse(node2));
        }
    }

    public ApiResponseList(Node node, ApiResponseList apiResponseList) throws ClientApiException {
        super(node.getNodeName());
        try {
            this.list = new ArrayList<ApiResponse>();
            Class<? extends ApiResponse> clazz = apiResponseList.getItemsClass();
            if (clazz != null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    Constructor<? extends ApiResponse> constructor = clazz.getConstructor(Node.class, ApiResponse.class);
                    this.addItem(constructor.newInstance(node2, apiResponseList.list.get(0)));
                }
            }
        }
        catch (Exception exception) {
            throw new ClientApiException(exception);
        }
    }

    public ApiResponseList(String string, ApiResponse[] apiResponseArray) {
        super(string);
        this.list = new ArrayList<ApiResponse>();
        for (ApiResponse apiResponse : apiResponseArray) {
            this.list.add(apiResponse);
        }
    }

    public ApiResponseList(String string, List<ApiResponse> list) {
        super(string);
        this.list = list;
    }

    public void addItem(ApiResponse apiResponse) {
        this.list.add(apiResponse);
    }

    public List<ApiResponse> getItems() {
        return this.list;
    }

    public Class<? extends ApiResponse> getItemsClass() {
        if (this.list == null || this.list.size() == 0) {
            return null;
        }
        return this.list.get(0).getClass();
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("ApiResponseList ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" : [\n");
        for (ApiResponse apiResponse : this.list) {
            stringBuilder.append(apiResponse.toString(n + 1));
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

