/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsAPI;

public class HttpSessionsAPIUnitTest {
    private static final String HOST = "example.com";

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionWhenGettingAuthorityFromNullSite() {
        String string = null;
        HttpSessionsAPI.getAuthority(string);
    }

    @Test
    public void shouldReturnEmptySiteWhenGettingAuthorityFromEmptySite() {
        String string = "";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldNotRemovePortWhenGettingAuthorityFromSite() {
        String string = "example.com:8080";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldRemoveHttpSchemeWhenGettingAuthorityFromSite() {
        String string = "http://example.com";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)HOST)));
    }

    @Test
    public void shouldRemoveSecureHttpSchemeAndKeepNonDefaultPortWhenGettingAuthorityFromSite() {
        String string = "https://example.com:8443";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"example.com:8443")));
    }

    @Test
    public void shouldRemoveSecureHttpSchemeAndAddDefaultPortWhenGettingAuthorityFromSite() {
        String string = "https://example.com";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"example.com:443")));
    }

    @Test
    public void shouldIgnoreEmptyPathComponentWhenGettingAuthorityFromSite() {
        String string = HOST;
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)HOST)));
    }

    @Test
    public void shouldRemoveNonEmptyPathComponentWhenGettingAuthorityFromSite() {
        String string = "example.com/path";
        String string2 = HttpSessionsAPI.getAuthority(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)HOST)));
    }
}

