/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class SpiderScanController
implements ScanController<SpiderScan> {
    private static final Logger log = Logger.getLogger(SpiderScanController.class);
    private ExtensionSpider extension;
    private final Lock spiderScansLock = new ReentrantLock();
    private int scanIdCounter;
    private Map<Integer, SpiderScan> spiderScanMap;
    private List<SpiderScan> spiderScanList;

    public SpiderScanController(ExtensionSpider extensionSpider) {
        this.extension = extensionSpider;
        this.spiderScanMap = new HashMap<Integer, SpiderScan>();
        this.spiderScanList = new ArrayList<SpiderScan>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startScan(String string, Target target, User user, Object[] objectArray) {
        this.spiderScansLock.lock();
        try {
            int n = this.scanIdCounter++;
            SpiderParam spiderParam = this.extension.getSpiderParam();
            ArrayList<SpiderParser> arrayList = new ArrayList<SpiderParser>();
            ArrayList<FetchFilter> arrayList2 = new ArrayList<FetchFilter>();
            ArrayList<ParseFilter> arrayList3 = new ArrayList<ParseFilter>();
            URI uRI = null;
            if (objectArray != null) {
                for (Object object : objectArray) {
                    if (object instanceof SpiderParam) {
                        log.debug((Object)"Setting custom spider params");
                        spiderParam = (SpiderParam)object;
                        continue;
                    }
                    if (object instanceof SpiderParser) {
                        arrayList.add((SpiderParser)object);
                        continue;
                    }
                    if (object instanceof FetchFilter) {
                        arrayList2.add((FetchFilter)object);
                        continue;
                    }
                    if (object instanceof ParseFilter) {
                        arrayList3.add((ParseFilter)object);
                        continue;
                    }
                    if (object instanceof URI) {
                        uRI = (URI)object;
                        continue;
                    }
                    log.error((Object)("Unexpected contextSpecificObject: " + object.getClass().getCanonicalName()));
                }
            }
            SpiderScan spiderScan = new SpiderScan(this.extension, spiderParam, target, uRI, user, n);
            spiderScan.setDisplayName(string);
            spiderScan.setCustomSpiderParsers(arrayList);
            spiderScan.setCustomFetchFilters(arrayList2);
            spiderScan.setCustomParseFilters(arrayList3);
            this.spiderScanMap.put(n, spiderScan);
            this.spiderScanList.add(spiderScan);
            spiderScan.start();
            int n2 = n;
            return n2;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public SpiderScan getScan(int n) {
        return this.spiderScanMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiderScan getLastScan() {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanList.size() == 0) {
                SpiderScan spiderScan = null;
                return spiderScan;
            }
            SpiderScan spiderScan = this.spiderScanList.get(this.spiderScanList.size() - 1);
            return spiderScan;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpiderScan> getAllScans() {
        ArrayList<SpiderScan> arrayList = new ArrayList<SpiderScan>();
        this.spiderScansLock.lock();
        try {
            for (SpiderScan spiderScan : this.spiderScanList) {
                arrayList.add(spiderScan);
            }
            ArrayList<SpiderScan> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpiderScan> getActiveScans() {
        ArrayList<SpiderScan> arrayList = new ArrayList<SpiderScan>();
        this.spiderScansLock.lock();
        try {
            for (SpiderScan spiderScan : this.spiderScanList) {
                if (spiderScan.isStopped()) continue;
                arrayList.add(spiderScan);
            }
            ArrayList<SpiderScan> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiderScan removeScan(int n) {
        this.spiderScansLock.lock();
        try {
            SpiderScan spiderScan = this.spiderScanMap.get(n);
            if (!this.spiderScanMap.containsKey(n)) {
                SpiderScan spiderScan2 = null;
                return spiderScan2;
            }
            spiderScan.stopScan();
            this.spiderScanMap.remove(n);
            this.spiderScanList.remove(spiderScan);
            SpiderScan spiderScan3 = spiderScan;
            return spiderScan3;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    public int getTotalNumberScans() {
        return this.spiderScanMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan spiderScan : this.spiderScanMap.values()) {
                spiderScan.stopScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan spiderScan : this.spiderScanMap.values()) {
                spiderScan.pauseScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan spiderScan : this.spiderScanMap.values()) {
                spiderScan.resumeScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllScans() {
        this.spiderScansLock.lock();
        try {
            int n = 0;
            Iterator<SpiderScan> iterator = this.spiderScanMap.values().iterator();
            while (iterator.hasNext()) {
                SpiderScan spiderScan = iterator.next();
                spiderScan.stopScan();
                iterator.remove();
                this.spiderScanList.remove(spiderScan);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeFinishedScans() {
        this.spiderScansLock.lock();
        try {
            int n = 0;
            Iterator<SpiderScan> iterator = this.spiderScanMap.values().iterator();
            while (iterator.hasNext()) {
                SpiderScan spiderScan = iterator.next();
                if (!spiderScan.isStopped()) continue;
                spiderScan.stopScan();
                iterator.remove();
                this.spiderScanList.remove(spiderScan);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopScan(int n) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(n)) {
                this.spiderScanMap.get(n).stopScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseScan(int n) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(n)) {
                this.spiderScanMap.get(n).pauseScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeScan(int n) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(n)) {
                this.spiderScanMap.get(n).resumeScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.removeAllScans();
        this.spiderScansLock.lock();
        try {
            this.scanIdCounter = 0;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }
}

