/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderGitParser
extends SpiderParser {
    private SpiderParam params;
    private static final Pattern gitIndexFilenamePattern = Pattern.compile("/.git/index$");
    private static final Pattern gitIndexContentPattern = Pattern.compile("^DIRC");
    private Pattern GIT_FILE_PATTERN = Pattern.compile("/\\.git/index$");

    public SpiderGitParser(SpiderParam spiderParam) {
        this.params = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        if (httpMessage == null || !this.params.isParseGit()) {
            return false;
        }
        log.debug((Object)"Parsing a Git resource...");
        byte[] byArray = httpMessage.getResponseBody().getBytes();
        String string = httpMessage.getRequestHeader().getURI().toString();
        try {
            Matcher matcher;
            String string2 = httpMessage.getRequestHeader().getURI().getPath();
            if (string2 == null) {
                string2 = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The full path is [" + string2 + "]"));
            }
            if ((matcher = gitIndexFilenamePattern.matcher(string2)).find()) {
                Matcher matcher2 = gitIndexContentPattern.matcher(new String(byArray));
                if (matcher2.find()) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    byte[] byArray2 = new byte[4];
                    byteBuffer.get(byArray2, 0, 4);
                    int n2 = byteBuffer.getInt();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The Git index file version is " + n2));
                    }
                    int n3 = byteBuffer.getInt();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(n3 + " entries were found in the Git index file "));
                    }
                    if (n2 != 2 && n2 != 3 && n2 != 4) {
                        throw new Exception("Only Git Index File versions 2, 3, and 4 are currently supported. Git Index File Version " + n2 + " was found.");
                    }
                    String string3 = "";
                    for (int i = 0; i < n3; ++i) {
                        int n4;
                        int n5;
                        int n6 = 0;
                        int n7 = byteBuffer.getInt();
                        n6 += 4;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has indexEntryCtime1 " + n7));
                        }
                        int n8 = byteBuffer.getInt();
                        n6 += 4;
                        int n9 = byteBuffer.getInt();
                        n6 += 4;
                        int n10 = byteBuffer.getInt();
                        n6 += 4;
                        int n11 = byteBuffer.getInt();
                        n6 += 4;
                        int n12 = byteBuffer.getInt();
                        n6 += 4;
                        int n13 = byteBuffer.getInt();
                        n6 += 4;
                        int n14 = byteBuffer.getInt();
                        n6 += 4;
                        int n15 = byteBuffer.getInt();
                        n6 += 4;
                        int n16 = byteBuffer.getInt();
                        n6 += 4;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has size " + n16));
                        }
                        byte[] byArray3 = new byte[20];
                        byteBuffer.get(byArray3, 0, 20);
                        n6 += 20;
                        String string4 = new String(byArray3);
                        short s = byteBuffer.getShort();
                        n6 += 2;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has flags " + s));
                        }
                        int n17 = s & 0xFFF;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has a name of length " + n17));
                        }
                        int n18 = (s & 0x4000) >> 14;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has an extended flag of " + n18));
                        }
                        if (n18 != 0 && n18 != 1) {
                            throw new Exception("Error parsing out the extended flag for index entry " + i + ". We got " + n18);
                        }
                        if (n2 == 2 && n18 != 0) {
                            throw new Exception("Index File Version 2 is supposed to have the extended flag set to 0. For index entry " + i + ", it is set to " + n18);
                        }
                        if (n2 > 2 && n18 == 1) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("For Index file version " + n2 + ", reading an extra 16 bits for Entry " + i));
                            }
                            short s2 = byteBuffer.getShort();
                            n6 += 2;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Entry " + i + " has (optional) extended flags " + s2));
                            }
                        }
                        String string5 = null;
                        if (n2 > 3) {
                            int n19;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Inflating the (deflated) entry name for index entry " + i + " based on the previous entry name, since Index file version " + n2 + " requires this"));
                            }
                            n5 = 0;
                            n4 = 0;
                            int n20 = -128;
                            byte by = (byte)(~n20 & 0xFF);
                            while (++n5 > 0) {
                                n19 = byteBuffer.get();
                                ++n6;
                                n4 = n5 == 1 ? n4 << 8 | 0xFF & (n19 & by) : n4 << 8 | 0xFF & (n19 | n20);
                                if ((n19 & n20) != 0) continue;
                                break;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("We read " + n5 + " bytes of variable length data from before the start of the entry name"));
                            }
                            if (n5 > 4) {
                                throw new Exception("An entry name is never expected to be > 2^^32 bytes long. Some file corruption may have occurred, or a parsing error has occurred");
                            }
                            n19 = n17 - (string3.length() - n4);
                            byte[] byArray4 = new byte[n19];
                            byteBuffer.get(byArray4, 0, n19);
                            n6 += n19;
                            string5 = string3.substring(0, string3.length() - n4) + new String(byArray4);
                        } else {
                            byte[] byArray5 = new byte[n17];
                            byteBuffer.get(byArray5, 0, n17);
                            n6 += n17;
                            string5 = new String(byArray5);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Entry " + i + " has name " + string5));
                        }
                        string3 = string5;
                        n5 = byteBuffer.get();
                        ++n6;
                        if (n2 < 4) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Aligning to an 8 byte boundary after Entry " + i + ", since Index file version " + n2 + " mandates 64 bit alignment for index entries"));
                            }
                            n4 = (8 - n6 % 8) % 8;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("The number of bytes read for index entry " + i + " thus far is: " + n6));
                                log.debug((Object)("So we must read " + n4 + " bytes to stay on a 64 bit boundary"));
                            }
                            byte[] byArray6 = new byte[n4];
                            byteBuffer.get(byArray6, 0, n4);
                            n6 += n4;
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Not aligning to an 8 byte boundary after Entry " + i + ", since Index file version " + n2 + " does not mandate 64 bit alignment for index entries"));
                        }
                        if (string5 == null || string5.length() <= 0) continue;
                        log.info((Object)("Found file/symbolic link/gitlink " + string5 + " in the Git entries file"));
                        this.processURL(httpMessage, n, "../" + string5, string);
                    }
                    return true;
                }
                throw new Exception("The file '" + string2 + "' could not be parsed as a Git Index file due to unexpected content");
            }
            throw new Exception("This path cannot be handled by the Git parser");
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred trying to parse Git url '" + string + "': " + exception));
            return true;
        }
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        Matcher matcher = this.GIT_FILE_PATTERN.matcher(string);
        return matcher.find();
    }
}

