/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.NodeSelectDialog;
import org.zaproxy.zap.view.widgets.ContextSelectComboBox;

public abstract class StandardFieldsDialog
extends AbstractDialog {
    private static final Logger logger = Logger.getLogger(StandardFieldsDialog.class);
    private static final long serialVersionUID = 1L;
    private static final EmptyBorder FULL_BORDER = new EmptyBorder(8, 8, 8, 8);
    private static final EmptyBorder TOP_BOTTOM_BORDER = new EmptyBorder(8, 0, 8, 0);
    private JPanel mainPanel = null;
    private List<JPanel> tabPanels = null;
    private List<Integer> tabOffsets = null;
    private JTabbedPane tabbedPane = null;
    private double labelWeight = 0.0;
    private double fieldWeight = 1.0;
    private JButton helpButton = null;
    private JButton cancelButton = null;
    private JButton saveButton = null;
    private List<Component> fieldList = new ArrayList<Component>();
    private Map<String, Component> fieldMap = new HashMap<String, Component>();
    private Map<String, JPanel> tabNameMap = new HashMap<String, JPanel>();

    public StandardFieldsDialog(Frame frame, String string, Dimension dimension) {
        this((Window)frame, string, dimension);
    }

    public StandardFieldsDialog(Window window, String string, Dimension dimension) {
        this(window, string, dimension, null);
    }

    public StandardFieldsDialog(Frame frame, String string, Dimension dimension, String[] stringArray) {
        this((Window)frame, string, dimension, stringArray);
    }

    public StandardFieldsDialog(Window window, String string, Dimension dimension, String[] stringArray) {
        super(window, false);
        this.setTitle(Constant.messages.getString(string));
        this.setXWeights(0.4, 0.6);
        this.initialize(dimension, stringArray);
    }

    private boolean isTabbed() {
        return this.tabPanels != null;
    }

    private void initialize(Dimension dimension, String[] stringArray) {
        this.setLayout(new GridBagLayout());
        this.setSize(dimension);
        if (stringArray == null) {
            this.initializeSinglePane(dimension);
        } else {
            this.initializeTabbed(dimension, stringArray);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardFieldsDialog.this.setVisible(false);
                StandardFieldsDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public void setXWeights(double d, double d2) {
        this.labelWeight = d;
        this.fieldWeight = d2;
    }

    private void initializeTabbed(Dimension dimension, String[] stringArray) {
        JComponent jComponent;
        this.tabPanels = new ArrayList<JPanel>();
        this.tabOffsets = new ArrayList<Integer>();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(TOP_BOTTOM_BORDER);
        jPanel.setPreferredSize(dimension);
        this.setContentPane(jPanel);
        this.tabbedPane = new JTabbedPane();
        JButton[] jButtonArray = this.getExtraButtons();
        String string = this.getHelpIndex();
        if (jButtonArray == null) {
            jPanel.add((Component)this.tabbedPane, LayoutHelper.getGBC(0, 0, 4, 1.0, 1.0));
            if (string != null) {
                jPanel.add((Component)this.getHelpButton(string), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            if (this.hasCancelSaveButtons()) {
                jPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            }
            jPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(3, 1, 1, 0.0));
        } else {
            jPanel.add((Component)this.tabbedPane, LayoutHelper.getGBC(0, 0, 4 + jButtonArray.length, 1.0, 1.0));
            if (string != null) {
                jPanel.add((Component)this.getHelpButton(string), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            if (this.hasCancelSaveButtons()) {
                jPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            }
            int n = 3;
            if (jButtonArray != null) {
                JButton[] jButtonArray2 = jButtonArray;
                int n2 = jButtonArray2.length;
                for (int i = 0; i < n2; ++i) {
                    jComponent = jButtonArray2[i];
                    jPanel.add((Component)jComponent, LayoutHelper.getGBC(n, 1, 1, 0.0));
                    ++n;
                }
            }
            jPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(n, 1, 1, 0.0));
        }
        for (String string2 : stringArray) {
            jComponent = new JPanel();
            jComponent.setLayout(new GridBagLayout());
            jComponent.setBorder(FULL_BORDER);
            this.tabbedPane.addTab(Constant.messages.getString(string2), jComponent);
            this.tabNameMap.put(string2, (JPanel)jComponent);
            this.tabPanels.add((JPanel)jComponent);
            this.tabOffsets.add(0);
        }
    }

    public boolean hasCancelSaveButtons() {
        return true;
    }

    public String getHelpIndex() {
        return null;
    }

    private void initializeSinglePane(Dimension dimension) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(FULL_BORDER);
        jPanel.setPreferredSize(dimension);
        this.setContentPane(jPanel);
        JButton[] jButtonArray = this.getExtraButtons();
        String string = this.getHelpIndex();
        if (jButtonArray == null) {
            jPanel.add((Component)this.getMainPanel(), LayoutHelper.getGBC(0, 0, 4, 1.0, 1.0));
            if (string != null) {
                jPanel.add((Component)this.getHelpButton(string), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            if (this.hasCancelSaveButtons()) {
                jPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            }
            jPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(3, 1, 1, 0.0));
        } else {
            jPanel.add((Component)this.getMainPanel(), LayoutHelper.getGBC(0, 0, 4 + jButtonArray.length, 1.0, 1.0));
            if (string != null) {
                jPanel.add((Component)this.getHelpButton(string), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            if (this.hasCancelSaveButtons()) {
                jPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            }
            int n = 3;
            if (jButtonArray != null) {
                for (JButton jButton : this.getExtraButtons()) {
                    jPanel.add((Component)jButton, LayoutHelper.getGBC(n, 1, 1, 0.0));
                    ++n;
                }
            }
            jPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(n, 1, 1, 0.0));
        }
    }

    public String getSaveButtonText() {
        if (this.hasCancelSaveButtons()) {
            return Constant.messages.getString("all.button.save");
        }
        return Constant.messages.getString("all.button.close");
    }

    public JButton[] getExtraButtons() {
        return null;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(this.getSaveButtonText());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!StandardFieldsDialog.this.validateFieldsCustomMessage()) {
                        return;
                    }
                    String string = StandardFieldsDialog.this.validateFields();
                    if (string != null) {
                        View.getSingleton().showWarningDialog(StandardFieldsDialog.this, string);
                        return;
                    }
                    StandardFieldsDialog.this.save();
                    StandardFieldsDialog.this.setVisible(false);
                }
            });
        }
        return this.saveButton;
    }

    protected boolean validateFieldsCustomMessage() {
        return true;
    }

    public String getCancelButtonText() {
        return Constant.messages.getString("all.button.cancel");
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(this.getCancelButtonText());
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StandardFieldsDialog.this.cancelPressed();
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getHelpButton(final String string) {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(ExtensionHelp.HELP_ICON);
            this.helpButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionHelp.showHelp(string);
                }
            });
        }
        return this.helpButton;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
        }
        return this.mainPanel;
    }

    private void addPadding(JPanel jPanel, int n) {
        jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, n, 1, 0.0, 1.0, 1, new Insets(4, 4, 4, 4)));
    }

    public void addPadding() {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        this.addPadding(this.getMainPanel(), this.fieldList.size());
    }

    private void incTabOffset(int n) {
        int n2 = this.tabOffsets.get(n) + 1;
        this.tabOffsets.remove(n);
        this.tabOffsets.add(n, n2);
    }

    public void addPadding(int n) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        this.addPadding(this.tabPanels.get(n), this.tabOffsets.get(n));
        this.incTabOffset(n);
    }

    private void addField(JPanel jPanel, int n, String string, Component component, Component component2, double d) {
        if (this.fieldList.contains(component)) {
            throw new IllegalArgumentException("Field already added: " + component);
        }
        JLabel jLabel = new JLabel(Constant.messages.getString(string));
        jLabel.setLabelFor(component);
        jLabel.setVerticalAlignment(1);
        jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, n, 1, this.labelWeight, d, 1, new Insets(4, 4, 4, 4)));
        jPanel.add(component2, LayoutHelper.getGBC(1, n, 1, this.fieldWeight, d, 1, new Insets(4, 4, 4, 4)));
        this.fieldList.add(component);
        this.fieldMap.put(string, component);
        if (n == 0 && jPanel.equals(this.getMainPanel())) {
            component.requestFocusInWindow();
        }
    }

    private void addField(String string, Component component, Component component2, double d) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        this.addField(this.getMainPanel(), this.fieldList.size(), string, component, component2, d);
    }

    public void addTextField(String string, String string2) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        ZapTextField zapTextField = new ZapTextField();
        if (string2 != null) {
            zapTextField.setText(string2);
        }
        this.addField(string, zapTextField, zapTextField, 0.0);
    }

    public void addTextField(int n, String string, String string2) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        ZapTextField zapTextField = new ZapTextField();
        if (string2 != null) {
            zapTextField.setText(string2);
        }
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapTextField, zapTextField, 0.0);
        this.incTabOffset(n);
    }

    public void addMultilineField(String string, String string2) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        ZapTextArea zapTextArea = new ZapTextArea();
        zapTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(zapTextArea);
        if (string2 != null) {
            zapTextArea.setText(string2);
        }
        this.addField(string, zapTextArea, jScrollPane, 1.0);
    }

    public void addMultilineField(int n, String string, String string2) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        ZapTextArea zapTextArea = new ZapTextArea();
        zapTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(zapTextArea);
        if (string2 != null) {
            zapTextArea.setText(string2);
        }
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapTextArea, jScrollPane, 1.0);
        this.incTabOffset(n);
    }

    public void addComboField(String string, String[] stringArray, String string2) {
        this.addComboField(string, stringArray, string2, false);
    }

    public void addComboField(String string, String[] stringArray, String string2, boolean bl) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(bl);
        for (String string3 : stringArray) {
            jComboBox.addItem(string3);
        }
        if (string2 != null) {
            jComboBox.setSelectedItem(string2);
        }
        this.addField(string, jComboBox, jComboBox, 0.0);
    }

    public void addComboField(String string, List<String> list, String string2) {
        this.addComboField(string, list, string2, false);
    }

    public void addComboField(String string, List<String> list, String string2, boolean bl) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(bl);
        for (String string3 : list) {
            jComboBox.addItem(string3);
        }
        if (string2 != null) {
            jComboBox.setSelectedItem(string2);
        }
        this.addField(string, jComboBox, jComboBox, 0.0);
    }

    public void addComboField(int n, String string, String[] stringArray, String string2) {
        this.addComboField(n, string, stringArray, string2, false);
    }

    public void addComboField(int n, String string, String[] stringArray, String string2, boolean bl) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(bl);
        for (String string3 : stringArray) {
            jComboBox.addItem(string3);
        }
        if (string2 != null) {
            jComboBox.setSelectedItem(string2);
        }
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, jComboBox, jComboBox, 0.0);
        this.incTabOffset(n);
    }

    public void addComboField(int n, String string, List<String> list, String string2) {
        this.addComboField(n, string, list, string2, false);
    }

    public void addComboField(int n, String string, List<String> list, String string2, boolean bl) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(bl);
        for (String string3 : list) {
            jComboBox.addItem(string3);
        }
        if (string2 != null) {
            jComboBox.setSelectedItem(string2);
        }
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, jComboBox, jComboBox, 0.0);
        this.incTabOffset(n);
    }

    public void addComboField(String string, int[] nArray, int n) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        for (int n2 : nArray) {
            jComboBox.addItem(n2);
        }
        if (n >= 0) {
            jComboBox.setSelectedItem(n);
        }
        this.addField(string, jComboBox, jComboBox, 0.0);
    }

    public void addTableField(String string, JTable jTable) {
        this.addTableField(string, jTable, null);
    }

    public void addTableField(JTable jTable, List<JButton> list) {
        this.addTableField(null, jTable, list);
    }

    public void addTableField(String string, JTable jTable, List<JButton> list) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(jTable);
        jTable.setFillsViewportHeight(true);
        if (this.fieldList.contains(jTable)) {
            throw new IllegalArgumentException("Field already added: " + jTable);
        }
        if (list == null || list.size() == 0) {
            if (string == null) {
                this.getMainPanel().add((Component)jScrollPane, LayoutHelper.getGBC(1, this.fieldList.size(), 1, this.fieldWeight, 1.0, 1, new Insets(4, 4, 4, 4)));
            } else {
                this.addField(string, jTable, jScrollPane, 1.0);
            }
        } else {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)jScrollPane, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            int n = 0;
            for (JButton jButton : list) {
                jPanel2.add((Component)jButton, LayoutHelper.getGBC(0, n++, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            }
            jPanel2.add((Component)new JLabel(), LayoutHelper.getGBC(0, n++, 1, 0.0, 1.0, 1, new Insets(2, 2, 2, 2)));
            jPanel.add((Component)jPanel2, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            if (string == null) {
                this.getMainPanel().add((Component)jPanel, LayoutHelper.getGBC(1, this.fieldList.size(), 1, this.fieldWeight, 1.0, 1, new Insets(4, 4, 4, 4)));
            } else {
                this.addField(string, jTable, jPanel, 1.0);
            }
        }
        this.fieldList.add(jTable);
    }

    public void addTableField(int n, JTable jTable) {
        this.addTableField(n, jTable, null);
    }

    public void addTableField(int n, JTable jTable, List<JButton> list) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(jTable);
        jTable.setFillsViewportHeight(true);
        if (this.fieldList.contains(jTable)) {
            throw new IllegalArgumentException("Field already added: " + jTable);
        }
        if (list == null || list.size() == 0) {
            this.tabPanels.get(n).add((Component)jScrollPane, LayoutHelper.getGBC(1, this.tabOffsets.get(n), 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
        } else {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)jScrollPane, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            int n2 = 0;
            for (JButton jButton : list) {
                jPanel2.add((Component)jButton, LayoutHelper.getGBC(0, n2++, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            }
            jPanel2.add((Component)new JLabel(), LayoutHelper.getGBC(0, n2++, 1, 0.0, 1.0, 1, new Insets(2, 2, 2, 2)));
            jPanel.add((Component)jPanel2, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            this.tabPanels.get(n).add((Component)jPanel, LayoutHelper.getGBC(1, this.tabOffsets.get(n), 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
        }
        this.fieldList.add(jTable);
        this.incTabOffset(n);
    }

    public void setComboFields(String string, String[] stringArray, String string2) {
        Component component = this.fieldMap.get(string);
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.removeAllItems();
            for (String string3 : stringArray) {
                jComboBox.addItem(string3);
            }
            if (string2 != null) {
                jComboBox.setSelectedItem(string2);
            }
        } else if (component == null) {
            logger.debug((Object)("No field for " + string));
        } else {
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
    }

    public void setComboFields(String string, List<String> list, String string2) {
        Component component = this.fieldMap.get(string);
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.removeAllItems();
            for (String string3 : list) {
                jComboBox.addItem(string3);
            }
            if (string2 != null) {
                jComboBox.setSelectedItem(string2);
            }
        } else if (component == null) {
            logger.debug((Object)("No field for " + string));
        } else {
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
    }

    public void addNumberField(String string, Integer n, Integer n2, int n3) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        ZapNumberSpinner zapNumberSpinner = new ZapNumberSpinner(n, n3, n2);
        this.addField(string, zapNumberSpinner, zapNumberSpinner, 0.0);
    }

    public void addNumberField(int n, String string, Integer n2, Integer n3, int n4) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        ZapNumberSpinner zapNumberSpinner = new ZapNumberSpinner(n2, n4, n3);
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapNumberSpinner, zapNumberSpinner, 0.0);
        this.incTabOffset(n);
    }

    public void addCheckBoxField(String string, boolean bl) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        this.addField(string, jCheckBox, jCheckBox, 0.0);
    }

    public void addCheckBoxField(int n, String string, boolean bl) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, jCheckBox, jCheckBox, 0.0);
        this.incTabOffset(n);
    }

    public void addNodeSelectField(final String string, final SiteNode siteNode, boolean bl, final boolean bl2) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        final ZapTextField zapTextField = new ZapTextField();
        zapTextField.setEditable(bl);
        if (siteNode != null && siteNode.getHistoryReference() != null) {
            try {
                zapTextField.setText(siteNode.getHistoryReference().getURI().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JButton jButton = new JButton(Constant.messages.getString("all.button.select"));
        jButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        jButton.addActionListener(new ActionListener(){
            SiteNode node;
            {
                this.node = siteNode;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeSelectDialog nodeSelectDialog = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nodeSelectDialog.setAllowRoot(bl2);
                SiteNode siteNode2 = nodeSelectDialog.showDialog(this.node);
                if (siteNode2 != null && siteNode2.getHistoryReference() != null) {
                    try {
                        zapTextField.setText(siteNode2.getHistoryReference().getURI().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.node = siteNode2;
                    StandardFieldsDialog.this.siteNodeSelected(string, siteNode2);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)zapTextField, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(string, zapTextField, jPanel, 0.0);
    }

    public void addNodeSelectField(int n, final String string, final SiteNode siteNode, boolean bl, final boolean bl2) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        final ZapTextField zapTextField = new ZapTextField();
        zapTextField.setEditable(bl);
        if (siteNode != null && siteNode.getHistoryReference() != null) {
            try {
                zapTextField.setText(siteNode.getHistoryReference().getURI().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JButton jButton = new JButton(Constant.messages.getString("all.button.select"));
        jButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        jButton.addActionListener(new ActionListener(){
            SiteNode node;
            {
                this.node = siteNode;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeSelectDialog nodeSelectDialog = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nodeSelectDialog.setAllowRoot(bl2);
                SiteNode siteNode2 = nodeSelectDialog.showDialog(this.node);
                if (siteNode2 != null && siteNode2.getHistoryReference() != null) {
                    try {
                        zapTextField.setText(siteNode2.getHistoryReference().getURI().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.node = siteNode2;
                    StandardFieldsDialog.this.siteNodeSelected(string, siteNode2);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)zapTextField, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapTextField, jPanel, 0.0);
        this.incTabOffset(n);
    }

    public void addTargetSelectField(int n, final String string, final Target target, boolean bl, final boolean bl2) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        final ZapTextField zapTextField = new ZapTextField();
        zapTextField.setEditable(bl);
        this.setTextTarget(zapTextField, target);
        JButton jButton = new JButton(Constant.messages.getString("all.button.select"));
        jButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        jButton.addActionListener(new ActionListener(){
            Target target;
            {
                this.target = target;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeSelectDialog nodeSelectDialog = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nodeSelectDialog.setAllowRoot(bl2);
                this.target = nodeSelectDialog.showDialog(this.target);
                StandardFieldsDialog.this.setTextTarget(zapTextField, this.target);
                StandardFieldsDialog.this.targetSelected(string, this.target);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)zapTextField, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapTextField, jPanel, 0.0);
        this.incTabOffset(n);
    }

    private void setTextTarget(ZapTextField zapTextField, Target target) {
        String string = StandardFieldsDialog.getTargetText(target);
        if (string != null) {
            zapTextField.setText(string);
        }
    }

    protected static String getTargetText(Target target) {
        if (target != null) {
            if (target.getStartNode() != null && target.getStartNode().getHistoryReference() != null) {
                return target.getStartNode().getHistoryReference().getURI().toString();
            }
            if (target.getContext() != null) {
                return Constant.messages.getString("context.prefixName", target.getContext().getName());
            }
            if (target.isInScopeOnly()) {
                return Constant.messages.getString("context.allInScope");
            }
        }
        return null;
    }

    public void addContextSelectField(String string, Context context) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        ContextSelectComboBox contextSelectComboBox = new ContextSelectComboBox();
        if (context != null) {
            contextSelectComboBox.setSelectedItem(context);
        }
        this.addField(string, contextSelectComboBox, contextSelectComboBox, 0.0);
    }

    public void addContextSelectField(int n, String string, Context context) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        ContextSelectComboBox contextSelectComboBox = new ContextSelectComboBox();
        if (context != null) {
            contextSelectComboBox.setSelectedItem(context);
        }
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, contextSelectComboBox, contextSelectComboBox, 0.0);
        this.incTabOffset(n);
    }

    public void addFileSelectField(String string, final File file, final int n, final FileFilter fileFilter) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        final ZapTextField zapTextField = new ZapTextField();
        zapTextField.setEditable(false);
        if (file != null) {
            zapTextField.setText(file.getAbsolutePath());
        }
        final StandardFieldsDialog standardFieldsDialog = this;
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2;
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileSelectionMode(n);
                if (fileFilter != null) {
                    jFileChooser.setFileFilter(fileFilter);
                }
                if ((n2 = jFileChooser.showSaveDialog(standardFieldsDialog)) == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2 == null) {
                        return;
                    }
                    zapTextField.setText(file2.getAbsolutePath());
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)zapTextField, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(string, zapTextField, jPanel, 0.0);
    }

    public void addFileSelectField(int n, String string, final File file, final int n2, final FileFilter fileFilter) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        final ZapTextField zapTextField = new ZapTextField();
        zapTextField.setEditable(false);
        if (file != null) {
            zapTextField.setText(file.getAbsolutePath());
        }
        final StandardFieldsDialog standardFieldsDialog = this;
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileSelectionMode(n2);
                if (fileFilter != null) {
                    jFileChooser.setFileFilter(fileFilter);
                }
                if ((n = jFileChooser.showSaveDialog(standardFieldsDialog)) == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2 == null) {
                        return;
                    }
                    zapTextField.setText(file2.getAbsolutePath());
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)zapTextField, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, zapTextField, jPanel, 0.0);
        this.incTabOffset(n);
    }

    public void siteNodeSelected(String string, SiteNode siteNode) {
    }

    public void targetSelected(String string, Target target) {
    }

    public Component getField(String string) {
        return this.fieldMap.get(string);
    }

    public String getStringValue(String string) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapTextField) {
                return ((ZapTextField)component).getText();
            }
            if (component instanceof ZapTextArea) {
                return ((ZapTextArea)component).getText();
            }
            if (component instanceof JComboBox) {
                return (String)((JComboBox)component).getSelectedItem();
            }
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
        return null;
    }

    public Context getContextValue(String string) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ContextSelectComboBox) {
                return ((ContextSelectComboBox)component).getSelectedContext();
            }
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
        return null;
    }

    public void setFieldValue(String string, String string2) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapTextField) {
                ((ZapTextField)component).setText(string2);
            } else if (component instanceof ZapTextArea) {
                ((ZapTextArea)component).setText(string2);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(string2);
            } else if (component instanceof JLabel) {
                ((JLabel)component).setText(string2);
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
        }
    }

    public void setFieldValue(String string, boolean bl) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(bl);
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
        }
    }

    public boolean isEmptyField(String string) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            Object object = null;
            if (component instanceof ZapTextField) {
                object = ((ZapTextField)component).getText();
            } else if (component instanceof ZapTextArea) {
                object = ((ZapTextArea)component).getText();
            } else if (component instanceof JComboBox) {
                object = ((JComboBox)component).getSelectedItem();
            } else if (component instanceof ZapNumberSpinner) {
                object = ((ZapNumberSpinner)component).getValue();
                if ((Integer)object < 0) {
                    object = null;
                }
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
            return object == null || object.toString().length() == 0;
        }
        return true;
    }

    public int getIntValue(String string) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapNumberSpinner) {
                return ((ZapNumberSpinner)component).getValue();
            }
            if (component instanceof JComboBox) {
                return (Integer)((JComboBox)component).getSelectedItem();
            }
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
        return -1;
    }

    public void setFieldValue(String string, int n) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapNumberSpinner) {
                ((ZapNumberSpinner)component).setValue(n);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(n);
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
        }
    }

    public void addReadOnlyField(String string, String string2, boolean bl) {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
        JLabel jLabel = new JLabel();
        if (string2 != null) {
            jLabel.setText(string2);
        }
        if (bl) {
            this.getMainPanel().add((Component)jLabel, LayoutHelper.getGBC(0, this.fieldList.size(), 2, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
            this.fieldList.add(jLabel);
            this.fieldMap.put(string, jLabel);
        } else {
            this.addField(string, jLabel, jLabel, 0.0);
        }
    }

    public void addReadOnlyField(int n, String string, String string2, boolean bl) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        JLabel jLabel = new JLabel();
        if (string2 != null) {
            jLabel.setText(string2);
        }
        if (bl) {
            JPanel jPanel = this.tabPanels.get(n);
            jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, this.tabOffsets.get(n), 2, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
            this.fieldList.add(jLabel);
            this.fieldMap.put(string, jLabel);
            this.incTabOffset(n);
        } else {
            this.addField(this.tabPanels.get(n), this.tabOffsets.get(n), string, jLabel, jLabel, 0.0);
        }
        this.incTabOffset(n);
    }

    public void setCustomTabPanel(int n, JComponent jComponent) {
        this.tabPanels.get(n).add((Component)jComponent, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1));
    }

    public Boolean getBoolValue(String string) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof JCheckBox) {
                return ((JCheckBox)component).isSelected();
            }
            logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
        }
        return null;
    }

    public void addFieldListener(String string, ActionListener actionListener) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapTextField) {
                ((ZapTextField)component).addActionListener(actionListener);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(actionListener);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).addActionListener(actionListener);
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
        }
    }

    public void addFieldListener(String string, MouseAdapter mouseAdapter) {
        Component component = this.fieldMap.get(string);
        if (component != null) {
            if (component instanceof ZapTextField) {
                ((ZapTextField)component).addMouseListener(mouseAdapter);
            } else if (component instanceof ZapTextArea) {
                ((ZapTextArea)component).addMouseListener(mouseAdapter);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).addMouseListener(mouseAdapter);
            } else {
                logger.error((Object)("Unrecognised field class " + string + ": " + component.getClass().getCanonicalName()));
            }
        }
    }

    public void removeAllFields() {
        if (this.isTabbed()) {
            for (JPanel jPanel : this.tabPanels) {
                jPanel.removeAll();
            }
        } else {
            this.getMainPanel().removeAll();
        }
        this.fieldList.clear();
        this.fieldMap.clear();
    }

    public void requestTabFocus(int n) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (n < 0 || n >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        this.tabbedPane.setSelectedComponent(this.tabPanels.get(n));
    }

    public void setTabsVisible(String[] stringArray, boolean bl) {
        if (bl) {
            for (String string : stringArray) {
                String string2 = Constant.messages.getString(string);
                JPanel jPanel = this.tabNameMap.get(string);
                this.tabbedPane.addTab(string2, jPanel);
                this.tabPanels.add(jPanel);
            }
        } else {
            for (String string : stringArray) {
                JPanel jPanel = this.tabNameMap.get(string);
                this.tabbedPane.remove(jPanel);
            }
        }
    }

    public abstract void save();

    public abstract String validateFields();
}

