/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.composite;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.composite.CompositeVerifyQuery;
import org.apache.lucene.spatial.composite.IntersectsRPTVerifyQuery;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.lucene.spatial.util.ShapePredicateValueSource;

public class CompositeSpatialStrategy
extends SpatialStrategy {
    private final RecursivePrefixTreeStrategy indexStrategy;
    private final SerializedDVStrategy geometryStrategy;
    private boolean optimizePredicates = true;

    public CompositeSpatialStrategy(String fieldName, RecursivePrefixTreeStrategy indexStrategy, SerializedDVStrategy geometryStrategy) {
        super(indexStrategy.getSpatialContext(), fieldName);
        this.indexStrategy = indexStrategy;
        this.geometryStrategy = geometryStrategy;
    }

    public RecursivePrefixTreeStrategy getIndexStrategy() {
        return this.indexStrategy;
    }

    public SerializedDVStrategy getGeometryStrategy() {
        return this.geometryStrategy;
    }

    public boolean isOptimizePredicates() {
        return this.optimizePredicates;
    }

    public void setOptimizePredicates(boolean optimizePredicates) {
        this.optimizePredicates = optimizePredicates;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        ArrayList fields = new ArrayList();
        Collections.addAll(fields, this.indexStrategy.createIndexableFields(shape));
        Collections.addAll(fields, this.geometryStrategy.createIndexableFields(shape));
        return fields.toArray(new Field[fields.size()]);
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        SpatialArgs indexArgs;
        SpatialOperation pred = args.getOperation();
        if (pred == SpatialOperation.BBoxIntersects || pred == SpatialOperation.BBoxWithin) {
            throw new UnsupportedSpatialOperation(pred);
        }
        if (pred == SpatialOperation.IsDisjointTo) {
            throw new UnsupportedSpatialOperation(pred);
        }
        ShapePredicateValueSource predicateValueSource = new ShapePredicateValueSource(this.geometryStrategy.makeShapeValueSource(), pred, args.getShape());
        if (pred == SpatialOperation.Intersects && this.optimizePredicates) {
            SpatialPrefixTree grid = this.indexStrategy.getGrid();
            int detailLevel = grid.getLevelForDistance(args.resolveDistErr(this.ctx, 0.0));
            return new IntersectsRPTVerifyQuery(args.getShape(), this.indexStrategy.getFieldName(), grid, detailLevel, this.indexStrategy.getPrefixGridScanLevel(), predicateValueSource);
        }
        if (pred == SpatialOperation.Contains) {
            indexArgs = args;
        } else {
            indexArgs = new SpatialArgs(SpatialOperation.Intersects, args.getShape());
            indexArgs.setDistErr(args.getDistErr());
            indexArgs.setDistErrPct(args.getDistErrPct());
        }
        if (indexArgs.getDistErr() == null && indexArgs.getDistErrPct() == null) {
            indexArgs.setDistErrPct(0.1);
        }
        Query indexQuery = this.indexStrategy.makeQuery(indexArgs);
        return new CompositeVerifyQuery(indexQuery, predicateValueSource);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        return new QueryWrapperFilter(this.makeQuery(args));
    }
}

