/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNameModule;
import org.elasticsearch.index.analysis.AnalysisModule;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettingsModule;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class MapperTestUtils {
    public static MapperService newMapperService(Path tempDir, Settings indexSettings) throws IOException {
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", tempDir).put(indexSettings);
        if (indexSettings.get("index.version.created") == null) {
            settingsBuilder.put("index.version.created", Version.CURRENT);
        }
        Settings finalSettings = settingsBuilder.build();
        Environment environment = new Environment(finalSettings);
        ResourceWatcherService resourceWatcherService = new ResourceWatcherService(finalSettings, null);
        return new MapperService(new Index("test"), indexSettings, MapperTestUtils.newAnalysisService(finalSettings), MapperTestUtils.newSimilarityLookupService(finalSettings), new ScriptService(finalSettings, environment, new HashSet<ScriptEngineService>(), resourceWatcherService, ScriptContextRegistry.EMPTY), new IndicesModule().getMapperRegistry());
    }

    private static AnalysisService newAnalysisService(Settings indexSettings) {
        Injector parentInjector = new ModulesBuilder().add(new SettingsModule(indexSettings), new EnvironmentModule(new Environment(indexSettings))).createInjector();
        Index index = new Index("test");
        Injector injector = new ModulesBuilder().add(new IndexSettingsModule(index, indexSettings), new IndexNameModule(index), new AnalysisModule(indexSettings, parentInjector.getInstance(IndicesAnalysisService.class))).createChildInjector(parentInjector);
        return injector.getInstance(AnalysisService.class);
    }

    private static SimilarityLookupService newSimilarityLookupService(Settings indexSettings) {
        return new SimilarityLookupService(new Index("test"), indexSettings);
    }
}

