/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.modes.MindMapNode;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeTableModel;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.view.mindmapview.attributeview.AttributeView;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

abstract class AttributeTableModelDecoratorAdapter
extends AbstractTableModel
implements AttributeTableModel,
TableModelListener,
ChangeListener {
    protected NodeAttributeTableModel nodeAttributeModel;
    protected AttributeRegistry attributeRegistry;

    public AttributeTableModelDecoratorAdapter(AttributeView attrView) {
        this.nodeAttributeModel = attrView.getAttributes();
        this.attributeRegistry = attrView.getAttributeRegistry();
        MindMapNode node = this.nodeAttributeModel.getNode();
        this.addListeners();
    }

    @Override
    public MindMapNode getNode() {
        return this.nodeAttributeModel.getNode();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        return this.nodeAttributeModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.nodeAttributeModel.getColumnName(columnIndex);
    }

    @Override
    public int getColumnWidth(int col) {
        return this.nodeAttributeModel.getColumnWidth(col);
    }

    @Override
    public void setColumnWidth(int col, int width) {
        this.nodeAttributeModel.setColumnWidth(col, width);
    }

    private void addListeners() {
        this.nodeAttributeModel.addTableModelListener(this);
        this.attributeRegistry.addChangeListener(this);
    }

    private void removeListeners() {
        this.nodeAttributeModel.removeTableModelListener(this);
        this.attributeRegistry.removeChangeListener(this);
    }

    public void viewRemoved() {
        this.removeListeners();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireTableDataChanged();
    }

    public void editingCanceled() {
    }

    public abstract boolean areAttributesVisible();
}

