/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaCodecMapper;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwirlCompilerAdapterV10X
implements VersionedTwirlCompilerAdapter {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("play.twirl.compiler", "scala.io");
    private static final String DEFAULT_JAVA_IMPORTS = "import models._;import controllers._;import java.lang._;import java.util._;import scala.collection.JavaConversions._;import scala.collection.JavaConverters._;import play.api.i18n._;import play.core.j.PlayMagicForJava._;import play.mvc._;import play.data._;import play.api.data.Field;import play.mvc.Http.Context.Implicit._;import views.html._;";
    private static final String DEFAULT_SCALA_IMPORTS = "import models._;import controllers._;import play.api.i18n._;import play.api.mvc._;import play.api.data._;import views.html._;";
    private final String scalaVersion;
    private final String twirlVersion;

    public TwirlCompilerAdapterV10X(String twirlVersion, String scalaVersion) {
        this.scalaVersion = scalaVersion;
        this.twirlVersion = twirlVersion;
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, String.class, cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE, Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, boolean javaProject) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return new Object[]{file, sourceDirectory, destinationDirectory, "play.twirl.api.HtmlFormat", javaProject ? DEFAULT_JAVA_IMPORTS : DEFAULT_SCALA_IMPORTS, ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots(), this.isUseOldParser()};
    }

    private boolean isInclusiveDots() {
        return false;
    }

    private boolean isUseOldParser() {
        return false;
    }

    @Override
    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    @Override
    public String getDependencyNotation() {
        return String.format("com.typesafe.play:twirl-compiler_%s:%s", this.scalaVersion, this.twirlVersion);
    }
}

