/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.SbtJars;
import com.typesafe.zinc.ScalaLocation;
import com.typesafe.zinc.Setup;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerArgumentsGenerator;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.jvm.Jvm;
import scala.Option;
import xsbti.CompileFailed;
import xsbti.F0;
import xsbti.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZincScalaCompiler
implements org.gradle.language.base.internal.compile.Compiler<ScalaJavaJointCompileSpec>,
Serializable {
    private static final org.gradle.api.logging.Logger LOGGER = Logging.getLogger(ZincScalaCompiler.class);
    private final Iterable<File> scalaClasspath;
    private Iterable<File> zincClasspath;

    public ZincScalaCompiler(Iterable<File> scalaClasspath, Iterable<File> zincClasspath) {
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
    }

    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        return Compiler.execute(this.scalaClasspath, this.zincClasspath, spec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SbtLoggerAdapter
    implements Logger {
        private SbtLoggerAdapter() {
        }

        public void error(F0<String> msg) {
            LOGGER.error((String)msg.apply());
        }

        public void warn(F0<String> msg) {
            LOGGER.warn((String)msg.apply());
        }

        public void info(F0<String> msg) {
            LOGGER.info((String)msg.apply());
        }

        public void debug(F0<String> msg) {
            LOGGER.debug((String)msg.apply());
        }

        public void trace(F0<Throwable> exception) {
            LOGGER.trace(((Throwable)exception.apply()).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Compiler {
        private Compiler() {
        }

        static WorkResult execute(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, ScalaJavaJointCompileSpec spec) {
            LOGGER.info("Compiling with Zinc Scala compiler.");
            SbtLoggerAdapter logger = new SbtLoggerAdapter();
            com.typesafe.zinc.Compiler compiler = Compiler.createCompiler(scalaClasspath, zincClasspath, logger);
            List<String> scalacOptions = new ZincScalaCompilerArgumentsGenerator().generate(spec);
            List javacOptions = new JavaCompilerArgumentsBuilder((JavaCompileSpec)spec).includeClasspath(false).build();
            Inputs inputs = Inputs.create((List)ImmutableList.copyOf((Iterable)spec.getClasspath()), (List)ImmutableList.copyOf((Iterable)spec.getSource()), (File)spec.getDestinationDir(), scalacOptions, (List)javacOptions, (File)spec.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile(), spec.getAnalysisMap(), (String)"mixed", (IncOptions)Compiler.getIncOptions(), (boolean)true);
            if (LOGGER.isDebugEnabled()) {
                Inputs.debug((Inputs)inputs, (Logger)logger);
            }
            try {
                compiler.compile(inputs, (Logger)logger);
            }
            catch (CompileFailed e) {
                throw new CompilationFailedException((Throwable)e);
            }
            return new SimpleWorkResult(true);
        }

        private static IncOptions getIncOptions() {
            int transitiveStep = 3;
            double recompileAllFraction = 0.5;
            boolean relationsDebug = false;
            boolean apiDebug = false;
            int apiDiffContextSize = 5;
            Option apiDumpDirectory = Option.empty();
            boolean transactional = false;
            Option backup = Option.empty();
            IncOptions options = new IncOptions(transitiveStep, recompileAllFraction, relationsDebug, apiDebug, apiDiffContextSize, apiDumpDirectory, transactional, backup);
            return options;
        }

        static com.typesafe.zinc.Compiler createCompiler(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, Logger logger) {
            ScalaLocation scalaLocation = ScalaLocation.fromPath((List)Lists.newArrayList(scalaClasspath));
            SbtJars sbtJars = SbtJars.fromPath((List)Lists.newArrayList(zincClasspath));
            Setup setup = Setup.create((ScalaLocation)scalaLocation, (SbtJars)sbtJars, (File)Jvm.current().getJavaHome(), (boolean)true);
            if (LOGGER.isDebugEnabled()) {
                Setup.debug((Setup)setup, (Logger)logger);
            }
            return com.typesafe.zinc.Compiler.getOrCreate((Setup)setup, (Logger)logger);
        }
    }
}

