/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.model.internal.type.ClassTypeWrapper;
import org.gradle.model.internal.type.GenericArrayTypeWrapper;
import org.gradle.model.internal.type.ParameterizedTypeWrapper;
import org.gradle.model.internal.type.TypeVariableTypeWrapper;
import org.gradle.model.internal.type.TypeWrapper;
import org.gradle.model.internal.type.WildcardTypeWrapper;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelType<T> {
    public static final ModelType<Object> UNTYPED = ModelType.of(Object.class);
    private final TypeWrapper wrapper;
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final TypeWrapper[] EMPTY_TYPE_WRAPPER_ARRAY = new TypeWrapper[0];

    private ModelType(TypeWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected ModelType() {
        this.wrapper = ModelType.wrap(new TypeToken<T>(this.getClass()){}.getType());
    }

    private TypeToken<T> getTypeToken() {
        return (TypeToken)Cast.uncheckedCast((Object)TypeToken.of((Type)this.getType()));
    }

    public static <T> ModelType<T> of(Class<T> clazz) {
        return new Simple(clazz);
    }

    public static <T> ModelType<T> returnType(Method method) {
        return new Simple(method.getGenericReturnType());
    }

    @Nullable
    public static <T> ModelType<T> paramType(Method method, int i) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (i < parameterTypes.length) {
            return new Simple(parameterTypes[i]);
        }
        return null;
    }

    public static <T> ModelType<T> typeOf(T instance) {
        Class<?> clazz = instance.getClass();
        return ModelType.of(clazz);
    }

    public static ModelType<?> of(Type type) {
        return Simple.typed(type);
    }

    public Class<? super T> getRawClass() {
        return this.getTypeToken().getRawType();
    }

    public Class<T> getConcreteClass() {
        return (Class)Cast.uncheckedCast(this.getRawClass());
    }

    public boolean isRawClassOfParameterizedType() {
        Type type = this.getType();
        return type instanceof Class && ((Class)type).getTypeParameters().length > 0;
    }

    public Type getType() {
        return this.wrapper.unwrap();
    }

    public static ModelType<Object> untyped() {
        return UNTYPED;
    }

    public boolean isParameterized() {
        return this.getType() instanceof ParameterizedType;
    }

    public List<ModelType<?>> getTypeVariables() {
        if (this.isParameterized()) {
            Type[] typeArguments = ((ParameterizedType)this.getType()).getActualTypeArguments();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Type typeArgument : typeArguments) {
                builder.add(ModelType.of(typeArgument));
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public <U> ModelType<? extends U> asSubtype(ModelType<U> modelType) {
        if (this.isWildcard()) {
            throw new IllegalStateException(this + " is a wildcard type");
        }
        if (modelType.isWildcard()) {
            throw new IllegalArgumentException(modelType + " is a wildcard type");
        }
        if (modelType.getRawClass().isAssignableFrom(this.getRawClass())) {
            return (ModelType)Cast.uncheckedCast((Object)this);
        }
        throw new ClassCastException(String.format("'%s' cannot be cast as a subtype of '%s'", this, modelType));
    }

    public boolean isAssignableFrom(ModelType<?> modelType) {
        return this.getTypeToken().isAssignableFrom(super.getTypeToken());
    }

    public boolean isWildcard() {
        return this.getWildcardType() != null;
    }

    public ModelType<?> getUpperBound() {
        WildcardType wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        ModelType<?> upperBoundType = ModelType.of(wildcardType.getUpperBounds()[0]);
        if (upperBoundType.equals(UNTYPED)) {
            return null;
        }
        return upperBoundType;
    }

    public ModelType<?> getLowerBound() {
        WildcardType wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        Type[] lowerBounds = wildcardType.getLowerBounds();
        if (lowerBounds.length == 0) {
            return null;
        }
        return ModelType.of(lowerBounds[0]);
    }

    private WildcardType getWildcardType() {
        Type type = this.getType();
        if (type instanceof WildcardType) {
            return (WildcardType)type;
        }
        return null;
    }

    public boolean isHasWildcardTypeVariables() {
        if (this.isWildcard()) {
            return true;
        }
        if (this.isParameterized()) {
            for (ModelType<?> typeVariable : this.getTypeVariables()) {
                if (!typeVariable.isHasWildcardTypeVariables()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Class<?>> getAllClasses() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.wrapper.collectClasses(builder);
        return builder.build();
    }

    public String getName() {
        return this.wrapper.getRepresentation(true);
    }

    public String getDisplayName() {
        return this.wrapper.getRepresentation(false);
    }

    public static String getDisplayName(ModelType<?> type) {
        return type == null ? null : type.getDisplayName();
    }

    public String toString() {
        return this.wrapper.getRepresentation(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelType)) {
            return false;
        }
        ModelType modelType = (ModelType)o;
        return this.getType().equals(modelType.getType());
    }

    public int hashCode() {
        return this.getTypeToken().hashCode();
    }

    @Nullable
    private static TypeWrapper wrap(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return new ClassTypeWrapper((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeWrapper(ModelType.toWrappers(parameterizedType.getActualTypeArguments()), (ClassTypeWrapper)ModelType.wrap(parameterizedType.getRawType()), ModelType.wrap(parameterizedType.getOwnerType()), type.hashCode());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new WildcardTypeWrapper(ModelType.toWrappers(wildcardType.getUpperBounds()), ModelType.toWrappers(wildcardType.getLowerBounds()), type.hashCode());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return new TypeVariableTypeWrapper(typeVariable.getName(), ModelType.toWrappers(typeVariable.getBounds()), type.hashCode());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new GenericArrayTypeWrapper(ModelType.wrap(genericArrayType.getGenericComponentType()), type.hashCode());
        }
        throw new IllegalArgumentException("cannot wrap type of type " + type.getClass());
    }

    static TypeWrapper[] toWrappers(Type[] types) {
        if (types.length == 0) {
            return EMPTY_TYPE_WRAPPER_ARRAY;
        }
        TypeWrapper[] wrappers = new TypeWrapper[types.length];
        int i = 0;
        for (Type type : types) {
            wrappers[i++] = ModelType.wrap(type);
        }
        return wrappers;
    }

    static Type[] unwrap(TypeWrapper[] wrappers) {
        if (wrappers.length == 0) {
            return EMPTY_TYPE_ARRAY;
        }
        Type[] types = new Type[wrappers.length];
        int i = 0;
        for (TypeWrapper wrapper : wrappers) {
            types[i++] = wrapper.unwrap();
        }
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Simple<T>
    extends ModelType<T> {
        public static <T> ModelType<T> typed(Type type) {
            return new Simple<T>(type);
        }

        public Simple(Type type) {
            super(ModelType.wrap(type));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Specs {
        public static Spec<ModelType<?>> isAssignableTo(final ModelType<?> type) {
            return new Spec<ModelType<?>>(){

                public boolean isSatisfiedBy(ModelType<?> element) {
                    return type.isAssignableFrom(element);
                }
            };
        }

        public static Spec<ModelType<?>> isAssignableFrom(final ModelType<?> type) {
            return new Spec<ModelType<?>>(){

                public boolean isSatisfiedBy(ModelType<?> element) {
                    return element.isAssignableFrom(type);
                }
            };
        }

        public static Spec<ModelType<?>> isAssignableToAny(final Iterable<? extends ModelType<?>> types) {
            return new Spec<ModelType<?>>(){

                public boolean isSatisfiedBy(ModelType<?> element) {
                    return CollectionUtils.any((Iterable)types, Specs.isAssignableFrom(element));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Parameter<T> {
        private final TypeVariable<?> typeVariable;

        public Parameter() {
            Type type = new TypeToken<T>(this.getClass()){}.getType();
            if (!(type instanceof TypeVariable)) {
                throw new IllegalStateException("T for Parameter<T> MUST be a type variable");
            }
            this.typeVariable = (TypeVariable)type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<T> {
        private TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};

        public <I> Builder<T> where(Parameter<I> parameter, ModelType<I> type) {
            TypeResolver resolver = new TypeResolver().where((Type)((Parameter)parameter).typeVariable, ((ModelType)type).getTypeToken().getType());
            this.typeToken = TypeToken.of((Type)resolver.resolveType(this.typeToken.getType()));
            return this;
        }

        public ModelType<T> build() {
            return Simple.typed(this.typeToken.getType());
        }
    }
}

