/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import groovy.lang.GroovySystem;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.Main;
import org.gradle.BuildExceptionReporter;
import org.gradle.api.Action;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.internal.Actions;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.BuildActionsFactory;
import org.gradle.launcher.cli.CommandLineAction;
import org.gradle.launcher.cli.ExceptionReportingAction;
import org.gradle.launcher.cli.GuiActionsFactory;
import org.gradle.launcher.cli.JavaRuntimeValidationAction;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.ParametersConverter;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineActionFactory {
    private static final String HELP = "h";
    private static final String VERSION = "v";

    public Action<ExecutionListener> convert(List<String> args) {
        ServiceRegistry loggingServices = this.createLoggingServices();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        return new ExceptionReportingAction(new WithLogging(loggingServices, args, loggingConfiguration, new JavaRuntimeValidationAction(new ParseAndBuildAction(loggingServices, args))), new BuildExceptionReporter(loggingServices.get(StyledTextOutputFactory.class), loggingConfiguration, CommandLineActionFactory.clientMetaData()));
    }

    protected void createActionFactories(ServiceRegistry loggingServices, Collection<CommandLineAction> actions) {
        actions.add(new GuiActionsFactory());
        actions.add(new BuildActionsFactory(loggingServices, (CommandLineConverter<Parameters>)new ParametersConverter()));
    }

    private static GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }

    public ServiceRegistry createLoggingServices() {
        return LoggingServiceRegistry.newCommandLineProcessLogging();
    }

    private static void showUsage(PrintStream out, CommandLineParser parser) {
        out.println();
        out.print("USAGE: ");
        CommandLineActionFactory.clientMetaData().describeCommand(out, "[option...]", "[task...]");
        out.println();
        out.println();
        parser.printUsage((Appendable)out);
        out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParseAndBuildAction
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final List<String> args;

        private ParseAndBuildAction(ServiceRegistry loggingServices, List<String> args) {
            this.loggingServices = loggingServices;
            this.args = args;
        }

        @Override
        public void execute(ExecutionListener executionListener) {
            Action<ExecutionListener> action;
            ArrayList<CommandLineAction> actions = new ArrayList<CommandLineAction>();
            actions.add(new BuiltInActions());
            CommandLineActionFactory.this.createActionFactories(this.loggingServices, actions);
            CommandLineParser parser = new CommandLineParser();
            for (CommandLineAction action2 : actions) {
                action2.configureCommandLineParser(parser);
            }
            try {
                ParsedCommandLine commandLine = parser.parse(this.args);
                action = this.createAction(actions, parser, commandLine);
            }
            catch (CommandLineArgumentException e) {
                action = new CommandLineParseFailureAction(parser, (Exception)((Object)e));
            }
            action.execute(executionListener);
        }

        private Action<? super ExecutionListener> createAction(Iterable<CommandLineAction> factories, CommandLineParser parser, ParsedCommandLine commandLine) {
            for (CommandLineAction factory : factories) {
                Runnable action = factory.createAction(parser, commandLine);
                if (action == null) continue;
                return Actions.toAction(action);
            }
            throw new UnsupportedOperationException("No action factory for specified command-line arguments.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WithLogging
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final List<String> args;
        private final LoggingConfiguration loggingConfiguration;
        private final Action<ExecutionListener> action;

        WithLogging(ServiceRegistry loggingServices, List<String> args, LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action) {
            this.loggingServices = loggingServices;
            this.args = args;
            this.loggingConfiguration = loggingConfiguration;
            this.action = action;
        }

        @Override
        public void execute(ExecutionListener executionListener) {
            LoggingCommandLineConverter loggingConfigurationConverter = new LoggingCommandLineConverter();
            LayoutCommandLineConverter buildLayoutConverter = new LayoutCommandLineConverter();
            BuildLayoutParameters buildLayout = new BuildLayoutParameters();
            CommandLineParser parser = new CommandLineParser();
            loggingConfigurationConverter.configure(parser);
            buildLayoutConverter.configure(parser);
            parser.allowUnknownOptions();
            parser.allowMixedSubcommandsAndOptions();
            try {
                ParsedCommandLine parsedCommandLine = parser.parse(this.args);
                loggingConfigurationConverter.convert(parsedCommandLine, this.loggingConfiguration);
                buildLayoutConverter.convert(parsedCommandLine, buildLayout);
            }
            catch (CommandLineArgumentException e) {
                // empty catch block
            }
            LoggingManagerInternal loggingManager = this.loggingServices.getFactory(LoggingManagerInternal.class).create();
            loggingManager.setLevel(this.loggingConfiguration.getLogLevel());
            loggingManager.start();
            NativeServices.initialize((File)buildLayout.getGradleUserHomeDir());
            loggingManager.attachProcessConsole(this.loggingConfiguration.getConsoleOutput());
            this.action.execute(executionListener);
        }
    }

    private static class ShowVersionAction
    implements Runnable {
        private ShowVersionAction() {
        }

        public void run() {
            GradleVersion currentVersion = GradleVersion.current();
            StringBuilder sb = new StringBuilder();
            sb.append("\n------------------------------------------------------------\nGradle ");
            sb.append(currentVersion.getVersion());
            sb.append("\n------------------------------------------------------------\n\nBuild time:   ");
            sb.append(currentVersion.getBuildTime());
            sb.append("\nBuild number: ");
            sb.append(currentVersion.getBuildNumber());
            sb.append("\nRevision:     ");
            sb.append(currentVersion.getRevision());
            sb.append("\n\nGroovy:       ");
            sb.append(GroovySystem.getVersion());
            sb.append("\nAnt:          ");
            sb.append(Main.getAntVersion());
            sb.append("\nJVM:          ");
            sb.append(Jvm.current());
            sb.append("\nOS:           ");
            sb.append(OperatingSystem.current());
            sb.append("\n");
            System.out.println(sb.toString());
        }
    }

    private static class ShowUsageAction
    implements Runnable {
        private final CommandLineParser parser;

        public ShowUsageAction(CommandLineParser parser) {
            this.parser = parser;
        }

        public void run() {
            CommandLineActionFactory.showUsage(System.out, this.parser);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineParseFailureAction
    implements Action<ExecutionListener> {
        private final Exception e;
        private final CommandLineParser parser;

        public CommandLineParseFailureAction(CommandLineParser parser, Exception e) {
            this.parser = parser;
            this.e = e;
        }

        @Override
        public void execute(ExecutionListener executionListener) {
            System.err.println();
            System.err.println(this.e.getMessage());
            CommandLineActionFactory.showUsage(System.err, this.parser);
            executionListener.onFailure(this.e);
        }
    }

    private static class BuiltInActions
    implements CommandLineAction {
        private BuiltInActions() {
        }

        public void configureCommandLineParser(CommandLineParser parser) {
            parser.option(new String[]{CommandLineActionFactory.HELP, "?", "help"}).hasDescription("Shows this help message.");
            parser.option(new String[]{CommandLineActionFactory.VERSION, "version"}).hasDescription("Print version info.");
        }

        public Runnable createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
            if (commandLine.hasOption(CommandLineActionFactory.HELP)) {
                return new ShowUsageAction(parser);
            }
            if (commandLine.hasOption(CommandLineActionFactory.VERSION)) {
                return new ShowVersionAction();
            }
            return null;
        }
    }
}

