/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.messaging.remote.Address;

class DomainRegistryUpdater
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DomainRegistryUpdater.class);
    private final DaemonRegistry daemonRegistry;
    private final DaemonContext daemonContext;
    private final String password;
    private Address connectorAddress;

    public DomainRegistryUpdater(DaemonRegistry daemonRegistry, DaemonContext daemonContext, String password) {
        this.daemonRegistry = daemonRegistry;
        this.daemonContext = daemonContext;
        this.password = password;
    }

    public void onStartActivity() {
        LOGGER.info("Marking the daemon as busy, address: {}", this.connectorAddress);
        try {
            this.daemonRegistry.markBusy(this.connectorAddress);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot mark daemon as busy because the registry is empty.");
        }
    }

    public void onCompleteActivity() {
        LOGGER.info("Marking the daemon as idle, address: {}", this.connectorAddress);
        try {
            this.daemonRegistry.markIdle(this.connectorAddress);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot mark daemon as idle because the registry is empty.");
        }
    }

    public void onStart(Address connectorAddress) {
        LOGGER.info("{}{}", "Advertising the daemon address to the clients: ", connectorAddress);
        LOGGER.debug("Advertised daemon context: {}", this.daemonContext);
        this.connectorAddress = connectorAddress;
        this.daemonRegistry.store(connectorAddress, this.daemonContext, this.password, false);
    }

    public void stop() {
        LOGGER.debug("Removing our presence to clients, eg. removing this address from the registry: {}", this.connectorAddress);
        try {
            this.daemonRegistry.remove(this.connectorAddress);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot remove daemon from the registry because the registry is empty.");
        }
        LOGGER.debug("Address removed from registry.");
    }
}

