/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.set.PartitionMutableSet;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.api.set.Pool;
import com.gs.collections.api.set.SetIterable;
import com.gs.collections.api.set.UnsortedSetIterable;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates2;
import com.gs.collections.impl.block.procedure.CollectIfProcedure;
import com.gs.collections.impl.block.procedure.CollectProcedure;
import com.gs.collections.impl.block.procedure.CountProcedure;
import com.gs.collections.impl.block.procedure.FlatCollectProcedure;
import com.gs.collections.impl.block.procedure.MultimapEachPutProcedure;
import com.gs.collections.impl.block.procedure.MultimapPutProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionPredicate2Procedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.block.procedure.RejectProcedure;
import com.gs.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.gs.collections.impl.block.procedure.SelectProcedure;
import com.gs.collections.impl.block.procedure.ZipWithIndexProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.parallel.AbstractBatch;
import com.gs.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import com.gs.collections.impl.lazy.parallel.set.CollectUnsortedSetBatch;
import com.gs.collections.impl.lazy.parallel.set.RootUnsortedSetBatch;
import com.gs.collections.impl.lazy.parallel.set.SelectUnsortedSetBatch;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.multimap.set.UnifiedSetMultimap;
import com.gs.collections.impl.parallel.BatchIterable;
import com.gs.collections.impl.partition.set.PartitionUnifiedSet;
import com.gs.collections.impl.set.mutable.SynchronizedMutableSet;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import com.gs.collections.impl.utility.internal.MutableCollectionIterate;
import com.gs.collections.impl.utility.internal.SetIterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class UnifiedSet<T>
implements MutableSet<T>,
Externalizable,
Pool<T>,
BatchIterable<T> {
    protected static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "UnifiedSet.NULL_KEY";
        }
    };
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 1L;
    protected transient Object[] table;
    protected transient int occupied;
    protected float loadFactor = 0.75f;
    protected int maxSize;

    public UnifiedSet() {
        this.allocate(16);
    }

    public UnifiedSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UnifiedSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.loadFactor = loadFactor;
        this.init(this.fastCeil((float)initialCapacity / loadFactor));
    }

    public UnifiedSet(Collection<? extends T> collection) {
        this(Math.max(collection.size(), 8), 0.75f);
        this.addAll(collection);
    }

    public UnifiedSet(UnifiedSet<T> set) {
        this.maxSize = set.maxSize;
        this.loadFactor = set.loadFactor;
        this.occupied = set.occupied;
        this.allocateTable(set.table.length);
        for (int i = 0; i < set.table.length; ++i) {
            Object key = set.table[i];
            if (key instanceof ChainedBucket) {
                this.table[i] = ((ChainedBucket)key).copy();
                continue;
            }
            if (key == null) continue;
            this.table[i] = key;
        }
    }

    public static <K> UnifiedSet<K> newSet() {
        return new UnifiedSet();
    }

    public static <K> UnifiedSet<K> newSet(int size) {
        return new UnifiedSet(size);
    }

    /*
     * Exception decompiling
     */
    public static <K> UnifiedSet<K> newSet(Iterable<? extends K> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <K> UnifiedSet<K> newSet(int size, float loadFactor) {
        return new UnifiedSet(size, loadFactor);
    }

    public static <K> UnifiedSet<K> newSetWith(K ... elements) {
        return UnifiedSet.newSet(elements.length).with(elements);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    protected int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    protected int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.table = new Object[sizeToAllocate];
    }

    protected void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    protected final int index(Object key) {
        int h = key == null ? 0 : key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.table.length - 1;
    }

    public void clear() {
        if (this.occupied == 0) {
            return;
        }
        this.occupied = 0;
        Object[] set = this.table;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    public boolean add(T key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            this.table[index] = UnifiedSet.toSentinelIfNull(key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return true;
        }
        if (cur instanceof ChainedBucket || !this.nonNullTableObjectEquals(cur, key)) {
            return this.chainedAdd(key, index);
        }
        return false;
    }

    private boolean chainedAdd(T key, int index) {
        Object realKey = UnifiedSet.toSentinelIfNull(key);
        if (this.table[index] instanceof ChainedBucket) {
            ChainedBucket bucket = (ChainedBucket)this.table[index];
            while (true) {
                if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                    return false;
                }
                if (bucket.one == null) {
                    bucket.one = realKey;
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return true;
                }
                if (this.nonNullTableObjectEquals(bucket.one, key)) {
                    return false;
                }
                if (bucket.two == null) {
                    bucket.two = realKey;
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return true;
                }
                if (this.nonNullTableObjectEquals(bucket.two, key)) {
                    return false;
                }
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            if (bucket.three == null) {
                bucket.three = realKey;
                if (++this.occupied > this.maxSize) {
                    this.rehash();
                }
                return true;
            }
            if (this.nonNullTableObjectEquals(bucket.three, key)) {
                return false;
            }
            bucket.three = new ChainedBucket(bucket.three, realKey);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return true;
        }
        ChainedBucket newBucket = new ChainedBucket(this.table[index], realKey);
        this.table[index] = newBucket;
        if (++this.occupied > this.maxSize) {
            this.rehash();
        }
        return true;
    }

    protected void rehash() {
        this.rehash(this.table.length << 1);
    }

    protected void rehash(int newCapacity) {
        int oldLength = this.table.length;
        Object[] old = this.table;
        this.allocate(newCapacity);
        this.occupied = 0;
        block0: for (int i = 0; i < oldLength; ++i) {
            Object oldKey = old[i];
            if (oldKey instanceof ChainedBucket) {
                ChainedBucket bucket = (ChainedBucket)oldKey;
                while (true) {
                    if (bucket.zero != null) {
                        this.add(this.nonSentinel(bucket.zero));
                    }
                    if (bucket.one == null) continue block0;
                    this.add(this.nonSentinel(bucket.one));
                    if (bucket.two == null) continue block0;
                    this.add(this.nonSentinel(bucket.two));
                    if (bucket.three == null) continue block0;
                    if (!(bucket.three instanceof ChainedBucket)) break;
                    bucket = (ChainedBucket)bucket.three;
                }
                this.add(this.nonSentinel(bucket.three));
                continue;
            }
            if (oldKey == null) continue;
            this.add(this.nonSentinel(oldKey));
        }
    }

    public boolean contains(Object key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return false;
        }
        if (cur instanceof ChainedBucket) {
            return this.chainContains((ChainedBucket)cur, key);
        }
        return this.nonNullTableObjectEquals(cur, key);
    }

    private boolean chainContains(ChainedBucket bucket, T key) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                return true;
            }
            if (bucket.one == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                return true;
            }
            if (bucket.two == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                return true;
            }
            if (bucket.three == null) {
                return false;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return this.nonNullTableObjectEquals(bucket.three, key);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return Math.max(1, this.table.length / batchSize);
    }

    @Override
    public void batchForEach(Procedure<? super T> procedure, int sectionIndex, int sectionCount) {
        Object[] set = this.table;
        int sectionSize = set.length / sectionCount;
        int start = sectionSize * sectionIndex;
        int end = sectionIndex == sectionCount - 1 ? set.length : start + sectionSize;
        for (int i = start; i < end; ++i) {
            Object cur = set[i];
            if (cur == null) continue;
            if (cur instanceof ChainedBucket) {
                this.chainedForEach((ChainedBucket)cur, procedure);
                continue;
            }
            procedure.value(this.nonSentinel(cur));
        }
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                this.chainedForEach((ChainedBucket)cur, procedure);
                continue;
            }
            if (cur == null) continue;
            procedure.value(this.nonSentinel(cur));
        }
    }

    private void chainedForEach(ChainedBucket bucket, Procedure<? super T> procedure) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three));
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                this.chainedForEachWith((ChainedBucket)cur, procedure, parameter);
                continue;
            }
            if (cur == null) continue;
            procedure.value(this.nonSentinel(cur), parameter);
        }
    }

    private <P> void chainedForEachWith(ChainedBucket bucket, Procedure2<? super T, ? super P> procedure, P parameter) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero), parameter);
            if (bucket.one == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.one), parameter);
            if (bucket.two == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.two), parameter);
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three), parameter);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                count = this.chainedForEachWithIndex((ChainedBucket)cur, objectIntProcedure, count);
                continue;
            }
            if (cur == null) continue;
            objectIntProcedure.value(this.nonSentinel(cur), count++);
        }
    }

    private int chainedForEachWithIndex(ChainedBucket bucket, ObjectIntProcedure<? super T> procedure, int count) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero), count++);
            if (bucket.one == null) {
                return count;
            }
            procedure.value(this.nonSentinel(bucket.one), count++);
            if (bucket.two == null) {
                return count;
            }
            procedure.value(this.nonSentinel(bucket.two), count++);
            if (bucket.three == null) {
                return count;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three), count++);
        return count;
    }

    public UnifiedSet<T> newEmpty() {
        return UnifiedSet.newSet();
    }

    public T getFirst() {
        return this.isEmpty() ? null : (T)this.iterator().next();
    }

    public T getLast() {
        return this.getFirst();
    }

    public UnifiedSet<T> select(Predicate<? super T> predicate) {
        return (UnifiedSet)this.select(predicate, this.newEmpty());
    }

    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        this.forEach((Procedure<? super T>)new SelectProcedure<T>(predicate, target));
        return target;
    }

    public <P> UnifiedSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (UnifiedSet)this.selectWith(predicate, parameter, this.newEmpty());
    }

    public <P, R extends Collection<T>> R selectWith(final Predicate2<? super T, ? super P> predicate, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<T, P>(){

            public void value(T each, P parm) {
                if (predicate.accept(each, parm)) {
                    targetCollection.add(each);
                }
            }
        }, parameter);
        return targetCollection;
    }

    public UnifiedSet<T> reject(Predicate<? super T> predicate) {
        return (UnifiedSet)this.reject(predicate, this.newEmpty());
    }

    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        this.forEach((Procedure<? super T>)new RejectProcedure<T>(predicate, target));
        return target;
    }

    public <P> UnifiedSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (UnifiedSet)this.rejectWith(predicate, parameter, this.newEmpty());
    }

    public <P, R extends Collection<T>> R rejectWith(final Predicate2<? super T, ? super P> predicate, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<T, P>(){

            public void value(T each, P parm) {
                if (!predicate.accept(each, parm)) {
                    targetCollection.add(each);
                }
            }
        }, parameter);
        return targetCollection;
    }

    public <P> Twin<MutableList<T>> selectAndRejectWith(final Predicate2<? super T, ? super P> predicate, P parameter) {
        final MutableList positiveResult = Lists.mutable.of();
        final MutableList negativeResult = Lists.mutable.of();
        this.forEachWith(new Procedure2<T, P>(){

            public void value(T each, P parm) {
                (predicate.accept(each, parm) ? positiveResult : negativeResult).add(each);
            }
        }, parameter);
        return Tuples.twin(positiveResult, negativeResult);
    }

    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach((Procedure<? super T>)new PartitionProcedure<T>(predicate, partitionUnifiedSet));
        return partitionUnifiedSet;
    }

    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach((Procedure<? super T>)new PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionUnifiedSet));
        return partitionUnifiedSet;
    }

    public <S> UnifiedSet<S> selectInstancesOf(Class<S> clazz) {
        UnifiedSet result = UnifiedSet.newSet();
        this.forEach((Procedure<? super T>)new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public void removeIf(Predicate<? super T> predicate) {
        IterableIterate.removeIf(this, predicate);
    }

    public <P> void removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        IterableIterate.removeIfWith(this, predicate, parameter);
    }

    public <V> UnifiedSet<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanHashSet());
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectBooleanProcedure<T>(booleanFunction, target));
        return target;
    }

    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteHashSet());
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectByteProcedure<T>(byteFunction, target));
        return target;
    }

    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharHashSet());
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectCharProcedure<T>(charFunction, target));
        return target;
    }

    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleHashSet());
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectDoubleProcedure<T>(doubleFunction, target));
        return target;
    }

    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatHashSet());
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectFloatProcedure<T>(floatFunction, target));
        return target;
    }

    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntHashSet());
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectIntProcedure<T>(intFunction, target));
        return target;
    }

    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongHashSet());
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectLongProcedure<T>(longFunction, target));
        return target;
    }

    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortHashSet());
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        this.forEach((Procedure<? super T>)new CollectShortProcedure<T>(shortFunction, target));
        return target;
    }

    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        this.forEach((Procedure<? super T>)new CollectProcedure<T, V>(function, target));
        return target;
    }

    public <V> UnifiedSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(new FlatCollectProcedure(function, target));
        return target;
    }

    public <P, A> UnifiedSet<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.collectWith(function, parameter, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <P, A, R extends Collection<A>> R collectWith(final Function2<? super T, ? super P, ? extends A> function, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<T, P>(){

            public void value(T each, P parm) {
                targetCollection.add(function.value(each, parm));
            }
        }, parameter);
        return targetCollection;
    }

    public <V> UnifiedSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        this.forEach((Procedure<? super T>)new CollectIfProcedure<T, V>(target, function, predicate));
        return target;
    }

    public T detect(Predicate<? super T> predicate) {
        for (int i = 0; i < this.table.length; ++i) {
            T each;
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                Object chainedDetect = this.chainedDetect((ChainedBucket)cur, predicate);
                if (chainedDetect == null) continue;
                return this.nonSentinel(chainedDetect);
            }
            if (cur == null || !predicate.accept(each = this.nonSentinel(cur))) continue;
            return each;
        }
        return null;
    }

    private Object chainedDetect(ChainedBucket bucket, Predicate<? super T> predicate) {
        while (true) {
            if (predicate.accept(this.nonSentinel(bucket.zero))) {
                return bucket.zero;
            }
            if (bucket.one == null) {
                return null;
            }
            if (predicate.accept(this.nonSentinel(bucket.one))) {
                return bucket.one;
            }
            if (bucket.two == null) {
                return null;
            }
            if (predicate.accept(this.nonSentinel(bucket.two))) {
                return bucket.two;
            }
            if (bucket.three == null) {
                return null;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        if (predicate.accept(this.nonSentinel(bucket.three))) {
            return bucket.three;
        }
        return null;
    }

    public T min(Comparator<? super T> comparator) {
        return Iterate.min(this, comparator);
    }

    public T max(Comparator<? super T> comparator) {
        return Iterate.max(this, comparator);
    }

    public T min() {
        return Iterate.min(this);
    }

    public T max() {
        return Iterate.max(this);
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return IterableIterate.minBy(this, function);
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return IterableIterate.maxBy(this, function);
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        return (T)(result == null ? function.value() : result);
    }

    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.detectWith(this, predicate, parameter);
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        T result = this.detectWith(predicate, parameter);
        return (T)(result == null ? function.value() : result);
    }

    public int count(Predicate<? super T> predicate) {
        CountProcedure<T> procedure = new CountProcedure<T>(predicate);
        this.forEach((Procedure<? super T>)procedure);
        return procedure.getCount();
    }

    public <P> int countWith(final Predicate2<? super T, ? super P> predicate, P parameter) {
        final Counter count = new Counter();
        this.forEachWith(new Procedure2<T, P>(){

            public void value(T each, P parm) {
                if (predicate.accept(each, parm)) {
                    count.increment();
                }
            }
        }, parameter);
        return count.getCount();
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (!(cur instanceof ChainedBucket ? this.chainedAnySatisfy((ChainedBucket)cur, predicate) : cur != null && predicate.accept(this.nonSentinel(cur)))) continue;
            return true;
        }
        return false;
    }

    private boolean chainedAnySatisfy(ChainedBucket bucket, Predicate<? super T> predicate) {
        while (true) {
            if (predicate.accept(this.nonSentinel(bucket.zero))) {
                return true;
            }
            if (bucket.one == null) {
                return false;
            }
            if (predicate.accept(this.nonSentinel(bucket.one))) {
                return true;
            }
            if (bucket.two == null) {
                return false;
            }
            if (predicate.accept(this.nonSentinel(bucket.two))) {
                return true;
            }
            if (bucket.three == null) {
                return false;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return predicate.accept(this.nonSentinel(bucket.three));
    }

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.anySatisfyWith(this, predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (!(cur instanceof ChainedBucket ? !this.chainedAllSatisfy((ChainedBucket)cur, predicate) : cur != null && !predicate.accept(this.nonSentinel(cur)))) continue;
            return false;
        }
        return true;
    }

    private boolean chainedAllSatisfy(ChainedBucket bucket, Predicate<? super T> predicate) {
        while (true) {
            if (!predicate.accept(this.nonSentinel(bucket.zero))) {
                return false;
            }
            if (bucket.one == null) {
                return true;
            }
            if (!predicate.accept(this.nonSentinel(bucket.one))) {
                return false;
            }
            if (bucket.two == null) {
                return true;
            }
            if (!predicate.accept(this.nonSentinel(bucket.two))) {
                return false;
            }
            if (bucket.three == null) {
                return true;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return predicate.accept(this.nonSentinel(bucket.three));
    }

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.allSatisfyWith(this, predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return IterableIterate.noneSatisfy(this, predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.noneSatisfyWith(this, predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public long sumOfInt(IntFunction<? super T> function) {
        return IterableIterate.sumOfInt(this, function);
    }

    public double sumOfFloat(FloatFunction<? super T> function) {
        return IterableIterate.sumOfFloat(this, function);
    }

    public long sumOfLong(LongFunction<? super T> function) {
        return IterableIterate.sumOfLong(this, function);
    }

    public double sumOfDouble(DoubleFunction<? super T> function) {
        return IterableIterate.sumOfDouble(this, function);
    }

    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        return IterableIterate.injectIntoWith(injectValue, this, function, parameter);
    }

    public MutableList<T> toList() {
        return FastList.newList(this);
    }

    public MutableList<T> toSortedList() {
        return FastList.newList(this).sortThis();
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return FastList.newList(this).sortThis((Comparator)comparator);
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        return this.toSortedList((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableSortedSet<T> toSortedSet() {
        return TreeSortedSet.newSet(null, this);
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        return TreeSortedSet.newSet(comparator, this);
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        return this.toSortedSet((Comparator<? super T>)Comparators.byFunction(function));
    }

    public UnifiedSet<T> toSet() {
        return UnifiedSet.newSet(this);
    }

    public MutableBag<T> toBag() {
        return HashBag.newBag(this);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return UnifiedMap.newMap(this.size()).collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return TreeSortedMap.newMap().collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return TreeSortedMap.newMap(comparator).collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public LazyIterable<T> asLazy() {
        return LazyIterate.adapt(this);
    }

    public MutableSet<T> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    public MutableSet<T> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    public ImmutableSet<T> toImmutable() {
        return Sets.immutable.ofAll((Iterable)((Object)this));
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.occupied == 0;
    }

    public UnifiedSet<T> with(T element) {
        this.add(element);
        return this;
    }

    public UnifiedSet<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public UnifiedSet<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public UnifiedSet<T> with(T ... elements) {
        this.addAll(Arrays.asList(elements));
        return this;
    }

    public UnifiedSet<T> withAll(Iterable<? extends T> iterable) {
        this.addAllIterable(iterable);
        return this;
    }

    public UnifiedSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    public UnifiedSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    public boolean addAll(Collection<? extends T> collection) {
        return this.addAllIterable(collection);
    }

    /*
     * Exception decompiling
     */
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureCapacity(int size) {
        if (size > this.maxSize) {
            int capacity = Integer.highestOneBit(size);
            if ((size = (int)((float)size / this.loadFactor) + 1) != capacity) {
                capacity <<= 1;
            }
            this.rehash(capacity);
        }
    }

    protected boolean copySet(UnifiedSet<?> unifiedset) {
        boolean changed = false;
        for (int i = 0; i < unifiedset.table.length; ++i) {
            Object cur = unifiedset.table[i];
            if (cur instanceof ChainedBucket) {
                changed |= this.copyChain((ChainedBucket)cur);
                continue;
            }
            if (cur == null) continue;
            changed |= this.add(this.nonSentinel(cur));
        }
        return changed;
    }

    private boolean copyChain(ChainedBucket bucket) {
        boolean changed = false;
        while (true) {
            changed |= this.add(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return changed;
            }
            changed |= this.add(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return changed;
            }
            changed |= this.add(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return changed;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return changed |= this.add(this.nonSentinel(bucket.three));
    }

    public boolean remove(Object key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return false;
        }
        if (cur instanceof ChainedBucket) {
            return this.removeFromChain((ChainedBucket)cur, key, index);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            this.table[index] = null;
            --this.occupied;
            return true;
        }
        return false;
    }

    private boolean removeFromChain(ChainedBucket bucket, T key, int index) {
        if (this.nonNullTableObjectEquals(bucket.zero, key)) {
            bucket.zero = bucket.removeLast(0);
            if (bucket.zero == null) {
                this.table[index] = null;
            }
            --this.occupied;
            return true;
        }
        if (bucket.one == null) {
            return false;
        }
        if (this.nonNullTableObjectEquals(bucket.one, key)) {
            bucket.one = bucket.removeLast(1);
            --this.occupied;
            return true;
        }
        if (bucket.two == null) {
            return false;
        }
        if (this.nonNullTableObjectEquals(bucket.two, key)) {
            bucket.two = bucket.removeLast(2);
            --this.occupied;
            return true;
        }
        if (bucket.three == null) {
            return false;
        }
        if (bucket.three instanceof ChainedBucket) {
            return this.removeDeepChain(bucket, key);
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return true;
        }
        return false;
    }

    private boolean removeDeepChain(ChainedBucket oldBucket, T key) {
        ChainedBucket bucket;
        while (true) {
            if (this.nonNullTableObjectEquals((bucket = (ChainedBucket)oldBucket.three).zero, key)) {
                bucket.zero = bucket.removeLast(0);
                if (bucket.zero == null) {
                    oldBucket.three = null;
                }
                --this.occupied;
                return true;
            }
            if (bucket.one == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                bucket.one = bucket.removeLast(1);
                --this.occupied;
                return true;
            }
            if (bucket.two == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                bucket.two = bucket.removeLast(2);
                --this.occupied;
                return true;
            }
            if (bucket.three == null) {
                return false;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            oldBucket = bucket;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.occupied;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                hashCode += this.chainedHashCode((ChainedBucket)cur);
                continue;
            }
            if (cur == null) continue;
            hashCode += cur == NULL_KEY ? 0 : cur.hashCode();
        }
        return hashCode;
    }

    private int chainedHashCode(ChainedBucket bucket) {
        int hashCode = 0;
        while (true) {
            hashCode += bucket.zero == NULL_KEY ? 0 : bucket.zero.hashCode();
            if (bucket.one == null) {
                return hashCode;
            }
            hashCode += bucket.one == NULL_KEY ? 0 : bucket.one.hashCode();
            if (bucket.two == null) {
                return hashCode;
            }
            hashCode += bucket.two == NULL_KEY ? 0 : bucket.two.hashCode();
            if (bucket.three == null) {
                return hashCode;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return hashCode += bucket.three == NULL_KEY ? 0 : bucket.three.hashCode();
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.loadFactor = in.readFloat();
        this.init(Math.max((int)((float)size / this.loadFactor) + 1, 8));
        for (int i = 0; i < size; ++i) {
            this.add(in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(this.loadFactor);
        for (int i = 0; i < this.table.length; ++i) {
            Object o = this.table[i];
            if (o == null) continue;
            if (o instanceof ChainedBucket) {
                this.writeExternalChain(out, (ChainedBucket)o);
                continue;
            }
            out.writeObject(this.nonSentinel(o));
        }
    }

    private void writeExternalChain(ObjectOutput out, ChainedBucket bucket) throws IOException {
        while (true) {
            out.writeObject(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return;
            }
            out.writeObject(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return;
            }
            out.writeObject(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        out.writeObject(this.nonSentinel(bucket.three));
    }

    public boolean containsAll(Collection<?> collection) {
        return Iterate.allSatisfyWith(collection, Predicates2.in(), this);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return Iterate.allSatisfyWith(source, Predicates2.in(), this);
    }

    public boolean containsAllArguments(Object ... elements) {
        return ArrayIterate.allSatisfyWith(elements, Predicates2.in(), this);
    }

    public boolean removeAll(Collection<?> collection) {
        return this.removeAllIterable(collection);
    }

    public boolean removeAllIterable(Iterable<?> iterable) {
        boolean changed = false;
        for (Object each : iterable) {
            changed |= this.remove(each);
        }
        return changed;
    }

    private void addIfFound(T key, UnifiedSet<T> other) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return;
        }
        if (cur instanceof ChainedBucket) {
            this.addIfFoundFromChain((ChainedBucket)cur, key, other);
            return;
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            other.add(this.nonSentinel(cur));
        }
    }

    private void addIfFoundFromChain(ChainedBucket bucket, T key, UnifiedSet<T> other) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                other.add(this.nonSentinel(bucket.zero));
                return;
            }
            if (bucket.one == null) {
                return;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                other.add(this.nonSentinel(bucket.one));
                return;
            }
            if (bucket.two == null) {
                return;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                other.add(this.nonSentinel(bucket.two));
                return;
            }
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            other.add(this.nonSentinel(bucket.three));
            return;
        }
    }

    public boolean retainAll(Collection<?> collection) {
        return this.retainAllIterable(collection);
    }

    public boolean retainAllIterable(Iterable<?> iterable) {
        if (iterable instanceof Set) {
            return this.retainAllFromSet((Set)iterable);
        }
        return this.retainAllFromNonSet(iterable);
    }

    private boolean retainAllFromNonSet(Iterable<?> iterable) {
        int retainedSize = Iterate.sizeOf(iterable);
        UnifiedSet<T> retainedCopy = new UnifiedSet<T>(retainedSize, this.loadFactor);
        for (Object key : iterable) {
            this.addIfFound(key, retainedCopy);
        }
        if (retainedCopy.size() < this.size()) {
            this.maxSize = retainedCopy.maxSize;
            this.occupied = retainedCopy.occupied;
            this.table = retainedCopy.table;
            return true;
        }
        return false;
    }

    private boolean retainAllFromSet(Set<?> collection) {
        boolean result = false;
        Iterator<T> e = this.iterator();
        while (e.hasNext()) {
            if (collection.contains(e.next())) continue;
            e.remove();
            result = true;
        }
        return result;
    }

    public UnifiedSet<T> clone() {
        return new UnifiedSet<T>(this);
    }

    public Object[] toArray() {
        Object[] result = new Object[this.occupied];
        this.copyToArray(result);
        return result;
    }

    private void copyToArray(Object[] result) {
        Object[] table = this.table;
        int count = 0;
        for (int i = 0; i < table.length; ++i) {
            Object cur = table[i];
            if (cur == null) continue;
            if (cur instanceof ChainedBucket) {
                ChainedBucket bucket = (ChainedBucket)cur;
                count = this.copyBucketToArray(result, bucket, count);
                continue;
            }
            result[count++] = this.nonSentinel(cur);
        }
    }

    private int copyBucketToArray(Object[] result, ChainedBucket bucket, int count) {
        block1: {
            while (true) {
                result[count++] = this.nonSentinel(bucket.zero);
                if (bucket.one == null) break block1;
                result[count++] = this.nonSentinel(bucket.one);
                if (bucket.two == null) break block1;
                result[count++] = this.nonSentinel(bucket.two);
                if (bucket.three == null) break block1;
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            result[count++] = this.nonSentinel(bucket.three);
        }
        return count;
    }

    public <T> T[] toArray(T[] array) {
        int size = this.size();
        Object[] result = array.length < size ? (Object[])Array.newInstance(array.getClass().getComponentType(), size) : array;
        this.copyToArray(result);
        if (size < result.length) {
            result[size] = null;
        }
        return result;
    }

    public Iterator<T> iterator() {
        return new PositionalIterator();
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        IterableIterate.appendString(this, appendable, start, separator, end);
    }

    public <V> UnifiedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, UnifiedSetMultimap.newMultimap());
    }

    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.forEach((Procedure<? super T>)new MultimapPutProcedure<V, T>(target, function));
        return target;
    }

    public <V> UnifiedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap());
    }

    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(new MultimapEachPutProcedure(target, function));
        return target;
    }

    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".groupByUniqueKey() not implemented yet");
    }

    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)UnifiedSet.newSet()));
    }

    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        this.forEach(ZipWithIndexProcedure.create(target));
        return target;
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        return MutableCollectionIterate.chunk(this, size);
    }

    public MutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.unionInto(this, set, this.newEmpty());
    }

    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersectInto(this, set, this.newEmpty());
    }

    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.differenceInto(this, subtrahendSet, this.newEmpty());
    }

    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifferenceInto(this, setB, this.newEmpty());
    }

    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.powerSet(this);
    }

    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    public T get(T key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return null;
        }
        if (cur instanceof ChainedBucket) {
            return this.chainedGet(key, (ChainedBucket)cur);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            return (T)cur;
        }
        return null;
    }

    private T chainedGet(T key, ChainedBucket bucket) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                return this.nonSentinel(bucket.zero);
            }
            if (bucket.one == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                return this.nonSentinel(bucket.one);
            }
            if (bucket.two == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                return this.nonSentinel(bucket.two);
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        if (bucket.three == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            return this.nonSentinel(bucket.three);
        }
        return null;
    }

    public T put(T key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            this.table[index] = UnifiedSet.toSentinelIfNull(key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return key;
        }
        if (cur instanceof ChainedBucket || !this.nonNullTableObjectEquals(cur, key)) {
            return this.chainedPut(key, index);
        }
        return this.nonSentinel(cur);
    }

    private T chainedPut(T key, int index) {
        if (this.table[index] instanceof ChainedBucket) {
            ChainedBucket bucket = (ChainedBucket)this.table[index];
            while (true) {
                if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                    return this.nonSentinel(bucket.zero);
                }
                if (bucket.one == null) {
                    bucket.one = UnifiedSet.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return key;
                }
                if (this.nonNullTableObjectEquals(bucket.one, key)) {
                    return this.nonSentinel(bucket.one);
                }
                if (bucket.two == null) {
                    bucket.two = UnifiedSet.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return key;
                }
                if (this.nonNullTableObjectEquals(bucket.two, key)) {
                    return this.nonSentinel(bucket.two);
                }
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            if (bucket.three == null) {
                bucket.three = UnifiedSet.toSentinelIfNull(key);
                if (++this.occupied > this.maxSize) {
                    this.rehash();
                }
                return key;
            }
            if (this.nonNullTableObjectEquals(bucket.three, key)) {
                return this.nonSentinel(bucket.three);
            }
            bucket.three = new ChainedBucket(bucket.three, key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return key;
        }
        ChainedBucket newBucket = new ChainedBucket(this.table[index], key);
        this.table[index] = newBucket;
        if (++this.occupied > this.maxSize) {
            this.rehash();
        }
        return key;
    }

    public T removeFromPool(T key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return null;
        }
        if (cur instanceof ChainedBucket) {
            return this.removeFromChainForPool((ChainedBucket)cur, key, index);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            this.table[index] = null;
            --this.occupied;
            return this.nonSentinel(cur);
        }
        return null;
    }

    private T removeFromChainForPool(ChainedBucket bucket, T key, int index) {
        if (this.nonNullTableObjectEquals(bucket.zero, key)) {
            Object result = bucket.zero;
            bucket.zero = bucket.removeLast(0);
            if (bucket.zero == null) {
                this.table[index] = null;
            }
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.one == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.one, key)) {
            Object result = bucket.one;
            bucket.one = bucket.removeLast(1);
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.two == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.two, key)) {
            Object result = bucket.two;
            bucket.two = bucket.removeLast(2);
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.three == null) {
            return null;
        }
        if (bucket.three instanceof ChainedBucket) {
            return this.removeDeepChainForPool(bucket, key);
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            Object result = bucket.three;
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return this.nonSentinel(result);
        }
        return null;
    }

    private T removeDeepChainForPool(ChainedBucket oldBucket, T key) {
        ChainedBucket bucket;
        while (true) {
            if (this.nonNullTableObjectEquals((bucket = (ChainedBucket)oldBucket.three).zero, key)) {
                Object result = bucket.zero;
                bucket.zero = bucket.removeLast(0);
                if (bucket.zero == null) {
                    oldBucket.three = null;
                }
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.one == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                Object result = bucket.one;
                bucket.one = bucket.removeLast(1);
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.two == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                Object result = bucket.two;
                bucket.two = bucket.removeLast(2);
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.three == null) {
                return null;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            oldBucket = bucket;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            Object result = bucket.three;
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return this.nonSentinel(result);
        }
        return null;
    }

    private T nonSentinel(Object key) {
        return (T)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        if (key == null) {
            return NULL_KEY;
        }
        return key;
    }

    private boolean nonNullTableObjectEquals(Object cur, T key) {
        return cur == key || (cur == NULL_KEY ? key == null : cur.equals(key));
    }

    public <K2, V> MutableMap<K2, V> aggregateInPlaceBy(Function<? super T, ? extends K2> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach((Procedure<? super T>)new MutatingAggregationProcedure<T, K2, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K2, V> MutableMap<K2, V> aggregateBy(Function<? super T, ? extends K2> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach((Procedure<? super T>)new NonMutatingAggregationProcedure<T, K2, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    @Beta
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        return new UnifiedSetParallelUnsortedIterable(executorService, batchSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnifiedSetParallelUnsortedIterable
    extends AbstractParallelUnsortedSetIterable<T, RootUnsortedSetBatch<T>> {
        private final ExecutorService executorService;
        private final int batchSize;

        private UnifiedSetParallelUnsortedIterable(ExecutorService executorService, int batchSize) {
            this.executorService = executorService;
            this.batchSize = batchSize;
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @Override
        public LazyIterable<RootUnsortedSetBatch<T>> split() {
            return new UnifiedSetParallelSplitLazyIterable();
        }

        public void forEach(Procedure<? super T> procedure) {
            UnifiedSetParallelUnsortedIterable.forEach(this, procedure);
        }

        public boolean anySatisfy(Predicate<? super T> predicate) {
            return UnifiedSetParallelUnsortedIterable.anySatisfy(this, predicate);
        }

        public boolean allSatisfy(Predicate<? super T> predicate) {
            return UnifiedSetParallelUnsortedIterable.allSatisfy(this, predicate);
        }

        public T detect(Predicate<? super T> predicate) {
            return UnifiedSetParallelUnsortedIterable.detect(this, predicate);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class UnifiedSetParallelSplitLazyIterable
        extends AbstractLazyIterable<RootUnsortedSetBatch<T>> {
            private UnifiedSetParallelSplitLazyIterable() {
            }

            public void forEach(Procedure<? super RootUnsortedSetBatch<T>> procedure) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    RootUnsortedSetBatch chunk = i$.next();
                    procedure.value(chunk);
                }
            }

            public <P> void forEachWith(Procedure2<? super RootUnsortedSetBatch<T>, ? super P> procedure, P parameter) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    RootUnsortedSetBatch chunk = i$.next();
                    procedure.value(chunk, parameter);
                }
            }

            public void forEachWithIndex(ObjectIntProcedure<? super RootUnsortedSetBatch<T>> objectIntProcedure) {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
            }

            public Iterator<RootUnsortedSetBatch<T>> iterator() {
                return new UnifiedSetParallelSplitIterator();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class UnifiedSetParallelSplitIterator
        implements Iterator<RootUnsortedSetBatch<T>> {
            protected int chunkIndex;

            private UnifiedSetParallelSplitIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.chunkIndex * UnifiedSetParallelUnsortedIterable.this.batchSize < UnifiedSet.this.table.length;
            }

            @Override
            public RootUnsortedSetBatch<T> next() {
                int chunkStartIndex = this.chunkIndex * UnifiedSetParallelUnsortedIterable.this.batchSize;
                int chunkEndIndex = (this.chunkIndex + 1) * UnifiedSetParallelUnsortedIterable.this.batchSize;
                int truncatedChunkEndIndex = Math.min(chunkEndIndex, UnifiedSet.this.table.length);
                ++this.chunkIndex;
                return new UnifiedUnsortedSetBatch(chunkStartIndex, truncatedChunkEndIndex);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnifiedUnsortedSetBatch
    extends AbstractBatch<T>
    implements RootUnsortedSetBatch<T> {
        private final int chunkStartIndex;
        private final int chunkEndIndex;

        private UnifiedUnsortedSetBatch(int chunkStartIndex, int chunkEndIndex) {
            this.chunkStartIndex = chunkStartIndex;
            this.chunkEndIndex = chunkEndIndex;
        }

        @Override
        public void forEach(Procedure<? super T> procedure) {
            for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
                Object cur = UnifiedSet.this.table[i];
                if (cur instanceof ChainedBucket) {
                    UnifiedSet.this.chainedForEach((ChainedBucket)cur, procedure);
                    continue;
                }
                if (cur == null) continue;
                procedure.value(UnifiedSet.this.nonSentinel(cur));
            }
        }

        @Override
        public boolean anySatisfy(Predicate<? super T> predicate) {
            for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
                Object cur = UnifiedSet.this.table[i];
                if (cur instanceof ChainedBucket) {
                    UnifiedSet.this.chainedAnySatisfy((ChainedBucket)cur, predicate);
                    continue;
                }
                if (cur == null || !predicate.accept(UnifiedSet.this.nonSentinel(cur))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(Predicate<? super T> predicate) {
            for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
                Object cur = UnifiedSet.this.table[i];
                if (cur instanceof ChainedBucket) {
                    UnifiedSet.this.chainedAllSatisfy((ChainedBucket)cur, predicate);
                    continue;
                }
                if (cur == null || predicate.accept(UnifiedSet.this.nonSentinel(cur))) continue;
                return false;
            }
            return true;
        }

        @Override
        public T detect(Predicate<? super T> predicate) {
            for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
                Object each;
                Object cur = UnifiedSet.this.table[i];
                if (cur instanceof ChainedBucket) {
                    Object chainedDetect = UnifiedSet.this.chainedDetect((ChainedBucket)cur, predicate);
                    if (chainedDetect == null) continue;
                    return UnifiedSet.this.nonSentinel(chainedDetect);
                }
                if (cur == null || !predicate.accept(each = UnifiedSet.this.nonSentinel(cur))) continue;
                return each;
            }
            return null;
        }

        @Override
        public UnsortedSetBatch<T> select(Predicate<? super T> predicate) {
            return new SelectUnsortedSetBatch(this, predicate);
        }

        @Override
        public <V> UnsortedSetBatch<V> collect(Function<? super T, ? extends V> function) {
            return new CollectUnsortedSetBatch(this, function);
        }
    }

    private static final class ChainedBucket {
        private Object zero;
        private Object one;
        private Object two;
        private Object three;

        private ChainedBucket() {
        }

        private ChainedBucket(Object first, Object second) {
            this.zero = first;
            this.one = second;
        }

        public void remove(int i) {
            if (i <= 3) {
                switch (i) {
                    case 0: {
                        this.zero = this.removeLast(0);
                        return;
                    }
                    case 1: {
                        this.one = this.removeLast(1);
                        return;
                    }
                    case 2: {
                        this.two = this.removeLast(2);
                        return;
                    }
                    case 3: {
                        if (this.three instanceof ChainedBucket) {
                            this.removeLongChain(this, i - 3);
                            return;
                        }
                        this.three = null;
                        return;
                    }
                }
                throw new AssertionError();
            }
            this.removeLongChain(this, i - 3);
        }

        private void removeLongChain(ChainedBucket oldBucket, int i) {
            block6: while (true) {
                ChainedBucket bucket = (ChainedBucket)oldBucket.three;
                switch (i) {
                    case 0: {
                        bucket.zero = bucket.removeLast(0);
                        return;
                    }
                    case 1: {
                        bucket.one = bucket.removeLast(1);
                        return;
                    }
                    case 2: {
                        bucket.two = bucket.removeLast(2);
                        return;
                    }
                    case 3: {
                        if (bucket.three instanceof ChainedBucket) {
                            i -= 3;
                            oldBucket = bucket;
                            continue block6;
                        }
                        bucket.three = null;
                        return;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        public Object get(int i) {
            ChainedBucket bucket = this;
            while (i > 3 && bucket.three instanceof ChainedBucket) {
                bucket = (ChainedBucket)bucket.three;
                i -= 3;
            }
            block8: while (true) {
                switch (i) {
                    case 0: {
                        return bucket.zero;
                    }
                    case 1: {
                        return bucket.one;
                    }
                    case 2: {
                        return bucket.two;
                    }
                    case 3: {
                        if (bucket.three instanceof ChainedBucket) {
                            i -= 3;
                            bucket = (ChainedBucket)bucket.three;
                            continue block8;
                        }
                        return bucket.three;
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        public Object removeLast(int cur) {
            if (this.three instanceof ChainedBucket) {
                return this.removeLast(this);
            }
            if (this.three != null) {
                Object result = this.three;
                this.three = null;
                return cur == 3 ? null : result;
            }
            if (this.two != null) {
                Object result = this.two;
                this.two = null;
                return cur == 2 ? null : result;
            }
            if (this.one != null) {
                Object result = this.one;
                this.one = null;
                return cur == 1 ? null : result;
            }
            this.zero = null;
            return null;
        }

        private Object removeLast(ChainedBucket oldBucket) {
            ChainedBucket bucket;
            while (true) {
                bucket = (ChainedBucket)oldBucket.three;
                if (!(bucket.three instanceof ChainedBucket)) break;
                oldBucket = bucket;
            }
            if (bucket.three != null) {
                Object result = bucket.three;
                bucket.three = null;
                return result;
            }
            if (bucket.two != null) {
                Object result = bucket.two;
                bucket.two = null;
                return result;
            }
            if (bucket.one != null) {
                Object result = bucket.one;
                bucket.one = null;
                return result;
            }
            Object result = bucket.zero;
            oldBucket.three = null;
            return result;
        }

        public ChainedBucket copy() {
            ChainedBucket result;
            ChainedBucket dest = result = new ChainedBucket();
            ChainedBucket src = this;
            while (true) {
                dest.zero = src.zero;
                dest.one = src.one;
                dest.two = src.two;
                if (!(src.three instanceof ChainedBucket)) break;
                dest.three = new ChainedBucket();
                src = (ChainedBucket)src.three;
                dest = (ChainedBucket)dest.three;
            }
            dest.three = src.three;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PositionalIterator
    implements Iterator<T> {
        protected int count;
        protected int position;
        protected int chainPosition;
        protected boolean lastReturned;

        protected PositionalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < UnifiedSet.this.size();
        }

        @Override
        public void remove() {
            if (!this.lastReturned) {
                throw new IllegalStateException("next() must be called as many times as remove()");
            }
            --this.count;
            --UnifiedSet.this.occupied;
            if (this.chainPosition != 0) {
                this.removeFromChain();
                return;
            }
            int pos = this.position - 1;
            Object key = UnifiedSet.this.table[pos];
            if (key instanceof ChainedBucket) {
                this.removeLastFromChain((ChainedBucket)key, pos);
                return;
            }
            UnifiedSet.this.table[pos] = null;
            this.position = pos;
            this.lastReturned = false;
        }

        protected void removeFromChain() {
            ChainedBucket chain = (ChainedBucket)UnifiedSet.this.table[this.position];
            chain.remove(--this.chainPosition);
            this.lastReturned = false;
        }

        protected void removeLastFromChain(ChainedBucket bucket, int tableIndex) {
            bucket.removeLast(0);
            if (bucket.zero == null) {
                UnifiedSet.this.table[tableIndex] = null;
            }
            this.lastReturned = false;
        }

        protected T nextFromChain() {
            ChainedBucket bucket = (ChainedBucket)UnifiedSet.this.table[this.position];
            Object cur = bucket.get(this.chainPosition);
            ++this.chainPosition;
            if (bucket.get(this.chainPosition) == null) {
                this.chainPosition = 0;
                ++this.position;
            }
            this.lastReturned = true;
            return UnifiedSet.this.nonSentinel(cur);
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            Object[] table = UnifiedSet.this.table;
            if (this.chainPosition != 0) {
                return this.nextFromChain();
            }
            while (table[this.position] == null) {
                ++this.position;
            }
            Object cur = table[this.position];
            if (cur instanceof ChainedBucket) {
                return this.nextFromChain();
            }
            ++this.position;
            this.lastReturned = true;
            return UnifiedSet.this.nonSentinel(cur);
        }
    }
}

