/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CompositeInterceptor
implements HandlerInterceptor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected List<HandlerInterceptor> handlers = new ArrayList<HandlerInterceptor>();
    protected List<HandlerInterceptor> handlersReversed = new ArrayList<HandlerInterceptor>();

    public List<HandlerInterceptor> getHandlers() {
        return this.handlers;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("preHandle " + request + ", " + response + ", " + o);
        }
        for (HandlerInterceptor handler : this.handlers) {
            if (!handler.preHandle(request, response, o)) {
                return false;
            }
            if (request.getAttribute("org.grails.FORWARD_CALLED") == null) continue;
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("postHandle " + request + ", " + response + ", " + o + ", " + modelAndView);
        }
        for (HandlerInterceptor handler : this.handlersReversed) {
            handler.postHandle(request, response, o, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("afterCompletion " + request + ", " + response + ", " + o + ", " + e);
        }
        for (HandlerInterceptor handler : this.handlersReversed) {
            handler.afterCompletion(request, response, o, e);
        }
    }

    public void setHandlers(List<HandlerInterceptor> handlers) {
        this.handlers = handlers;
        this.initReversed();
    }

    public void addHandler(HandlerInterceptor handler) {
        this.handlers.add(handler);
        this.initReversed();
    }

    protected void initReversed() {
        this.handlersReversed = new ArrayList<HandlerInterceptor>(this.handlers);
        Collections.reverse(this.handlersReversed);
    }
}

