/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Incubating;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.CompositeInitScriptFinder;
import org.gradle.initialization.DistributionInitScriptFinder;
import org.gradle.initialization.UserHomeInitScriptFinder;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.gradle.jarjar.com.google.common.collect.Sets;
import org.gradle.jarjar.org.apache.commons.lang.builder.EqualsBuilder;
import org.gradle.jarjar.org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartParameter
extends LoggingConfiguration
implements Serializable {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final File DEFAULT_GRADLE_USER_HOME = new BuildLayoutParameters().getGradleUserHomeDir();
    private List<TaskExecutionRequest> taskRequests = new ArrayList<TaskExecutionRequest>();
    private Set<String> excludedTaskNames = new LinkedHashSet<String>();
    private boolean buildProjectDependencies = true;
    private File currentDir;
    private File projectDir;
    private boolean searchUpwards;
    private Map<String, String> projectProperties = new HashMap<String, String>();
    private Map<String, String> systemPropertiesArgs = new HashMap<String, String>();
    private File gradleUserHomeDir;
    private File gradleHomeDir;
    private File settingsFile;
    private boolean useEmptySettings;
    private File buildFile;
    private List<File> initScripts = new ArrayList<File>();
    private boolean dryRun;
    private boolean rerunTasks;
    private boolean profile;
    private boolean continueOnFailure;
    private boolean offline;
    private File projectCacheDir;
    private boolean refreshDependencies;
    private boolean recompileScripts;
    private int parallelThreadCount;
    private boolean configureOnDemand;

    public void setProjectCacheDir(File projectCacheDir) {
        this.projectCacheDir = projectCacheDir;
    }

    public File getProjectCacheDir() {
        return this.projectCacheDir;
    }

    public StartParameter() {
        this.gradleHomeDir = new DefaultModuleRegistry().getGradleHome();
        BuildLayoutParameters layoutParameters = new BuildLayoutParameters();
        this.searchUpwards = layoutParameters.getSearchUpwards();
        this.currentDir = layoutParameters.getCurrentDir();
        this.projectDir = layoutParameters.getProjectDir();
        this.gradleUserHomeDir = layoutParameters.getGradleUserHomeDir();
    }

    public StartParameter newInstance() {
        return this.prepareNewInstance(new StartParameter());
    }

    protected StartParameter prepareNewInstance(StartParameter p) {
        this.prepareNewBuild(p);
        p.buildFile = this.buildFile;
        p.projectDir = this.projectDir;
        p.settingsFile = this.settingsFile;
        p.useEmptySettings = this.useEmptySettings;
        p.taskRequests = new ArrayList<TaskExecutionRequest>(this.taskRequests);
        p.excludedTaskNames = new LinkedHashSet<String>(this.excludedTaskNames);
        p.buildProjectDependencies = this.buildProjectDependencies;
        p.currentDir = this.currentDir;
        p.searchUpwards = this.searchUpwards;
        p.projectProperties = new HashMap<String, String>(this.projectProperties);
        p.systemPropertiesArgs = new HashMap<String, String>(this.systemPropertiesArgs);
        p.gradleHomeDir = this.gradleHomeDir;
        p.initScripts = new ArrayList<File>(this.initScripts);
        p.dryRun = this.dryRun;
        p.projectCacheDir = this.projectCacheDir;
        return p;
    }

    public StartParameter newBuild() {
        return this.prepareNewBuild(new StartParameter());
    }

    protected StartParameter prepareNewBuild(StartParameter p) {
        p.gradleUserHomeDir = this.gradleUserHomeDir;
        p.setLogLevel(this.getLogLevel());
        p.setConsoleOutput(this.getConsoleOutput());
        p.setShowStacktrace(this.getShowStacktrace());
        p.profile = this.profile;
        p.continueOnFailure = this.continueOnFailure;
        p.offline = this.offline;
        p.rerunTasks = this.rerunTasks;
        p.recompileScripts = this.recompileScripts;
        p.refreshDependencies = this.refreshDependencies;
        p.parallelThreadCount = this.parallelThreadCount;
        p.configureOnDemand = this.configureOnDemand;
        return p;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File buildFile) {
        if (buildFile == null) {
            this.buildFile = null;
            this.setCurrentDir(null);
        } else {
            this.buildFile = GFileUtils.canonicalise(buildFile);
            this.setProjectDir(this.buildFile.getParentFile());
        }
    }

    public StartParameter useEmptySettings() {
        this.searchUpwards = false;
        this.useEmptySettings = true;
        this.settingsFile = null;
        return this;
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }

    public List<String> getTaskNames() {
        ArrayList<String> taskNames = Lists.newArrayList();
        for (TaskExecutionRequest taskRequest : this.taskRequests) {
            taskNames.addAll(taskRequest.getArgs());
        }
        return taskNames;
    }

    public void setTaskNames(Iterable<String> taskNames) {
        this.taskRequests = taskNames == null ? Collections.emptyList() : Arrays.asList(new DefaultTaskExecutionRequest(taskNames));
    }

    @Incubating
    public List<TaskExecutionRequest> getTaskRequests() {
        return this.taskRequests;
    }

    @Incubating
    public void setTaskRequests(Iterable<? extends TaskExecutionRequest> taskParameters) {
        this.taskRequests = Lists.newArrayList(taskParameters);
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public void setExcludedTaskNames(Iterable<String> excludedTaskNames) {
        this.excludedTaskNames = Sets.newLinkedHashSet(excludedTaskNames);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File currentDir) {
        this.currentDir = currentDir != null ? GFileUtils.canonicalise(currentDir) : new BuildLayoutParameters().getCurrentDir();
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public void setSearchUpwards(boolean searchUpwards) {
        this.searchUpwards = searchUpwards;
    }

    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = projectProperties;
    }

    public Map<String, String> getSystemPropertiesArgs() {
        return this.systemPropertiesArgs;
    }

    public void setSystemPropertiesArgs(Map<String, String> systemPropertiesArgs) {
        this.systemPropertiesArgs = systemPropertiesArgs;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir == null ? new BuildLayoutParameters().getGradleUserHomeDir() : GFileUtils.canonicalise(gradleUserHomeDir);
    }

    public boolean isBuildProjectDependencies() {
        return this.buildProjectDependencies;
    }

    public StartParameter setBuildProjectDependencies(boolean build) {
        this.buildProjectDependencies = build;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setSettingsFile(File settingsFile) {
        if (settingsFile == null) {
            this.settingsFile = null;
        } else {
            this.useEmptySettings = false;
            this.settingsFile = GFileUtils.canonicalise(settingsFile);
            this.currentDir = this.settingsFile.getParentFile();
        }
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void addInitScript(File initScriptFile) {
        this.initScripts.add(initScriptFile);
    }

    public void setInitScripts(List<File> initScripts) {
        this.initScripts = initScripts;
    }

    public List<File> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    @Incubating
    public List<File> getAllInitScripts() {
        CompositeInitScriptFinder initScriptFinder = new CompositeInitScriptFinder(new UserHomeInitScriptFinder(this.getGradleUserHomeDir()), new DistributionInitScriptFinder(this.gradleHomeDir));
        ArrayList<File> scripts = new ArrayList<File>(this.getInitScripts());
        initScriptFinder.findScripts(scripts);
        return Collections.unmodifiableList(scripts);
    }

    public void setProjectDir(File projectDir) {
        if (projectDir == null) {
            this.setCurrentDir(null);
            this.projectDir = null;
        } else {
            File canonicalFile;
            this.currentDir = canonicalFile = GFileUtils.canonicalise(projectDir);
            this.projectDir = canonicalFile;
        }
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isRefreshDependencies() {
        return this.refreshDependencies;
    }

    public void setRefreshDependencies(boolean refreshDependencies) {
        this.refreshDependencies = refreshDependencies;
    }

    public boolean isRerunTasks() {
        return this.rerunTasks;
    }

    public void setRerunTasks(boolean rerunTasks) {
        this.rerunTasks = rerunTasks;
    }

    public boolean isRecompileScripts() {
        return this.recompileScripts;
    }

    public void setRecompileScripts(boolean recompileScripts) {
        this.recompileScripts = recompileScripts;
    }

    public int getParallelThreadCount() {
        return this.parallelThreadCount;
    }

    public void setParallelThreadCount(int parallelThreadCount) {
        this.parallelThreadCount = parallelThreadCount;
    }

    @Incubating
    public boolean isConfigureOnDemand() {
        return this.configureOnDemand;
    }

    public String toString() {
        return "StartParameter{taskRequests=" + this.taskRequests + ", excludedTaskNames=" + this.excludedTaskNames + ", currentDir=" + this.currentDir + ", searchUpwards=" + this.searchUpwards + ", projectProperties=" + this.projectProperties + ", systemPropertiesArgs=" + this.systemPropertiesArgs + ", gradleUserHomeDir=" + this.gradleUserHomeDir + ", gradleHome=" + this.gradleHomeDir + ", logLevel=" + (Object)((Object)this.getLogLevel()) + ", showStacktrace=" + (Object)((Object)this.getShowStacktrace()) + ", buildFile=" + this.buildFile + ", initScripts=" + this.initScripts + ", dryRun=" + this.dryRun + ", rerunTasks=" + this.rerunTasks + ", recompileScripts=" + this.recompileScripts + ", offline=" + this.offline + ", refreshDependencies=" + this.refreshDependencies + ", parallelThreadCount=" + this.parallelThreadCount + ", configureOnDemand=" + this.configureOnDemand + '}';
    }

    void setGradleHomeDir(File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    @Incubating
    public void setConfigureOnDemand(boolean configureOnDemand) {
        this.configureOnDemand = configureOnDemand;
    }
}

