/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui;

import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;

public class DynamicMethodDialog
extends DynamicDialog {
    public DynamicMethodDialog(GrReferenceExpression referenceExpression) {
        super(referenceExpression, QuickfixUtil.createSettings(referenceExpression), GroovyExpectedTypesProvider.calculateTypeConstraints((GrExpression)referenceExpression.getParent()), true);
        assert (this.getSettings().isMethod());
        List<ParamInfo> pairs = this.getSettings().getParams();
        this.setupParameterTable(pairs);
        this.setupParameterList(pairs);
        this.setTitle(GroovyBundle.message("add.dynamic.method", new Object[0]));
        this.setUpTypeLabel(GroovyBundle.message("dynamic.method.return.type", new Object[0]));
    }

    private void setupParameterTable(final List<ParamInfo> pairs) {
        MySuggestedNameCellEditor suggestedNameCellEditor = new MySuggestedNameCellEditor(QuickfixUtil.getArgumentsNames(pairs));
        this.myParametersTable.setDefaultEditor(String.class, (TableCellEditor)((Object)suggestedNameCellEditor));
        suggestedNameCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int editingColumn = DynamicMethodDialog.this.myParametersTable.getSelectedColumn();
                if (editingColumn != 0) {
                    return;
                }
                int editingRow = DynamicMethodDialog.this.myParametersTable.getSelectedRow();
                if (editingRow < 0 || editingRow >= pairs.size()) {
                    return;
                }
                String newNameValue = ((MySuggestedNameCellEditor)((Object)e.getSource())).getCellEditorValue();
                ParamInfo editingPair = (ParamInfo)pairs.get(editingRow);
                editingPair.name = newNameValue;
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
    }

    private void setupParameterList(List<ParamInfo> arguments) {
        ListTableModel dataModel = new ListTableModel(new ColumnInfo[]{new NameColumnInfo(), new TypeColumnInfo()});
        dataModel.setItems(arguments);
        this.myParametersTable.setModel((TableModel)dataModel);
        if (arguments.isEmpty()) {
            return;
        }
        String max0 = arguments.get((int)0).name;
        String max1 = arguments.get((int)0).type;
        for (ParamInfo argument : arguments) {
            if (argument.name.length() > max0.length()) {
                max0 = argument.name;
            }
            if (argument.type.length() <= max1.length()) continue;
            max1 = argument.type;
        }
        FontMetrics metrics = this.myParametersTable.getFontMetrics(this.myParametersTable.getFont());
        TableColumn column0 = this.myParametersTable.getColumnModel().getColumn(0);
        column0.setPreferredWidth(metrics.stringWidth(max0 + "  "));
        TableColumn column1 = this.myParametersTable.getColumnModel().getColumn(1);
        column1.setPreferredWidth(metrics.stringWidth(max1 + "  "));
    }

    private static class MySuggestedNameCellEditor
    extends AbstractTableCellEditor {
        JTextField myNameField;

        public MySuggestedNameCellEditor(String[] names) {
            this.myNameField = names.length == 0 ? new JTextField() : new JTextField(names[0]);
        }

        public String getCellEditorValue() {
            return this.myNameField.getText();
        }

        public boolean isCellEditable(EventObject e) {
            return true;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof String) {
                this.myNameField.setText((String)value);
            }
            return this.myNameField;
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<ParamInfo, String> {
        public NameColumnInfo() {
            super(GroovyBundle.message("dynamic.name", new Object[0]));
        }

        public boolean isCellEditable(ParamInfo myPair) {
            return true;
        }

        public String valueOf(ParamInfo pair) {
            return pair.name;
        }
    }

    private class TypeColumnInfo
    extends ColumnInfo<ParamInfo, String> {
        public TypeColumnInfo() {
            super(GroovyBundle.message("dynamic.type", new Object[0]));
        }

        public String valueOf(ParamInfo pair) {
            return pair.type;
        }

        public boolean isCellEditable(ParamInfo stringPsiTypeMyPair) {
            return false;
        }

        public void setValue(ParamInfo pair, String value) {
            PsiType type;
            try {
                type = GroovyPsiElementFactory.getInstance(DynamicMethodDialog.this.myProject).createTypeElement(value).getType();
            }
            catch (IncorrectOperationException e) {
                return;
            }
            pair.type = type.getCanonicalText();
        }
    }
}

