/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Parser;

public class VaspPoscarReader
extends AtomSetCollectionReader {
    protected Lst<String> atomLabels;
    private boolean haveAtomLabels = true;
    private boolean atomsLabeledInline;
    private float scaleFac;
    protected int ac;
    protected String title;
    protected boolean quiet;
    protected String[] defaultLabels;
    protected String[] elementLabel;
    int radiusPt = Integer.MIN_VALUE;
    int elementPt = Integer.MIN_VALUE;

    @Override
    protected void initializeReader() throws Exception {
        this.readStructure(null);
        this.continuing = false;
    }

    protected void readStructure(String string) throws Exception {
        this.title = this.rd().trim();
        this.readUnitCellVectors();
        this.readMolecularFormula();
        this.readCoordinates();
        this.asc.setAtomSetName(this.title + (string == null ? "" : "[" + string + "]"));
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (!this.haveAtomLabels && !this.atomsLabeledInline) {
            this.appendLoadNote("VASP POSCAR reader using pseudo atoms Al B C Db...");
        }
        this.finalizeReaderASCR();
    }

    protected void readUnitCellVectors() throws Exception {
        boolean bl;
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        this.scaleFac = this.parseFloatStr(this.rdline().trim());
        boolean bl2 = bl = this.scaleFac < 0.0f;
        if (bl) {
            this.scaleFac = (float)Math.pow(-this.scaleFac, 0.3333333333333333);
        }
        float[] fArray = new float[9];
        String string = this.rdline() + " " + this.rdline() + " " + this.rdline();
        Parser.parseStringInfestedFloatArray(string, null, fArray);
        if (bl) {
            M3 m3 = M3.newA9(fArray);
            this.scaleFac /= m3.determinant3();
        }
        if (this.scaleFac != 1.0f) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * this.scaleFac;
            }
        }
        this.addPrimitiveLatticeVector(0, fArray, 0);
        this.addPrimitiveLatticeVector(1, fArray, 3);
        this.addPrimitiveLatticeVector(2, fArray, 6);
    }

    protected void readMolecularFormula() throws Exception {
        String[] stringArray;
        if (this.elementLabel == null) {
            this.elementLabel = PT.getTokens(this.discardLinesUntilNonBlank());
        }
        if (PT.parseInt(this.elementLabel[0]) == Integer.MIN_VALUE) {
            this.atomsLabeledInline = false;
            stringArray = PT.getTokens(this.rdline());
            while (this.line != null && (stringArray.length == 0 || this.parseIntStr(stringArray[0]) == Integer.MIN_VALUE)) {
                stringArray = PT.getTokens(this.rdline());
            }
        } else {
            stringArray = this.elementLabel;
            this.elementLabel = PT.split(this.title, " ");
            if (this.elementLabel.length != stringArray.length || this.elementLabel[0].length() > 2) {
                this.elementLabel = PT.split("Al B C Db Eu F Ga Hf I K Li Mn N O P Ru S Te U V W Xe Yb Zn", " ");
                this.haveAtomLabels = false;
            }
        }
        String[] stringArray2 = this.elementLabel;
        SB sB = new SB();
        this.atomLabels = new Lst();
        this.ac = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            this.ac += n;
            String string = stringArray2[i];
            sB.append(" ").append(string).appendI(n);
            int n2 = n;
            while (--n2 >= 0) {
                this.atomLabels.addLast(string);
            }
        }
        String string = sB.toString();
        if (!this.quiet) {
            this.appendLoadNote(this.ac + " atoms identified for" + string);
        }
        this.asc.newAtomSet();
        this.asc.setAtomSetName(string);
    }

    protected void readCoordinates() throws Exception {
        boolean bl;
        boolean bl2 = this.discardLinesUntilNonBlank().toLowerCase().contains("selective");
        if (bl2) {
            this.rd();
        }
        if (bl = this.line.toLowerCase().contains("cartesian")) {
            this.setFractionalCoordinates(false);
        }
        for (int i = 0; i < this.ac; ++i) {
            String string;
            float f = Float.NaN;
            String[] stringArray = PT.getTokens(this.rdline());
            if (this.radiusPt == Integer.MIN_VALUE) {
                int n = stringArray.length;
                while (--n > 2) {
                    if (stringArray[n].equals("radius")) {
                        this.radiusPt = n + 1;
                        continue;
                    }
                    if (this.getElement(stringArray[n]) == null) continue;
                    this.elementPt = n;
                    this.atomsLabeledInline = true;
                }
            }
            if (this.radiusPt >= 0) {
                f = this.parseFloatStr(stringArray[this.radiusPt]);
            }
            String string2 = string = this.atomsLabeledInline ? stringArray[this.elementPt] : (String)this.atomLabels.get(i);
            if (bl) {
                for (int j = 0; j < 3; ++j) {
                    stringArray[j] = "" + this.parseFloatStr(stringArray[j]) * this.scaleFac;
                }
            }
            Atom atom = this.addAtomXYZSymName(stringArray, 0, null, string);
            if (!Float.isNaN(f)) {
                atom.radius = f * this.scaleFac;
            }
            if (this.asc.bsAtoms == null) continue;
            this.asc.bsAtoms.set(atom.index);
        }
    }

    protected String getElement(String string) {
        String string2 = null;
        switch (string.length()) {
            default: {
                String string3 = string2 = string.length() > 2 ? string.substring(0, 2) : null;
                if (string2 != null && JmolAdapter.getElementNumber(string2) >= 0) {
                    return string2;
                }
            }
            case 1: {
                string2 = string.substring(0);
                if (JmolAdapter.getElementNumber(string2) < 0) break;
                return string2;
            }
            case 0: 
        }
        return null;
    }

    protected String rdline() throws Exception {
        this.rd();
        if (this.line != null && this.line.startsWith("[")) {
            this.line = this.line.substring(this.line.indexOf("]") + 1).trim();
        }
        return this.line;
    }
}

