/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MMCifValidationParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Structure;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;

public class MMCifReader
extends CifReader {
    private boolean isBiomolecule;
    private boolean byChain;
    private boolean bySymop;
    private Map<String, P3> chainAtomMap;
    private Map<String, int[]> chainAtomCounts;
    private Lst<Map<String, Object>> vBiomolecules;
    private Map<String, Object> thisBiomolecule;
    private Map<String, M4> htBiomts;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, String> htHetero;
    private Map<String, Lst<Object[]>> htBondMap;
    private Map<String, BS> assemblyIdAtoms;
    private int thisChain = -1;
    private int modelIndex = 0;
    private P3 chainSum;
    private int[] chainAtomCount;
    private boolean isLigandBondBug;
    private static final byte OPER_ID = 12;
    private static final byte OPER_XYZ = 13;
    private static final String FAMILY_OPER_CAT = "_pdbx_struct_oper_list.";
    private static final String FAMILY_OPER = "_pdbx_struct_oper_list";
    private static final String[] operFields = new String[]{"*_matrix[1][1]", "*_matrix[1][2]", "*_matrix[1][3]", "*_vector[1]", "*_matrix[2][1]", "*_matrix[2][2]", "*_matrix[2][3]", "*_vector[2]", "*_matrix[3][1]", "*_matrix[3][2]", "*_matrix[3][3]", "*_vector[3]", "*_id", "*_symmetry_operation"};
    private static final byte ASSEM_ID = 0;
    private static final byte ASSEM_OPERS = 1;
    private static final byte ASSEM_LIST = 2;
    private static final String FAMILY_ASSEM_CAT = "_pdbx_struct_assembly_gen.";
    private static final String[] assemblyFields = new String[]{"_pdbx_struct_assembly_gen_assembly_id", "_pdbx_struct_assembly_gen_oper_expression", "_pdbx_struct_assembly_gen_asym_id_list"};
    private static final String FAMILY_SEQUENCEDIF_CAT = "_struct_ref_seq_dif.";
    private static final byte STRUCT_REF_G3 = 0;
    private static final byte STRUCT_REF_G1 = 1;
    private static final String[] structRefFields = new String[]{"_struct_ref_seq_dif_mon_id", "_struct_ref_seq_dif_db_mon_id"};
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String FAMILY_CHEMCOMP_CAT = "_chem_comp.";
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String FAMILY_STRUCTCONF_CAT = "_struct_conf.";
    private static final String FAMILY_STRUCTCONF = "_struct_conf";
    private static final String[] structConfFields = new String[]{"*_conf_type_id", "*_beg_auth_asym_id", "*_beg_auth_seq_id", "*_pdbx_beg_pdb_ins_code", "*_end_auth_asym_id", "*_end_auth_seq_id", "*_pdbx_end_pdb_ins_code", "*_id", "*_pdbx_pdb_helix_id", "*_pdbx_pdb_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String FAMILY_SHEET_CAT = "_struct_sheet_range.";
    private static final String FAMILY_SHEET = "_struct_sheet_range";
    private static final String[] structSheetRangeFields = new String[]{"*_sheet_id", "*_beg_auth_asym_id", "*_beg_auth_seq_id", "*_pdbx_beg_pdb_ins_code", "*_end_auth_asym_id", "*_end_auth_seq_id", "*_pdbx_end_pdb_ins_code", "*_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String FAMILY_STRUCSITE_CAT = "_struct_site_gen.";
    private static final String FAMILY_STRUCSITE = "_struct_site_gen";
    private static final String[] structSiteFields = new String[]{"*_site_id", "*_auth_comp_id", "*_auth_asym_id", "*_auth_seq_id", "*_label_alt_id"};
    private static final byte STRUCT_CONN_ASYM1 = 0;
    private static final byte STRUCT_CONN_SEQ1 = 1;
    private static final byte STRUCT_CONN_COMP1 = 2;
    private static final byte STRUCT_CONN_ATOM1 = 3;
    private static final byte STRUCT_CONN_ALT1 = 4;
    private static final byte STRUCT_CONN_SYMM1 = 5;
    private static final byte STRUCT_CONN_ASYM2 = 6;
    private static final byte STRUCT_CONN_SEQ2 = 7;
    private static final byte STRUCT_CONN_COMP2 = 8;
    private static final byte STRUCT_CONN_ATOM2 = 9;
    private static final byte STRUCT_CONN_ALT2 = 10;
    private static final byte STRUCT_CONN_SYMM2 = 11;
    private static final byte STRUCT_CONN_TYPE = 12;
    private static final byte STRUCT_CONN_ORDER = 13;
    private static final String FAMILY_STRUCTCONN_CAT = "_struct_conn.";
    private static final String FAMILY_STRUCTCONN = "_struct_conn";
    private static final String[] structConnFields = new String[]{"*_ptnr1_auth_asym_id", "*_ptnr1_auth_seq_id", "*_ptnr1_auth_comp_id", "*_ptnr1_label_atom_id", "*_pdbx_ptnr1_label_alt_id", "*_ptnr1_symmetry", "*_ptnr2_auth_asym_id", "*_ptnr2_auth_seq_id", "*_ptnr2_auth_comp_id", "*_ptnr2_label_atom_id", "*_pdbx_ptnr2_label_alt_id", "*_ptnr2_symmetry", "*_conn_type_id", "*_pdbx_value_order"};
    private Lst<Object[]> structConnMap;
    private String structConnList = "";
    private boolean doSetBonds;
    private static final byte CHEM_COMP_BOND_ID = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 1;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 2;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 3;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 4;
    private static final String FAMILY_COMPBOND_CAT = "_chem_comp_bond.";
    private static final String FAMILY_COMPBOND = "_chem_comp_bond";
    private static final String[] chemCompBondFields = new String[]{"*_comp_id", "*_atom_id_1", "*_atom_id_2", "*_value_order", "*_pdbx_aromatic_flag"};

    @Override
    protected void initSubclass() {
        this.setIsPDB();
        this.isMMCIF = true;
        if (this.htParams.containsKey("isMutate")) {
            this.asc.setInfo("isMutate", Boolean.TRUE);
        }
        this.doSetBonds = this.checkFilterKey("ADDBONDS");
        this.byChain = this.checkFilterKey("BYCHAIN");
        if (this.checkFilterKey("BIOMOLECULE")) {
            this.filter = PT.rep(this.filter, "BIOMOLECULE", "ASSEMBLY");
        }
        this.isBiomolecule = this.checkFilterKey("ASSEMBLY");
        if (this.isBiomolecule) {
            this.filter = this.filter.replace(':', ' ');
            this.bySymop = this.checkFilterKey("BYSYMOP");
        }
        boolean bl = this.isCourseGrained = this.byChain || this.bySymop;
        if (this.isCourseGrained) {
            this.chainAtomMap = new Hashtable<String, P3>();
            this.chainAtomCounts = new Hashtable<String, int[]>();
        }
        this.isLigandBondBug = this.stateScriptVersionInt >= 140204 && this.stateScriptVersionInt <= 140208 || this.stateScriptVersionInt >= 140304 && this.stateScriptVersionInt <= 140308;
    }

    @Override
    protected void processSubclassEntry() throws Exception {
        if (this.key0.startsWith(FAMILY_ASSEM_CAT) || this.key0.startsWith(FAMILY_STRUCTCONN_CAT) || this.key0.startsWith(FAMILY_SEQUENCEDIF_CAT)) {
            this.processSubclassLoopBlock();
        } else if (this.key.equals("_rna3d") || this.key.equals("_dssr")) {
            this.addedData = this.data;
            this.addedDataKey = this.key;
        }
    }

    @Override
    protected boolean processSubclassLoopBlock() throws Exception {
        if (this.key0.startsWith(FAMILY_OPER_CAT)) {
            return this.processStructOperListBlock();
        }
        if (this.key0.startsWith(FAMILY_ASSEM_CAT)) {
            return this.processAssemblyGenBlock();
        }
        if (this.key0.startsWith(FAMILY_SEQUENCEDIF_CAT)) {
            return this.processSequence();
        }
        if (this.isCourseGrained) {
            return false;
        }
        if (this.key0.startsWith(FAMILY_STRUCSITE_CAT)) {
            return this.processStructSiteBlock();
        }
        if (this.key0.startsWith(FAMILY_CHEMCOMP_CAT)) {
            return this.processChemCompLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_STRUCTCONF_CAT)) {
            return this.processStructConfLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_SHEET_CAT)) {
            return this.processStructSheetRangeLoopBlock();
        }
        if (this.isLigandBondBug) {
            return false;
        }
        if (this.key0.startsWith(FAMILY_COMPBOND_CAT)) {
            return this.processCompBondLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_STRUCTCONN_CAT)) {
            return this.processStructConnLoopBlock();
        }
        return false;
    }

    @Override
    protected boolean finalizeSubclass() throws Exception {
        if (this.byChain && !this.isBiomolecule) {
            for (String string : this.chainAtomMap.keySet()) {
                this.createParticle(string);
            }
        }
        if (!this.isCourseGrained && this.asc.ac == this.nAtoms) {
            this.asc.removeCurrentAtomSet();
        } else {
            if (!(this.dssr == null && this.validation == null && this.addedData == null || this.isCourseGrained)) {
                String string;
                MMCifValidationParser mMCifValidationParser = ((MMCifValidationParser)this.getInterface("org.jmol.adapter.readers.cif.MMCifValidationParser")).set(this);
                string = null;
                if (this.addedData == null) {
                    if (this.validation != null || this.dssr != null) {
                        string = mMCifValidationParser.finalizeValidations(this.vwr, this.modelMap);
                    }
                } else if (this.addedDataKey.equals("_rna3d")) {
                    string = mMCifValidationParser.finalizeRna3d(this.modelMap);
                }
                if (string != null) {
                    this.appendLoadNote(string);
                }
            }
            this.setHetero();
            if (this.doSetBonds) {
                this.setBonds();
            }
            if (!this.isCourseGrained) {
                this.applySymmetryAndSetTrajectory();
            }
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.vBiomolecules != null && this.vBiomolecules.size() > 0 && (this.isCourseGrained || this.asc.ac > 0)) {
            this.asc.setCurrentModelInfo("biomolecules", this.vBiomolecules);
            this.setBiomolecules();
            if (this.thisBiomolecule != null) {
                this.asc.getXSymmetry().applySymmetryBio(this.thisBiomolecule, this.unitCellParams, this.applySymmetryToBonds, this.filter);
                this.asc.xtalSymmetry = null;
            }
        }
        return true;
    }

    @Override
    protected boolean checkSubclassSymmetry() {
        this.asc.checkSpecial = false;
        int n = this.asc.iSet;
        this.asc.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.asc.getAtomSetAtomIndex(n), this.asc.getAtomSetAtomCount(n), this.maxSerial});
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void setBonds() {
        block12: {
            if (this.htBondMap == null) {
                return;
            }
            var1_1 = this.asc.bsAtoms;
            if (var1_1 == null) {
                var1_1 = BSUtil.newBitSet2(0, this.asc.ac);
            }
            var2_2 = this.asc.atoms;
            var3_3 = -1.0f;
            var4_4 = null;
            var5_5 = null;
            var6_6 = var1_1.nextSetBit(0);
            while (var6_6 >= 0) {
                var7_7 = var2_2[var6_6];
                v0 = var8_8 = var7_7.vib == null ? (float)var7_7.sequenceNumber : var7_7.vib.x;
                if (var8_8 == var3_3) ** GOTO lbl-1000
                var3_3 = var8_8;
                if (var4_4 != null) {
                    this.processBonds(this.htBondMap.get(var4_4), var5_5, false);
                }
                var5_5 = new Hashtable<K, V>();
                var4_4 = var2_2[var6_6].group3;
                if (!this.htBondMap.containsKey(var4_4)) {
                    var4_4 = null;
                } else if (var4_4 != null) {
                    var5_5.put(var7_7.atomName, var7_7.index);
                }
                var6_6 = var1_1.nextSetBit(var6_6 + 1);
            }
            if (var4_4 != null) {
                this.processBonds(this.htBondMap.get(var4_4), var5_5, false);
            }
            if (this.structConnMap == null) break block12;
            var5_5 = new Hashtable<Object, Integer>();
            var3_3 = -1.0f;
            var4_4 = null;
            var6_6 = var1_1.nextSetBit(0);
            while (var6_6 >= 0) {
                var7_7 = var2_2[var6_6];
                v1 = var8_8 = var7_7.vib == null ? (float)var7_7.sequenceNumber : var7_7.vib.x;
                if (var8_8 == var3_3) ** GOTO lbl45
                var3_3 = var8_8;
                var9_9 = var7_7.chainID + var7_7.group3 + var3_3;
                if (this.structConnList.indexOf(var9_9) < 0) {
                    var4_4 = null;
                } else {
                    var4_4 = var9_9;
lbl45:
                    // 2 sources

                    if (var4_4 != null) {
                        var5_5.put(var4_4 + var7_7.atomName + var7_7.altLoc, var7_7.index);
                    }
                }
                var6_6 = var1_1.nextSetBit(var6_6 + 1);
            }
            this.processBonds(this.structConnMap, var5_5, true);
        }
        this.appendLoadNote(this.asc.bondCount + " bonds added");
    }

    private void processBonds(Lst<Object[]> lst, Map<Object, Integer> map, boolean bl) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            Integer n2;
            Object[] objectArray = (Object[])lst.get(i);
            Integer n3 = map.get(objectArray[0]);
            if (n3 == null || (n2 = map.get(objectArray[1])) == null) continue;
            if (this.debugging) {
                Logger.debug((bl ? FAMILY_STRUCTCONN : "_comp_bond") + " adding bond " + n3 + " " + n2 + " order=" + objectArray[2]);
            }
            this.asc.addNewBondWithOrder(n3, n2, (Integer)objectArray[2]);
        }
    }

    private boolean processSequence() throws Exception {
        this.parseLoopParameters(structRefFields);
        while (this.parser.getData()) {
            String string;
            String string2 = this.getField((byte)1).toLowerCase();
            if (this.isNull(string2) || string2.length() != 1 || this.isNull(string = this.getField((byte)0))) continue;
            if (this.htGroup1 == null) {
                this.htGroup1 = new Hashtable();
                this.asc.setInfo("htGroup1", this.htGroup1);
            }
            this.htGroup1.put(string, string2);
        }
        return true;
    }

    private boolean processAssemblyGenBlock() throws Exception {
        this.parseLoopParameters(assemblyFields);
        while (this.parser.getData()) {
            String[] stringArray = new String[3];
            int n = 0;
            int n2 = this.parser.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.fieldProperty(i);
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++n;
                        stringArray[n3] = this.field;
                    }
                }
            }
            if (n != 3) continue;
            this.addAssembly(stringArray);
        }
        return true;
    }

    private void addAssembly(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[2];
        String string3 = stringArray[1];
        String string4 = "biomolecule " + string;
        Logger.info(string4 + " operators " + string3 + " ASYM_IDs " + string2);
        this.appendLoadNote("found " + string4 + ": " + string2);
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        Map<String, Lst<Lst<Lst<Lst<Object>>>>> map = null;
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            if (!((Map)this.vBiomolecules.get(n)).get("name").equals(string4)) continue;
            map = (Map)this.vBiomolecules.get(n);
            break;
        }
        if (map == null) {
            map = new Hashtable<String, String>();
            map.put("name", (Lst<Lst<Lst<Lst<Object>>>>)((Object)string4));
            n = this.parseIntStr(string);
            map.put("molecule", (Lst<Lst<Lst<Lst<Object>>>>)(n == Integer.MIN_VALUE ? string : Integer.valueOf(n)));
            map.put("biomts", new Lst());
            map.put("chains", new Lst());
            map.put("assemblies", new Lst());
            map.put("operators", new Lst());
            this.vBiomolecules.addLast(map);
        }
        ((Lst)map.get("assemblies")).addLast("$" + string2.replace(',', '$'));
        ((Lst)map.get("operators")).addLast(this.decodeAssemblyOperators(string3));
        if (this.checkFilterKey("ASSEMBLY " + string + ";") || this.checkFilterKey("ASSEMBLY=" + string + ";")) {
            this.thisBiomolecule = map;
        }
    }

    private String decodeAssemblyOperators(String string) {
        int n = string.indexOf(")(");
        if (n >= 0) {
            return this.crossBinary(this.decodeAssemblyOperators(string.substring(0, n + 1)), this.decodeAssemblyOperators(string.substring(n + 1)));
        }
        if (string.startsWith("(")) {
            if (string.indexOf("-") >= 0) {
                string = BS.unescape("({" + string.substring(1, string.length() - 1).replace('-', ':') + "})").toJSON();
            }
            string = PT.rep(string, " ", "");
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String crossBinary(String string, String string2) {
        SB sB = new SB();
        String[] stringArray = PT.split(string, ",");
        String[] stringArray2 = PT.split(string2, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                sB.append(",").append(stringArray[i]).append("|").append(stringArray2[j]);
            }
        }
        return sB.toString().substring(1);
    }

    private boolean processStructOperListBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_OPER, operFields);
        float[] fArray = new float[16];
        fArray[15] = 1.0f;
        while (this.parser.getData()) {
            int n = 0;
            String string = null;
            String string2 = null;
            int n2 = this.parser.getColumnCount();
            block6: for (int i = 0; i < n2; ++i) {
                int n3 = this.fieldProperty(i);
                switch (n3) {
                    case -1: {
                        continue block6;
                    }
                    case 12: {
                        string = this.field;
                        continue block6;
                    }
                    case 13: {
                        string2 = this.field;
                        continue block6;
                    }
                    default: {
                        fArray[n3] = this.parseFloatStr(this.field);
                        ++n;
                    }
                }
            }
            if (string == null || n != 12 && (string2 == null || this.symmetry == null)) continue;
            Logger.info("assembly operator " + string + " " + string2);
            M4 m4 = new M4();
            if (n != 12) {
                this.symmetry.getMatrixFromString(string2, fArray, false, 0);
                fArray[3] = fArray[3] * (this.symmetry.getUnitCellInfoType(0) / 12.0f);
                fArray[7] = fArray[7] * (this.symmetry.getUnitCellInfoType(1) / 12.0f);
                fArray[11] = fArray[11] * (this.symmetry.getUnitCellInfoType(2) / 12.0f);
            }
            m4.setA(fArray);
            if (this.htBiomts == null) {
                this.htBiomts = new Hashtable<String, M4>();
            }
            this.htBiomts.put(string, m4);
        }
        return true;
    }

    private boolean processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.parser.getData()) {
            String string;
            String string2 = this.getField((byte)0);
            if (this.isNull(string2) || this.isNull(string = this.getField((byte)1))) continue;
            this.addHetero(string2, string, true);
        }
        return true;
    }

    private void addHetero(String string, String string2, boolean bl) {
        if (!this.vwr.getJBR().isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (this.htHetero.containsKey(string)) {
            return;
        }
        this.htHetero.put(string, string2);
        if (bl) {
            this.appendLoadNote(string + " = " + string2);
        }
    }

    private boolean processStructConfLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_STRUCTCONF, structConfFields);
        if (!this.checkAllFieldsPresent(structConfFields, true)) {
            this.parser.skipLoop(true);
            return false;
        }
        while (this.parser.getData()) {
            Structure structure = new Structure(-1, STR.HELIX, STR.HELIX, null, 0, 0);
            int n = this.parser.getColumnCount();
            block14: for (int i = 0; i < n; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block14;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = structure.substructureType = STR.TURN;
                            continue block14;
                        }
                        if (this.field.startsWith("HELX")) continue block14;
                        structure.structureType = structure.substructureType = STR.NONE;
                        continue block14;
                    }
                    case 1: {
                        structure.startChainStr = this.field;
                        structure.startChainID = this.vwr.getChainID(this.field, true);
                        continue block14;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block14;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block14;
                    }
                    case 4: {
                        structure.endChainStr = this.field;
                        structure.endChainID = this.vwr.getChainID(this.field, true);
                        continue block14;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block14;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType(this.parseIntStr(this.field));
                        continue block14;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block14;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block14;
                    }
                    case 8: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.asc.addStructure(structure);
        }
        return true;
    }

    private boolean processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_SHEET, structSheetRangeFields);
        if (!this.checkAllFieldsPresent(structSheetRangeFields, true)) {
            this.parser.skipLoop(true);
            return false;
        }
        while (this.parser.getData()) {
            Structure structure = new Structure(-1, STR.SHEET, STR.SHEET, this.getField((byte)0), this.parseIntStr(this.getField((byte)7)), 1);
            structure.startChainID = this.vwr.getChainID(this.getField((byte)1), true);
            structure.startSequenceNumber = this.parseIntStr(this.getField((byte)2));
            structure.startInsertionCode = this.getField((byte)3).charAt(0);
            structure.endChainID = this.vwr.getChainID(this.getField((byte)4), true);
            structure.endSequenceNumber = this.parseIntStr(this.getField((byte)5));
            structure.endInsertionCode = this.getField((byte)6).charAt(0);
            this.asc.addStructure(structure);
        }
        return true;
    }

    private boolean processStructSiteBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_STRUCSITE, structSiteFields);
        Map<String, Object> map = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.parser.getData()) {
            String string;
            String string2 = this.getField((byte)3);
            if (this.isNull(string2) || this.isNull(string = this.getField((byte)1))) continue;
            String string3 = this.getField((byte)0);
            map = this.htSites.get(string3);
            if (map == null) {
                map = new Hashtable<String, Object>();
                map.put("groups", "");
                this.htSites.put(string3, map);
            }
            String string4 = this.getField((byte)4);
            String string5 = this.getField((byte)2);
            String string6 = "[" + string + "]" + string2 + (this.isNull(string4) ? "" : "^" + string4) + (this.isNull(string5) ? "" : ":" + string5);
            String string7 = (String)map.get("groups");
            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
            map.put("groups", string7);
        }
        return true;
    }

    private void setBiomolecules() {
        if (this.assemblyIdAtoms == null && this.chainAtomCounts == null) {
            return;
        }
        BS bS = new BS();
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            Map map;
            this.setBiomolecule(map, (map = (Map)this.vBiomolecules.get(n)) == this.thisBiomolecule ? bS : null);
        }
        if (this.isBiomolecule && bS.cardinality() < this.asc.ac) {
            if (this.asc.bsAtoms != null) {
                this.asc.bsAtoms.and(bS);
            } else if (!this.isCourseGrained) {
                this.asc.bsAtoms = bS;
            }
        }
    }

    private int setBiomolecule(Map<String, Object> map, BS bS) {
        Lst lst = (Lst)map.get("chains");
        Lst lst2 = (Lst)map.get("biomts");
        Lst lst3 = (Lst)map.get("operators");
        Lst lst4 = (Lst)map.get("assemblies");
        P3 p3 = new P3();
        int n = 0;
        BS bS2 = new BS();
        int n2 = 0;
        M4 m4 = M4.newM4(null);
        boolean bl = this.isBiomolecule && this.isCourseGrained;
        int n3 = lst3.size();
        while (--n3 >= 0) {
            Object object;
            int n4;
            String[] stringArray = PT.split((String)lst3.get(n3), ",");
            String[] stringArray2 = PT.split((String)lst4.get(n3), "$");
            String string = "";
            int n5 = 0;
            for (n4 = 1; n4 < stringArray2.length; ++n4) {
                JSONEncodable jSONEncodable;
                object = stringArray2[n4];
                string = string + ":" + (String)object + ";";
                if (this.assemblyIdAtoms != null) {
                    map.put("asemblyIdAtoms", this.assemblyIdAtoms);
                    jSONEncodable = this.assemblyIdAtoms.get(object);
                    if (jSONEncodable == null) continue;
                    bS2.or((BS)jSONEncodable);
                    if (bS != null) {
                        bS.or((BS)jSONEncodable);
                    }
                    n5 += ((BS)jSONEncodable).cardinality();
                    continue;
                }
                if (!bl || (jSONEncodable = this.chainAtomMap.get(object)) == null) continue;
                if (this.bySymop) {
                    p3.add((T3)jSONEncodable);
                    n += this.chainAtomCounts.get(object)[0];
                    continue;
                }
                this.createParticle((String)object);
                ++n5;
            }
            if (!this.isBiomolecule) continue;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                object = this.getOpMatrix(stringArray[n4]);
                if (object == null) {
                    return 0;
                }
                if (((M4)object).equals(m4)) {
                    lst2.add(0, m4);
                    lst.add(0, string);
                    continue;
                }
                lst2.addLast(object);
                lst.addLast(string);
            }
            if (this.bySymop && bS != null) {
                n5 = 1;
                Atom atom = new Atom();
                atom.setT(p3);
                atom.scale(1.0f / (float)n);
                atom.radius = 16.0f;
                this.asc.addAtom(atom);
            }
            n2 += (n5 *= stringArray.length);
        }
        map.put("atomCount", n2);
        return n2;
    }

    private void createParticle(String string) {
        P3 p3 = this.chainAtomMap.get(string);
        int n = this.chainAtomCounts.get(string)[0];
        Atom atom = new Atom();
        atom.setT(p3);
        atom.scale(1.0f / (float)n);
        atom.elementSymbol = "Pt";
        this.setChainID(atom, string);
        atom.radius = 16.0f;
        this.asc.addAtom(atom);
    }

    private M4 getOpMatrix(String string) {
        if (this.htBiomts == null) {
            return M4.newM4(null);
        }
        int n = string.indexOf("|");
        if (n >= 0) {
            M4 m4 = M4.newM4(this.htBiomts.get(string.substring(0, n)));
            m4.mul(this.htBiomts.get(string.substring(n + 1)));
            return m4;
        }
        return this.htBiomts.get(string);
    }

    private boolean processStructConnLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_STRUCTCONN, structConnFields);
        while (this.parser.getData()) {
            String string;
            String string2;
            String string3 = this.getField((byte)5);
            if (!string3.equals(string2 = this.getField((byte)11)) || !this.isNull(string3) && !string3.equals("1_555") || !(string = this.getField((byte)12)).startsWith("covale") && !string.equals("disulf") && !string.equals("metalc")) continue;
            if (this.htBondMap == null) {
                this.htBondMap = new Hashtable<String, Lst<Object[]>>();
            }
            String string4 = this.vwr.getChainID(this.getField((byte)0), true) + this.getField((byte)2) + this.parseFloatStr(this.getField((byte)1)) + this.getField((byte)3) + this.getField((byte)4);
            String string5 = this.vwr.getChainID(this.getField((byte)6), true) + this.getField((byte)8) + this.parseFloatStr(this.getField((byte)7)) + this.getField((byte)9) + this.getField((byte)10);
            int n = this.getBondOrder(this.getField((byte)13));
            if (this.structConnMap == null) {
                this.structConnMap = new Lst();
            }
            this.structConnMap.addLast(new Object[]{string4, string5, n});
            if (this.structConnList.indexOf(string4) < 0) {
                this.structConnList = this.structConnList + string4;
            }
            if (this.structConnList.indexOf(string5) >= 0) continue;
            this.structConnList = this.structConnList + string5;
        }
        return true;
    }

    private boolean processCompBondLoopBlock() throws Exception {
        this.doSetBonds = true;
        this.parseLoopParametersFor(FAMILY_COMPBOND, chemCompBondFields);
        while (this.parser.getData()) {
            Lst<Object> lst;
            String string = this.getField((byte)0);
            String string2 = this.getField((byte)1);
            String string3 = this.getField((byte)2);
            int n = this.getBondOrder(this.getField((byte)3));
            if (this.getField((byte)4).charAt(0) == 'Y') {
                switch (n) {
                    case 1: {
                        n = 513;
                        break;
                    }
                    case 2: {
                        n = 514;
                    }
                }
            }
            if (this.isLigand) {
                this.asc.addNewBondWithOrderA(this.asc.getAtomFromName(string2), this.asc.getAtomFromName(string3), n);
                continue;
            }
            if (!this.haveHAtoms && (this.htHetero == null || !this.htHetero.containsKey(string))) continue;
            if (this.htBondMap == null) {
                this.htBondMap = new Hashtable<String, Lst<Object[]>>();
            }
            if ((lst = this.htBondMap.get(string)) == null) {
                lst = new Lst();
                this.htBondMap.put(string, lst);
            }
            lst.addLast(new Object[]{string2, string3, this.haveHAtoms ? n : 1});
        }
        return true;
    }

    @Override
    public boolean processSubclassAtom(Atom atom, String string, String string2) {
        if (this.isBiomolecule) {
            if (this.isCourseGrained) {
                P3 p3 = this.chainAtomMap.get(string);
                if (p3 == null) {
                    p3 = new P3();
                    this.chainAtomMap.put(string, p3);
                    this.chainAtomCounts.put(string, new int[1]);
                }
                int[] nArray = this.chainAtomCounts.get(string);
                nArray[0] = nArray[0] + 1;
                p3.add(atom);
                return false;
            }
        } else if (this.byChain) {
            if (this.thisChain != atom.chainID) {
                this.thisChain = atom.chainID;
                this.chainSum = this.chainAtomMap.get(string2);
                if (this.chainSum == null) {
                    this.chainSum = new P3();
                    this.chainAtomMap.put(string2, this.chainSum);
                    this.chainAtomCount = new int[1];
                    this.chainAtomCounts.put(string2, this.chainAtomCount);
                }
            }
            this.chainSum.add(atom);
            this.chainAtomCount[0] = this.chainAtomCount[0] + 1;
            return false;
        }
        if (string != null) {
            BS bS;
            if (this.assemblyIdAtoms == null) {
                this.assemblyIdAtoms = new Hashtable<String, BS>();
            }
            if ((bS = this.assemblyIdAtoms.get(string)) == null) {
                bS = new BS();
                this.assemblyIdAtoms.put(string, bS);
            }
            bS.set(this.ac);
        }
        return true;
    }

    @Override
    protected int checkPDBModelField(int n, int n2) throws Exception {
        this.fieldProperty(n);
        int n3 = this.parseIntStr(this.field);
        if (n3 != n2) {
            if (this.iHaveDesiredModel && this.asc.atomSetCount > 0) {
                this.parser.skipLoop(false);
                this.skipping = false;
                this.continuing = true;
                return Integer.MIN_VALUE;
            }
            int n4 = this.useFileModelNumbers ? n3 : (this.modelIndex = this.modelIndex + 1);
            this.setHetero();
            this.newModel(n4);
            if (!this.skipping) {
                this.nextAtomSet();
                if (this.modelMap == null || this.asc.ac == 0) {
                    this.modelMap = new Hashtable();
                }
                this.modelMap.put("" + n3, Math.max(0, this.asc.iSet));
                this.modelMap.put("_" + Math.max(0, this.asc.iSet), n3);
            }
        }
        return n3;
    }

    private void setHetero() {
        if (this.htHetero != null) {
            this.asc.setCurrentModelInfo("hetNames", this.htHetero);
            this.asc.setInfo("hetNames", this.htHetero);
        }
    }
}

