/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;
    private SymmetryDesc desc;

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, T3[] t3Array, BS bS, boolean bl, float f, float f2, boolean bl2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, t3Array, bS, bl, f, f2, bl2);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2, f)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    @Override
    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, bl, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 m4, boolean bl) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((bl ? "!" : "") + "[[bio" + m4, 0, false);
    }

    @Override
    public void setLattice(int n) {
        this.spaceGroup.setLatticeParam(n);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public void setSpaceGroupFrom(SymmetryInterface symmetryInterface) {
        this.spaceGroup = (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    @Override
    public boolean createSpaceGroup(int n, String string, Object object) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, object);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo(null));
        }
        return this.spaceGroup != null;
    }

    @Override
    public String getSpaceGroupInfoStr(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(String string, P3[] p3Array, int n, int n2, boolean bl, String string2) {
        if (string != null && (string.startsWith("bio") || string.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = string;
        }
        if (string2 != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.operations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!string2.contains(" " + (i + 1) + " ")) continue;
                lst.addLast(this.spaceGroup.operations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, string + " *(" + string2.trim() + ")", lst);
        }
        this.spaceGroup.setFinalOperations(p3Array, n, n2, bl);
    }

    @Override
    public M4 getSpaceGroupOperation(int n) {
        return n >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[n] : this.spaceGroup.finalOperations[n]);
    }

    @Override
    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.getXyz(n, bl);
    }

    @Override
    public void newSpaceGroupPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(p3, p32, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(p3, p32, n2, n3, n4);
    }

    @Override
    public V3[] rotateAxes(int n, V3[] v3Array, P3 p3, M3 m3) {
        return n == 0 ? v3Array : this.spaceGroup.finalOperations[n].rotateAxes(v3Array, this.unitCell, p3, m3);
    }

    @Override
    public String getSpaceGroupOperationCode(int n) {
        return this.spaceGroup.operations[n].subsystemCode;
    }

    @Override
    public void setTimeReversal(int n, int n2) {
        this.spaceGroup.operations[n].setTimeReversal(n2);
    }

    @Override
    public float getSpinOp(int n) {
        return this.spaceGroup.operations[n].getSpinOp();
    }

    @Override
    public boolean addLatticeVectors(Lst<float[]> lst) {
        return this.spaceGroup.addLatticeVectors(lst);
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Matrix getOperationRsVs(int n) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[n].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 p3) {
        return this.spaceGroup.getSiteMultiplicity(p3, this.unitCell);
    }

    @Override
    public String addOp(String string, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.spaceGroup.isSSG = true;
        String string2 = SymmetryOperation.getXYZFromRsVs(matrix, matrix2, false);
        int n = this.spaceGroup.addSymmetry(string2, -1, true);
        this.spaceGroup.operations[n].setSigma(string, matrix3);
        return string2;
    }

    @Override
    public String getMatrixFromString(String string, float[] fArray, boolean bl, int n) {
        return SymmetryOperation.getMatrixFromString(null, string, fArray, bl);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        return this.symmetryInfo == null ? "" : this.symmetryInfo.infoStr;
    }

    @Override
    public M4[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        return this.spaceGroup.finalOperations;
    }

    @Override
    public boolean isPeriodic() {
        return this.symmetryInfo == null ? false : this.symmetryInfo.isPeriodic();
    }

    @Override
    public void setSymmetryInfo(int n, Map<String, Object> map, float[] fArray) {
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray2 = this.symmetryInfo.setSymmetryInfo(map, fArray);
        if (fArray2 == null) {
            return;
        }
        this.setUnitCell(fArray2, map.containsKey("jmolData"));
        this.unitCell.moreInfo = (Lst)map.get("moreUnitCellInfo");
        map.put("infoUnitCell", this.getUnitCellAsArray(false));
        this.setOffsetPt((T3)map.get("unitCellOffset"));
        M3 m3 = (M3)map.get("matUnitCellOrientation");
        if (m3 != null) {
            this.initializeOrientation(m3);
        }
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public boolean checkUnitCell(SymmetryInterface symmetryInterface, P3 p3, P3 p32, boolean bl) {
        symmetryInterface.toFractional(p32, bl);
        return p32.x >= p3.x - 1.0f - 0.02f && p32.x <= p3.x + 0.02f && p32.y >= p3.y - 1.0f - 0.02f && p32.y <= p3.y + 0.02f && p32.z >= p3.z - 1.0f - 0.02f && p32.z <= p3.z + 0.02f;
    }

    @Override
    public void setUnitCell(float[] fArray, boolean bl) {
        this.unitCell = UnitCell.newA(fArray, bl);
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface symmetryInterface) {
        return ((Symmetry)symmetryInterface).unitCell.isSameAs(this.unitCell);
    }

    @Override
    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public void initializeOrientation(M3 m3) {
        this.unitCell.initOrientation(m3);
    }

    @Override
    public void unitize(P3 p3) {
        this.unitCell.unitize(p3);
    }

    @Override
    public void toUnitCell(P3 p3, P3 p32) {
        this.unitCell.toUnitCell(p3, p32);
    }

    @Override
    public P3 toSupercell(P3 p3) {
        return this.unitCell.toSupercell(p3);
    }

    @Override
    public void toFractional(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toFractional(t3, bl);
        }
    }

    @Override
    public void toCartesian(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toCartesian(t3, bl);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean bl) {
        return this.unitCell.getUnitCellAsArray(bl);
    }

    @Override
    public Tensor getTensor(Viewer viewer, float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.newA(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true);
        }
        return this.unitCell.getTensor(viewer, fArray);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(T3 t3) {
        this.unitCell.setOffset(t3);
    }

    @Override
    public void setOffset(int n) {
        P3 p3 = new P3();
        SimpleUnitCell.ijkToPoint3f(n, p3, 0);
        this.unitCell.setOffset(p3);
    }

    @Override
    public P3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public P3[] getCanonicalCopy(float f, boolean bl) {
        return this.unitCell.getCanonicalCopy(f, bl);
    }

    @Override
    public float getUnitCellInfoType(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        this.unitCell.setMinMaxLatticeParameters(p3i, p3i2);
    }

    @Override
    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        return this.unitCell.checkDistance(p3, p32, f, f2, n, n2, n3, p33);
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] t3Array, boolean bl, String string) {
        this.unitCell = UnitCell.newP(t3Array, bl);
        if (string != null) {
            this.unitCell.name = string;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bS, int[] nArray) {
        try {
            BS bS2 = new BS();
            int n = bS.nextSetBit(0);
            JmolMolecule[] jmolMoleculeArray = modelSet.getMolecules();
            int n2 = jmolMoleculeArray.length;
            Atom[] atomArray = modelSet.at;
            boolean bl = jmolMoleculeArray[n2 - 1].firstAtomIndex == modelSet.am[atomArray[n].mi].firstAtomIndex;
            P3 p3 = new P3();
            boolean bl2 = nArray[6] == 1;
            int n3 = n2;
            block2: while (--n3 >= 0 && bS.get(jmolMoleculeArray[n3].firstAtomIndex)) {
                BS bS3 = jmolMoleculeArray[n3].atomList;
                p3.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                int n5 = bS3.nextSetBit(0);
                while (n5 >= 0) {
                    if (bl || bl2) {
                        p3.setT(atomArray[n5]);
                        if (this.isNotCentroid(p3, 1, nArray, bl2)) {
                            if (bl) {
                                bS2.set(n5);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        p3.add(atomArray[n5]);
                        ++n4;
                    }
                    n5 = bS3.nextSetBit(n5 + 1);
                }
                if (!bl2 && (n4 <= 0 || !this.isNotCentroid(p3, n4, nArray, false))) continue;
                bS2.or(bS3);
            }
            return bS2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 p3, int n, int[] nArray, boolean bl) {
        p3.scale(1.0f / (float)n);
        this.toFractional(p3, false);
        if (bl) {
            return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x - 5.0E-6f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y - 5.0E-6f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z - 5.0E-6f > (float)nArray[5];
        }
        return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x + 5.0E-5f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y + 5.0E-5f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z + 5.0E-5f > (float)nArray[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        return this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc;
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        return this.getDesc(modelSet).getSymmetryInfoAtom(bS, string, n, p3, p32, string2, n2, modelSet);
    }

    @Override
    public String getSymmetryInfoString(ModelSet modelSet, int n, int n2, P3 p3, P3 p32, String string, String string2) {
        return this.getDesc(modelSet).getSymmetryInfoString(this, n, n2, p3, p32, string, string2, modelSet);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String string) {
        return this.getDesc(modelSet).getSpaceGroupInfo(this, -1, string, 0, null, null, null, modelSet);
    }

    @Override
    public Object getSymmetryInfo(ModelSet modelSet, int n, int n2, SymmetryInterface symmetryInterface, String string, int n3, P3 p3, P3 p32, String string2, int n4) {
        return this.getDesc(modelSet).getSymmetryInfo(this, n, n2, (Symmetry)symmetryInterface, string, n3, p3, p32, string2, n4, modelSet);
    }

    @Override
    public String fcoord(T3 t3) {
        return SymmetryOperation.fcoord(t3);
    }

    @Override
    public T3[] getV0abc(Object object) {
        M4 m4;
        Object object2;
        T3[] t3Array;
        if (this.unitCell == null) {
            return null;
        }
        boolean bl = false;
        if (object instanceof String) {
            t3Array = (V3[])object;
            if (t3Array.indexOf(";") < 0) {
                t3Array = (String)t3Array + ";0,0,0";
            }
            if (bl = t3Array.startsWith("!")) {
                t3Array = t3Array.substring(1);
            }
            object2 = new Symmetry();
            ((Symmetry)object2).setSpaceGroup(false);
            int n = ((Symmetry)object2).addSpaceGroupOperation("=" + (String)t3Array, 0);
            if (n < 0) {
                return null;
            }
            m4 = ((Symmetry)object2).getSpaceGroupOperation(n);
            ((SymmetryOperation)m4).doFinalize();
        } else {
            m4 = object instanceof M3 ? M4.newMV((M3)object, new P3()) : (M4)object;
        }
        t3Array = new V3[4];
        object2 = new P3();
        M3 m3 = new M3();
        m4.getRotationScale(m3);
        m4.getTranslation((T3)object2);
        if (bl) {
            m3.invert();
            m3.transpose();
            m3.rotate((T3)object2);
            ((T3)object2).scale(-1.0f);
        } else {
            m3.transpose();
        }
        this.unitCell.toCartesian((T3)object2, false);
        t3Array[0] = V3.newV((T3)object2);
        t3Array[1] = V3.new3(1.0f, 0.0f, 0.0f);
        t3Array[2] = V3.new3(0.0f, 1.0f, 0.0f);
        t3Array[3] = V3.new3(0.0f, 0.0f, 1.0f);
        for (int i = 1; i < 4; ++i) {
            m3.rotate(t3Array[i]);
            this.unitCell.toCartesian(t3Array[i], true);
        }
        return t3Array;
    }

    @Override
    public Quat getQuaternionRotation(String string) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(string);
    }

    @Override
    public T3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public void setAxes(float f, P3[] p3Array, P3 p3, P3 p32) {
        P3[] p3Array2 = this.getUnitCellVerticesNoOffset();
        P3 p33 = this.getCartesianOffset();
        if (p3 == null) {
            p32.add2(p33, p3Array2[0]);
        } else {
            p33 = p3;
        }
        p3Array[0].scaleAdd2(f, p3Array2[4], p33);
        p3Array[1].scaleAdd2(f, p3Array2[2], p33);
        p3Array[2].scaleAdd2(f, p3Array2[1], p33);
    }

    @Override
    public boolean getState(SB sB) {
        P3 p3 = this.getFractionalOffset();
        boolean bl = false;
        if (p3 != null && (p3.x != 0.0f || p3.y != 0.0f || p3.z != 0.0f)) {
            sB.append("; set unitcell ").append(Escape.eP(p3));
            bl = true;
        }
        if ((p3 = this.getUnitCellMultiplier()) != null) {
            sB.append("; set unitcell ").append(Escape.eP(p3));
            bl = true;
        }
        return bl;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer viewer, Atom atom, Atom[] atomArray, BS bS, float f) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", viewer, "script")).set(this, atom, atomArray, bS, f);
    }
}

