/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.batik;

import com.kitfox.svg.batik.MultipleGradientPaint;
import com.kitfox.svg.batik.RadialGradientPaintContext;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public final class RadialGradientPaint
extends MultipleGradientPaint {
    private Point2D focus;
    private Point2D center;
    private float radius;

    public RadialGradientPaint(float f, float f2, float f3, float[] fArray, Color[] colorArray) {
        this(f, f2, f3, f, f2, fArray, colorArray);
    }

    public RadialGradientPaint(Point2D point2D, float f, float[] fArray, Color[] colorArray) {
        this(point2D, f, point2D, fArray, colorArray);
    }

    public RadialGradientPaint(float f, float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray) {
        this(new Point2D.Float(f, f2), f3, new Point2D.Float(f4, f5), fArray, colorArray, NO_CYCLE, SRGB);
    }

    public RadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray) {
        this(point2D, f, point2D2, fArray, colorArray, NO_CYCLE, SRGB);
    }

    public RadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) {
        this(point2D, f, point2D2, fArray, colorArray, cycleMethodEnum, colorSpaceEnum, new AffineTransform());
    }

    public RadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum, AffineTransform affineTransform) {
        super(fArray, colorArray, cycleMethodEnum, colorSpaceEnum, affineTransform);
        if (point2D == null) {
            throw new NullPointerException("Center point should not be null.");
        }
        if (point2D2 == null) {
            throw new NullPointerException("Focus point should not be null.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("radius should be greater than zero");
        }
        this.center = (Point2D)point2D.clone();
        this.focus = (Point2D)point2D2.clone();
        this.radius = f;
    }

    public RadialGradientPaint(Rectangle2D rectangle2D, float[] fArray, Color[] colorArray) {
        this((float)rectangle2D.getX() + (float)rectangle2D.getWidth() / 2.0f, (float)rectangle2D.getY() + (float)rectangle2D.getWidth() / 2.0f, (float)rectangle2D.getWidth() / 2.0f, fArray, colorArray);
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.concatenate(this.gradientTransform);
        try {
            return new RadialGradientPaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, (float)this.center.getX(), (float)this.center.getY(), this.radius, (float)this.focus.getX(), (float)this.focus.getY(), this.fractions, this.colors, this.cycleMethod, this.colorSpace);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public Point2D getCenterPoint() {
        return new Point2D.Double(this.center.getX(), this.center.getY());
    }

    public Point2D getFocusPoint() {
        return new Point2D.Double(this.focus.getX(), this.focus.getY());
    }

    public float getRadius() {
        return this.radius;
    }
}

