/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "aligncircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true, "createcircle", true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private int[] distributeNodes(PolarNode[] polarNodeArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[polarNodeArray.length];
        double[] dArray = new double[polarNodeArray.length];
        double[] dArray2 = new double[polarNodeArray.length];
        for (n3 = 0; n3 < polarNodeArray.length; ++n3) {
            dArray[n3] = polarNodeArray[(n3 + 1) % polarNodeArray.length].a - polarNodeArray[n3].a;
            if (!(dArray[n3] < 0.0)) continue;
            int n4 = n3;
            dArray[n4] = dArray[n4] + Math.PI * 2;
        }
        n3 = 0;
        for (n2 = 0; n2 < polarNodeArray.length; ++n2) {
            double d = dArray[n2] / 2.0 / Math.PI * (double)n;
            nArray[n2] = (int)Math.floor(d);
            dArray2[n2] = d - (double)nArray[n2];
            n3 += nArray[n2];
        }
        while (n3 < n) {
            n2 = 0;
            for (int i = 1; i < polarNodeArray.length; ++i) {
                if (!(dArray2[i] > dArray2[n2])) continue;
                n2 = i;
            }
            int n5 = n2;
            nArray[n5] = nArray[n5] + 1;
            dArray2[n2] = 0.0;
            ++n3;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        void var8_12;
        double d;
        double d2;
        List<Node> list;
        double d3;
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        int n = Main.pref.getInteger("createcircle.nodecount", 16);
        if (n < 1) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        Collection<OsmPrimitive> collection = CreateCircleAction.getCurrentDataSet().getSelected();
        List<Node> list2 = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list3 = OsmPrimitive.getFilteredList(collection, Way.class);
        Way way = null;
        if (list2.isEmpty() && list3.size() == 1) {
            way = list3.get(0);
            for (Node object22 : way.getNodes()) {
                if (list2.contains(object22)) continue;
                list2.add(object22);
            }
        }
        if (list2.size() < 2 || list2.size() > 3) {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        LinkedList linkedList = new LinkedList();
        Object var8_9 = null;
        if (list2.size() == 2) {
            object = list2.get(0);
            d3 = ((Node)object).getEastNorth().east();
            double d4 = ((Node)object).getEastNorth().north();
            list = list2.get(1);
            double d5 = ((Node)((Object)list)).getEastNorth().east();
            double d6 = ((Node)((Object)list)).getEastNorth().north();
            d2 = 0.5 * (d3 + d5);
            d = 0.5 * (d4 + d6);
            EastNorth eastNorth = new EastNorth(d2, d);
        } else {
            EastNorth eastNorth = Geometry.getCenter(list2);
            if (eastNorth == null) {
                CreateCircleAction.notifyNodesNotOnCircle();
                return;
            }
        }
        object = list2.get(0).getEastNorth();
        d3 = Math.sqrt(Math.pow(var8_12.east() - ((EastNorth)object).east(), 2.0) + Math.pow(var8_12.north() - ((EastNorth)object).north(), 2.0));
        PolarNode[] polarNodeArray = new PolarNode[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            polarNodeArray[i] = new PolarNode((EastNorth)var8_12, list2.get(i));
        }
        Arrays.sort(polarNodeArray, new PolarNodeComparator());
        int[] nArray = this.distributeNodes(polarNodeArray, n >= list2.size() ? n - list2.size() : 0);
        list = new ArrayList();
        for (int i = 0; i < list2.size(); ++i) {
            list.add(polarNodeArray[i].node);
            double d7 = polarNodeArray[(i + 1) % list2.size()].a - polarNodeArray[i].a;
            if (d7 < 0.0) {
                d7 += Math.PI * 2;
            }
            for (int j = 0; j < nArray[i]; ++j) {
                d2 = polarNodeArray[i].a + (double)(j + 1) * d7 / (double)(nArray[i] + 1);
                d = var8_12.east() + d3 * Math.cos(d2);
                double d8 = var8_12.north() + d3 * Math.sin(d2);
                LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d, d8));
                if (latLon.isOutSideWorld()) {
                    CreateCircleAction.notifyNodesNotOnCircle();
                    return;
                }
                Node node = new Node(latLon);
                list.add(node);
                linkedList.add(new AddCommand(node));
            }
        }
        list.add((Node)list.get(0));
        list = way != null && way.getNodesCount() >= 3 ? CreateCircleAction.orderNodesByWay(list, way) : CreateCircleAction.orderNodesByTrafficHand(list);
        if (way == null) {
            Way way2 = new Way();
            way2.setNodes(list);
            linkedList.add(new AddCommand(way2));
        } else {
            Way way3 = new Way(way);
            way3.setNodes(list);
            linkedList.add(new ChangeCommand(way, way3));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), linkedList));
        Main.map.repaint();
    }

    private static List<Node> orderNodesByTrafficHand(List<Node> list) {
        boolean bl = true;
        for (Node node : list) {
            if (RightAndLefthandTraffic.isRightHandTraffic(node.getCoor())) continue;
            bl = false;
            break;
        }
        if (bl == Geometry.isClockwise(list)) {
            Collections.reverse(list);
        }
        return list;
    }

    private static List<Node> orderNodesByWay(List<Node> list, Way way) {
        List<Node> list2 = way.getNodes();
        if (!way.isClosed()) {
            list2.add(list2.get(0));
        }
        if (Geometry.isClockwise(list2) != Geometry.isClockwise(list)) {
            Collections.reverse(list);
        }
        return list;
    }

    private static void notifyNodesNotOnCircle() {
        new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
    }

    @Override
    protected void updateEnabledState() {
        if (CreateCircleAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateCircleAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class PolarNodeComparator
    implements Comparator<PolarNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PolarNodeComparator() {
        }

        @Override
        public int compare(PolarNode polarNode, PolarNode polarNode2) {
            return Double.compare(polarNode.a, polarNode2.a);
        }
    }

    private static class PolarNode {
        private double a;
        private Node node;

        PolarNode(EastNorth eastNorth, Node node) {
            EastNorth eastNorth2 = node.getEastNorth();
            this.a = Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
            this.node = node;
        }
    }
}

