/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WMTSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String URL_GET_ENCODING_PARAMS = "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER={layer}&STYLE={Style}&FORMAT={format}&tileMatrixSet={TileMatrixSet}&tileMatrix={TileMatrix}&tileRow={TileRow}&tileCol={TileCol}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}"};
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private Collection<Layer> layers;
    private Layer currentLayer;
    private TileMatrixSet currentTileMatrixSet;
    private double crsScale;
    private TransferMode transferMode;

    public WMTSTileSource(ImageryInfo imageryInfo) throws IOException {
        super(imageryInfo);
        this.baseUrl = WMTSTileSource.normalizeCapabilitiesUrl(this.handleTemplate(imageryInfo.getUrl()));
        this.layers = this.getCapabilities();
        if (this.layers.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("No layers defined by getCapabilities document: {0}", imageryInfo.getUrl()));
        }
    }

    private Layer userSelectLayer(Collection<Layer> collection) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        Layer layer = null;
        SelectLayerDialog selectLayerDialog = new SelectLayerDialog(collection);
        if (selectLayerDialog.showDialog().getValue() == 1) {
            layer = selectLayerDialog.getSelectedLayer();
        }
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("No layer selected", new Object[0]));
        }
        return layer;
    }

    private String handleTemplate(String string) {
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private Collection<Layer> getCapabilities() throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = new CachedFile(this.baseUrl).setHttpHeaders(this.headers).setMaxAge(604800L).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getInputStream();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            byte[] byArray = Utils.readBytesFromStream(inputStream);
            if (byArray == null || byArray.length == 0) {
                throw new IllegalArgumentException("Could not read data from: " + this.baseUrl);
            }
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            Node node = WMTSTileSource.getByXpath(document, "/Capabilities/OperationsMetadata/Operation[@name=\"GetTile\"]/DCP/HTTP/Get").item(0);
            this.baseUrl = WMTSTileSource.getStringByXpath(node, "@href");
            this.transferMode = TransferMode.fromString(WMTSTileSource.getStringByXpath(node, "Constraint[@name=\"GetEncoding\"]/AllowedValues/Value"));
            NodeList nodeList = WMTSTileSource.getByXpath(document, "/Capabilities/Contents/Layer");
            Map<String, TileMatrixSet> map = this.parseMatrices(WMTSTileSource.getByXpath(document, "/Capabilities/Contents/TileMatrixSet"));
            return this.parseLayer(nodeList, map);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private static String normalizeCapabilitiesUrl(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
        return uRL2.toExternalForm();
    }

    private Collection<Layer> parseLayer(NodeList nodeList, Map<String, TileMatrixSet> map) throws XPathExpressionException {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = WMTSTileSource.getByXpath(node, "TileMatrixSetLink");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Layer layer = new Layer();
                layer.format = WMTSTileSource.getStringByXpath(node, "Format");
                layer.name = WMTSTileSource.getStringByXpath(node, "Identifier");
                layer.baseUrl = WMTSTileSource.getStringByXpath(node, "ResourceURL[@resourceType='tile']/@template");
                layer.style = WMTSTileSource.getStringByXpath(node, "Style[@isDefault='true']/Identifier");
                if (layer.style == null) {
                    layer.style = "";
                }
                Node node2 = nodeList2.item(j);
                TileMatrixSet tileMatrixSet = map.get(WMTSTileSource.getStringByXpath(node2, "TileMatrixSet"));
                layer.tileMatrixSet = tileMatrixSet;
                arrayList.add(layer);
            }
        }
        return arrayList;
    }

    private Map<String, TileMatrixSet> parseMatrices(NodeList nodeList) throws XPathExpressionException {
        ConcurrentHashMap<String, TileMatrixSet> concurrentHashMap = new ConcurrentHashMap<String, TileMatrixSet>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            TileMatrixSet tileMatrixSet = new TileMatrixSet();
            tileMatrixSet.identifier = WMTSTileSource.getStringByXpath(node, "Identifier");
            tileMatrixSet.crs = WMTSTileSource.crsToCode(WMTSTileSource.getStringByXpath(node, "SupportedCRS"));
            NodeList nodeList2 = WMTSTileSource.getByXpath(node, "TileMatrix");
            Projection projection = Projections.getProjectionByCode(tileMatrixSet.crs);
            if (projection == null) {
                projection = Main.getProjection();
            }
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                TileMatrix tileMatrix = new TileMatrix();
                tileMatrix.identifier = WMTSTileSource.getStringByXpath(node2, "Identifier");
                tileMatrix.scaleDenominator = Double.parseDouble(WMTSTileSource.getStringByXpath(node2, "ScaleDenominator"));
                String[] stringArray = WMTSTileSource.getStringByXpath(node2, "TopLeftCorner").split(" ");
                if (projection.switchXY()) {
                    tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
                } else {
                    tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                }
                tileMatrix.tileHeight = Integer.parseInt(WMTSTileSource.getStringByXpath(node2, "TileHeight"));
                tileMatrix.tileWidth = Integer.parseInt(WMTSTileSource.getStringByXpath(node2, "TileHeight"));
                tileMatrix.matrixWidth = WMTSTileSource.getOptionalIntegerByXpath(node2, "MatrixWidth");
                tileMatrix.matrixHeight = WMTSTileSource.getOptionalIntegerByXpath(node2, "MatrixHeight");
                if (tileMatrix.tileHeight != tileMatrix.tileWidth) {
                    throw new AssertionError((Object)I18n.tr("Only square tiles are supported. {0}x{1} returned by server for TileMatrix identifier {2}", tileMatrix.tileHeight, tileMatrix.tileWidth, tileMatrix.identifier));
                }
                tileMatrixSet.tileMatrix.add(tileMatrix);
            }
            concurrentHashMap.put(tileMatrixSet.identifier, tileMatrixSet);
        }
        return concurrentHashMap;
    }

    private static String crsToCode(String string) {
        if (string.startsWith("urn:ogc:def:crs:")) {
            return string.replaceFirst("urn:ogc:def:crs:([^:]*):.*:(.*)$", "$1:$2");
        }
        return string;
    }

    private static int getOptionalIntegerByXpath(Node node, String string) throws XPathExpressionException {
        String string2 = WMTSTileSource.getStringByXpath(node, string);
        if (string2 == null || "".equals(string2)) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    private static String getStringByXpath(Node node, String string) throws XPathExpressionException {
        return (String)WMTSTileSource.getByXpath(node, string, XPathConstants.STRING);
    }

    private static NodeList getByXpath(Node node, String string) throws XPathExpressionException {
        return (NodeList)WMTSTileSource.getByXpath(node, string, XPathConstants.NODESET);
    }

    private static Object getByXpath(Node node, String string, QName qName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        return xPathExpression.evaluate(node, qName);
    }

    public void initProjection(Projection projection) {
        Layer layer;
        Collection<Layer> collection;
        String string = null;
        if (this.currentLayer != null) {
            string = this.currentLayer.name;
        }
        if (!(collection = this.getLayers(string, projection.toCode())).isEmpty() && (layer = this.userSelectLayer(collection)) != null) {
            this.currentTileMatrixSet = layer.tileMatrixSet;
            this.currentLayer = layer;
        }
        this.crsScale = (double)this.getTileSize() * 2.8E-4 / projection.getMetersPerUnit();
    }

    private Collection<Layer> getLayers(String string, String string2) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (string != null && !string.equals(layer.name) || string2 != null && !string2.equals(layer.tileMatrixSet.crs)) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    @Override
    public int getDefaultTileSize() {
        return this.getTileSize();
    }

    @Override
    public int getTileSize() {
        TileMatrix tileMatrix = this.getTileMatrix(1);
        if (tileMatrix == null) {
            return 1;
        }
        return tileMatrix.tileHeight;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string;
        if (this.currentLayer == null) {
            return "";
        }
        switch (this.transferMode) {
            case KVP: {
                string = this.baseUrl + URL_GET_ENCODING_PARAMS;
                break;
            }
            case REST: {
                string = this.currentLayer.baseUrl;
                break;
            }
            default: {
                string = "";
            }
        }
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return "";
        }
        return string.replaceAll("\\{layer\\}", this.currentLayer.name).replaceAll("\\{format\\}", this.currentLayer.format).replaceAll("\\{TileMatrixSet\\}", this.currentTileMatrixSet.identifier).replaceAll("\\{TileMatrix\\}", tileMatrix.identifier).replaceAll("\\{TileRow\\}", Integer.toString(n3)).replaceAll("\\{TileCol\\}", Integer.toString(n2)).replaceAll("\\{Style\\}", this.currentLayer.style);
    }

    private TileMatrix getTileMatrix(int n) {
        if (n > this.getMaxZoom()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        return this.currentTileMatrixSet.tileMatrix.toArray(new TileMatrix[0])[n - 1];
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return Main.getProjection().getWorldBoundsLatLon().getCenter().toCoordinate();
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        return Main.getProjection().eastNorth2latlon(eastNorth).toCoordinate();
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileXY(0.0, 0.0);
        }
        Projection projection = Main.getProjection();
        EastNorth eastNorth = projection.latlon2eastNorth(new LatLon(d, d2));
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        return new TileXY((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3, (tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.getTileXMax(n, Main.getProjection());
    }

    @Override
    public int getTileXMin(int n) {
        return 0;
    }

    @Override
    public int getTileYMax(int n) {
        return this.getTileYMax(n, Main.getProjection());
    }

    @Override
    public int getTileYMin(int n) {
        return 0;
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new Point(0, 0);
        }
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3), (int)Math.round((tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public Coordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public Coordinate xyToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return new Coordinate(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        Projection projection = Main.getProjection();
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        LatLon latLon = projection.eastNorth2latlon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getMaxZoom() {
        if (this.currentTileMatrixSet != null) {
            return this.currentTileMatrixSet.tileMatrix.size();
        }
        return 0;
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    public Set<String> getSupportedProjections() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.currentLayer == null) {
            for (Layer layer : this.layers) {
                hashSet.add(layer.tileMatrixSet.crs);
            }
        } else {
            for (Layer layer : this.layers) {
                if (!this.currentLayer.name.equals(layer.name)) continue;
                hashSet.add(layer.tileMatrixSet.crs);
            }
        }
        return hashSet;
    }

    private int getTileYMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixHeight != -1) {
            return tileMatrix.matrixHeight;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.north() - eastNorth.north()) / d);
    }

    private int getTileXMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixWidth != -1) {
            return tileMatrix.matrixWidth;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.east() - eastNorth.east()) / d);
    }

    private static final class SelectLayerDialog
    extends ExtendedDialog {
        private final Layer[] layers;
        private final JTable list;

        SelectLayerDialog(Collection<Layer> collection) {
            super(Main.parent, I18n.tr("Select WMTS layer", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.layers = collection.toArray(new Layer[0]);
            this.list = new JTable(new AbstractTableModel(){

                @Override
                public Object getValueAt(int n, int n2) {
                    switch (n2) {
                        case 0: {
                            return SelectLayerDialog.this.layers[n].name;
                        }
                        case 1: {
                            return SelectLayerDialog.this.layers[n].tileMatrixSet.crs;
                        }
                        case 2: {
                            return SelectLayerDialog.this.layers[n].tileMatrixSet.identifier;
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public int getRowCount() {
                    return SelectLayerDialog.this.layers.length;
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return I18n.tr("Layer name", new Object[0]);
                        }
                        case 1: {
                            return I18n.tr("Projection", new Object[0]);
                        }
                        case 2: {
                            return I18n.tr("Matrix set identifier", new Object[0]);
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            });
            this.list.setPreferredSize(new Dimension(400, 400));
            this.list.setSelectionMode(0);
            this.list.setRowSelectionAllowed(true);
            this.list.setColumnSelectionAllowed(false);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.list, GBC.eol().fill());
            this.setContent(jPanel);
        }

        public Layer getSelectedLayer() {
            int n = this.list.getSelectedRow();
            if (n < 0) {
                return null;
            }
            return this.layers[n];
        }
    }

    private static enum TransferMode {
        KVP("KVP"),
        REST("RESTful");

        private final String typeString;

        private TransferMode(String string2) {
            this.typeString = string2;
        }

        private String getTypeString() {
            return this.typeString;
        }

        private static TransferMode fromString(String string) {
            for (TransferMode transferMode : TransferMode.values()) {
                if (!transferMode.getTypeString().equals(string)) continue;
                return transferMode;
            }
            return null;
        }
    }

    private static class Layer {
        private String format;
        private String name;
        private TileMatrixSet tileMatrixSet;
        private String baseUrl;
        private String style;

        private Layer() {
        }
    }

    private static class TileMatrixSet {
        SortedSet<TileMatrix> tileMatrix = new TreeSet<TileMatrix>(new Comparator<TileMatrix>(){

            @Override
            public int compare(TileMatrix tileMatrix, TileMatrix tileMatrix2) {
                return -1 * Double.compare(tileMatrix.scaleDenominator, tileMatrix2.scaleDenominator);
            }
        });
        private String crs;
        private String identifier;

        private TileMatrixSet() {
        }
    }

    private static class TileMatrix {
        private String identifier;
        private double scaleDenominator;
        private EastNorth topLeftCorner;
        private int tileWidth;
        private int tileHeight;
        private int matrixWidth = -1;
        private int matrixHeight = -1;

        private TileMatrix() {
        }
    }
}

