/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import oauth.signpost.OAuthConsumer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthToken {
    private String key;
    private String secret;

    public static OAuthToken createToken(OAuthConsumer oAuthConsumer) {
        return new OAuthToken(oAuthConsumer.getToken(), oAuthConsumer.getTokenSecret());
    }

    public OAuthToken(String string, String string2) {
        this.key = string;
        this.secret = string2;
    }

    public OAuthToken(OAuthToken oAuthToken) {
        CheckParameterUtil.ensureParameterNotNull(oAuthToken, "other");
        this.key = oAuthToken.key;
        this.secret = oAuthToken.secret;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        n = 31 * n + (this.secret == null ? 0 : this.secret.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuthToken oAuthToken = (OAuthToken)object;
        if (this.key == null ? oAuthToken.key != null : !this.key.equals(oAuthToken.key)) {
            return false;
        }
        return !(this.secret == null ? oAuthToken.secret != null : !this.secret.equals(oAuthToken.secret));
    }
}

