/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerHistoryReader
extends OsmServerReader {
    private OsmPrimitiveType primitiveType;
    private long id;

    public OsmServerHistoryReader(OsmPrimitiveType osmPrimitiveType, long l) {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        if (l < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected. Got ''{1}''.", "id", l));
        }
        this.primitiveType = osmPrimitiveType;
        this.id = l;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    /*
     * Loose catch block
     */
    public HistoryDataSet parseHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("");
        try {
            HistoryDataSet historyDataSet;
            Throwable throwable;
            InputStream inputStream;
            block27: {
                block28: {
                    block24: {
                        HistoryDataSet historyDataSet2;
                        block25: {
                            block26: {
                                progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(this.primitiveType.getAPIName()).append('/').append(this.id).append("/history");
                                inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                                throwable = null;
                                if (inputStream != null) break block24;
                                historyDataSet2 = null;
                                if (inputStream == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            inputStream.close();
                        }
                        return historyDataSet2;
                    }
                    progressMonitor.indeterminateSubTask(I18n.tr("Downloading history...", new Object[0]));
                    OsmHistoryReader osmHistoryReader = new OsmHistoryReader(inputStream);
                    historyDataSet = osmHistoryReader.parse(progressMonitor.createSubTaskMonitor(1, true));
                    if (inputStream == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block27;
                }
                inputStream.close();
            }
            return historyDataSet;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (OsmTransferException osmTransferException) {
                    throw osmTransferException;
                }
                catch (Exception exception) {
                    if (this.cancel) {
                        inputStream = null;
                        return inputStream;
                    }
                    throw new OsmTransferException(exception);
                }
            }
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

