/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.net.BindException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Ruby;

public class SelectorFactory {
    private static final int RETRY_MAX = 20;

    public static Selector openWithRetryFrom(Ruby runtime, SelectorProvider provider) throws IOException {
        int retryCount = 0;
        while (true) {
            try {
                return provider.openSelector();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("Unable to establish loopback connection") && e.getCause() instanceof BindException && retryCount < 20) {
                    ++retryCount;
                    if (runtime == null) continue;
                    runtime.getWarnings().warn("try number " + retryCount + " to get a selector");
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

