/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public final class DebugCounter {
    private static final ArrayList<DebugCounter> allCounters = new ArrayList();
    private final String name;
    private final AtomicLong value;

    private DebugCounter(String name) {
        this.name = name;
        this.value = new AtomicLong();
        allCounters.add(this);
    }

    public static DebugCounter create(String name) {
        return new DebugCounter(name);
    }

    public long get() {
        return this.value.get();
    }

    public void inc() {
        this.value.incrementAndGet();
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.value;
    }

    public static void dumpCounters() {
        DebugCounter.dumpCounters(System.out);
    }

    public static void dumpCounters(PrintStream out) {
        for (DebugCounter counter : allCounters) {
            out.println(counter);
        }
    }
}

