/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadHashValueNode
extends PackNode {
    private final Object key;

    public ReadHashValueNode(RubyContext context, Object key) {
        super(context);
        this.key = key;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    public Object read(Object[] source) {
        if (source.length != 1 || !RubyGuards.isRubyHash(source[0])) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("one hash required", this));
        }
        return this.getContext().send(source[0], "fetch", null, this.key);
    }
}

