/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChild(value="array", type=RubyNode.class)
public abstract class ArrayDupNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateNode;

    public ArrayDupNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
    }

    public abstract DynamicObject executeDup(VirtualFrame var1, DynamicObject var2);

    @Specialization(guards={"isRubyArray(from)", "isNullArray(from)"})
    public DynamicObject dupNull(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
    }

    @Specialization(guards={"isRubyArray(from)", "isIntArray(from)"})
    public DynamicObject dupIntegerFixnum(DynamicObject from) {
        int[] store = (int[])Layouts.ARRAY.getStore(from);
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), store.clone(), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isLongArray(from)"})
    public DynamicObject dupLongFixnum(DynamicObject from) {
        long[] store = (long[])Layouts.ARRAY.getStore(from);
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), store.clone(), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isDoubleArray(from)"})
    public DynamicObject dupFloat(DynamicObject from) {
        double[] store = (double[])Layouts.ARRAY.getStore(from);
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), store.clone(), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isObjectArray(from)"})
    public DynamicObject dupObject(DynamicObject from) {
        Object[] store = (Object[])Layouts.ARRAY.getStore(from);
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.copy(store), Layouts.ARRAY.getSize(from));
    }
}

