/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedUnboxedDispatchNode
extends CachedDispatchNode {
    private final Class<?> expectedClass;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;

    public CachedUnboxedDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Class<?> expectedClass, Assumption unmodifiedAssumption, InternalMethod method, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.expectedClass = expectedClass;
        this.unmodifiedAssumption = unmodifiedAssumption;
        this.method = method;
        this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
        this.applySplittingInliningStrategy(this.callNode, method);
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && !(receiver instanceof DynamicObject) && receiver.getClass() == this.expectedClass;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                return CachedUnboxedDispatchNode.call(this.callNode, frame, this.method, receiverObject, blockObject, argumentsObjects);
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }
}

