/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Main;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.Constants;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodesFactory;
import org.jruby.truffle.nodes.core.BindingNodesFactory;
import org.jruby.truffle.nodes.core.ClassNodes;
import org.jruby.truffle.nodes.core.ClassNodesFactory;
import org.jruby.truffle.nodes.core.CoreMethodNodeManager;
import org.jruby.truffle.nodes.core.EncodingConverterNodesFactory;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.EncodingNodesFactory;
import org.jruby.truffle.nodes.core.ExceptionNodes;
import org.jruby.truffle.nodes.core.ExceptionNodesFactory;
import org.jruby.truffle.nodes.core.FalseClassNodesFactory;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.core.FloatNodesFactory;
import org.jruby.truffle.nodes.core.IntegerNodesFactory;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MainNodesFactory;
import org.jruby.truffle.nodes.core.MatchDataNodesFactory;
import org.jruby.truffle.nodes.core.MathNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodesFactory;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.MutexNodesFactory;
import org.jruby.truffle.nodes.core.ObjectSpaceNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodesFactory;
import org.jruby.truffle.nodes.core.ProcessNodesFactory;
import org.jruby.truffle.nodes.core.QueueNodesFactory;
import org.jruby.truffle.nodes.core.RangeNodesFactory;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.SizedQueueNodesFactory;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.SymbolNodesFactory;
import org.jruby.truffle.nodes.core.ThreadBacktraceLocationNodesFactory;
import org.jruby.truffle.nodes.core.ThreadNodesFactory;
import org.jruby.truffle.nodes.core.TimeNodesFactory;
import org.jruby.truffle.nodes.core.TrueClassNodesFactory;
import org.jruby.truffle.nodes.core.TruffleInteropNodesFactory;
import org.jruby.truffle.nodes.core.TrufflePrimitiveNodesFactory;
import org.jruby.truffle.nodes.core.UnboundMethodNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.fixnum.FixnumNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashNodesFactory;
import org.jruby.truffle.nodes.ext.BigDecimalNodesFactory;
import org.jruby.truffle.nodes.ext.DigestNodesFactory;
import org.jruby.truffle.nodes.ext.EtcNodesFactory;
import org.jruby.truffle.nodes.ext.ObjSpaceNodesFactory;
import org.jruby.truffle.nodes.ext.ZlibNodesFactory;
import org.jruby.truffle.nodes.ext.psych.PsychEmitterNodesFactory;
import org.jruby.truffle.nodes.ext.psych.PsychParserNodes;
import org.jruby.truffle.nodes.ext.psych.PsychParserNodesFactory;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.rubinius.AtomicReferenceNodesFactory;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodesFactory;
import org.jruby.truffle.nodes.rubinius.PosixNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusTypeNodesFactory;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.EncodingOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.layouts.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.runtime.layouts.ext.DigestLayoutImpl;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.signal.SignalOperations;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class CoreLibrary {
    private static final String CLI_RECORD_SEPARATOR = (String)Options.CLI_RECORD_SEPARATOR.load();
    private final RubyContext context;
    private final DynamicObject argumentErrorClass;
    private final DynamicObject arrayClass;
    private final DynamicObjectFactory arrayFactory;
    private final DynamicObject basicObjectClass;
    private final DynamicObject bignumClass;
    private final DynamicObjectFactory bignumFactory;
    private final DynamicObject bindingClass;
    private final DynamicObjectFactory bindingFactory;
    private final DynamicObject classClass;
    private final DynamicObject complexClass;
    private final DynamicObject dirClass;
    private final DynamicObject encodingClass;
    private final DynamicObject encodingConverterClass;
    private final DynamicObject encodingErrorClass;
    private final DynamicObject exceptionClass;
    private final DynamicObject falseClass;
    private final DynamicObject fiberClass;
    private final DynamicObject fixnumClass;
    private final DynamicObject floatClass;
    private final DynamicObject floatDomainErrorClass;
    private final DynamicObject hashClass;
    private final DynamicObjectFactory hashFactory;
    private final DynamicObject integerClass;
    private final DynamicObject indexErrorClass;
    private final DynamicObject ioErrorClass;
    private final DynamicObject loadErrorClass;
    private final DynamicObject localJumpErrorClass;
    private final DynamicObject lookupTableClass;
    private final DynamicObject matchDataClass;
    private final DynamicObject moduleClass;
    private final DynamicObject nameErrorClass;
    private final DynamicObject nilClass;
    private final DynamicObject noMethodErrorClass;
    private final DynamicObject notImplementedErrorClass;
    private final DynamicObject numericClass;
    private final DynamicObject objectClass;
    private final DynamicObject procClass;
    private final DynamicObjectFactory procFactory;
    private final DynamicObject processModule;
    private final DynamicObject rangeClass;
    private final DynamicObject rangeErrorClass;
    private final DynamicObject rationalClass;
    private final DynamicObject regexpClass;
    private final DynamicObject regexpErrorClass;
    private final DynamicObject rubyTruffleErrorClass;
    private final DynamicObject runtimeErrorClass;
    private final DynamicObject securityErrorClass;
    private final DynamicObject standardErrorClass;
    private final DynamicObject stringClass;
    private final DynamicObjectFactory stringFactory;
    private final DynamicObject stringDataClass;
    private final DynamicObject symbolClass;
    private final DynamicObject syntaxErrorClass;
    private final DynamicObject systemCallErrorClass;
    private final DynamicObject systemExitClass;
    private final DynamicObject threadClass;
    private final DynamicObject threadBacktraceClass;
    private final DynamicObject threadBacktraceLocationClass;
    private final DynamicObject timeClass;
    private final DynamicObjectFactory timeFactory;
    private final DynamicObject transcodingClass;
    private final DynamicObject trueClass;
    private final DynamicObject tupleClass;
    private final DynamicObject typeErrorClass;
    private final DynamicObject zeroDivisionErrorClass;
    private final DynamicObject enumerableModule;
    private final DynamicObject errnoModule;
    private final DynamicObject kernelModule;
    private final DynamicObject rubiniusModule;
    private final DynamicObject rubiniusChannelClass;
    private final DynamicObject rubiniusFFIModule;
    private final DynamicObject rubiniusFFIPointerClass;
    private final DynamicObject rubiniusMirrorClass;
    private final DynamicObject signalModule;
    private final DynamicObject truffleModule;
    private final DynamicObject bigDecimalClass;
    private final DynamicObject encodingCompatibilityErrorClass;
    private final DynamicObject methodClass;
    private final DynamicObjectFactory methodFactory;
    private final DynamicObject unboundMethodClass;
    private final DynamicObjectFactory unboundMethodFactory;
    private final DynamicObject byteArrayClass;
    private final DynamicObjectFactory byteArrayFactory;
    private final DynamicObject fiberErrorClass;
    private final DynamicObject threadErrorClass;
    private final DynamicObject internalBufferClass;
    private final DynamicObject weakRefClass;
    private final DynamicObjectFactory weakRefFactory;
    private final DynamicObject objectSpaceModule;
    private final DynamicObject psychModule;
    private final DynamicObject psychParserClass;
    private final DynamicObject randomizerClass;
    private final DynamicObjectFactory randomizerFactory;
    private final DynamicObject atomicReferenceClass;
    private final DynamicObject argv;
    private final DynamicObject globalVariablesObject;
    private final DynamicObject mainObject;
    private final DynamicObject nilObject;
    private final DynamicObject rubiniusUndefined;
    private final DynamicObject digestClass;
    @CompilerDirectives.CompilationFinal
    private ArrayNodes.MinBlock arrayMinBlock;
    @CompilerDirectives.CompilationFinal
    private ArrayNodes.MaxBlock arrayMaxBlock;
    private final DynamicObject rubyInternalMethod;
    private final Map<Errno, DynamicObject> errnoClasses = new HashMap<Errno, DynamicObject>();
    @CompilerDirectives.CompilationFinal
    private InternalMethod basicObjectSendMethod;
    private State state = State.INITIALIZING;
    private final DynamicObjectFactory integerFixnumRangeFactory;
    private final DynamicObjectFactory longFixnumRangeFactory;
    private final CoreLibraryNode node;

    public String getCoreLoadPath() {
        String path = this.context.getOptions().CORE_LOAD_PATH;
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("truffle:")) {
            return path;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CoreLibrary(RubyContext context) {
        this.context = context;
        this.node = new CoreLibraryNode(context, new CoreSourceSection("CoreLibrary", "initialize"));
        this.classClass = ClassNodes.createClassClass(context);
        this.basicObjectClass = ClassNodes.createBootClass(context, this.classClass, null, "BasicObject");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.basicObjectClass, Layouts.BASIC_OBJECT.createBasicObjectShape(this.basicObjectClass, this.basicObjectClass));
        this.objectClass = ClassNodes.createBootClass(context, this.classClass, this.basicObjectClass, "Object");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.objectClass, Layouts.BASIC_OBJECT.createBasicObjectShape(this.objectClass, this.objectClass));
        this.moduleClass = ClassNodes.createBootClass(context, this.classClass, this.objectClass, "Module");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.moduleClass, Layouts.MODULE.createModuleShape(this.moduleClass, this.moduleClass));
        Layouts.MODULE.getFields((DynamicObject)this.classClass).parentModule = Layouts.MODULE.getFields((DynamicObject)this.moduleClass).start;
        Layouts.MODULE.getFields(this.moduleClass).addDependent(this.classClass);
        Layouts.MODULE.getFields(this.classClass).newVersion();
        Layouts.MODULE.getFields(this.classClass).getAdoptedByLexicalParent(context, this.objectClass, "Class", this.node);
        Layouts.MODULE.getFields(this.basicObjectClass).getAdoptedByLexicalParent(context, this.objectClass, "BasicObject", this.node);
        Layouts.MODULE.getFields(this.objectClass).getAdoptedByLexicalParent(context, this.objectClass, "Object", this.node);
        Layouts.MODULE.getFields(this.moduleClass).getAdoptedByLexicalParent(context, this.objectClass, "Module", this.node);
        this.exceptionClass = this.defineClass("Exception");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.exceptionClass, Layouts.EXCEPTION.createExceptionShape(this.exceptionClass, this.exceptionClass));
        this.defineClass(this.exceptionClass, "NoMemoryError");
        this.rubyTruffleErrorClass = this.defineClass(this.exceptionClass, "RubyTruffleError");
        this.standardErrorClass = this.defineClass(this.exceptionClass, "StandardError");
        this.argumentErrorClass = this.defineClass(this.standardErrorClass, "ArgumentError");
        this.encodingErrorClass = this.defineClass(this.standardErrorClass, "EncodingError");
        this.fiberErrorClass = this.defineClass(this.standardErrorClass, "FiberError");
        this.ioErrorClass = this.defineClass(this.standardErrorClass, "IOError");
        this.localJumpErrorClass = this.defineClass(this.standardErrorClass, "LocalJumpError");
        this.regexpErrorClass = this.defineClass(this.standardErrorClass, "RegexpError");
        this.runtimeErrorClass = this.defineClass(this.standardErrorClass, "RuntimeError");
        this.threadErrorClass = this.defineClass(this.standardErrorClass, "ThreadError");
        this.typeErrorClass = this.defineClass(this.standardErrorClass, "TypeError");
        this.zeroDivisionErrorClass = this.defineClass(this.standardErrorClass, "ZeroDivisionError");
        this.rangeErrorClass = this.defineClass(this.standardErrorClass, "RangeError");
        this.floatDomainErrorClass = this.defineClass(this.rangeErrorClass, "FloatDomainError");
        this.indexErrorClass = this.defineClass(this.standardErrorClass, "IndexError");
        this.defineClass(this.indexErrorClass, "KeyError");
        this.defineClass(this.ioErrorClass, "EOFError");
        this.nameErrorClass = this.defineClass(this.standardErrorClass, "NameError");
        this.noMethodErrorClass = this.defineClass(this.nameErrorClass, "NoMethodError");
        this.systemCallErrorClass = this.defineClass(this.standardErrorClass, "SystemCallError");
        this.errnoModule = this.defineModule("Errno");
        for (Errno errno : Errno.values()) {
            if (!errno.name().startsWith("E")) continue;
            this.errnoClasses.put(errno, this.defineClass(this.errnoModule, this.systemCallErrorClass, errno.name()));
        }
        DynamicObject scriptErrorClass = this.defineClass(this.exceptionClass, "ScriptError");
        this.loadErrorClass = this.defineClass(scriptErrorClass, "LoadError");
        this.notImplementedErrorClass = this.defineClass(scriptErrorClass, "NotImplementedError");
        this.syntaxErrorClass = this.defineClass(scriptErrorClass, "SyntaxError");
        this.securityErrorClass = this.defineClass(this.exceptionClass, "SecurityError");
        DynamicObject signalExceptionClass = this.defineClass(this.exceptionClass, "SignalException");
        this.defineClass(signalExceptionClass, "Interrupt");
        this.systemExitClass = this.defineClass(this.exceptionClass, "SystemExit");
        this.defineClass(this.exceptionClass, "SystemStackError");
        this.numericClass = this.defineClass("Numeric");
        this.complexClass = this.defineClass(this.numericClass, "Complex");
        this.floatClass = this.defineClass(this.numericClass, "Float");
        this.integerClass = this.defineClass(this.numericClass, "Integer");
        this.fixnumClass = this.defineClass(this.integerClass, "Fixnum");
        this.bignumClass = this.defineClass(this.integerClass, "Bignum");
        this.bignumFactory = Layouts.BIGNUM.createBignumShape(this.bignumClass, this.bignumClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bignumClass, this.bignumFactory);
        this.rationalClass = this.defineClass(this.numericClass, "Rational");
        this.arrayClass = this.defineClass("Array");
        this.arrayFactory = Layouts.ARRAY.createArrayShape(this.arrayClass, this.arrayClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.arrayClass, this.arrayFactory);
        this.bindingClass = this.defineClass("Binding");
        this.bindingFactory = Layouts.BINDING.createBindingShape(this.bindingClass, this.bindingClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bindingClass, this.bindingFactory);
        this.dirClass = this.defineClass("Dir");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.dirClass, Layouts.DIR.createDirShape(this.dirClass, this.dirClass));
        this.encodingClass = this.defineClass("Encoding");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.encodingClass, Layouts.ENCODING.createEncodingShape(this.encodingClass, this.encodingClass));
        this.falseClass = this.defineClass("FalseClass");
        this.fiberClass = this.defineClass("Fiber");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.fiberClass, Layouts.FIBER.createFiberShape(this.fiberClass, this.fiberClass));
        this.defineModule("FileTest");
        this.hashClass = this.defineClass("Hash");
        this.hashFactory = Layouts.HASH.createHashShape(this.hashClass, this.hashClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.hashClass, this.hashFactory);
        this.matchDataClass = this.defineClass("MatchData");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.matchDataClass, Layouts.MATCH_DATA.createMatchDataShape(this.matchDataClass, this.matchDataClass));
        this.methodClass = this.defineClass("Method");
        this.methodFactory = Layouts.METHOD.createMethodShape(this.methodClass, this.methodClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.methodClass, this.methodFactory);
        DynamicObject mutexClass = this.defineClass("Mutex");
        Layouts.CLASS.setInstanceFactoryUnsafe(mutexClass, Layouts.MUTEX.createMutexShape(mutexClass, mutexClass));
        this.nilClass = this.defineClass("NilClass");
        this.procClass = this.defineClass("Proc");
        this.procFactory = Layouts.PROC.createProcShape(this.procClass, this.procClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.procClass, this.procFactory);
        this.processModule = this.defineModule("Process");
        DynamicObject queueClass = this.defineClass("Queue");
        Layouts.CLASS.setInstanceFactoryUnsafe(queueClass, Layouts.QUEUE.createQueueShape(queueClass, queueClass));
        DynamicObject sizedQueueClass = this.defineClass(queueClass, "SizedQueue");
        Layouts.CLASS.setInstanceFactoryUnsafe(sizedQueueClass, Layouts.SIZED_QUEUE.createSizedQueueShape(sizedQueueClass, sizedQueueClass));
        this.rangeClass = this.defineClass("Range");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.rangeClass, Layouts.OBJECT_RANGE.createObjectRangeShape(this.rangeClass, this.rangeClass));
        this.integerFixnumRangeFactory = Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRangeShape(this.rangeClass, this.rangeClass);
        this.longFixnumRangeFactory = Layouts.LONG_FIXNUM_RANGE.createLongFixnumRangeShape(this.rangeClass, this.rangeClass);
        this.regexpClass = this.defineClass("Regexp");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.regexpClass, Layouts.REGEXP.createRegexpShape(this.regexpClass, this.regexpClass));
        this.stringClass = this.defineClass("String");
        this.stringFactory = Layouts.STRING.createStringShape(this.stringClass, this.stringClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.stringClass, this.stringFactory);
        this.symbolClass = this.defineClass("Symbol");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.symbolClass, Layouts.SYMBOL.createSymbolShape(this.symbolClass, this.symbolClass));
        this.threadClass = this.defineClass("Thread");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.threadClass, Layouts.THREAD.createThreadShape(this.threadClass, this.threadClass));
        this.threadBacktraceClass = this.defineClass(this.threadClass, this.objectClass, "Backtrace");
        this.threadBacktraceLocationClass = this.defineClass(this.threadBacktraceClass, this.objectClass, "Location");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.threadBacktraceLocationClass, ThreadBacktraceLocationLayoutImpl.INSTANCE.createThreadBacktraceLocationShape(this.threadBacktraceLocationClass, this.threadBacktraceLocationClass));
        this.timeClass = this.defineClass("Time");
        this.timeFactory = Layouts.TIME.createTimeShape(this.timeClass, this.timeClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.timeClass, this.timeFactory);
        this.trueClass = this.defineClass("TrueClass");
        this.unboundMethodClass = this.defineClass("UnboundMethod");
        this.unboundMethodFactory = Layouts.UNBOUND_METHOD.createUnboundMethodShape(this.unboundMethodClass, this.unboundMethodClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.unboundMethodClass, this.unboundMethodFactory);
        DynamicObject ioClass = this.defineClass("IO");
        Layouts.CLASS.setInstanceFactoryUnsafe(ioClass, Layouts.IO.createIOShape(ioClass, ioClass));
        this.internalBufferClass = this.defineClass(ioClass, this.objectClass, "InternalBuffer");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.internalBufferClass, Layouts.IO_BUFFER.createIOBufferShape(this.internalBufferClass, this.internalBufferClass));
        this.weakRefClass = this.defineClass("WeakRef");
        this.weakRefFactory = Layouts.WEAK_REF_LAYOUT.createWeakRefShape(this.weakRefClass, this.weakRefClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.weakRefClass, this.weakRefFactory);
        DynamicObject comparableModule = this.defineModule("Comparable");
        this.defineModule("Config");
        this.enumerableModule = this.defineModule("Enumerable");
        this.defineModule("GC");
        this.kernelModule = this.defineModule("Kernel");
        this.defineModule("Math");
        this.objectSpaceModule = this.defineModule("ObjectSpace");
        this.signalModule = this.defineModule("Signal");
        this.encodingCompatibilityErrorClass = this.defineClass(this.encodingClass, this.encodingErrorClass, "CompatibilityError");
        this.encodingConverterClass = this.defineClass(this.encodingClass, this.objectClass, "Converter");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.encodingConverterClass, Layouts.ENCODING_CONVERTER.createEncodingConverterShape(this.encodingConverterClass, this.encodingConverterClass));
        this.truffleModule = this.defineModule("Truffle");
        this.defineModule(this.truffleModule, "Interop");
        this.defineModule(this.truffleModule, "Debug");
        this.defineModule(this.truffleModule, "Primitive");
        this.defineModule(this.truffleModule, "Digest");
        this.defineModule(this.truffleModule, "Zlib");
        this.defineModule(this.truffleModule, "ObjSpace");
        this.defineModule(this.truffleModule, "Etc");
        this.psychModule = this.defineModule("Psych");
        this.psychParserClass = this.defineClass(this.psychModule, this.objectClass, "Parser");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.psychParserClass, Layouts.PSYCH_PARSER.createParserShape(this.psychParserClass, this.psychParserClass));
        DynamicObject psychHandlerClass = this.defineClass(this.psychModule, this.objectClass, "Handler");
        DynamicObject psychEmitterClass = this.defineClass(this.psychModule, psychHandlerClass, "Emitter");
        Layouts.CLASS.setInstanceFactoryUnsafe(psychEmitterClass, Layouts.PSYCH_EMITTER.createEmitterShape(psychEmitterClass, psychEmitterClass));
        this.bigDecimalClass = this.defineClass(this.truffleModule, this.numericClass, "BigDecimal");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bigDecimalClass, Layouts.BIG_DECIMAL.createBigDecimalShape(this.bigDecimalClass, this.bigDecimalClass));
        this.rubiniusModule = this.defineModule("Rubinius");
        this.rubiniusFFIModule = this.defineModule(this.rubiniusModule, "FFI");
        this.defineModule(this.defineModule(this.rubiniusFFIModule, "Platform"), "POSIX");
        this.rubiniusFFIPointerClass = this.defineClass(this.rubiniusFFIModule, this.objectClass, "Pointer");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.rubiniusFFIPointerClass, Layouts.POINTER.createPointerShape(this.rubiniusFFIPointerClass, this.rubiniusFFIPointerClass));
        this.rubiniusChannelClass = this.defineClass(this.rubiniusModule, this.objectClass, "Channel");
        this.rubiniusMirrorClass = this.defineClass(this.rubiniusModule, this.objectClass, "Mirror");
        this.defineModule(this.rubiniusModule, "Type");
        this.byteArrayClass = this.defineClass(this.rubiniusModule, this.objectClass, "ByteArray");
        this.byteArrayFactory = Layouts.BYTE_ARRAY.createByteArrayShape(this.byteArrayClass, this.byteArrayClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.byteArrayClass, this.byteArrayFactory);
        this.lookupTableClass = this.defineClass(this.rubiniusModule, this.hashClass, "LookupTable");
        this.stringDataClass = this.defineClass(this.rubiniusModule, this.objectClass, "StringData");
        this.transcodingClass = this.defineClass(this.encodingClass, this.objectClass, "Transcoding");
        this.tupleClass = this.defineClass(this.rubiniusModule, this.arrayClass, "Tuple");
        this.randomizerClass = this.defineClass(this.rubiniusModule, this.objectClass, "Randomizer");
        this.atomicReferenceClass = this.defineClass(this.rubiniusModule, this.objectClass, "AtomicReference");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.atomicReferenceClass, Layouts.ATOMIC_REFERENCE.createAtomicReferenceShape(this.atomicReferenceClass, this.atomicReferenceClass));
        this.randomizerFactory = Layouts.RANDOMIZER.createRandomizerShape(this.randomizerClass, this.randomizerClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.randomizerClass, this.randomizerFactory);
        this.rubyInternalMethod = null;
        this.includeModules(comparableModule);
        this.mainObject = Layouts.CLASS.getInstanceFactory(this.objectClass).newInstance(new Object[0]);
        this.nilObject = Layouts.CLASS.getInstanceFactory(this.nilClass).newInstance(new Object[0]);
        this.argv = Layouts.ARRAY.createArray(Layouts.CLASS.getInstanceFactory(this.arrayClass), null, 0);
        this.rubiniusUndefined = Layouts.CLASS.getInstanceFactory(this.objectClass).newInstance(new Object[0]);
        this.globalVariablesObject = Layouts.CLASS.getInstanceFactory(this.objectClass).newInstance(new Object[0]);
        this.digestClass = this.defineClass(this.truffleModule, this.basicObjectClass, "Digest");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.digestClass, DigestLayoutImpl.INSTANCE.createDigestShape(this.digestClass, this.digestClass));
    }

    private void includeModules(DynamicObject comparableModule) {
        assert (RubyGuards.isRubyModule(comparableModule));
        Layouts.MODULE.getFields(this.objectClass).include(this.context, this.node, this.kernelModule);
        Layouts.MODULE.getFields(this.numericClass).include(this.context, this.node, comparableModule);
        Layouts.MODULE.getFields(this.symbolClass).include(this.context, this.node, comparableModule);
        Layouts.MODULE.getFields(this.arrayClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.dirClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.hashClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.rangeClass).include(this.context, this.node, this.enumerableModule);
    }

    public void initialize() {
        this.addCoreMethods();
        this.initializeGlobalVariables();
        this.initializeConstants();
        this.initializeEncodingConstants();
        this.initializeSignalConstants();
    }

    private void addCoreMethods() {
        this.arrayMinBlock = new ArrayNodes.MinBlock(this.context);
        this.arrayMaxBlock = new ArrayNodes.MaxBlock(this.context);
        CoreMethodNodeManager coreMethodNodeManager = new CoreMethodNodeManager(this.context, this.node.getSingletonClassNode());
        Main.printTruffleTimeMetric((String)"before-load-truffle-nodes");
        coreMethodNodeManager.addCoreMethodNodes(ArrayNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BasicObjectNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BindingNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BignumNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ExceptionNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FalseClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FiberNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FixnumNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FloatNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(HashNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(IntegerNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(KernelNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MainNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MatchDataNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MathNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ModuleNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MutexNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ObjectSpaceNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ProcessNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ProcNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(QueueNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RangeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RegexpNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(SizedQueueNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(StringNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(SymbolNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ThreadNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TrueClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TrufflePrimitiveNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(EncodingNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(EncodingConverterNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TruffleInteropNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MethodNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(UnboundMethodNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ByteArrayNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TimeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(PosixNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RubiniusTypeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ThreadBacktraceLocationNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(DigestNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BigDecimalNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ZlibNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ObjSpaceNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(EtcNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(PsychParserNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(PsychEmitterNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(AtomicReferenceNodesFactory.getFactories());
        Main.printTruffleTimeMetric((String)"after-load-truffle-nodes");
        coreMethodNodeManager.allMethodInstalled();
        this.basicObjectSendMethod = Layouts.MODULE.getFields(this.basicObjectClass).getMethods().get("__send__");
        assert (this.basicObjectSendMethod != null);
    }

    private void initializeGlobalVariables() {
        DynamicObject globals = this.globalVariablesObject;
        globals.define("$LOAD_PATH", Layouts.ARRAY.createArray(Layouts.CLASS.getInstanceFactory(this.arrayClass), null, 0), 0);
        globals.define("$LOADED_FEATURES", Layouts.ARRAY.createArray(Layouts.CLASS.getInstanceFactory(this.arrayClass), null, 0), 0);
        globals.define("$:", globals.get("$LOAD_PATH", this.nilObject), 0);
        globals.define("$\"", globals.get("$LOADED_FEATURES", this.nilObject), 0);
        globals.define("$,", this.nilObject, 0);
        globals.define("$*", this.argv, 0);
        globals.define("$0", StringOperations.createString(this.context, StringOperations.encodeByteList(this.context.getRuntime().getInstanceConfig().displayedFileName(), (Encoding)UTF8Encoding.INSTANCE)), 0);
        globals.define("$DEBUG", this.context.getRuntime().isDebug(), 0);
        DynamicObject value = this.context.getRuntime().warningsEnabled() ? Boolean.valueOf(this.context.getRuntime().isVerbose()) : this.nilObject;
        globals.define("$VERBOSE", value, 0);
        DynamicObject defaultRecordSeparator = StringOperations.createString(this.context, StringOperations.encodeByteList(CLI_RECORD_SEPARATOR, (Encoding)UTF8Encoding.INSTANCE));
        this.node.freezeNode.executeFreeze(defaultRecordSeparator);
        globals.define("$/", defaultRecordSeparator, 0);
        globals.define("$SAFE", 0, 0);
    }

    private void initializeConstants() {
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_VERSION", StringOperations.createString(this.context, StringOperations.encodeByteList("2.2.2", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "JRUBY_VERSION", StringOperations.createString(this.context, StringOperations.encodeByteList("9.0.4.0", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_PATCHLEVEL", 0);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_REVISION", Constants.RUBY_REVISION);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_ENGINE", StringOperations.createString(this.context, StringOperations.encodeByteList("jruby+truffle", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_PLATFORM", StringOperations.createString(this.context, StringOperations.encodeByteList("java", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_RELEASE_DATE", StringOperations.createString(this.context, StringOperations.encodeByteList("2015-11-12", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_DESCRIPTION", StringOperations.createString(this.context, StringOperations.encodeByteList(OutputStrings.getVersionString(), (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_COPYRIGHT", StringOperations.createString(this.context, StringOperations.encodeByteList(OutputStrings.getCopyrightString(), (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.basicObjectClass).setConstant(this.context, this.node, "BasicObject", this.basicObjectClass);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "ARGV", this.argv);
        Layouts.MODULE.getFields(this.rubiniusModule).setConstant(this.context, this.node, "UNDEFINED", this.rubiniusUndefined);
        Layouts.MODULE.getFields(this.rubiniusModule).setConstant(this.context, this.node, "LIBC", Platform.LIBC);
        Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_MONOTONIC", 1);
        Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_REALTIME", 2);
        if (Platform.getPlatform().getOS() == Platform.OS_TYPE.LINUX) {
            Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_THREAD_CPUTIME_ID", 3);
            Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_MONOTONIC_RAW", 4);
        }
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "INVALID_MASK", 15);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "INVALID_REPLACE", 2);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_MASK", 240);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_REPLACE", 32);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_HEX_CHARREF", 48);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "PARTIAL_INPUT", 65536);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "AFTER_OUTPUT", 131072);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNIVERSAL_NEWLINE_DECORATOR", 256);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "CRLF_NEWLINE_DECORATOR", 4096);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "CR_NEWLINE_DECORATOR", 8192);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_TEXT_DECORATOR", 16384);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_ATTR_CONTENT_DECORATOR", 32768);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_ATTR_QUOTE_DECORATOR", 0x100000);
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "ANY", PsychParserNodes.YAMLEncoding.YAML_ANY_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF8", PsychParserNodes.YAMLEncoding.YAML_UTF8_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF16LE", PsychParserNodes.YAMLEncoding.YAML_UTF16LE_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF16BE", PsychParserNodes.YAMLEncoding.YAML_UTF16BE_ENCODING.ordinal());
    }

    private void initializeSignalConstants() {
        Object[] signals = new Object[SignalOperations.SIGNALS_LIST.size()];
        int i = 0;
        for (Map.Entry<String, Integer> signal : SignalOperations.SIGNALS_LIST.entrySet()) {
            DynamicObject signalName = StringOperations.createString(this.context, StringOperations.encodeByteList(signal.getKey(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{signalName, signal.getValue()};
            signals[i++] = Layouts.ARRAY.createArray(Layouts.CLASS.getInstanceFactory(this.arrayClass), objects, objects.length);
        }
        Layouts.MODULE.getFields(this.signalModule).setConstant(this.context, this.node, "SIGNAL_LIST", Layouts.ARRAY.createArray(Layouts.CLASS.getInstanceFactory(this.arrayClass), signals, signals.length));
    }

    private DynamicObject defineClass(String name) {
        return this.defineClass(this.objectClass, name);
    }

    private DynamicObject defineClass(DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyClass(superclass));
        return ClassNodes.createRubyClass(this.context, this.objectClass, superclass, name);
    }

    private DynamicObject defineClass(DynamicObject lexicalParent, DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyModule(lexicalParent));
        assert (RubyGuards.isRubyClass(superclass));
        return ClassNodes.createRubyClass(this.context, lexicalParent, superclass, name);
    }

    private DynamicObject defineModule(String name) {
        return this.defineModule(this.objectClass, name);
    }

    private DynamicObject defineModule(DynamicObject lexicalParent, String name) {
        assert (RubyGuards.isRubyModule(lexicalParent));
        return ModuleNodes.createRubyModule(this.context, this.moduleClass, lexicalParent, name, this.node);
    }

    public void initializeAfterMethodsAdded() {
        this.initializeRubiniusFFI();
        try {
            Main.printTruffleTimeMetric((String)"before-load-truffle-core");
            this.state = State.LOADING_RUBY_CORE;
            try {
                this.context.load(this.context.getSourceCache().getSource(this.getCoreLoadPath() + "/core.rb"), this.node);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Main.printTruffleTimeMetric((String)"after-load-truffle-core");
        }
        catch (RaiseException e) {
            DynamicObject rubyException = e.getRubyException();
            BacktraceFormatter.createDefaultFormatter(this.getContext()).printBacktrace(rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
            throw new TruffleFatalException("couldn't load the core library", e);
        }
        finally {
            this.state = State.LOADED;
        }
    }

    private void initializeRubiniusFFI() {
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_CHAR", 0);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_UCHAR", 1);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_BOOL", 2);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_SHORT", 3);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_USHORT", 4);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_INT", 5);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_UINT", 6);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_LONG", 7);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ULONG", 8);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_LL", 9);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ULL", 10);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_FLOAT", 11);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_DOUBLE", 12);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_PTR", 13);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_VOID", 14);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_STRING", 15);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_STRPTR", 16);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_CHARARR", 17);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ENUM", 18);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_VARARGS", 19);
    }

    public void initializeEncodingConstants() {
        this.getContext().getRuntime().getEncodingService().defineEncodings(new EncodingService.EncodingDefinitionVisitor(){

            public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name, int p, int end) {
                DynamicObject re = EncodingNodes.newEncoding(CoreLibrary.this.encodingClass, null, name, p, end, encodingEntry.isDummy());
                EncodingNodes.storeEncoding(encodingEntry.getIndex(), re);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                Layouts.MODULE.getFields(CoreLibrary.this.encodingClass).setConstant(CoreLibrary.this.context, CoreLibrary.this.node, constName, EncodingNodes.getEncoding(encodingListIndex));
            }
        });
        this.getContext().getRuntime().getEncodingService().defineAliases(new EncodingService.EncodingAliasVisitor(){

            public void defineAlias(int encodingListIndex, String constName) {
                DynamicObject re = EncodingNodes.getEncoding(encodingListIndex);
                EncodingNodes.storeAlias(constName, re);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                Layouts.MODULE.getFields(CoreLibrary.this.encodingClass).setConstant(CoreLibrary.this.context, CoreLibrary.this.node, constName, EncodingNodes.getEncoding(encodingListIndex));
            }
        });
    }

    public DynamicObject getMetaClass(Object object) {
        if (object instanceof DynamicObject) {
            return Layouts.BASIC_OBJECT.getMetaClass((DynamicObject)object);
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException("Can't get metaclass for null");
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException(String.format("Don't know how to get the metaclass for %s", object.getClass()));
    }

    public DynamicObject getLogicalClass(Object object) {
        if (object instanceof DynamicObject) {
            return Layouts.BASIC_OBJECT.getLogicalClass((DynamicObject)object);
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException();
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException(String.format("Don't know how to get the logical class for %s", object.getClass()));
    }

    public static double toDouble(Object value, DynamicObject nil) {
        assert (value != null);
        if (value == nil) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (RubyGuards.isRubyBignum(value)) {
            return Layouts.BIGNUM.getValue((DynamicObject)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException();
    }

    public static boolean fitsIntoInteger(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    public DynamicObject runtimeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.runtimeErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject frozenError(String className, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.runtimeError(String.format("can't modify frozen %s", className), currentNode);
    }

    public DynamicObject argumentError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.argumentErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject argumentErrorOutOfRange(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError("out of range", currentNode);
    }

    public DynamicObject argumentErrorInvalidRadix(int radix, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("invalid radix %d", radix), currentNode);
    }

    public DynamicObject argumentErrorMissingKeyword(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("missing keyword: %s", name), currentNode);
    }

    public DynamicObject argumentError(int passed, int required, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d)", passed, required), currentNode);
    }

    public DynamicObject argumentError(int passed, int required, int optional, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d..%d)", passed, required, required + optional), currentNode);
    }

    public DynamicObject argumentErrorEmptyVarargs(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError("wrong number of arguments (0 for 1+)", currentNode);
    }

    public DynamicObject argumentErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = Layouts.MODULE.getFields(this.getLogicalClass(object)).getName();
        return this.argumentError(String.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    public DynamicObject errnoError(int errno, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        Errno errnoObj = Errno.valueOf((long)errno);
        if (errnoObj == null) {
            return this.systemCallError(String.format("Unknown Error (%s)", errno), currentNode);
        }
        return ExceptionNodes.createRubyException(this.getErrnoClass(errnoObj), StringOperations.createString(this.context, StringOperations.encodeByteList(errnoObj.description(), (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject errnoError(int errno, String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        Errno errnoObj = Errno.valueOf((long)errno);
        if (errnoObj == null) {
            return this.systemCallError(String.format("Unknown Error (%s) - %s", errno, message), currentNode);
        }
        DynamicObject errorMessage = StringOperations.createString(this.context, StringOperations.encodeByteList(String.format("%s - %s", errnoObj.description(), message), (Encoding)UTF8Encoding.INSTANCE));
        return ExceptionNodes.createRubyException(this.getErrnoClass(errnoObj), errorMessage, RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject indexError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.indexErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject indexTooSmallError(String type, int index, int length, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.indexError(String.format("index %d too small for %s; minimum: -%d", index, type, length), currentNode);
    }

    public DynamicObject localJumpError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.localJumpErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject noBlockGiven(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("no block given", currentNode);
    }

    public DynamicObject breakFromProcClosure(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("break from proc-closure", currentNode);
    }

    public DynamicObject unexpectedReturn(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("unexpected return", currentNode);
    }

    public DynamicObject noBlockToYieldTo(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("no block given (yield)", currentNode);
    }

    public DynamicObject typeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.typeErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject typeErrorAllocatorUndefinedFor(DynamicObject rubyClass, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String className = Layouts.MODULE.getFields(rubyClass).getName();
        return this.typeError(String.format("allocator undefined for %s", className), currentNode);
    }

    public DynamicObject typeErrorCantDefineSingleton(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError("can't define singleton", currentNode);
    }

    public DynamicObject typeErrorShouldReturn(String object, String method, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s#%s should return %s", object, method, expectedType), currentNode);
    }

    public DynamicObject typeErrorCantConvertTo(Object from, String toClass, String methodUsed, Object result, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String fromClass = Layouts.MODULE.getFields(this.getLogicalClass(from)).getName();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", fromClass, toClass, fromClass, methodUsed, this.getLogicalClass(result).toString()), currentNode);
    }

    public DynamicObject typeErrorCantConvertInto(Object from, String toClass, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("can't convert %s into %s", Layouts.MODULE.getFields(this.getLogicalClass(from)).getName(), toClass), currentNode);
    }

    public DynamicObject typeErrorIsNotA(String value, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s is not a %s", value, expectedType), currentNode);
    }

    public DynamicObject typeErrorNoImplicitConversion(Object from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("no implicit conversion of %s into %s", Layouts.MODULE.getFields(this.getLogicalClass(from)).getName(), to), currentNode);
    }

    public DynamicObject typeErrorMustBe(String variable, String type, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("value of %s must be %s", variable, type), currentNode);
    }

    public DynamicObject typeErrorBadCoercion(Object from, String to, String coercionMethod, Object coercedTo, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = Layouts.MODULE.getFields(this.getLogicalClass(from)).getName();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", badClassName, to, badClassName, coercionMethod, Layouts.MODULE.getFields(this.getLogicalClass(coercedTo)).getName()), currentNode);
    }

    public DynamicObject typeErrorCantDump(Object object, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String logicalClass = Layouts.MODULE.getFields(this.getLogicalClass(object)).getName();
        return this.typeError(String.format("can't dump %s", logicalClass), currentNode);
    }

    public DynamicObject typeErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = Layouts.MODULE.getFields(this.getLogicalClass(object)).getName();
        return this.typeError(String.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    public DynamicObject nameError(String message, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject nameString = StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject nameError = ExceptionNodes.createRubyException(this.nameErrorClass, nameString, RubyCallStack.getBacktrace(currentNode));
        nameError.define("@name", this.context.getSymbolTable().getSymbol(name), 0);
        return nameError;
    }

    public DynamicObject nameErrorConstantNotDefined(DynamicObject module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("constant %s::%s not defined", Layouts.MODULE.getFields(module).getName(), name), name, currentNode);
    }

    public DynamicObject nameErrorUninitializedConstant(DynamicObject module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        String message = module == this.objectClass ? String.format("uninitialized constant %s", name) : String.format("uninitialized constant %s::%s", Layouts.MODULE.getFields(module).getName(), name);
        return this.nameError(message, name, currentNode);
    }

    public DynamicObject nameErrorUninitializedClassVariable(DynamicObject module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(String.format("uninitialized class variable %s in %s", name, Layouts.MODULE.getFields(module).getName()), name, currentNode);
    }

    public DynamicObject nameErrorPrivateConstant(DynamicObject module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(String.format("private constant %s::%s referenced", Layouts.MODULE.getFields(module).getName(), name), name, currentNode);
    }

    public DynamicObject nameErrorInstanceNameNotAllowable(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("`%s' is not allowable as an instance variable name", name), name, currentNode);
    }

    public DynamicObject nameErrorInstanceVariableNotDefined(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("instance variable %s not defined", name), name, currentNode);
    }

    public DynamicObject nameErrorReadOnly(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("%s is a read-only variable", name), name, currentNode);
    }

    public DynamicObject nameErrorUndefinedLocalVariableOrMethod(String name, Object receiver, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String className = Layouts.MODULE.getFields(this.getLogicalClass(receiver)).getName();
        return this.nameError(String.format("undefined local variable or method `%s' for %s", name, className), name, currentNode);
    }

    public DynamicObject nameErrorUndefinedMethod(String name, DynamicObject module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(String.format("undefined method `%s' for %s", name, Layouts.MODULE.getFields(module).getName()), name, currentNode);
    }

    public DynamicObject nameErrorMethodNotDefinedIn(DynamicObject module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("method `%s' not defined in %s", name, Layouts.MODULE.getFields(module).getName()), name, currentNode);
    }

    public DynamicObject nameErrorPrivateMethod(String name, DynamicObject module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("method `%s' for %s is private", name, Layouts.MODULE.getFields(module).getName()), name, currentNode);
    }

    public DynamicObject nameErrorLocalVariableNotDefined(String name, DynamicObject binding, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyBinding(binding));
        return this.nameError(String.format("local variable `%s' not defined for %s", name, binding.toString()), name, currentNode);
    }

    public DynamicObject nameErrorClassVariableNotDefined(String name, DynamicObject module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(String.format("class variable `%s' not defined for %s", name, Layouts.MODULE.getFields(module).getName()), name, currentNode);
    }

    public DynamicObject noMethodError(String message, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject messageString = StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject noMethodError = ExceptionNodes.createRubyException(this.context.getCoreLibrary().getNoMethodErrorClass(), messageString, RubyCallStack.getBacktrace(currentNode));
        noMethodError.define("@name", this.context.getSymbolTable().getSymbol(name), 0);
        return noMethodError;
    }

    public DynamicObject noSuperMethodError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject noMethodError = this.noMethodError("super called outside of method", "<unknown>", currentNode);
        noMethodError.define("@name", this.nilObject, 0);
        return noMethodError;
    }

    public DynamicObject noMethodErrorOnReceiver(String name, Object receiver, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject logicalClass = this.getLogicalClass(receiver);
        String repr = Layouts.MODULE.getFields(logicalClass).getName();
        if (RubyGuards.isRubyModule(receiver)) {
            repr = Layouts.MODULE.getFields((DynamicObject)receiver).getName() + ":" + repr;
        }
        return this.noMethodError(String.format("undefined method `%s' for %s", name, repr), name, currentNode);
    }

    public DynamicObject privateMethodError(String name, Object self, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String className = Layouts.MODULE.getFields(this.getLogicalClass(self)).getName();
        return this.noMethodError(String.format("private method `%s' called for %s", name, className), name, currentNode);
    }

    public DynamicObject loadError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.context.getCoreLibrary().getLoadErrorClass(), StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject loadErrorCannotLoad(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.loadError(String.format("cannot load such file -- %s", name), currentNode);
    }

    public DynamicObject zeroDivisionError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.context.getCoreLibrary().getZeroDivisionErrorClass(), StringOperations.createString(this.context, StringOperations.encodeByteList("divided by 0", (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject notImplementedError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.notImplementedErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(String.format("Method %s not implemented", message), (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject syntaxError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.syntaxErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject floatDomainError(String value, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.floatDomainErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(value, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject mathDomainError(String method, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.getErrnoClass(Errno.EDOM), StringOperations.createString(this.context, StringOperations.encodeByteList(String.format("Numerical argument is out of domain - \"%s\"", method), (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject ioError(String fileName, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.ioErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(String.format("Error reading file -  %s", fileName), (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject rangeError(int code, DynamicObject encoding, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyEncoding(encoding));
        return this.rangeError(String.format("invalid codepoint %x in %s", code, EncodingOperations.getEncoding(encoding)), currentNode);
    }

    public DynamicObject rangeError(String type, String value, String range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.rangeError(String.format("%s %s out of range of %s", type, value, range), currentNode);
    }

    public DynamicObject rangeError(DynamicObject range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isIntegerFixnumRange(range));
        return this.rangeError(String.format("%d..%s%d out of range", Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? "." : "", Layouts.INTEGER_FIXNUM_RANGE.getEnd(range)), currentNode);
    }

    public DynamicObject rangeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.rangeErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject internalError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.context.getCoreLibrary().getRubyTruffleErrorClass(), StringOperations.createString(this.context, StringOperations.encodeByteList("internal implementation error - " + message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject regexpError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.regexpErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject encodingCompatibilityErrorIncompatible(String a, String b, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.encodingCompatibilityError(String.format("incompatible character encodings: %s and %s", a, b), currentNode);
    }

    public DynamicObject encodingCompatibilityError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.encodingCompatibilityErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject fiberError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.fiberErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject deadFiberCalledError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.fiberError("dead fiber called", currentNode);
    }

    public DynamicObject yieldFromRootFiberError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.fiberError("can't yield from root fiber", currentNode);
    }

    public DynamicObject threadError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.threadErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject securityError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.securityErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject systemCallError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return ExceptionNodes.createRubyException(this.systemCallErrorClass, StringOperations.createString(this.context, StringOperations.encodeByteList(message, (Encoding)UTF8Encoding.INSTANCE)), RubyCallStack.getBacktrace(currentNode));
    }

    public DynamicObject systemExit(int exitStatus, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject message = StringOperations.createString(this.context, StringOperations.encodeByteList("exit", (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject systemExit = ExceptionNodes.createRubyException(this.systemExitClass, message, RubyCallStack.getBacktrace(currentNode));
        systemExit.define("@status", exitStatus, 0);
        return systemExit;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public DynamicObject getArrayClass() {
        return this.arrayClass;
    }

    public DynamicObject getBasicObjectClass() {
        return this.basicObjectClass;
    }

    public DynamicObject getBignumClass() {
        return this.bignumClass;
    }

    public DynamicObject getBigDecimalClass() {
        return this.bigDecimalClass;
    }

    public DynamicObject getBindingClass() {
        return this.bindingClass;
    }

    public DynamicObjectFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public DynamicObject getClassClass() {
        return this.classClass;
    }

    public DynamicObject getFalseClass() {
        return this.falseClass;
    }

    public DynamicObject getFiberClass() {
        return this.fiberClass;
    }

    public DynamicObject getFixnumClass() {
        return this.fixnumClass;
    }

    public DynamicObject getFloatClass() {
        return this.floatClass;
    }

    public DynamicObject getHashClass() {
        return this.hashClass;
    }

    public DynamicObject getStandardErrorClass() {
        return this.standardErrorClass;
    }

    public DynamicObject getLoadErrorClass() {
        return this.loadErrorClass;
    }

    public DynamicObject getMatchDataClass() {
        return this.matchDataClass;
    }

    public DynamicObject getModuleClass() {
        return this.moduleClass;
    }

    public DynamicObject getNameErrorClass() {
        return this.nameErrorClass;
    }

    public DynamicObject getNilClass() {
        return this.nilClass;
    }

    public DynamicObject getRubyInternalMethod() {
        return this.rubyInternalMethod;
    }

    public DynamicObject getNoMethodErrorClass() {
        return this.noMethodErrorClass;
    }

    public DynamicObject getObjectClass() {
        return this.objectClass;
    }

    public DynamicObject getProcClass() {
        return this.procClass;
    }

    public DynamicObject getRangeClass() {
        return this.rangeClass;
    }

    public DynamicObject getRationalClass() {
        return this.rationalClass;
    }

    public DynamicObject getRegexpClass() {
        return this.regexpClass;
    }

    public DynamicObject getRubyTruffleErrorClass() {
        return this.rubyTruffleErrorClass;
    }

    public DynamicObject getRuntimeErrorClass() {
        return this.runtimeErrorClass;
    }

    public DynamicObject getStringClass() {
        return this.stringClass;
    }

    public DynamicObject getThreadClass() {
        return this.threadClass;
    }

    public DynamicObject getTimeClass() {
        return this.timeClass;
    }

    public DynamicObject getTypeErrorClass() {
        return this.typeErrorClass;
    }

    public DynamicObject getTrueClass() {
        return this.trueClass;
    }

    public DynamicObject getZeroDivisionErrorClass() {
        return this.zeroDivisionErrorClass;
    }

    public DynamicObject getKernelModule() {
        return this.kernelModule;
    }

    public DynamicObject getArgv() {
        return this.argv;
    }

    public DynamicObject getGlobalVariablesObject() {
        return this.globalVariablesObject;
    }

    public DynamicObject getLoadPath() {
        return (DynamicObject)this.globalVariablesObject.get("$LOAD_PATH", this.context.getCoreLibrary().getNilObject());
    }

    public DynamicObject getLoadedFeatures() {
        return (DynamicObject)this.globalVariablesObject.get("$LOADED_FEATURES", this.context.getCoreLibrary().getNilObject());
    }

    public DynamicObject getMainObject() {
        return this.mainObject;
    }

    public DynamicObject getNilObject() {
        return this.nilObject;
    }

    public DynamicObject getENV() {
        return (DynamicObject)Layouts.MODULE.getFields(this.objectClass).getConstants().get("ENV").getValue();
    }

    public ArrayNodes.MinBlock getArrayMinBlock() {
        return this.arrayMinBlock;
    }

    public ArrayNodes.MaxBlock getArrayMaxBlock() {
        return this.arrayMaxBlock;
    }

    public DynamicObject getNumericClass() {
        return this.numericClass;
    }

    public DynamicObject getIntegerClass() {
        return this.integerClass;
    }

    public DynamicObject getEncodingConverterClass() {
        return this.encodingConverterClass;
    }

    public DynamicObject getUnboundMethodClass() {
        return this.unboundMethodClass;
    }

    public DynamicObjectFactory getUnboundMethodFactory() {
        return this.unboundMethodFactory;
    }

    public DynamicObject getMethodClass() {
        return this.methodClass;
    }

    public DynamicObjectFactory getMethodFactory() {
        return this.methodFactory;
    }

    public DynamicObject getComplexClass() {
        return this.complexClass;
    }

    public DynamicObject getByteArrayClass() {
        return this.byteArrayClass;
    }

    public DynamicObjectFactory getByteArrayFactory() {
        return this.byteArrayFactory;
    }

    public DynamicObject getLookupTableClass() {
        return this.lookupTableClass;
    }

    public DynamicObject getStringDataClass() {
        return this.stringDataClass;
    }

    public DynamicObject getTranscodingClass() {
        return this.transcodingClass;
    }

    public DynamicObject getTupleClass() {
        return this.tupleClass;
    }

    public DynamicObject getRubiniusChannelClass() {
        return this.rubiniusChannelClass;
    }

    public DynamicObject getRubiniusFFIPointerClass() {
        return this.rubiniusFFIPointerClass;
    }

    public DynamicObject getRubiniusMirrorClass() {
        return this.rubiniusMirrorClass;
    }

    public DynamicObject getRubiniusUndefined() {
        return this.rubiniusUndefined;
    }

    public DynamicObject getErrnoClass(Errno errno) {
        return this.errnoClasses.get(errno);
    }

    public DynamicObject getSymbolClass() {
        return this.symbolClass;
    }

    public DynamicObject getThreadBacktraceLocationClass() {
        return this.threadBacktraceLocationClass;
    }

    public DynamicObject getInternalBufferClass() {
        return this.internalBufferClass;
    }

    public boolean isLoadingRubyCore() {
        return this.state == State.LOADING_RUBY_CORE;
    }

    public boolean isLoaded() {
        return this.state == State.LOADED;
    }

    public boolean isSend(InternalMethod method) {
        return method.getCallTarget() == this.basicObjectSendMethod.getCallTarget();
    }

    public DynamicObjectFactory getIntegerFixnumRangeFactory() {
        return this.integerFixnumRangeFactory;
    }

    public DynamicObjectFactory getLongFixnumRangeFactory() {
        return this.longFixnumRangeFactory;
    }

    public DynamicObject getDigestClass() {
        return this.digestClass;
    }

    public DynamicObjectFactory getArrayFactory() {
        return this.arrayFactory;
    }

    public DynamicObjectFactory getBignumFactory() {
        return this.bignumFactory;
    }

    public DynamicObjectFactory getProcFactory() {
        return this.procFactory;
    }

    public DynamicObjectFactory getStringFactory() {
        return this.stringFactory;
    }

    public DynamicObjectFactory getHashFactory() {
        return this.hashFactory;
    }

    public DynamicObjectFactory getWeakRefFactory() {
        return this.weakRefFactory;
    }

    public Object getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    public DynamicObjectFactory getRandomizerFactory() {
        return this.randomizerFactory;
    }

    public DynamicObjectFactory getTimeFactory() {
        return this.timeFactory;
    }

    public DynamicObject getSystemExitClass() {
        return this.systemExitClass;
    }

    private static class CoreLibraryNode
    extends RubyNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        FreezeNode freezeNode;

        public CoreLibraryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.adoptChildren();
        }

        public SingletonClassNode getSingletonClassNode() {
            return this.singletonClassNode;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.nil();
        }
    }

    private static enum State {
        INITIALIZING,
        LOADING_RUBY_CORE,
        LOADED;

    }
}

