/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.ext.psych;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ext.psych.ParserLayout;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.parser.Parser;

public class ParserLayoutImpl
extends BasicObjectLayoutImpl
implements ParserLayout {
    public static final ParserLayout INSTANCE = new ParserLayoutImpl();
    protected static final Shape.Allocator PARSER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey PARSER_IDENTIFIER = new HiddenKey("parser");
    protected static final Property PARSER_PROPERTY = Property.create(PARSER_IDENTIFIER, PARSER_ALLOCATOR.locationForType(Parser.class), 0);
    protected static final HiddenKey EVENT_IDENTIFIER = new HiddenKey("event");
    protected static final Property EVENT_PROPERTY = Property.create(EVENT_IDENTIFIER, PARSER_ALLOCATOR.locationForType(Event.class), 0);

    protected ParserLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createParserShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ParserType(logicalClass, metaClass)).addProperty(PARSER_PROPERTY).addProperty(EVENT_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createParser(DynamicObjectFactory factory, Parser parser, Event event) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsParser(factory));
        assert (factory.getShape().hasProperty(PARSER_IDENTIFIER));
        assert (factory.getShape().hasProperty(EVENT_IDENTIFIER));
        return factory.newInstance(parser, event);
    }

    @Override
    public boolean isParser(DynamicObject object) {
        return this.isParser(object.getShape().getObjectType());
    }

    private boolean isParser(ObjectType objectType) {
        return objectType instanceof ParserType;
    }

    private boolean createsParser(DynamicObjectFactory factory) {
        return this.isParser(factory.getShape().getObjectType());
    }

    @Override
    public Parser getParser(DynamicObject object) {
        assert (this.isParser(object));
        assert (object.getShape().hasProperty(PARSER_IDENTIFIER));
        return (Parser)PARSER_PROPERTY.get(object, true);
    }

    @Override
    public void setParser(DynamicObject object, Parser value) {
        assert (this.isParser(object));
        assert (object.getShape().hasProperty(PARSER_IDENTIFIER));
        try {
            PARSER_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Event getEvent(DynamicObject object) {
        assert (this.isParser(object));
        assert (object.getShape().hasProperty(EVENT_IDENTIFIER));
        return (Event)EVENT_PROPERTY.get(object, true);
    }

    @Override
    public void setEvent(DynamicObject object, Event value) {
        assert (this.isParser(object));
        assert (object.getShape().hasProperty(EVENT_IDENTIFIER));
        try {
            EVENT_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class ParserType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ParserType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ParserType setLogicalClass(DynamicObject logicalClass) {
            return new ParserType(logicalClass, this.metaClass);
        }

        @Override
        public ParserType setMetaClass(DynamicObject metaClass) {
            return new ParserType(this.logicalClass, metaClass);
        }
    }
}

