/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.tools.LineToProbesMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;

public class AttachmentsManager {
    private final RubyContext context;
    private final LineToProbesMap lineToProbesMap;
    private final Map<LineLocation, List<Instrument>> attachments = new HashMap<LineLocation, List<Instrument>>();

    public AttachmentsManager(RubyContext context) {
        this.context = context;
        this.lineToProbesMap = new LineToProbesMap();
        this.lineToProbesMap.install();
    }

    public synchronized void attach(String file, int line, final DynamicObject block) {
        Instrument instrument = Instrument.create(new StandardInstrumentListener(){

            @Override
            public void enter(Probe probe, Node node, VirtualFrame frame) {
                DynamicObject binding = BindingNodes.createBinding(AttachmentsManager.this.context, frame.materialize());
                ProcNodes.rootCall(block, binding);
            }

            @Override
            public void returnVoid(Probe probe, Node node, VirtualFrame virtualFrame) {
            }

            @Override
            public void returnValue(Probe probe, Node node, VirtualFrame virtualFrame, Object o) {
            }

            @Override
            public void returnExceptional(Probe probe, Node node, VirtualFrame virtualFrame, Exception e) {
            }
        }, String.format("Truffle::Primitive.attach@%s:%d", file, line));
        Source source = this.context.getSourceCache().getBestSourceFuzzily(file);
        LineLocation lineLocation = source.createLineLocation(line);
        List<Instrument> instruments = this.attachments.get(lineLocation);
        if (instruments == null) {
            instruments = new ArrayList<Instrument>();
            this.attachments.put(lineLocation, instruments);
        }
        instruments.add(instrument);
        for (Probe probe : this.lineToProbesMap.findProbes(lineLocation)) {
            if (!probe.isTaggedAs(StandardSyntaxTag.STATEMENT)) continue;
            probe.attach(instrument);
            return;
        }
        throw new RuntimeException("couldn't find a statement!");
    }

    public synchronized void detach(String file, int line) {
        Source source = this.context.getSourceCache().getBestSourceFuzzily(file);
        LineLocation lineLocation = source.createLineLocation(line);
        List<Instrument> instruments = this.attachments.remove(lineLocation);
        if (instruments != null) {
            for (Instrument instrument : instruments) {
                instrument.dispose();
            }
        }
    }
}

