// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var AltKeyRing, AltKeyRingBase, BaseKeyRing, E, GPG, Globals, GpgKey, Log, MasterKeyRing, Parser, QuarantinedKeyRing, RingFileBundle, TmpKeyRing, TmpKeyRingBase, TmpOneShotKeyRing, TmpPrimaryKeyRing, a_json_parse, athrow, base64u, chain, colgrep, fingerprint_to_key_id_64, fpeq, fs, globals, iced, list_fingerprints, log, make_esc, master_ring, mkdir_p, os, path, pgp_utils, prng, reset_master_ring, states, strip, trim, userid, util, __iced_k, __iced_k_noop, _globals, _ref, _ref1, _ref2,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  GPG = require('./gpg').GPG;

  _ref = require('iced-error'), chain = _ref.chain, make_esc = _ref.make_esc;

  mkdir_p = require('iced-utils').fs.mkdir_p;

  prng = require('crypto').prng;

  pgp_utils = require('pgp-utils');

  _ref1 = pgp_utils.util, trim = _ref1.trim, fingerprint_to_key_id_64 = _ref1.fingerprint_to_key_id_64, fpeq = _ref1.fpeq, athrow = _ref1.athrow, base64u = _ref1.base64u;

  userid = pgp_utils.userid;

  E = require('./err').E;

  path = require('path');

  fs = require('fs');

  colgrep = require('./colgrep').colgrep;

  util = require('util');

  os = require('os');

  a_json_parse = require('iced-utils').util.a_json_parse;

  _ref2 = require('./index'), list_fingerprints = _ref2.list_fingerprints, Parser = _ref2.Parser;

  strip = function(m) {
    return m.split(/\s+/).join('');
  };

  states = {
    NONE: 0,
    LOADED: 1,
    SAVED: 2
  };

  exports.Log = Log = (function() {
    function Log() {}

    Log.prototype.debug = function(x) {
      return console.error(x);
    };

    Log.prototype.warn = function(x) {
      return console.error(x);
    };

    Log.prototype.error = function(x) {
      return console.error(x);
    };

    Log.prototype.info = function(x) {
      return console.error(x);
    };

    return Log;

  })();

  exports.Globals = Globals = (function() {
    function Globals(_arg) {
      this.get_preserve_tmp_keyring = _arg.get_preserve_tmp_keyring, this.get_debug = _arg.get_debug, this.get_tmp_keyring_dir = _arg.get_tmp_keyring_dir, this.get_key_klass = _arg.get_key_klass, this.get_home_dir = _arg.get_home_dir, this.get_gpg_cmd = _arg.get_gpg_cmd, this.get_no_options = _arg.get_no_options, this.log = _arg.log;
      this.get_preserve_tmp_keyring || (this.get_preserve_tmp_keyring = function() {
        return false;
      });
      this.log || (this.log = new Log);
      this.get_debug || (this.get_debug = function() {
        return false;
      });
      this.get_tmp_keyring_dir || (this.get_tmp_keyring_dir = function() {
        return os.tmpdir();
      });
      this.get_key_klass || (this.get_key_klass = function() {
        return GpgKey;
      });
      this.get_home_dir || (this.get_home_dir = function() {
        return null;
      });
      this.get_gpg_cmd || (this.get_gpg_cmd = function() {
        return null;
      });
      this.get_no_options || (this.get_no_options = function() {
        return false;
      });
      this._mring = null;
    }

    Globals.prototype.master_ring = function() {
      return this._mring;
    };

    Globals.prototype.set_master_ring = function(r) {
      return this._mring = r;
    };

    return Globals;

  })();

  _globals = new Globals({});

  globals = function() {
    return _globals;
  };

  exports.init = function(d) {
    _globals = new Globals(d);
    return _globals.set_master_ring(new MasterKeyRing());
  };

  log = function() {
    return globals().log;
  };

  exports.GpgKey = GpgKey = (function() {
    function GpgKey(fields) {
      var k, v;
      this._state = states.NONE;
      for (k in fields) {
        v = fields[k];
        this["_" + k] = v;
      }
    }

    GpgKey.prototype.fingerprint = function() {
      return this._fingerprint;
    };

    GpgKey.prototype.key_id_64 = function() {
      return this._key_id_64 || (this.fingerprint() ? this.fingerprint().slice(-16) : null);
    };

    GpgKey.prototype.load_id = function() {
      return this.key_id_64() || this.fingerprint() || this.username();
    };

    GpgKey.prototype.username = function() {
      return this._username;
    };

    GpgKey.prototype.uid = function() {
      return this._uid;
    };

    GpgKey.prototype.all_uids = function() {
      return this._all_uids;
    };

    GpgKey.prototype.key_data = function() {
      return this._key_data;
    };

    GpgKey.prototype.keyring = function() {
      return this._keyring;
    };

    GpgKey.prototype.get_pgp_key_id = function() {
      return this.key_id_64();
    };

    GpgKey.prototype.get_pgp_fingerprint = function() {
      return this.fingerprint().toLowerCase();
    };

    GpgKey.prototype.get_ekid = function() {
      return null;
    };

    GpgKey.prototype.is_signed = function() {
      return !!this._is_signed;
    };

    GpgKey.prototype.check_is_signed = function(signer, cb) {
      var args, err, id, out, row, rows, to_find, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log().debug("+ Check if " + (signer.to_string()) + " signed " + (this.to_string()));
      id = this.load_id();
      args = ["--list-sigs", "--with-colons", id];
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.check_is_signed"
          });
          _this.gpg({
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 125
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _i, _len;
          if (typeof err === "undefined" || err === null) {
            rows = colgrep({
              buffer: out,
              patterns: {
                0: /^sig$/
              },
              separator: /:/
            });
            to_find = signer.key_id_64().toUpperCase();
            for (_i = 0, _len = rows.length; _i < _len; _i++) {
              row = rows[_i];
              if (row[4] === to_find) {
                log().debug("| Found in row: " + (JSON.stringify(row)));
                _this._is_signed = true;
                break;
              }
            }
          }
          log().debug("- Check -> " + _this._is_signed);
          return cb(err, _this._is_signed);
        };
      })(this));
    };

    GpgKey.prototype.find = function(cb) {
      var args, err, fp, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if ((fp = _this.fingerprint()) != null) {
            args = ["-" + (_this._secret ? 'K' : 'k'), "--with-colons", fp];
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "GpgKey.find"
              });
              _this.gpg({
                args: args,
                quiet: true
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return out = arguments[1];
                  };
                })(),
                lineno: 143
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(typeof err !== "undefined" && err !== null ? err = new E.NotFoundError("Key for " + (_this.to_string()) + " not found") : void 0);
            });
          } else {
            return __iced_k(err = new E.NoFingerprintError("No fingerprint given for " + _this._username));
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    GpgKey.prototype.check_sig = function(signing_key, cb) {
      var args, err, out, rows, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = ['--list-sigs', '--with-colon', this.fingerprint()];
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.check_sig"
          });
          _this.gpg({
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 155
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            rows = colgrep({
              buffer: out,
              patterns: {
                0: /^sub$/,
                4: new RegExp("^" + (signing_key.key_id_64()) + "$", "i")
              }
            });
            if (rows.length === 0) {
              err = new E.VerifyError("No signature of " + (_this.to_string()) + " by " + (signing_key.to_string()));
            }
          }
          return cb(err);
        };
      })(this));
    };

    GpgKey.prototype.set_keyring = function(r) {
      return this._keyring = r;
    };

    GpgKey.prototype.to_string = function() {
      return [this.username(), this.key_id_64()].join("/");
    };

    GpgKey.prototype.gpg = function(gargs, cb) {
      return this.keyring().gpg(gargs, cb);
    };

    GpgKey.prototype.save = function(cb) {
      var args, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = ["--import"];
      if (this._secret) {
        args.push("--import-options", "import-local-sigs");
      }
      log().debug("| Save key " + (this.to_string()) + " to " + (this.keyring().to_string()));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.save"
          });
          _this.gpg({
            args: args,
            stdin: _this._key_data,
            quiet: true,
            secret: _this._secret,
            no_options: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 185
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          _this._state = states.SAVED;
          return cb(err);
        };
      })(this));
    };

    GpgKey.prototype.load = function(cb) {
      var args, err, esc, fp, id, l, out, uids, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      id = this.load_id();
      esc = make_esc(cb, "GpgKey::load");
      args = [(this._secret ? "--export-secret-key" : "--export"), "--export-options", "export-local-sigs", "-a", id];
      log().debug("| Load key " + (this.to_string()) + " from " + (this.keyring().to_string()) + " (secret=" + this._secret + ")");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.load"
          });
          _this.gpg({
            args: args
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1._key_data = arguments[0];
              };
            })(_this),
            lineno: 202
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (_this.fingerprint() == null) {
              log().debug("+ lookup fingerprint");
              args = ["-k", "--fingerprint", "--with-colons", id];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "GpgKey.load"
                });
                _this.gpg({
                  args: args,
                  no_options: true
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return out = arguments[0];
                    };
                  })(),
                  lineno: 207
                })));
                __iced_deferrals._fulfill();
              })(function() {
                fp = list_fingerprints(out.toString('utf8'));
                return __iced_k((l = fp.length) === 0 ? err = new E.GpgError("Couldn't find GPG fingerprint for " + id) : l > 1 ? err = new E.GpgError("Found more than one (#l) keys for " + id) : (_this._state = states.LOADED, _this._fingerprint = fp[0], log().debug("- Map " + id + " -> " + _this._fingerprint + " via gpg")));
              });
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              if (_this.uid() == null) {
                log().debug("+ lookup UID");
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "GpgKey.load"
                  });
                  _this.read_uids_from_key(esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return uids = arguments[0];
                      };
                    })(),
                    lineno: 220
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  l = uids.length;
                  if (l === 0) {
                    log().debug("| weird; no UIDs found");
                  } else {
                    if (l > 1) {
                      log().debug("| got back more than one UID; using the first: (" + (JSON.stringify(uids)) + ")");
                    }
                    _this._uid = uids[0];
                    log().debug(" - Map " + id + " -> " + _this._uid + " via gpg");
                  }
                  _this._all_uids = uids;
                  return __iced_k(log().debug("- looked up UID"));
                });
              } else {
                return __iced_k();
              }
            })(function() {
              return cb(err);
            });
          });
        };
      })(this));
    };

    GpgKey.prototype.remove = function(cb) {
      var args, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = [(this._secret ? "--delete-secret-and-public-key" : "--delete-keys"), "--batch", "--yes", this.fingerprint()];
      log().debug("| Delete key " + (this.to_string()) + " from " + (this.keyring().to_string()));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.remove"
          });
          _this.gpg({
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 243
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    GpgKey.prototype.read_uids_from_key = function(cb) {
      var args, err, fp, tmp, uids, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      fp = this.fingerprint();
      log().debug("+ read_uids_from_keys " + fp);
      uids = null;
      (function(_this) {
        return (function(__iced_k) {
          if ((uids = _this._my_userids) != null) {
            return __iced_k(log().debug("| hit cache"));
          } else {
            args = {
              fingerprint: fp
            };
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "GpgKey.read_uids_from_key"
              });
              _this.keyring().read_uids_from_key(args, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return tmp = arguments[1];
                  };
                })(),
                lineno: 257
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(uids = _this._my_userids = tmp);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          log().debug("| got: " + (uids != null ? JSON.stringify(uids) : null));
          log().debug("- read_uids_from_key -> " + err);
          return cb(err, uids);
        };
      })(this));
    };

    GpgKey.prototype.sign_key = function(_arg, cb) {
      var args, err, hsk, signer, skip, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      signer = _arg.signer;
      log().debug("| GPG-signing " + (this.username()) + "'s key with your key");
      args = ["--sign-key", "--batch", "--yes"];
      skip = false;
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (signer != null) {
            return __iced_k(args.push("-u", signer.fingerprint()));
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "GpgKey.sign_key"
              });
              _this.keyring().has_signing_key(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return hsk = arguments[1];
                  };
                })(),
                lineno: 273
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err != null ? skip = true : !hsk ? (log().info("Not trying to sign key " + (_this.to_string()) + " since there's no signing key available"), skip = true) : void 0);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (!skip) {
              args.push(_this.fingerprint());
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "GpgKey.sign_key"
                });
                _this.gpg({
                  args: args,
                  quiet: true
                }, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 280
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err);
          });
        };
      })(this));
    };

    GpgKey.prototype.commit = function(_arg, cb) {
      var esc, ring, sign_key, signer, try_sign, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      signer = _arg.signer, sign_key = _arg.sign_key, ring = _arg.ring;
      esc = make_esc(cb, "GpgKey::commit");
      try_sign = sign_key || (signer != null);
      (function(_this) {
        return (function(__iced_k) {
          if (_this.keyring().is_temporary()) {
            log().debug("+ " + (_this.to_string()) + ": Commit temporary key");
            (function(__iced_k) {
              if (try_sign) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "GpgKey.commit"
                  });
                  _this.sign_key({
                    signer: signer
                  }, esc(__iced_deferrals.defer({
                    lineno: 291
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "GpgKey.commit"
                });
                _this.load(esc(__iced_deferrals.defer({
                  lineno: 292
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "GpgKey.commit"
                  });
                  _this.remove(esc(__iced_deferrals.defer({
                    lineno: 293
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  ring || (ring = master_ring());
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                      funcname: "GpgKey.commit"
                    });
                    (_this.copy_to_keyring(ring)).save(esc(__iced_deferrals.defer({
                      lineno: 295
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(log().debug("- " + (_this.to_string()) + ": Commit temporary key"));
                  });
                });
              });
            });
          } else {
            (function(__iced_k) {
              if (!_this._is_signed) {
                (function(__iced_k) {
                  if (try_sign) {
                    log().debug("| " + (_this.to_string()) + ": signing key, since it wasn't signed");
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                        funcname: "GpgKey.commit"
                      });
                      _this.sign_key({
                        signer: signer
                      }, esc(__iced_deferrals.defer({
                        lineno: 300
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k(log().debug("| " + (_this.to_string()) + ": key wasn't signed, but signing was skipping"));
                  }
                })(__iced_k);
              } else {
                return __iced_k(log().debug("| " + (_this.to_string()) + ": key was previously commited; noop"));
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    GpgKey.prototype.rollback = function(cb) {
      var err, s, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      s = this.to_string();
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (globals().get_preserve_tmp_keyring() && _this.keyring().is_temporary()) {
            return __iced_k(log().debug("| " + s + ": preserving temporary keyring by command-line flag"));
          } else {
            (function(__iced_k) {
              if (_this.keyring().is_temporary()) {
                log().debug("| " + s + ": Rolling back temporary key");
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "GpgKey.rollback"
                  });
                  _this.remove(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return err = arguments[0];
                      };
                    })(),
                    lineno: 316
                  }));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k(log().debug("| " + s + ": no need to rollback key, it's permanent"));
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    GpgKey.prototype.to_data_dict = function() {
      var d, k, v;
      d = {};
      for (k in this) {
        v = this[k];
        if (k[0] === '_') {
          d[k.slice(1)] = v;
        }
      }
      return d;
    };

    GpgKey.prototype.copy_to_keyring = function(keyring) {
      return keyring.make_key(this.to_data_dict());
    };

    GpgKey.prototype._find_key_in_stderr = function(which, buf) {
      var d, err, fingerprint, ki64, m;
      err = ki64 = fingerprint = null;
      d = buf.toString('utf8');
      if ((m = d.match(/Primary key fingerprint: (.*)/)) != null) {
        fingerprint = m[1];
      } else if ((m = d.match(/using [RD]SA key ([A-F0-9]{16})/)) != null) {
        ki64 = m[1];
      } else {
        err = new E.VerifyError("" + which + ": can't parse PGP output in verify signature");
      }
      return {
        err: err,
        ki64: ki64,
        fingerprint: fingerprint
      };
    };

    GpgKey.prototype._verify_key_id_64 = function(_arg, cb) {
      var a, b, err, ki64, m, out, sig, which, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ki64 = _arg.ki64, which = _arg.which, sig = _arg.sig;
      log().debug("+ GpgKey::_verify_key_id_64: " + which + ": " + ki64 + " vs " + (this.fingerprint()));
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (ki64 !== _this.key_id_64()) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "GpgKey._verify_key_id_64"
              });
              _this.gpg({
                args: ["--fingerprint", "--keyid-format", "long", ki64]
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return out = arguments[1];
                  };
                })(),
                lineno: 349
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err != null ? void 0 : (m = out.toString('utf8').match(/Key fingerprint = ([A-F0-9 ]+)/)) == null ? err = new E.VerifyError("Querying for a fingerprint failed") : !(a = strip(m[1])) === (b = _this.fingerprint()) ? err = new E.VerifyError("Fingerprint mismatch: " + a + " != " + b) : log().debug("| Successful map of " + ki64 + " -> " + (_this.fingerprint())));
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (err == null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "GpgKey._verify_key_id_64"
                });
                _this.keyring().assert_no_collision(ki64, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 359
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            log().debug("- GpgKey::_verify_key_id_64: " + which + ": " + ki64 + " vs " + (_this.fingerprint()) + " -> " + err);
            return cb(err);
          });
        };
      })(this));
    };

    GpgKey.prototype.verify_sig = function(_arg, cb) {
      var a, args, b, err, fp, msg, out, payload, sig, which, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      which = _arg.which, sig = _arg.sig, payload = _arg.payload;
      log().debug("+ GpgKey::verify_sig " + which);
      err = null;
      args = {
        query: this.fingerprint(),
        single: true,
        sig: sig,
        no_json: true,
        keyblock: this._key_data,
        secret: this._secret
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "GpgKey.verify_sig"
          });
          _this.keyring().oneshot_verify(args, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                out = arguments[1];
                return fp = arguments[2];
              };
            })(),
            lineno: 376
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if ((err == null) && !(_this._fingerprint != null) && (typeof fp !== "undefined" && fp !== null)) {
            _this._fingerprint = fp;
            log().debug("| Setting fingerprint to " + fp + " as a result of oneshot_verify");
          }
          msg = err != null ? "signature verification failed" : (_this._fingerprint != null) && (_this._fingerprint.toLowerCase() !== fp.toLowerCase()) ? "Wrong key fingerprint; was the server lying? " + _this._fingerprint + " != " + fp : (a = trim(out.toString('utf8'))) !== (b = trim(payload)) ? "wrong payload: " + a + " != " + b + " (" + a.length + " v " + b.length + ")" : null;
          if (msg != null) {
            err = new E.VerifyError("" + which + ": " + msg);
          }
          log().debug("- GpgKey::verify_sig " + which + " -> " + err);
          return cb(err);
        };
      })(this));
    };

    return GpgKey;

  })();

  exports.BaseKeyRing = BaseKeyRing = (function(_super) {
    __extends(BaseKeyRing, _super);

    function BaseKeyRing() {
      BaseKeyRing.__super__.constructor.call(this, {
        cmd: globals().get_gpg_cmd()
      });
      this._has_signing_key = null;
    }

    BaseKeyRing.prototype.has_signing_key = function(cb) {
      var err, ids, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this._has_signing_key == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "BaseKeyRing.has_signing_key"
              });
              _this.find_secret_keys({}, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return ids = arguments[1];
                  };
                })(),
                lineno: 408
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err != null ? log().warn("Issue listing secret keys: " + err.message) : _this._has_signing_key = ids.length > 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, _this._has_signing_key);
        };
      })(this));
    };

    BaseKeyRing.prototype.make_key = function(opts) {
      var klass, ret;
      klass = globals().get_key_klass();
      ret = new klass(opts);
      ret.set_keyring(this);
      return ret;
    };

    BaseKeyRing.prototype.is_temporary = function() {
      return false;
    };

    BaseKeyRing.prototype.tmp_dir = function() {
      return os.tmpdir();
    };

    BaseKeyRing.prototype.make_oneshot_ring_2 = function(_arg, cb) {
      var err, esc, fps, keyblock, n, secret, single, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      keyblock = _arg.keyblock, single = _arg.single, secret = _arg.secret;
      esc = make_esc(cb, "BaseKeyRing::_make_oneshot_ring_2");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.make_oneshot_ring_2"
          });
          _this.gpg({
            no_options: true,
            args: ["--import"],
            stdin: keyblock,
            quiet: true,
            secret: secret
          }, esc(__iced_deferrals.defer({
            lineno: 432
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
              funcname: "BaseKeyRing.make_oneshot_ring_2"
            });
            _this.list_fingerprints(esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return fps = arguments[0];
                };
              })(),
              lineno: 433
            })));
            __iced_deferrals._fulfill();
          })(function() {
            n = fps.length;
            err = n === 0 ? new E.NotFoundError("key import failed") : single && n > 1 ? new E.PgpIdCollisionError("too many keys found: " + n) : (_this._fingerprint = fps[0], _this._key_id_64 = _this._fingerprint.slice(-16), null);
            return cb(err, _this._fingerprint);
          });
        };
      })(this));
    };

    BaseKeyRing.prototype.make_oneshot_ring = function(_arg, cb) {
      var args, e2, err, esc, fp, keyblock, query, ring, secret, single, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query, single = _arg.single, keyblock = _arg.keyblock, secret = _arg.secret;
      esc = make_esc(cb, "BaseKeyRing::make_oneshot_ring");
      (function(_this) {
        return (function(__iced_k) {
          if (keyblock == null) {
            args = ["-a", "--export", query];
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "BaseKeyRing.make_oneshot_ring"
              });
              _this.gpg({
                args: args,
                no_options: true
              }, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return keyblock = arguments[0];
                  };
                })(),
                lineno: 450
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
              funcname: "BaseKeyRing.make_oneshot_ring"
            });
            TmpOneShotKeyRing.make(esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return ring = arguments[0];
                };
              })(),
              lineno: 451
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "BaseKeyRing.make_oneshot_ring"
              });
              ring.make_oneshot_ring_2({
                keyblock: keyblock,
                single: single,
                secret: secret
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return fp = arguments[1];
                  };
                })(),
                lineno: 452
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (typeof err !== "undefined" && err !== null) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                      funcname: "BaseKeyRing.make_oneshot_ring"
                    });
                    ring.nuke(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return e2 = arguments[0];
                        };
                      })(),
                      lineno: 454
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(typeof e2 !== "undefined" && e2 !== null ? log().warn("Error cleaning up keyring after failure: " + e2.message) : void 0);
                  });
                } else {
                  return __iced_k();
                }
              })(function() {
                return cb(err, ring, fp);
              });
            });
          });
        };
      })(this));
    };

    BaseKeyRing.prototype.find_keys_full = function(_arg, cb) {
      var args, err, index, k, out, query, res, secret, sigs, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query, secret = _arg.secret, sigs = _arg.sigs;
      args = ["--with-colons", "--fingerprint"];
      args.push(secret ? "-K" : "-k");
      if (query) {
        args.push(query);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.find_keys_full"
          });
          _this.gpg({
            args: args,
            list_keys: true,
            no_options: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 464
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          res = null;
          if (typeof err === "undefined" || err === null) {
            index = (new Parser(out.toString('utf8'))).parse();
            res = (function() {
              var _i, _len, _ref3, _results;
              _ref3 = index.keys();
              _results = [];
              for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                k = _ref3[_i];
                _results.push(this.make_key(k.to_dict({
                  secret: secret
                })));
              }
              return _results;
            }).call(_this);
          }
          return cb(err, res);
        };
      })(this));
    };

    BaseKeyRing.prototype.find_keys = function(_arg, cb) {
      var args, err, id64s, out, query, row, rows, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query;
      args = ["-k", "--with-colons"];
      if (query) {
        args.push(query);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.find_keys"
          });
          _this.gpg({
            args: args,
            list_keys: true,
            no_options: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 476
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          id64s = null;
          if (typeof err === "undefined" || err === null) {
            rows = colgrep({
              buffer: out,
              patterns: {
                0: /^pub$/
              },
              separator: /:/
            });
            id64s = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = rows.length; _i < _len; _i++) {
                row = rows[_i];
                _results.push(row[4]);
              }
              return _results;
            })();
          }
          return cb(err, id64s);
        };
      })(this));
    };

    BaseKeyRing.prototype.find_secret_keys = function(_arg, cb) {
      var args, err, id64s, out, query, row, rows, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query;
      args = ["-K", "--with-colons"];
      if (query) {
        args.push(query);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.find_secret_keys"
          });
          _this.gpg({
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 490
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          id64s = null;
          if (typeof err === "undefined" || err === null) {
            rows = colgrep({
              buffer: out,
              patterns: {
                0: /^sec$/
              },
              separator: /:/
            });
            id64s = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = rows.length; _i < _len; _i++) {
                row = rows[_i];
                _results.push(row[4]);
              }
              return _results;
            })();
          }
          return cb(err, id64s);
        };
      })(this));
    };

    BaseKeyRing.prototype.list_fingerprints = function(cb) {
      var err, out, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.list_fingerprints"
          });
          _this.gpg({
            args: ["--with-colons", "--fingerprint"]
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 501
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          ret = [];
          if (typeof err === "undefined" || err === null) {
            ret = list_fingerprints(out.toString('utf8'));
          }
          return cb(err, ret);
        };
      })(this));
    };

    BaseKeyRing.prototype.list_keys = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.list_keys"
          });
          _this.find_keys({}, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1._all_id_64s = arguments[1];
              };
            })(_this),
            lineno: 510
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, _this._all_id_64s);
        };
      })(this));
    };

    BaseKeyRing.prototype.safe_inspect = function(gargs) {
      var d, k, v;
      d = {};
      for (k in gargs) {
        v = gargs[k];
        if ((k === 'stdin') && gargs.secret) {
          v = "<redacted>";
        }
        d[k] = v;
      }
      return util.inspect(d);
    };

    BaseKeyRing.prototype.gpg = function(gargs, cb) {
      var err, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log().debug("| Call to " + this.CMD + ": " + (this.safe_inspect(gargs)));
      if (gargs.quiet && globals().get_debug()) {
        gargs.quiet = false;
      }
      if (globals().get_no_options()) {
        gargs.no_options = true;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.gpg"
          });
          _this.run(gargs, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return res = arguments[1];
              };
            })(),
            lineno: 551
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, res);
        };
      })(this));
    };

    BaseKeyRing.prototype.index2 = function(opts, cb) {
      var args, err, i, k, out, p, q, w, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      k = (opts != null ? opts.secret : void 0) ? '-K' : '-k';
      args = [k, "--with-fingerprint", "--with-colons"];
      if ((q = opts.query) != null) {
        args.push(q);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.index2"
          });
          _this.gpg({
            args: args,
            quiet: true,
            no_options: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 560
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          i = w = null;
          if (typeof err === "undefined" || err === null) {
            p = new Parser(out.toString('utf8'));
            i = p.parse();
            w = p.warnings();
          }
          return cb(err, i, w);
        };
      })(this));
    };

    BaseKeyRing.prototype.read_uids_from_key = function(_arg, cb) {
      var err, fingerprint, index, opts, query, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      fingerprint = _arg.fingerprint, query = _arg.query;
      query = fingerprint || query;
      opts = {
        query: query
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.read_uids_from_key"
          });
          _this.index2(opts, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return index = arguments[1];
              };
            })(),
            lineno: 573
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref3, _ref4;
          ret = typeof err !== "undefined" && err !== null ? null : typeof index !== "undefined" && index !== null ? (_ref3 = index.keys()) != null ? (_ref4 = _ref3[0]) != null ? _ref4.userids() : void 0 : void 0 : void 0;
          return cb(err, ret);
        };
      })(this));
    };

    BaseKeyRing.prototype.index = function(cb) {
      return this.index2({}, cb);
    };

    BaseKeyRing.prototype.oneshot_verify_2 = function(_arg, cb) {
      var err, file, no_json, raw, ret, ring, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ring = _arg.ring, sig = _arg.sig, file = _arg.file, no_json = _arg.no_json;
      err = ret = null;
      (function(_this) {
        return (function(__iced_k) {
          if (file != null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "BaseKeyRing.oneshot_verify_2"
              });
              ring.verify_sig_on_file({
                sig: sig,
                file: file
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 586
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "BaseKeyRing.oneshot_verify_2"
              });
              ring.verify_and_decrypt_sig({
                sig: sig
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return raw = arguments[1];
                  };
                })(),
                lineno: 588
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (err != null) {
                  return __iced_k();
                } else {
                  (function(__iced_k) {
                    if (no_json) {
                      return __iced_k(ret = raw);
                    } else {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                          funcname: "BaseKeyRing.oneshot_verify_2"
                        });
                        a_json_parse(raw, __iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              err = arguments[0];
                              return ret = arguments[1];
                            };
                          })(),
                          lineno: 592
                        }));
                        __iced_deferrals._fulfill();
                      })(__iced_k);
                    }
                  })(__iced_k);
                }
              })(__iced_k);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    BaseKeyRing.prototype.oneshot_verify = function(_arg, cb) {
      var clean, esc, file, fp, keyblock, no_json, query, ret, ring, secret, sig, single, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query, single = _arg.single, sig = _arg.sig, file = _arg.file, no_json = _arg.no_json, keyblock = _arg.keyblock, secret = _arg.secret;
      log().debug("+ oneshot verify");
      ring = null;
      clean = function(cb) {
        var err, ___iced_passed_deferral1, __iced_deferrals, __iced_k;
        __iced_k = __iced_k_noop;
        ___iced_passed_deferral1 = iced.findDeferral(arguments);
        log().debug("| oneshot clean");
        (function(_this) {
          return (function(__iced_k) {
            if (ring != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral1,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced"
                });
                ring.nuke(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 603
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(typeof err !== "undefined" && err !== null ? log().warn("Error cleaning up 1-shot ring: " + err.message) : void 0);
              });
            } else {
              return __iced_k();
            }
          });
        })(this)((function(_this) {
          return function() {
            return cb();
          };
        })(this));
      };
      cb = chain(cb, clean);
      esc = make_esc(cb, "BaseKeyRing::oneshot_verify");
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "BaseKeyRing.oneshot_verify"
          });
          _this.make_oneshot_ring({
            query: query,
            single: single,
            keyblock: keyblock,
            secret: secret
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                ring = arguments[0];
                return fp = arguments[1];
              };
            })(),
            lineno: 609
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
              funcname: "BaseKeyRing.oneshot_verify"
            });
            _this.oneshot_verify_2({
              ring: ring,
              sig: sig,
              file: file,
              no_json: no_json
            }, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return ret = arguments[0];
                };
              })(),
              lineno: 610
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log().debug("- oneshot verify -> ok! (fp=" + fp + ")");
            return cb(null, ret, fp);
          });
        };
      })(this));
    };

    return BaseKeyRing;

  })(GPG);

  exports.MasterKeyRing = MasterKeyRing = (function(_super) {
    __extends(MasterKeyRing, _super);

    function MasterKeyRing() {
      return MasterKeyRing.__super__.constructor.apply(this, arguments);
    }

    MasterKeyRing.prototype.to_string = function() {
      return "master keyring";
    };

    MasterKeyRing.prototype.mutate_args = function(gargs) {
      var h;
      if ((h = globals().get_home_dir()) != null) {
        gargs.args = ["--homedir", h].concat(gargs.args);
        return log().debug("| Mutate GPG args; new args: " + (gargs.args.join(' ')));
      }
    };

    return MasterKeyRing;

  })(BaseKeyRing);

  exports.make_ring = function(d) {
    var klass;
    klass = d != null ? AltKeyRing : MasterKeyRing;
    return new klass(d);
  };

  exports.reset_master_ring = reset_master_ring = function() {
    return globals().set_master_ring(new MasterKeyRing());
  };

  exports.master_ring = master_ring = function() {
    return globals().master_ring();
  };

  exports.load_key = function(opts, cb) {
    var err, key, signer, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    if ((signer = opts.signer) != null) {
      delete opts.signer;
    }
    key = master_ring().make_key(opts);
    (function(_this) {
      return (function(__iced_k) {
        __iced_deferrals = new iced.Deferrals(__iced_k, {
          parent: ___iced_passed_deferral,
          filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
          funcname: "load_key"
        });
        key.load(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 645
        }));
        __iced_deferrals._fulfill();
      });
    })(this)((function(_this) {
      return function() {
        (function(__iced_k) {
          if ((typeof err === "undefined" || err === null) && (signer != null)) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "load_key"
              });
              key.check_is_signed(signer, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 647
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        })(function() {
          return cb(err, key);
        });
      };
    })(this));
  };

  RingFileBundle = (function() {
    RingFileBundle.prototype.FILES = {
      secring: {
        arg: "secret-keyring",
        "default": ""
      },
      pubring: {
        arg: "keyring",
        "default": ""
      },
      trustdb: {
        arg: "trustdb-name",
        "default": "016770670303010501020000532b0f0c000000000000000000000000000000000000000000000000"
      }
    };

    function RingFileBundle(_arg) {
      var pub_only, w, which, _i, _len;
      this.dir = _arg.dir, pub_only = _arg.pub_only, this.no_default = _arg.no_default, this.primary = _arg.primary;
      this._files = {};
      which = pub_only ? ["pubring"] : ["pubring", "secring", "trustdb"];
      for (_i = 0, _len = which.length; _i < _len; _i++) {
        w = which[_i];
        this._files[w] = this.get_file(w);
      }
    }

    RingFileBundle.prototype.get_file = function(which) {
      return path.join(this.dir, [which, "gpg"].join("."));
    };

    RingFileBundle.prototype.mutate_args = function(gargs, opts) {
      var arg, file, prepend, w, _ref3;
      if (opts == null) {
        opts = {};
      }
      prepend = [];
      if (this.no_default || opts.no_default) {
        prepend.push("--no-default-keyring");
      }
      _ref3 = this._files;
      for (w in _ref3) {
        file = _ref3[w];
        arg = w === 'pubring' && this.primary ? "primary-keyring" : this.FILES[w].arg;
        prepend.push("--" + arg, file);
      }
      return gargs.args = prepend.concat(gargs.args);
    };

    RingFileBundle.prototype.touch = function(which, f, cb) {
      var d, e2, err, fd, ok, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log().debug("+ Make/check empty " + which + " " + f);
      ok = true;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "RingFileBundle.touch"
          });
          fs.open(f, "ax", 0x180, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return fd = arguments[1];
              };
            })(),
            lineno: 692
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (typeof err === "undefined" || err === null) {
              log().debug("| Made a new one");
              d = new Buffer(_this.FILES[which]["default"], "hex");
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "RingFileBundle.touch"
                });
                fs.write(fd, d, 0, d.length, null, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return e2 = arguments[0];
                    };
                  })(),
                  lineno: 696
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(e2 != null ? log().error("Write failed: " + e2.message) : void 0);
              });
            } else {
              return __iced_k(err.code === "EEXIST" ? log().debug("| Found one") : (log().warn("Unexpected error code from file touch " + f + ": " + err.message), ok = false));
            }
          })(function() {
            (function(__iced_k) {
              if (fd >= 0 && (typeof err === "undefined" || err === null)) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "RingFileBundle.touch"
                  });
                  fs.close(fd, __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return e2 = arguments[0];
                      };
                    })(),
                    lineno: 704
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  return __iced_k(typeof e2 !== "undefined" && e2 !== null ? log().error("Close failed: " + e2.message) : void 0);
                });
              } else {
                return __iced_k();
              }
            })(function() {
              log().debug("- Made/check empty " + which + " -> " + ok);
              return cb(null);
            });
          });
        };
      })(this));
    };

    RingFileBundle.prototype.touch_all = function(cb) {
      var esc, f, which, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "RingFileBundle::touch_all");
      (function(_this) {
        return (function(__iced_k) {
          var _i, _k, _keys, _ref3, _results, _while;
          _ref3 = _this._files;
          _keys = (function() {
            var _results1;
            _results1 = [];
            for (_k in _ref3) {
              _results1.push(_k);
            }
            return _results1;
          })();
          _i = 0;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                ++_i;
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(_i < _keys.length)) {
              return _break();
            } else {
              which = _keys[_i];
              f = _ref3[which];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                  funcname: "RingFileBundle.touch_all"
                });
                _this.touch(which, f, esc(__iced_deferrals.defer({
                  lineno: 714
                })));
                __iced_deferrals._fulfill();
              })(_next);
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    return RingFileBundle;

  })();

  AltKeyRingBase = (function(_super) {
    __extends(AltKeyRingBase, _super);

    function AltKeyRingBase(dir) {
      this.dir = dir;
      AltKeyRingBase.__super__.constructor.call(this);
      this._rfb = this.make_ring_file_bundle();
    }

    AltKeyRingBase.prototype.to_string = function() {
      return "keyring " + this.dir;
    };

    AltKeyRingBase.prototype.make_ring_file_bundle = function() {
      return new RingFileBundle({
        dir: this.dir,
        no_default: true
      });
    };

    AltKeyRingBase.prototype.mkfile = function(n) {
      return path.join(this.dir, n);
    };

    AltKeyRingBase.prototype.post_make = function(cb) {
      return this._rfb.touch_all(cb);
    };

    AltKeyRingBase.make = function(klass, dir, cb, opts) {
      var err, made, mode, nxt, parent, so, targ, tkr, tmp, type, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      opts || (opts = {});
      tmp = !opts.perm;
      type = tmp ? "temporary" : "permanent";
      parent = path.dirname(dir);
      nxt = path.basename(dir);
      mode = 0x1c0;
      log().debug("+ Make new " + type + " keychain");
      log().debug("| mkdir_p parent " + parent);
      targ = tmp ? parent : dir;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "AltKeyRingBase.make"
          });
          mkdir_p(targ, mode, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return made = arguments[1];
              };
            })(),
            lineno: 760
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (err != null) {
              return __iced_k(log().error("Error making keyring dir " + parent + ": " + err.message));
            } else {
              (function(__iced_k) {
                if (made) {
                  return __iced_k(log().info("Creating " + type + " keyring dir: " + targ));
                } else {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                      funcname: "AltKeyRingBase.make"
                    });
                    fs.stat(targ, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          err = arguments[0];
                          return so = arguments[1];
                        };
                      })(),
                      lineno: 766
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      if (err != null) {
                        return __iced_k(log().error("Failed to stat directory " + targ + ": " + err.message));
                      } else {
                        (function(__iced_k) {
                          if ((so.mode & 0x1ff) !== mode) {
                            (function(__iced_k) {
                              __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                                funcname: "AltKeyRingBase.make"
                              });
                              fs.chmod(targ, mode, __iced_deferrals.defer({
                                assign_fn: (function() {
                                  return function() {
                                    return err = arguments[0];
                                  };
                                })(),
                                lineno: 770
                              }));
                              __iced_deferrals._fulfill();
                            })(function() {
                              return __iced_k(err != null ? log().error("Failed to change mode of " + parent + " to " + mode + ": " + err.message) : void 0);
                            });
                          } else {
                            return __iced_k();
                          }
                        })(__iced_k);
                      }
                    })(__iced_k);
                  });
                }
              })(__iced_k);
            }
          })(function() {
            (function(__iced_k) {
              if ((err == null) && tmp) {
                dir = path.join(parent, nxt);
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                    funcname: "AltKeyRingBase.make"
                  });
                  fs.mkdir(dir, mode, __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return err = arguments[0];
                      };
                    })(),
                    lineno: 778
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  log().debug("| making directory " + dir);
                  return __iced_k(err != null ? log().error("Failed to make dir " + dir + ": " + err.message) : void 0);
                });
              } else {
                return __iced_k();
              }
            })(function() {
              log().debug("- Made new " + type + " keychain");
              tkr = typeof err !== "undefined" && err !== null ? null : new klass(dir);
              (function(__iced_k) {
                if ((tkr != null) && (typeof err === "undefined" || err === null)) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                      funcname: "AltKeyRingBase.make"
                    });
                    tkr.post_make(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 786
                    }));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                return cb(err, tkr);
              });
            });
          });
        };
      })(this));
    };

    AltKeyRingBase.prototype.copy_key = function(k1, cb) {
      var esc, k2, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TmpKeyRing::copy_key");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "AltKeyRingBase.copy_key"
          });
          k1.load(esc(__iced_deferrals.defer({
            lineno: 793
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          k2 = k1.copy_to_keyring(_this);
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
              funcname: "AltKeyRingBase.copy_key"
            });
            k2.save(esc(__iced_deferrals.defer({
              lineno: 795
            })));
            __iced_deferrals._fulfill();
          })(function() {
            return cb();
          });
        };
      })(this));
    };

    AltKeyRingBase.prototype.mutate_args = function(gargs) {
      this._rfb.mutate_args(gargs);
      return log().debug("| Mutate GPG args; new args: " + (gargs.args.join(' ')));
    };

    return AltKeyRingBase;

  })(BaseKeyRing);

  TmpKeyRingBase = (function(_super) {
    __extends(TmpKeyRingBase, _super);

    function TmpKeyRingBase(dir) {
      TmpKeyRingBase.__super__.constructor.call(this, dir);
      this._nuked = false;
    }

    TmpKeyRingBase.make = function(klass, cb) {
      var dir;
      dir = path.join(globals().get_tmp_keyring_dir(), base64u.encode(prng(15)));
      return AltKeyRingBase.make(klass, dir, cb);
    };

    TmpKeyRingBase.prototype.to_string = function() {
      return "tmp keyring " + this.dir;
    };

    TmpKeyRingBase.prototype.is_temporary = function() {
      return true;
    };

    TmpKeyRingBase.prototype.tmp_dir = function() {
      return this.dir;
    };

    TmpKeyRingBase.prototype.nuke = function(cb) {
      var e2, err, file, files, fp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if (!_this._nuked) {
            log().debug("| nuking temporary kerying: " + _this.dir);
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                funcname: "TmpKeyRingBase.nuke"
              });
              fs.readdir(_this.dir, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return files = arguments[1];
                  };
                })(),
                lineno: 833
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (typeof err !== "undefined" && err !== null) {
                  return __iced_k(log().error("Cannot read dir " + _this.dir + ": " + err.message));
                } else {
                  (function(__iced_k) {
                    var _i, _len, _ref3, _results, _while;
                    _ref3 = files;
                    _len = _ref3.length;
                    _i = 0;
                    _results = [];
                    _while = function(__iced_k) {
                      var _break, _continue, _next;
                      _break = function() {
                        return __iced_k(_results);
                      };
                      _continue = function() {
                        return iced.trampoline(function() {
                          ++_i;
                          return _while(__iced_k);
                        });
                      };
                      _next = function(__iced_next_arg) {
                        _results.push(__iced_next_arg);
                        return _continue();
                      };
                      if (!(_i < _len)) {
                        return _break();
                      } else {
                        file = _ref3[_i];
                        fp = path.join(_this.dir, file);
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                            funcname: "TmpKeyRingBase.nuke"
                          });
                          fs.unlink(fp, __iced_deferrals.defer({
                            assign_fn: (function() {
                              return function() {
                                return e2 = arguments[0];
                              };
                            })(),
                            lineno: 839
                          }));
                          __iced_deferrals._fulfill();
                        })(function() {
                          return _next(typeof e2 !== "undefined" && e2 !== null ? (log().warn("Could not remove dir " + fp + ": " + e2.message), err = e2) : void 0);
                        });
                      }
                    };
                    _while(__iced_k);
                  })(function() {
                    (function(__iced_k) {
                      if (typeof err === "undefined" || err === null) {
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
                            funcname: "TmpKeyRingBase.nuke"
                          });
                          fs.rmdir(_this.dir, __iced_deferrals.defer({
                            assign_fn: (function() {
                              return function() {
                                return err = arguments[0];
                              };
                            })(),
                            lineno: 844
                          }));
                          __iced_deferrals._fulfill();
                        })(function() {
                          return __iced_k(typeof err !== "undefined" && err !== null ? log().error("Cannot delete tmp keyring @dir: " + err.message) : void 0);
                        });
                      } else {
                        return __iced_k();
                      }
                    })(__iced_k);
                  });
                }
              })(function() {
                return __iced_k(_this._nuked = true);
              });
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return TmpKeyRingBase;

  })(AltKeyRingBase);

  exports.TmpKeyRing = TmpKeyRing = (function(_super) {
    __extends(TmpKeyRing, _super);

    function TmpKeyRing() {
      return TmpKeyRing.__super__.constructor.apply(this, arguments);
    }

    TmpKeyRing.make = function(cb) {
      return TmpKeyRingBase.make(TmpKeyRing, cb);
    };

    return TmpKeyRing;

  })(TmpKeyRingBase);

  exports.AltKeyRing = AltKeyRing = (function(_super) {
    __extends(AltKeyRing, _super);

    function AltKeyRing() {
      return AltKeyRing.__super__.constructor.apply(this, arguments);
    }

    AltKeyRing.make = function(dir, cb) {
      return AltKeyRingBase.make(AltKeyRing, dir, cb, {
        perm: true
      });
    };

    return AltKeyRing;

  })(AltKeyRingBase);

  exports.TmpPrimaryKeyRing = TmpPrimaryKeyRing = (function(_super) {
    __extends(TmpPrimaryKeyRing, _super);

    function TmpPrimaryKeyRing() {
      return TmpPrimaryKeyRing.__super__.constructor.apply(this, arguments);
    }

    TmpPrimaryKeyRing.make = function(cb) {
      return TmpKeyRingBase.make(TmpPrimaryKeyRing, cb);
    };

    TmpPrimaryKeyRing.prototype.make_ring_file_bundle = function() {
      return new RingFileBundle({
        pub_only: true,
        dir: this.dir,
        primary: true
      });
    };

    TmpPrimaryKeyRing.prototype.mutate_args = function(gargs) {
      var h, prepend;
      this._rfb.mutate_args(gargs);
      prepend = gargs.list_keys ? ["--no-default-keyring"] : (h = globals().get_home_dir()) ? ["--no-default-keyring", "--keyring", path.join(h, "pubring.gpg"), "--secret-keyring", path.join(h, "secring.gpg"), "--trustdb-name", path.join(h, "trustdb.gpg")] : [];
      gargs.args = prepend.concat(gargs.args);
      return log().debug("| Mutate GPG args; new args: " + (gargs.args.join(' ')));
    };

    return TmpPrimaryKeyRing;

  })(TmpKeyRingBase);

  exports.TmpOneShotKeyRing = TmpOneShotKeyRing = (function(_super) {
    __extends(TmpOneShotKeyRing, _super);

    function TmpOneShotKeyRing() {
      return TmpOneShotKeyRing.__super__.constructor.apply(this, arguments);
    }

    TmpOneShotKeyRing.make = function(cb) {
      return TmpKeyRingBase.make(TmpOneShotKeyRing, cb);
    };

    TmpOneShotKeyRing.prototype.gpg = function(gargs, cb) {
      gargs.args.unshift("--no-options");
      return TmpOneShotKeyRing.__super__.gpg.call(this, gargs, cb);
    };

    TmpOneShotKeyRing.prototype.base_args = function() {
      return ["--trusted-key", this._key_id_64];
    };

    TmpOneShotKeyRing.prototype.verify_and_decrypt_sig = function(_arg, cb) {
      var args, err, out, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig = _arg.sig;
      args = this.base_args().concat(["--decrypt", "--no-auto-key-locate"]);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "TmpOneShotKeyRing.verify_and_decrypt_sig"
          });
          _this.gpg({
            args: args,
            stdin: sig,
            quiet: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 915
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, out);
        };
      })(this));
    };

    TmpOneShotKeyRing.prototype.verify_sig_on_file = function(_arg, cb) {
      var args, err, file, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig = _arg.sig, file = _arg.file;
      args = this.base_args().concat(["--verify", sig, file]);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "TmpOneShotKeyRing.verify_sig_on_file"
          });
          _this.gpg({
            args: args,
            quiet: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 922
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return TmpOneShotKeyRing;

  })(TmpKeyRing);

  exports.QuarantinedKeyRing = QuarantinedKeyRing = (function(_super) {
    __extends(QuarantinedKeyRing, _super);

    function QuarantinedKeyRing() {
      return QuarantinedKeyRing.__super__.constructor.apply(this, arguments);
    }

    QuarantinedKeyRing.make = function(cb) {
      return TmpKeyRingBase.make(QuarantinedKeyRing, cb);
    };

    QuarantinedKeyRing.prototype.set_fingerprint = function(fp) {
      this._fingerprint = fp;
      return this._key_id_64 = fingerprint_to_key_id_64(fp);
    };

    QuarantinedKeyRing.prototype.oneshot_verify = function(_arg, cb) {
      var err, file, keyblock, no_json, query, ret, sig, single, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      query = _arg.query, single = _arg.single, sig = _arg.sig, file = _arg.file, no_json = _arg.no_json, keyblock = _arg.keyblock;
      log().debug("+ Quarantined / oneshot verify");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/keyring.iced",
            funcname: "QuarantinedKeyRing.oneshot_verify"
          });
          _this.oneshot_verify_2({
            ring: _this,
            sig: sig,
            file: file,
            no_json: no_json
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 943
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log().debug("- Quarantined / oneshot verify -> ok! (fp=" + _this._fingerprint + ")");
          return cb(err, ret, _this._fingerprint);
        };
      })(this));
    };

    return QuarantinedKeyRing;

  })(TmpOneShotKeyRing);

}).call(this);
