// Generated by IcedCoffeeScript 1.7.1-g
(function() {
  var BaseCommand, HelpCommand, Installer, KeyJsonCommand, Main, VersionCommand, bin, constants, fullname, getopt, hash_json, iced, keyring, keyset, log, make_esc, os, path, run, version, __iced_k, __iced_k_noop, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  getopt = require('iced-utils').getopt;

  _ref = require('./package'), fullname = _ref.fullname, bin = _ref.bin, version = _ref.version;

  make_esc = require('iced-error').make_esc;

  BaseCommand = require('./base').BaseCommand;

  Installer = require('./installer').Installer;

  keyring = require('gpg-wrapper').keyring;

  constants = require('./constants').constants;

  hash_json = require('./util').hash_json;

  keyset = require('../json/keyset');

  log = require('./log');

  os = require('os');

  path = require('path');

  VersionCommand = (function(_super) {
    __extends(VersionCommand, _super);

    function VersionCommand() {
      return VersionCommand.__super__.constructor.apply(this, arguments);
    }

    VersionCommand.prototype.run = function(cb) {
      console.log(fullname());
      return cb(null);
    };

    return VersionCommand;

  })(BaseCommand);

  HelpCommand = (function(_super) {
    __extends(HelpCommand, _super);

    function HelpCommand(argv, err) {
      this.err = err != null ? err : null;
      HelpCommand.__super__.constructor.call(this, argv);
    }

    HelpCommand.prototype.run = function(cb) {
      console.log("usage: " + (bin()) + " [-dhjvCS] [-p <install-prefix>] [<keybase-version>]\n\n\tUpgrade or install a version of keybase.  Check signatures with\n\tKeybase.io's signing key. You can provide a specific version\n\tor by default you'll get the most recent version.\n\nBoolean Flags:\n\n\t-d/--debug              -- Turn on debugging output\n\t-h/--help               -- Print the help message and quit\n\t-j/--key-json           -- Output the hash of the JSON file of the built-in keyset\n\t-v/--version            -- Print the version and quit\n\t-C/--skip-cleanup       -- Don't delete temporary files after install\n\t-S/--no-https           -- Don't use HTTPS. Safe since we check PGP sigs on everything.\n\t-O/--no-gpg-options     -- Turn off GPG options file for temporary keyring operations\n\nOptions:\n\n\t-g/--gpg <cmd>\n\t\tUse a GPG command other than `gpg`\n\n\t-k/--keyring-dir <dir>\n\t\tWhere to store our GPG keys.\n\t\t(default: ~/.keybase-installer/keyring)\n\n\t-n/--npm <cmd>\n\t\tUse an npm command other than `npm`\n\n\t-p/--prefix <dir>\n\t\tInstall to the given prefix\n\t\t(rather than where `npm` installs by default)\n\n\t-u/--url-prefix <prfx>\n\t\tSpecify a URL prefix for fetching\n\t\t(default: " + constants.url_prefix.https + ")\n\n\t-x/--proxy <url>\n\t\tProxy all downloads through the given proxy\n\nEnvironment Variables:\n\n\thttp_proxy=<full-url> OR https_proxy=<full-url>\n\t\tAs --proxy above, proxy all requests through the\n\t\tgiven proxy.\n\n\tPREFIX\n\t\tAn install prefix\n\nVersion: " + (version()) + "\n");
      return cb(this.err);
    };

    return HelpCommand;

  })(BaseCommand);

  KeyJsonCommand = (function(_super) {
    __extends(KeyJsonCommand, _super);

    function KeyJsonCommand() {
      return KeyJsonCommand.__super__.constructor.apply(this, arguments);
    }

    KeyJsonCommand.prototype.run = function(cb) {
      keyset.self_sig = null;
      process.stdout.write(hash_json(keyset));
      return cb(null);
    };

    return KeyJsonCommand;

  })(BaseCommand);

  Main = (function() {
    function Main() {
      this.cmd = null;
    }

    Main.prototype.parse_args = function(cb) {
      var err, flags;
      err = null;
      flags = ["d", "h", "v", "j", "C", "?", "S", "O", "debug", "key-json", "hash", "help", "version", "skip-cleanup", "no-https", "no-gpg-options"];
      this.argv = getopt(process.argv.slice(2), {
        flags: flags
      });
      if (this.argv.get("v", "version")) {
        this.cmd = new VersionCommand();
      } else if (this.argv.get("h", "?", "help")) {
        this.cmd = new HelpCommand();
      } else if (this.argv.get("j", "key-json")) {
        this.cmd = new KeyJsonCommand(this.argv);
      } else if (this.argv.get().length > 1) {
        this.cmd = new HelpCommand(this.argv, new Error("Usage error: only zero or one argument allowed"));
      } else {
        this.cmd = new Installer(this.argv);
      }
      return cb(err);
    };

    Main.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/main.iced",
            funcname: "Main.run"
          });
          _this.setup(esc(__iced_deferrals.defer({
            lineno: 140
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug("+ cmd.run " + (version()));
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-installer/src/main.iced",
              funcname: "Main.run"
            });
            _this.cmd.run(esc(__iced_deferrals.defer({
              lineno: 142
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log.debug("- cmd.run");
            return cb(null);
          });
        };
      })(this));
    };

    Main.prototype.main = function() {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/main.iced",
            funcname: "Main.main"
          });
          _this.run(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 149
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            log.error(err.message);
            if (err.stderr != null) {
              log.warn(err.stderr.toString('utf8'));
            }
          }
          return process.exit(typeof err !== "undefined" && err !== null ? -2 : 0);
        };
      })(this));
    };

    Main.prototype.setup_logger = function() {
      var p;
      p = log["package"]();
      if (this.argv.get("d", "debug")) {
        return p.env().set_level(p.DEBUG);
      }
    };

    Main.prototype.setup = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "setup");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/main.iced",
            funcname: "Main.setup"
          });
          _this.parse_args(esc(__iced_deferrals.defer({
            lineno: 165
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          _this.setup_logger();
          return cb(null);
        };
      })(this));
    };

    return Main;

  })();

  exports.run = run = function() {
    return (new Main).main();
  };

}).call(this);
