/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnumMeta<T extends EnumItem> {
    private final Class enumClazz;
    private final List<T> items = new ArrayList<T>();
    private T enumDefault = null;

    public EnumMeta(Class clazz) {
        this.enumClazz = clazz;
    }

    protected void addItem(T t) {
        this.items.add(t);
        if (this.items.size() == 1) {
            ((EnumItem)t).setDefault();
        }
    }

    public T getDefault() {
        return this.enumDefault;
    }

    public Class getEnumClazz() {
        return this.enumClazz;
    }

    public T getItem(String string) {
        if (string == null) {
            return null;
        }
        for (EnumItem enumItem : this.items) {
            if (!enumItem.getId().equals(string)) continue;
            return (T)enumItem;
        }
        return null;
    }

    public T getItemOrDefault(String string) {
        T t = this.getItem(string);
        if (t == null) {
            t = this.getDefault();
        }
        return t;
    }

    public T[] getItems() {
        return this.items.toArray((EnumItem[])Array.newInstance(this.enumClazz, this.items.size()));
    }

    public T getMax() {
        EnumItem enumItem = null;
        for (EnumItem enumItem2 : this.items) {
            if (enumItem != null && enumItem2.getWeight() <= enumItem.getWeight()) continue;
            enumItem = enumItem2;
        }
        return (T)enumItem;
    }

    public T getMin() {
        EnumItem enumItem = null;
        for (EnumItem enumItem2 : this.items) {
            if (enumItem != null && enumItem2.getWeight() >= enumItem.getWeight()) continue;
            enumItem = enumItem2;
        }
        return (T)enumItem;
    }

    protected void setDefault(T t) {
        this.enumDefault = t;
    }

    public void sort() {
        this.sort(new Comparator<EnumItem>(){

            @Override
            public int compare(EnumItem enumItem, EnumItem enumItem2) {
                return enumItem.getLabel().compareToIgnoreCase(enumItem2.getLabel());
            }
        });
    }

    public void sort(Comparator<EnumItem> comparator) {
        Collections.sort(this.items, comparator);
    }
}

