/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class TaggedStringEvaluator
implements IStringEvaluator {
    private boolean escape;
    private final IStringEvaluator evaluator;
    private IDirectTagHandler handler = new IDirectTagHandler(){

        @Override
        public String process(String string, Object object) throws IOException {
            return TaggedStringEvaluator.this.evaluateExpression(string, (IArgs)object);
        }

        @Override
        public void setLocationProvider(ILocationProvider iLocationProvider) {
        }

        @Override
        public void startTag() {
        }
    };
    private boolean swallowExceptions = true;

    public TaggedStringEvaluator(IStringEvaluator iStringEvaluator) {
        this(iStringEvaluator, false);
    }

    public TaggedStringEvaluator(IStringEvaluator iStringEvaluator, boolean bl) {
        this.evaluator = iStringEvaluator;
        this.escape = bl;
    }

    @Override
    public Object evaluate(String string, IArgs iArgs) throws EvaluationException {
        if (string.indexOf(36) < 0) {
            return string;
        }
        try {
            StringReader stringReader = new StringReader(string);
            DirectTagReader directTagReader = new DirectTagReader(stringReader, this.handler, iArgs, this.isEscape());
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[string.length() * 2];
            int n = directTagReader.read(cArray);
            while (n != -1) {
                stringWriter.write(cArray, 0, n);
                n = directTagReader.read(cArray);
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            if (this.isSwallowExceptions()) {
                return "<error>";
            }
            throw new EvaluationException(iOException);
        }
    }

    protected String evaluateExpression(String string, IArgs iArgs) throws IOException {
        Object object;
        block4: {
            try {
                object = this.evaluator.evaluate(string, iArgs);
                if (object != null) break block4;
                return "";
            }
            catch (EvaluationException evaluationException) {
                if (this.isSwallowExceptions()) {
                    return "<error evaluating '" + string + "' (" + evaluationException.getMessage() + ")>";
                }
                throw ExceptionTools.createIOException("<error evaluating '" + string + "' (" + evaluationException.getMessage() + ")>", evaluationException);
            }
        }
        return String.valueOf(object);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public boolean isSwallowExceptions() {
        return this.swallowExceptions;
    }

    public void setEscape(boolean bl) {
        this.escape = bl;
    }

    public void setSwallowExceptions(boolean bl) {
        this.swallowExceptions = bl;
    }
}

