/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.rotate.listeners;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.listeners.AbstractRunButtonActionListener;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.commons.business.WorkExecutor;
import org.pdfsam.guiclient.commons.business.WorkThread;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.rotate.GUI.RotateMainGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunButtonActionListener
extends AbstractRunButtonActionListener {
    private static final Logger log = Logger.getLogger((String)RunButtonActionListener.class.getPackage().getName());
    private RotateMainGUI panel;

    public RunButtonActionListener(RotateMainGUI panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (WorkExecutor.getInstance().getRunningThreads() > 0 || this.panel.getSelectionPanel().isAdding()) {
            DialogUtility.showWarningAddingDocument((Component)((Object)this.panel));
            return;
        }
        Object[] items = this.panel.getSelectionPanel().getTableRows();
        if (ArrayUtils.isEmpty((Object[])items)) {
            DialogUtility.showWarningNoDocsSelected((Component)((Object)this.panel), (int)0);
            return;
        }
        LinkedList<String> args = new LinkedList<String>();
        try {
            if (this.panel.getOverwriteCheckbox().isSelected() && Configuration.getInstance().isAskOverwriteConfirmation()) {
                int dialogRet = DialogUtility.askForOverwriteConfirmation((Component)((Object)this.panel));
                if (1 == dialogRet) {
                    this.panel.getOverwriteCheckbox().setSelected(false);
                } else if (2 == dialogRet) {
                    return;
                }
            }
            args.addAll(this.getInputFilesArguments((PdfSelectionTableItem[])items));
            args.add("-o");
            if (StringUtils.isEmpty((String)this.panel.getDestinationTextField().getText())) {
                String suggestedDir = this.getSuggestedDestinationDirectory((PdfSelectionTableItem)items[items.length - 1]);
                int chosenOpt = DialogUtility.showConfirmOuputLocationDialog((Component)((Object)this.panel), (String)suggestedDir);
                if (0 == chosenOpt) {
                    this.panel.getDestinationTextField().setText(suggestedDir);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            args.add(this.panel.getDestinationTextField().getText());
            if (this.panel.getOverwriteCheckbox().isSelected()) {
                args.add("-overwrite");
            }
            if (this.panel.getOutputCompressedCheck().isSelected()) {
                args.add("-compressed");
            }
            args.add("-r");
            args.add(((StringItem)this.panel.getRotationPagesBox().getSelectedItem()).getId() + ":" + this.panel.getRotationBox().getSelectedItem());
            args.add("-p");
            args.add(this.panel.getOutPrefixTextField().getText());
            args.add("-pdfversion");
            args.add(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId());
            args.add("rotate");
            String[] myStringArray = args.toArray(new String[args.size()]);
            WorkExecutor.getInstance().execute((Runnable)new WorkThread(myStringArray));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
            SoundPlayer.getInstance().playErrorSound();
        }
    }

    private List<String> getInputFilesArguments(PdfSelectionTableItem[] items) {
        LinkedList<String> retList = new LinkedList<String>();
        for (PdfSelectionTableItem item : items) {
            retList.add("-f");
            String f = item.getInputFile().getAbsolutePath();
            if (item.getPassword() != null && item.getPassword().length() > 0) {
                log.debug((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found a password for input file."));
                f = f + ":" + item.getPassword();
            }
            retList.add(f);
        }
        return retList;
    }
}

