/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.pd.AbstractBitFlags;
import de.intarsys.pdf.pd.PDAcroFormField;

public class AcroFormFieldFlags
extends AbstractBitFlags {
    public static final int Bit_ReadOnly = 1;
    public static final int Bit_Required = 2;
    public static final int Bit_NoExport = 4;
    public static final int Bit_Multiline = 4096;
    public static final int Bit_Password = 8192;
    public static final int Bit_NoToggleToOff = 16384;
    public static final int Bit_Radio = 32768;
    public static final int Bit_Pushbutton = 65536;
    public static final int Bit_Combo = 131072;
    public static final int Bit_Edit = 262144;
    public static final int Bit_Sort = 524288;
    public static final int Bit_FileSelect = 0x100000;
    public static final int Bit_MultiSelect = 0x200000;
    public static final int Bit_DoNotSpellCheck = 0x400000;
    public static final int Bit_DoNotScroll = 0x800000;
    public static final int Bit_Comb = 0x1000000;
    public static final int Bit_RadiosInUnison = 0x2000000;
    public static final int Bit_CommitOnSelChange = 0x4000000;
    public static final int Bit_RichText = 0x8000000;
    private PDAcroFormField field;

    public AcroFormFieldFlags(int n) {
        super(n);
    }

    public AcroFormFieldFlags(PDAcroFormField pDAcroFormField) {
        super(pDAcroFormField, null);
        this.field = pDAcroFormField;
    }

    protected PDAcroFormField getField() {
        return this.field;
    }

    @Override
    protected int getValueInObject() {
        return this.getField().basicGetFieldFlags();
    }

    public boolean isComb() {
        return this.isSetAnd(0x1000000);
    }

    public boolean isCombo() {
        return this.isSetAnd(131072);
    }

    public boolean isCommitOnSelChange() {
        return this.isSetAnd(0x4000000);
    }

    public boolean isDoNotScroll() {
        return this.isSetAnd(0x800000);
    }

    public boolean isEdit() {
        return this.isSetAnd(262144);
    }

    public boolean isFileSelect() {
        return this.isSetAnd(0x100000);
    }

    public boolean isMultiline() {
        return this.isSetAnd(4096);
    }

    public boolean isMultiSelect() {
        return this.isSetAnd(0x200000);
    }

    public boolean isNoExport() {
        return this.isSetAnd(4);
    }

    public boolean isNoToggleOff() {
        return this.isSetAnd(16384);
    }

    public boolean isPassword() {
        return this.isSetAnd(8192);
    }

    public boolean isPushbutton() {
        return this.isSetAnd(65536);
    }

    public boolean isRadio() {
        return this.isSetAnd(32768);
    }

    public boolean isRadiosInUnison() {
        return this.isSetAnd(0x2000000);
    }

    public boolean isReadOnly() {
        return this.isSetAnd(1);
    }

    public boolean isRequired() {
        return this.isSetAnd(2);
    }

    @Override
    public void set(int n, boolean bl) {
        super.set(n, bl);
        if (this.getField() != null && this.getField().getKids() != null) {
            for (PDAcroFormField pDAcroFormField : this.getField().getKids()) {
                pDAcroFormField.getFieldFlags().set(n, bl);
            }
        }
    }

    public void setComb(boolean bl) {
        this.set(0x1000000, bl);
    }

    public void setCombo(boolean bl) {
        this.set(131072, bl);
    }

    public void setCommitOnSelChange(boolean bl) {
        this.set(0x4000000, bl);
    }

    public void setDoNotScroll(boolean bl) {
        this.set(0x800000, bl);
    }

    public void setEdit(boolean bl) {
        this.set(262144, bl);
    }

    public void setFileSelect(boolean bl) {
        this.set(0x100000, bl);
    }

    public void setMultiline(boolean bl) {
        this.set(4096, bl);
    }

    public void setMultiSelect(boolean bl) {
        this.set(0x200000, bl);
    }

    public void setNoExport(boolean bl) {
        this.set(4, bl);
    }

    public void setNoToggleToOff(boolean bl) {
        this.set(16384, bl);
    }

    public void setPassword(boolean bl) {
        this.set(8192, bl);
    }

    public void setPushbutton(boolean bl) {
        this.set(65536, bl);
    }

    public void setRadio(boolean bl) {
        this.set(32768, bl);
    }

    public void setReadOnly(boolean bl) {
        this.set(1, bl);
    }

    public void setRequired(boolean bl) {
        this.set(2, bl);
    }

    @Override
    protected void setValueInObject(int n) {
        this.getField().basicSetFieldFlags(n);
    }
}

