/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.loaders;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.loaders.PdfDocumentLoadedHook;
import org.pdfsam.guiclient.commons.business.loaders.PdfLoaderExecutor;
import org.pdfsam.guiclient.commons.business.loaders.callable.AddPdfDocument;
import org.pdfsam.guiclient.commons.business.loaders.callable.ReloadPdfDocument;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class PdfLoader {
    private static final Logger log = Logger.getLogger(PdfLoader.class.getPackage().getName());
    private JPdfSelectionPanel panel;
    private PdfLoaderExecutor executor = null;
    private PdfDocumentLoadedHook hook = null;

    public PdfLoader(JPdfSelectionPanel panel) {
        this.panel = panel;
        this.executor = new PdfLoaderExecutor();
    }

    public void showFileChooserAndAddFiles(boolean singleSelection) {
        if (this.panel.getMainTable().getModel().getRowCount() >= this.panel.getMaxSelectableFiles()) {
            JOptionPane.showMessageDialog(this.panel, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Selection table is full, please remove some pdf document."), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Table full"), 1);
        } else if (!this.executor.isExecuting()) {
            JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.PDF_FILE, 0);
            fileChooser.setMultiSelectionEnabled(!singleSelection);
            if (fileChooser.showOpenDialog(this.panel) == 0) {
                if (fileChooser.isMultiSelectionEnabled()) {
                    this.addFiles(fileChooser.getSelectedFiles());
                } else {
                    this.addFile(fileChooser.getSelectedFile());
                }
            }
        } else {
            log.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please wait while all files are processed.."));
        }
    }

    public void showFileChooserAndAddFiles() {
        this.showFileChooserAndAddFiles(false);
    }

    public void addFile(File file, String password, String pageSelection) {
        if (file != null) {
            this.executor.execute(new AddPdfDocument(file, this.panel, password, pageSelection), this.hook);
        }
    }

    public void addFile(File file, String password) {
        this.addFile(file, password, null);
    }

    public void addFile(File file) {
        this.addFile(file, null, null);
    }

    public void reloadFile(File file, String password, String pageSelection, int index) {
        if (file != null) {
            this.executor.execute(new ReloadPdfDocument(file, this.panel, password, pageSelection, index), this.hook);
        }
    }

    public void reloadFile(File file, String password, int index) {
        this.reloadFile(file, password, null, index);
    }

    public void reloadFile(File file, int index) {
        this.reloadFile(file, null, null, index);
    }

    public synchronized void addFiles(File[] files) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.executor.execute(new AddPdfDocument(files[i], this.panel), this.hook);
            }
        }
    }

    public void addFiles(List<File> files, boolean ordered) {
        if (files != null && !files.isEmpty()) {
            this.addFiles(files.toArray(new File[files.size()]));
        }
    }

    public void addFiles(List<File> files) {
        this.addFiles(files, false);
    }

    public boolean isExecuting() {
        return this.executor.isExecuting();
    }

    public void setHook(PdfDocumentLoadedHook hook) {
        this.hook = hook;
    }
}

