/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.models;

import java.io.Serializable;
import javax.swing.table.AbstractTableModel;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;

public abstract class AbstractPdfSelectionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4626256408853242065L;
    public static final int ROW_NUM = 0;
    public static final int FILENAME = 1;
    public static final int PATH = 2;
    public static final int PAGES = 3;
    public static final int PASSWORD = 4;
    public static final int PDF_DOCUMENT_VERSION = 5;
    public static final int PAGESELECTION = 6;
    public static final int MAX_COLUMNS_NUMBER = 7;
    public static final int DEFAULT_SHOWED_COLUMNS_NUMBER = 6;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private String[] columnNames;
    private String[] toolTips;
    private int showedColumns = 6;
    private int maxRowsNumber = Integer.MAX_VALUE;
    private boolean sortable = false;

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }

    @Override
    public int getColumnCount() {
        return this.showedColumns;
    }

    public int getShowedColumns() {
        return this.showedColumns;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public void setShowedColumns(int showedColumns) {
        this.showedColumns = showedColumns < 1 ? 1 : (showedColumns > 7 ? 7 : showedColumns);
    }

    public int getMaxRowsNumber() {
        return this.maxRowsNumber;
    }

    public void setMaxRowsNumber(int maxRowsNumber) {
        this.maxRowsNumber = maxRowsNumber < 1 ? 1 : maxRowsNumber;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 6 == column || 4 == column;
    }

    @Override
    public String getColumnName(int col) {
        return col < this.columnNames.length ? this.columnNames[col] : "";
    }

    public String[] getToolTips() {
        return this.toolTips;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    protected void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public abstract PdfSelectionTableItem[] getRows();

    public abstract void deleteRows(int[] var1) throws IndexOutOfBoundsException;

    public abstract void deleteRow(int var1) throws IndexOutOfBoundsException;

    public abstract void moveDownRows(int[] var1) throws IndexOutOfBoundsException;

    public abstract void moveDownRow(int var1) throws IndexOutOfBoundsException;

    public abstract void moveUpRows(int[] var1) throws IndexOutOfBoundsException;

    public abstract void moveUpRow(int var1) throws IndexOutOfBoundsException;

    public abstract void addRowAt(int var1, PdfSelectionTableItem var2);

    public abstract void updateRowAt(int var1, PdfSelectionTableItem var2);

    public abstract void addRow(PdfSelectionTableItem var1);

    public abstract void clearData();

    public abstract void setData(PdfSelectionTableItem[] var1);

    public abstract PdfSelectionTableItem getRow(int var1);

    public abstract void sort();

    public abstract SortingState getSortingState();

    public abstract void setSortingState(SortingState var1);

    public class SortingState
    implements Serializable {
        private static final long serialVersionUID = 3051421044350063901L;
        private int col = -1;
        private int sortType = 0;

        public SortingState() {
        }

        public SortingState(int col, int sortType) {
            this.col = col;
            this.sortType = sortType;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public int getSortType() {
            return this.sortType;
        }

        public void setSortType(int sortType) {
            this.sortType = sortType;
        }

        public boolean isSorted() {
            return this.sortType == -1 || this.sortType == 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.col;
            result = 31 * result + this.sortType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortingState other = (SortingState)obj;
            if (this.col != other.col) {
                return false;
            }
            return this.sortType == other.sortType;
        }

        public String toString() {
            return "[col=" + this.col + " sortType=" + this.sortType + "]";
        }
    }
}

